/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCKeyboardPanel
extends EFCPanel {
    private static final long serialVersionUID = 7256172882587702039L;
    private static final Logger logger = LoggerFactory.getLogger(EFCKeyboardPanel.class);
    private JTextField field;
    private EFCList<JButton> buttons = new EFCList();
    private JPanel base = new JPanel(new GridLayout(4, 3));

    public EFCKeyboardPanel(String ident, int height, int width, int alignment) {
        super(ident);
        this.base.setPreferredSize(new Dimension(width, height));
        this.base.setMaximumSize(new Dimension(width, height));
        this.base.setMinimumSize(new Dimension(width, height));
        this.buttons.addAll(Arrays.asList(new EFCKeyboardButton("1"), new EFCKeyboardButton("2"), new EFCKeyboardButton("3"), new EFCKeyboardButton("4"), new EFCKeyboardButton("5"), new EFCKeyboardButton("6"), new EFCKeyboardButton("7"), new EFCKeyboardButton("8"), new EFCKeyboardButton("9"), new EFCKeyboardDeleteButton("DEL"), new EFCKeyboardButton("0"), new EFCKeyboardEnterButton("OK")));
        this.buttons.forEach(button -> this.base.add((Component)button));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 0, 5, 0);
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = alignment;
        gbc.gridwidth = 0;
        this.add((Component)this.base, gbc);
    }

    public EFCList<JButton> getButtons() {
        return this.buttons;
    }

    public void setActiveEditorComponent(JTextField textField) {
        this.field = textField;
    }

    @Override
    public void setVisible(boolean aFlag) {
        this.base.setVisible(aFlag);
    }

    @Override
    public void terminate() {
        this.removeAll();
    }

    private class EFCKeyboardDeleteButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = -8686652719761088936L;

        EFCKeyboardDeleteButton(String name) {
            super(name);
            this.addActionListener(this);
            this.setFocusable(false);
            this.setFont(EFCLookAndFeelManager.FONT_EFC_STANDARD);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EFCKeyboardPanel.this.field != null && EFCKeyboardPanel.this.field.getText() != null && !EFCKeyboardPanel.this.field.getText().isEmpty()) {
                if (!EFCKeyboardPanel.this.field.hasFocus()) {
                    EFCKeyboardPanel.this.field.setText("");
                    EFCKeyboardPanel.this.field.requestFocusInWindow();
                } else if (EFCKeyboardPanel.this.field.getSelectedText() != null && !EFCKeyboardPanel.this.field.getSelectedText().isEmpty()) {
                    EFCKeyboardPanel.this.field.setText("");
                } else {
                    EFCKeyboardPanel.this.field.setText(EFCKeyboardPanel.this.field.getText().substring(0, EFCKeyboardPanel.this.field.getText().length() - 1));
                }
            }
        }
    }

    private class EFCKeyboardEnterButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = -440290964546549107L;

        EFCKeyboardEnterButton(String name) {
            super(name);
            this.addActionListener(this);
            this.setFocusable(false);
            this.setFont(EFCLookAndFeelManager.FONT_EFC_STANDARD);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EFCKeyboardPanel.this.field != null) {
                EFCKeyboardPanel.this.field.transferFocus();
            } else {
                logger.error("No ActiveEditorComponent");
            }
        }
    }

    private class EFCKeyboardButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = -1591551014943914934L;

        EFCKeyboardButton(String name) {
            super(name);
            this.addActionListener(this);
            this.setFocusable(false);
            this.setFont(EFCLookAndFeelManager.FONT_EFC_STANDARD);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EFCKeyboardPanel.this.field != null) {
                if (!EFCKeyboardPanel.this.field.hasFocus()) {
                    EFCKeyboardPanel.this.field.requestFocusInWindow();
                    EFCThreadUtil.doLater(() -> EFCKeyboardPanel.this.field.setText(this.getText()));
                } else if (EFCKeyboardPanel.this.field.getSelectedText() != null && !EFCKeyboardPanel.this.field.getSelectedText().isEmpty()) {
                    EFCKeyboardPanel.this.field.setText(this.getText());
                } else {
                    EFCKeyboardPanel.this.field.setText(EFCKeyboardPanel.this.field.getText() + this.getText());
                }
            } else {
                logger.error("No ActiveEditorComponent");
            }
        }
    }
}

