/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.base.data.LazyLoader;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.efcbl.error.ApplicationException;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.meta.MetaInfo;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.model.table.EFCColumnControlButton;
import de.effectivecompany.gui.components.model.table.EFCColumnModel;
import de.effectivecompany.gui.components.model.table.EFCTableColExt;
import de.effectivecompany.gui.components.model.table.EFCTableColumnLayoutInfo;
import de.effectivecompany.gui.components.model.table.ListTableModel;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.swing.EFCTable;
import de.effectivecompany.gui.components.table.EFCColumnResizer;
import de.effectivecompany.gui.events.ListTableDataLoadedEvent;
import de.effectivecompany.gui.events.SelectionContextChangeEvent;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.interfaces.panel.TablePanel;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.RowSorter;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCListTablePanel
extends EFCPanel
implements TablePanel {
    private static Logger logger = LoggerFactory.getLogger(EFCListTablePanel.class);
    public static final long serialVersionUID = -73345525L;
    private List<MetaInfo> data;
    private ListTableModel model;
    private EFCTable jxTable;
    private EFCList<String> colNames = new EFCList();
    private boolean dataModified;
    private static final boolean RESIZE = true;
    private boolean unselected = true;
    MyListSelectionHandler selectionHandler;
    private EFCColumnModel columnModel;
    private String layoutFileName;
    private List<EFCTableColExt> tableColumns = new ArrayList<EFCTableColExt>();
    private TableComparator tableComparator;
    private String tableLayout;
    private boolean isTableLayoutByAdmin = false;
    private boolean isTableLayoutLoaded = false;
    private List<? extends RowSorter.SortKey> sortKeys;
    private EFCController controller;
    private Runnable enterAction;
    private List<FocusListener> myFocusListener = new ArrayList<FocusListener>(5);

    public void setLocked(boolean isLocked) {
        if (isLocked) {
            this.setCursor(new Cursor(3));
        } else {
            this.setCursor(new Cursor(0));
        }
        this.jxTable.setEnabled(!isLocked);
        this.controller.getView().getEFCStatusBar().setProgressBarVisible(isLocked);
    }

    private void loadListModel() {
        if (this.colNames.size() > 0 && this.model.getColumnCount() > 0 && this.jxTable.getRowSorter() != null) {
            this.sortKeys = this.jxTable.getRowSorter().getSortKeys();
        }
        this.jxTable.setAutoCreateRowSorter(false);
        this.model.loadData(this.data);
        if (this.data.size() > 0 && !this.isTableLayoutLoaded) {
            this.model.setColNames(this.colNames);
            this.addColsToColumsModel((String[])this.colNames.toArray((Object[])new String[this.colNames.size()]));
            this.setColumnModelXML(this.tableLayout);
            this.jxTable.setColumnControl((JComponent)((Object)new EFCColumnControlButton(this.jxTable)));
            if (this.tableLayout != null) {
                if (this.isTableLayoutByAdmin) {
                    ((JButton)this.jxTable.getColumnControl()).setForeground(Color.RED);
                    logger.info("setzte Benutzer-bezogenes Tabellenlayout in: " + this.layoutFileName + ", Tabelle: " + this.getIdent());
                } else {
                    ((JButton)this.jxTable.getColumnControl()).setForeground(Color.BLUE);
                    logger.info("setzte angepasstes Tabellenlayout in: " + this.layoutFileName + ", Tabelle: " + this.getIdent());
                }
            }
        }
        this.jxTable.setAutoCreateRowSorter(true);
        if (this.sortKeys != null && !this.sortKeys.isEmpty() && this.jxTable.getColumnCount() > this.sortKeys.get(0).getColumn()) {
            this.jxTable.getRowSorter().setSortKeys(this.sortKeys);
            this.jxTable.getRowSorter().allRowsChanged();
        }
        this.jxTable.newFilter();
        logger.debug("fireTableDataChanged in EFCListTablePanel done()");
    }

    public EFCListTablePanel(ElementManager eManager, DataChangeManager dcManager, final String ident, final String parentIdent, boolean border, final EFCController controller, EFCMap<String, Font> columnFonts) {
        super(eManager, dcManager, ident, parentIdent, border);
        this.controller = controller;
        this.selectionHandler = new MyListSelectionHandler();
        EFCPanel.MyFocusHandler focusHandler = new EFCPanel.MyFocusHandler(){

            @Override
            public void focusGained(FocusEvent event) {
                super.focusGained(event);
                EFCListTablePanel.this.setBorder(EFCLookAndFeelManager.TABLE_BORRDER_OUTSIDE);
                int columnIndex = EFCListTablePanel.this.getSelectedColumn();
                String column = null;
                if (columnIndex != -1) {
                    column = ((ListTableModel)EFCListTablePanel.this.getTableModel()).getColumnId(columnIndex);
                }
                controller.onParamContextChanged(parentIdent, ident, column, EFCListTablePanel.this.getSelectedObject(), null);
            }

            @Override
            public void focusLost(FocusEvent event) {
                super.focusLost(event);
                EFCListTablePanel.this.setBorder(EFCLookAndFeelManager.TABLE_BORRDER_EMPTYBORDER);
            }
        };
        this.model = new ListTableModel();
        this.jxTable = new EFCTable(this.model, controller, columnFonts){
            private static final long serialVersionUID = 1L;

            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                super.changeSelection(rowIndex, columnIndex, true, false);
                controller.setActiveTableSelectionFocusIdent(EFCListTablePanel.this.getIdent());
            }
        };
        this.jxTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    evt.consume();
                    if (EFCListTablePanel.this.enterAction != null) {
                        EFCListTablePanel.this.enterAction.run();
                    }
                }
                if (evt.getKeyCode() == 9) {
                    evt.consume();
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            }
        });
        this.tableComparator = new TableComparator();
        this.jxTable.setTableIdent(ident);
        this.jxTable.setHorizontalScrollEnabled(true);
        this.jxTable.getSelectionModel().setSelectionMode(0);
        this.jxTable.addFocusListener(focusHandler);
        this.jxTable.getSelectionModel().addListSelectionListener(this.selectionHandler);
        this.columnModel = new EFCColumnModel(this.model);
        this.jxTable.setColumnModel((TableColumnModel)((Object)this.columnModel));
        JScrollPane pane = new JScrollPane((Component)((Object)this.jxTable));
        this.add(pane);
    }

    public void setData(List<MetaInfo> data) {
        logger.debug("{}: getting new data", (Object)this.getIdent());
        this.unselected = true;
        this.jxTable.setVisible(false);
        this.jxTable.clearSelection();
        this.getElementManager().resetAllFields(this.getIdent() + ".");
        this.data = data;
        this.dataModified = true;
        this.repaint();
    }

    public void clearVisibleCols() {
    }

    public void addVisibleCol(String colname) {
    }

    @Override
    public int getSelectedIndex() {
        int selectedRow = this.jxTable.getSelectedRow();
        if (selectedRow >= 0) {
            return this.jxTable.convertRowIndexToModel(selectedRow);
        }
        return -1;
    }

    @Override
    public int getSelectedColumn() {
        int selectedCol = this.jxTable.getSelectedColumn();
        if (selectedCol >= 0) {
            return this.jxTable.convertColumnIndexToModel(selectedCol);
        }
        return -1;
    }

    public BusinessObject getSelectedObject() {
        if (this.getSelectedIndex() >= 0) {
            return this.model.getObjectAtRow(this.getSelectedIndex());
        }
        return null;
    }

    public int getObjectCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    public void scrollToVisible(JXTable table, int rowIndex, int vColIndex) {
        if (!(table.getParent() instanceof JViewport) || rowIndex == -1) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(rowIndex, vColIndex, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }

    public boolean setSelectedIndex(int index) {
        if (index >= 0 && index < this.model.getRowCount()) {
            try {
                int index2 = this.jxTable.convertRowIndexToModel(index);
                this.jxTable.setRowSelectionInterval(index2, index2);
                this.scrollToVisible(this.jxTable, this.jxTable.getSelectedRow(), this.jxTable.getSelectedColumn());
            }
            catch (Throwable throwable) {}
        } else {
            return false;
        }
        return true;
    }

    public boolean setSelectedObject(BusinessObject object) {
        return false;
    }

    @Override
    public void addFocusListener(FocusListener l) {
        this.myFocusListener.add(l);
    }

    @Override
    public FocusListener[] getFocusListeners() {
        return this.myFocusListener.toArray(new FocusListener[this.myFocusListener.size()]);
    }

    @Override
    public void removeFocusListener(FocusListener l) {
        this.myFocusListener.remove(l);
    }

    public BusinessObject getObject(int num) {
        return null;
    }

    private void loadData() {
        if (this.data != null && this.data instanceof LazyLoader) {
            this.setLocked(false);
            new LoaderRunner((LazyLoader)this.data).execute();
        }
        this.dataModified = false;
    }

    @Override
    public void paint(Graphics g) {
        if (this.dataModified) {
            this.loadData();
        }
        super.paint(g);
    }

    @Override
    public TableModel getTableModel() {
        if (this.dataModified) {
            this.loadData();
        }
        return this.model;
    }

    public void setEnterAction(Runnable run) {
        this.enterAction = run;
    }

    @Override
    public void terminate() {
        for (FocusListener focusListener : this.jxTable.getFocusListeners()) {
            this.jxTable.removeFocusListener(focusListener);
        }
        this.jxTable.getSelectionModel().removeListSelectionListener(this.selectionHandler);
        this.selectionHandler = null;
        this.data = null;
        this.removeAll();
        this.jxTable = null;
        this.model = null;
        this.myFocusListener.clear();
        this.myFocusListener = null;
        this.selectionHandler = null;
        this.controller = null;
        this.sortKeys = null;
        this.layoutFileName = null;
        this.tableComparator = null;
        this.tableLayout = null;
        this.tableColumns = null;
        this.columnModel = null;
        this.enterAction = null;
        super.terminate();
    }

    @Override
    public JXTable getTable() {
        return this.jxTable;
    }

    public List<MetaInfo> getData() {
        return this.data;
    }

    @Override
    public void reloadColumnModel() {
        EFCColumnModel tableColumnModel = new EFCColumnModel(this.model);
        for (int i = 0; i < this.tableColumns.size(); ++i) {
            tableColumnModel.addColumn((TableColumn)((Object)this.tableColumns.get(i)));
        }
        this.jxTable.setColumnModel((TableColumnModel)((Object)tableColumnModel));
    }

    @Override
    public void setColumnModelXML(String xml) {
        List tableColumnLayoutInfos = null;
        if (xml != null) {
            XMLDecoder xmlDecoder = new XMLDecoder(new ByteArrayInputStream(xml.getBytes()));
            tableColumnLayoutInfos = (List)xmlDecoder.readObject();
            xmlDecoder.close();
        }
        this.columnModel = new EFCColumnModel(this.model);
        for (String col : this.model.getCols()) {
            EFCTableColumnLayoutInfo infoCol = new EFCTableColumnLayoutInfo(col);
            if (tableColumnLayoutInfos != null && tableColumnLayoutInfos.contains(infoCol)) {
                EFCTableColumnLayoutInfo tableColumnLayoutInfo = (EFCTableColumnLayoutInfo)tableColumnLayoutInfos.get(tableColumnLayoutInfos.indexOf(infoCol));
                EFCTableColExt tableColumn = this.tableColumns.stream().filter(tab -> tab.getIdentifier().equals(tableColumnLayoutInfo.getColumnName())).findFirst().orElse(null);
                tableColumn.setDefaultSize(false);
                tableColumn.setPreferredWidth(tableColumnLayoutInfo.getWidth());
                tableColumn.setVisible(tableColumnLayoutInfo.isVisible());
                tableColumn.setOrder(tableColumnLayoutInfo.getOrder());
                continue;
            }
            EFCTableColExt tableColumn = new EFCTableColExt(((ListTableModel)this.jxTable.getModel()).getCols().indexOf(col));
            tableColumn.setHeaderValue(((ListTableModel)this.jxTable.getModel()).getColumnName(((ListTableModel)this.jxTable.getModel()).getCols().indexOf(col)));
            tableColumn.setIdentifier(infoCol.getColumnName());
            tableColumn.setVisible(true);
            tableColumn.setOrder(this.tableColumns.size() - 1);
        }
        Collections.sort(this.tableColumns, this.tableComparator);
        for (EFCTableColExt tableColumn : this.tableColumns) {
            this.columnModel.addColumn((TableColumn)((Object)tableColumn));
        }
        this.reloadColumnModel();
        this.isTableLayoutLoaded = true;
    }

    @Override
    public String getLayoutFileName() {
        return this.layoutFileName;
    }

    public void setLayoutFileName(String layoutFileName) {
        this.layoutFileName = layoutFileName;
    }

    public void setTableLayout(String tableLayout, Boolean byAdmin) {
        this.tableLayout = tableLayout;
        this.isTableLayoutByAdmin = byAdmin;
        if (tableLayout != null) {
            this.isTableLayoutLoaded = false;
        }
    }

    public void addColsToColumsModel(String[] colname) {
        if (colname != null) {
            for (int i = 0; i < colname.length; ++i) {
                EFCTableColExt columnExt = new EFCTableColExt(this.model.getColIndex(colname[i]));
                columnExt.setIdentifier(colname[i]);
                if (this.model.getColIndex(colname[i]) != -1) {
                    columnExt.setHeaderValue(this.model.getColumnName(this.model.getColIndex(colname[i])));
                }
                this.tableColumns.add(columnExt);
            }
        }
    }

    @Override
    public String getColumnModelXML() {
        EFCColumnModel tableColumnModel = (EFCColumnModel)((Object)this.jxTable.getColumnModel());
        ArrayList<EFCTableColumnLayoutInfo> tableColumnLayoutInfos = new ArrayList<EFCTableColumnLayoutInfo>();
        String xmlString = null;
        List<EFCTableColExt> tableColumns = tableColumnModel.getActColumns();
        for (int currentColumnIndex = 0; currentColumnIndex < tableColumns.size(); ++currentColumnIndex) {
            TableColumnExt tableColumn = tableColumns.get(currentColumnIndex);
            TableColumnExt col = tableColumnModel.getColumnExt(tableColumn.getIdentifier());
            EFCTableColumnLayoutInfo tableColumnLayoutInfo = new EFCTableColumnLayoutInfo(tableColumn.getIdentifier().toString(), currentColumnIndex, col.getWidth(), tableColumn.isVisible());
            tableColumnLayoutInfos.add(tableColumnLayoutInfo);
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XMLEncoder xmlEncoder = new XMLEncoder(output);
        xmlEncoder.writeObject(tableColumnLayoutInfos);
        xmlEncoder.close();
        xmlString = output.toString();
        return xmlString;
    }

    @Override
    public void clearTableColums() {
        this.tableColumns.clear();
        this.tableLayout = null;
        this.isTableLayoutLoaded = false;
        this.loadListModel();
    }

    protected class MyListSelectionHandler
    implements ListSelectionListener {
        private String lastClickedElement;
        private int lastClickedRow = -1;
        private int lastClickedColumn = -1;

        protected MyListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            logger.debug("ListTableSelectionHandler.valueChanged() on {}", (Object)EFCListTablePanel.this.getIdent());
            int column = EFCListTablePanel.this.jxTable.getSelectedColumn();
            int row = EFCListTablePanel.this.jxTable.getSelectedRow();
            String colName = null;
            if (EFCListTablePanel.this.unselected) {
                this.lastClickedColumn = -1;
                this.lastClickedRow = -1;
            }
            colName = column >= 0 ? EFCListTablePanel.this.model.getColumnId(EFCListTablePanel.this.jxTable.getSelectedColumn()) : null;
            if (this.lastClickedRow == row) {
                if (colName == null && this.lastClickedElement == null) {
                    return;
                }
                if (colName == null || colName.equalsIgnoreCase(this.lastClickedElement)) {
                    return;
                }
            }
            EFCListTablePanel src = EFCListTablePanel.this;
            int eventId = 2079;
            Point oldPoint = new Point();
            oldPoint.x = this.lastClickedColumn;
            oldPoint.y = this.lastClickedRow;
            Point newPoint = new Point();
            newPoint.x = column;
            newPoint.y = row;
            if (this.lastClickedRow != row) {
                SelectionContextChangeEvent sece = new SelectionContextChangeEvent(src, eventId, EFCListTablePanel.this.getIdent(), oldPoint, newPoint);
                sece.setSelected(EFCListTablePanel.this.getSelectedObject());
                DataChangeManager dcm = EFCListTablePanel.this.getDataChangeManager();
                if (dcm != null) {
                    dcm.onSelectionContextChanged(sece);
                }
            }
            this.lastClickedRow = row;
            this.lastClickedColumn = column;
            this.lastClickedElement = colName;
        }
    }

    private class LoaderRunner
    extends SwingWorker<Object, Object> {
        private LazyLoader data2load;
        private boolean isUpdated;

        public LoaderRunner(LazyLoader data) {
            this.data2load = data;
            this.isUpdated = false;
            EFCListTablePanel.this.setLocked(true);
        }

        @Override
        protected Object doInBackground() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.data2load.lock();
            if (!this.data2load.isLoaded()) {
                this.data2load.load();
                if (EFCListTablePanel.this.data.size() > 0 && EFCListTablePanel.this.colNames.isEmpty()) {
                    int i;
                    MetaInfo element = EFCListTablePanel.this.data.get(0);
                    Field[] fields = element.getClass().getDeclaredFields();
                    for (i = 0; i < fields.length; ++i) {
                        if (Modifier.isStatic(fields[i].getModifiers()) || fields[i].getName().startsWith("_") || fields[i].getName().endsWith("Property")) continue;
                        EFCListTablePanel.this.colNames.add((Object)fields[i].getName());
                    }
                    fields = element.getClass().getSuperclass().getDeclaredFields();
                    for (i = 0; i < fields.length; ++i) {
                        if (Modifier.isStatic(fields[i].getModifiers()) || fields[i].getName().startsWith("_") || fields[i].getName().endsWith("Property")) continue;
                        EFCListTablePanel.this.colNames.add((Object)fields[i].getName());
                    }
                }
                this.isUpdated = true;
            }
            this.data2load.unlock();
            return null;
        }

        @Override
        protected void done() {
            block4: {
                try {
                    this.get();
                    if (this.isUpdated) {
                        EFCListTablePanel.this.loadListModel();
                    }
                    EFCListTablePanel.this.dataModified = false;
                    EFCListTablePanel.this.jxTable.setVisible(true);
                    EFCColumnResizer.adjustColumnPreferredWidthsByType((JTable)((Object)EFCListTablePanel.this.jxTable), null, EFCListTablePanel.this.tableColumns);
                    ListTableDataLoadedEvent listTableDataLoadedEvent = new ListTableDataLoadedEvent(EFCListTablePanel.this, 2089, EFCListTablePanel.this.getIdent());
                    DataChangeManager dcm = EFCListTablePanel.this.getDataChangeManager();
                    if (dcm != null) {
                        dcm.onListTableDataLoaded(listTableDataLoadedEvent);
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error(Translator.tr((String)"MSG_FRAME_EXCEPTION"), (Throwable)e);
                    if (!(e.getCause() instanceof ApplicationException)) break block4;
                    EFCDesktop.showInfoDlg(((ApplicationException)e.getCause()).getMsgList());
                }
            }
            EFCListTablePanel.this.setLocked(false);
        }
    }

    private static class TableComparator
    implements Comparator<EFCTableColExt> {
        private TableComparator() {
        }

        @Override
        public int compare(EFCTableColExt o1, EFCTableColExt o2) {
            if (o1.getOrder() < o2.getOrder()) {
                return -1;
            }
            if (o1.getOrder() > o2.getOrder()) {
                return 1;
            }
            return 0;
        }
    }
}

