/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.base.datatypes.EFCBlob;
import de.effectivecompany.data.EFCReportContainer;
import de.effectivecompany.gui.components.fx.EFCPDFBoxViewer;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCPDFViewerPanel
extends EFCPanel {
    public static final long serialVersionUID = -342343136L;
    private EFCReportContainer efcReportContainer;
    private static ImageIcon icon;
    private EFCPDFBoxViewer viewer;
    private static Logger logger;

    public EFCPDFViewerPanel(String ident, EFCReportContainer efcReportContainer, String string) {
        super(ident);
        this.efcReportContainer = efcReportContainer;
        this.init();
    }

    public EFCPDFViewerPanel(String ident, EFCReportContainer efcReportContainer) {
        this(ident, efcReportContainer, efcReportContainer.getInfo());
    }

    public EFCPDFViewerPanel(String ident, EFCBlob efcBlob) {
        this(ident, new EFCReportContainer(efcBlob));
    }

    public EFCPDFViewerPanel(ElementManager manager, DataChangeManager dcm, String ident) {
        super(manager, dcm, ident);
        this.init();
    }

    private void init() {
        if (icon == null) {
            icon = EFCLookAndFeelManager.ICON_APP_TEXT_EDITOR;
        }
        this.setLayout(new BorderLayout());
        this.viewer = new EFCPDFBoxViewer();
        this.add((Component)this.viewer, "Center");
        this.viewer.load(this.efcReportContainer);
    }

    public void initDoc(EFCBlob efcBlob) {
        this.efcReportContainer = new EFCReportContainer(efcBlob);
        try {
            this.viewer.load(this.efcReportContainer);
        }
        catch (Throwable th) {
            logger.error("Fehler PDF Preview(falsches Dateiformat)");
        }
    }

    @Override
    public void terminate() {
        this.viewer.terminate();
        this.viewer = null;
        super.terminate();
    }

    public EFCReportContainer getEfcReportContainer() {
        return this.efcReportContainer;
    }

    public EFCPDFBoxViewer getViewer() {
        return this.viewer;
    }

    static {
        logger = LoggerFactory.getLogger(EFCPDFViewerPanel.class);
    }
}

