/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.base.data.LazyLoader;
import de.effectivecompany.gui.components.panel.EFCGlassPanel;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.panel.EFCResourceDiagramPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.swing.EFCRangeSlider;
import de.effectivecompany.gui.data.chart.EFCDefaultBarChart;
import de.effectivecompany.gui.data.chart.EFCDefaultBarChartList;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EFCResourceDiagramListPanel
extends EFCPanel {
    private static final long serialVersionUID = -277152050729703605L;
    private JPanel mainPanel = new JPanel();
    private EFCGlassPanel glass;
    private EFCDefaultBarChartList diagrams;
    private ElementManager elementManager;
    private DataChangeManager changeManager;
    private String ident;
    private String parentIdent;
    private EFCRangeSlider slider;
    private JScrollPane scrollPane;
    public boolean dataModified = false;

    public EFCResourceDiagramListPanel(ElementManager eManager, DataChangeManager dcManager, String ident, String parentIdent, boolean border) {
        super(eManager, dcManager, ident, parentIdent, border);
        this.ident = ident;
        this.elementManager = eManager;
        this.changeManager = dcManager;
        this.parentIdent = parentIdent;
        this.scrollPane = new JScrollPane(this.mainPanel);
        this.glass = new EFCGlassPanel(this.scrollPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.glass, "Center");
    }

    public void setLocked(boolean locked) {
        if (this.glass != null) {
            this.glass.setEnabled(!locked);
            if (locked) {
                this.setCursor(new Cursor(3));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private Boolean init() {
        this.mainPanel.removeAll();
        this.slider = new EFCRangeSlider();
        this.add((Component)this.slider, "North");
        if (this.diagrams != null && !this.diagrams.getResourceDiagrams().isEmpty()) {
            this.mainPanel.setLayout(new GridLayout(this.diagrams.getResourceDiagrams().size(), 1));
            for (EFCDefaultBarChart diagram : this.diagrams.getResourceDiagrams()) {
                EFCResourceDiagramPanel panel = new EFCResourceDiagramPanel(this, this.elementManager, this.changeManager, this.ident, this.parentIdent, false);
                panel.setDataset(diagram);
                panel.createChart();
                panel.setPreferredSize(panel.getPreferredSize());
                this.slider.setValue(diagram.getInitFirstValue());
                this.slider.setMinimum(0);
                this.slider.setMaximum(diagram.getColumnCount());
                panel.getSlide().setFirstCategoryIndex(diagram.getInitFirstValue().intValue());
                if (diagram.getVisibleColumnCount() != null) {
                    this.slider.setUpperValue(diagram.getVisibleColumnCount());
                    panel.getSlide().setMaximumCategoryCount(diagram.getVisibleColumnCount().intValue());
                } else {
                    this.slider.setUpperValue(diagram.getColumnCount());
                    panel.getSlide().setMaximumCategoryCount(diagram.getColumnCount());
                }
                this.mainPanel.add(panel);
            }
        }
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                for (int i = 0; i < EFCResourceDiagramListPanel.this.mainPanel.getComponentCount(); ++i) {
                    if (!(EFCResourceDiagramListPanel.this.mainPanel.getComponent(i) instanceof EFCResourceDiagramPanel)) continue;
                    EFCRangeSlider slider = (EFCRangeSlider)e.getSource();
                    ((EFCResourceDiagramPanel)EFCResourceDiagramListPanel.this.mainPanel.getComponent(i)).getSlide().setMaximumCategoryCount(slider.getUpperValue());
                    ((EFCResourceDiagramPanel)EFCResourceDiagramListPanel.this.mainPanel.getComponent(i)).getSlide().setFirstCategoryIndex(slider.getValue());
                }
            }
        });
        this.updateUI();
        this.dataModified = false;
        return true;
    }

    public void setDatasetList(EFCDefaultBarChartList datasetList) {
        this.diagrams = datasetList;
        this.dataModified = true;
    }

    public EFCDefaultBarChartList getDatasetList() {
        return this.diagrams;
    }

    @Override
    public void paint(Graphics g) {
        if (this.dataModified) {
            this.loadData();
        }
        super.paint(g);
    }

    private void loadData() {
        LazyLoader loader;
        EFCDefaultBarChartList data = this.getDatasetList();
        if (data instanceof LazyLoader && !(loader = (LazyLoader)data).isLoaded()) {
            new LoaderRunner().execute();
        }
        this.dataModified = false;
    }

    public void reload() {
        this.loadData();
    }

    private class LoaderRunner
    extends SwingWorker<Boolean, Object> {
        LazyLoader loadData;

        public LoaderRunner() {
            EFCResourceDiagramListPanel.this.setLocked(true);
            EFCDefaultBarChartList data = EFCResourceDiagramListPanel.this.getDatasetList();
            if (data instanceof LazyLoader) {
                this.loadData = data;
            }
        }

        @Override
        protected Boolean doInBackground() {
            if (this.loadData != null) {
                this.loadData.lock();
                if (!this.loadData.isLoaded()) {
                    this.loadData.load();
                }
                this.loadData.unlock();
            }
            return EFCResourceDiagramListPanel.this.init();
        }

        @Override
        protected void done() {
            try {
                this.get();
            }
            catch (Throwable e) {
                EFCDesktop.reportError(e);
            }
            EFCResourceDiagramListPanel.this.setLocked(false);
        }
    }
}

