/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.gui.components.frame.EFCResDiagramDialog;
import de.effectivecompany.gui.components.panel.EFCGlassPanel;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.panel.EFCResourceDiagramListPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.data.BusinessObjectModel;
import de.effectivecompany.gui.data.chart.EFCCategoryAxis;
import de.effectivecompany.gui.data.chart.EFCDefaultBarChart;
import de.effectivecompany.gui.data.chart.EFCDefaultCategoryDataset;
import de.effectivecompany.gui.events.SelectionContextChangeEvent;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.SlidingCategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCResourceDiagramPanel
extends EFCPanel
implements ChartMouseListener {
    private static final long serialVersionUID = 1172937375418920474L;
    private ChartPanel chartPanel = new ChartPanel(null);
    private EFCGlassPanel glass;
    private static final Logger logger = LoggerFactory.getLogger(EFCResourceDiagramPanel.class);
    private SlidingCategoryDataset slide;
    private Integer lastSelectedSeries;
    private BusinessObject lastSelection;

    public EFCResourceDiagramPanel(EFCResourceDiagramListPanel parent, ElementManager eManager, DataChangeManager dcManager, String ident, String parentIdent, boolean border) {
        super(eManager, dcManager, ident, parentIdent, border);
        this.chartPanel.setMaximumDrawHeight(300);
        this.chartPanel.addChartMouseListener((ChartMouseListener)this);
        this.chartPanel.setMouseZoomable(false);
        this.chartPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getScrollType() != 0) {
                    return;
                }
                if (e.getWheelRotation() < 0) {
                    this.increaseZoom((JComponent)((ChartPanel)e.getComponent()), true);
                } else {
                    this.decreaseZoom((JComponent)((ChartPanel)e.getComponent()), true);
                }
            }

            public void increaseZoom(JComponent chart, boolean saveAction) {
                ChartPanel ch = (ChartPanel)chart;
                this.zoomChartAxis(ch, true);
            }

            public void decreaseZoom(JComponent chart, boolean saveAction) {
                ChartPanel ch = (ChartPanel)chart;
                this.zoomChartAxis(ch, false);
            }

            private void zoomChartAxis(ChartPanel chartP, boolean increase) {
                int width = chartP.getMaximumDrawWidth() - chartP.getMinimumDrawWidth();
                int height = chartP.getMaximumDrawHeight() - chartP.getMinimumDrawWidth();
                if (increase) {
                    chartP.zoomInBoth((double)(width / 2), (double)(height / 2));
                } else {
                    chartP.zoomOutBoth((double)(width / 2), (double)(height / 2));
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        JPanel panel = new JPanel();
        panel.add((Component)this.chartPanel);
        scrollPane.getViewport().add(panel);
        this.glass = new EFCGlassPanel(scrollPane);
        this.add(this.glass);
    }

    public JFreeChart createChart() {
        EFCDefaultBarChart dataSet = (EFCDefaultBarChart)this.slide.getUnderlyingDataset();
        JFreeChart chart = ChartFactory.createStackedBarChart((String)dataSet.getTitle(), (String)dataSet.getDomainAxisLabel(), (String)dataSet.getRangeAxisLabel(), (CategoryDataset)this.slide, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)dataSet.getLegendVisible(), (boolean)dataSet.getTooltipsVisible(), (boolean)dataSet.getUrlVisible());
        CustomGroupedStackedBarRenderer renderer = new CustomGroupedStackedBarRenderer();
        renderer.setDefaultOutlineStroke(new BasicStroke(0.5f));
        renderer.setDrawBarOutline(true);
        if (dataSet.getKeyToGroupMap() != null) {
            renderer.setSeriesToGroupMap(dataSet.getKeyToGroupMap());
        }
        renderer.setItemMargin(0.0);
        renderer.setMaximumBarWidth(0.2);
        EFCCategoryAxis efcCategoryAxis = new EFCCategoryAxis(dataSet.getDomainAxisLabel());
        efcCategoryAxis.setCategoryMargin(0.0);
        efcCategoryAxis.setxAxisValueInterval(dataSet.getxAxisValueInterval());
        efcCategoryAxis.setCategoryLabelPositions(dataSet.getCategoryLabelPositions());
        chart.getCategoryPlot().setDomainAxis((CategoryAxis)efcCategoryAxis);
        if (dataSet.getRange() != null) {
            chart.getCategoryPlot().getRangeAxis().setAutoRange(false);
            chart.getCategoryPlot().getRangeAxis().setRange(dataSet.getRange());
        }
        List<Color> colors = dataSet.getSeriesColors();
        CategoryPlot categoryPlot = (CategoryPlot)chart.getPlot();
        categoryPlot.setRenderer((CategoryItemRenderer)renderer);
        categoryPlot.isDomainZoomable();
        StandardChartTheme chartTheme = (StandardChartTheme)ChartFactory.getChartTheme();
        chartTheme.setBarPainter((BarPainter)new StandardBarPainter());
        if (dataSet.getDiagramLableFont() != null) {
            chartTheme.setRegularFont(dataSet.getDiagramLableFont());
            chartTheme.setLargeFont(dataSet.getDiagramLableFont());
        }
        chartTheme.apply(chart);
        for (int i = 0; i < colors.size(); ++i) {
            renderer.setSeriesPaint(i, colors.get(i));
        }
        if (dataSet.getDiagramTitleFont() != null && chart.getTitle() != null) {
            chart.getTitle().setFont(dataSet.getDiagramTitleFont());
        }
        this.chartPanel.setChart(chart);
        this.chartPanel.setPreferredSize(dataSet.getDimension());
        this.chartPanel.setMinimumDrawHeight((int)dataSet.getDimension().getHeight());
        this.chartPanel.setMaximumDrawHeight((int)dataSet.getDimension().getHeight());
        this.chartPanel.setMinimumDrawWidth((int)dataSet.getDimension().getWidth());
        this.chartPanel.setMaximumDrawWidth((int)dataSet.getDimension().getWidth());
        this.chartPanel.updateUI();
        this.chartPanel.setChart(chart);
        return chart;
    }

    public void setDataset(EFCDefaultBarChart dataset) {
        this.slide = new SlidingCategoryDataset((CategoryDataset)dataset, 0, dataset.getColumnCount());
    }

    public EFCDefaultBarChart getDataset() {
        return (EFCDefaultBarChart)this.slide.getUnderlyingDataset();
    }

    public void chartMouseClicked(ChartMouseEvent event) {
        ChartEntity entity = event.getEntity();
        event.getSource();
        BusinessObject businessObject = null;
        if (this.lastSelectedSeries != null) {
            this.chartPanel.getChart().getCategoryPlot().getRenderer().setSeriesOutlinePaint(this.lastSelectedSeries.intValue(), (Paint)Color.GRAY);
            BasicStroke stroke = new BasicStroke(0.5f);
            this.chartPanel.getChart().getCategoryPlot().getRenderer().setSeriesOutlineStroke(this.lastSelectedSeries.intValue(), (Stroke)stroke);
        }
        BusinessObject oldSelection = null;
        BusinessObject newSelection = null;
        oldSelection = this.lastSelection;
        SelectionContextChangeEvent sece = null;
        EFCResourceDiagramPanel src = this;
        if (entity instanceof CategoryItemEntity) {
            CategoryItemEntity result = (CategoryItemEntity)entity;
            EFCDefaultCategoryDataset data = (EFCDefaultCategoryDataset)((SlidingCategoryDataset)result.getDataset()).getUnderlyingDataset();
            this.chartPanel.getChart().getCategoryPlot().getRenderer().setSeriesOutlinePaint(result.getDataset().getRowIndex(result.getRowKey()), (Paint)Color.BLACK);
            BasicStroke stroke = new BasicStroke(1.5f);
            this.chartPanel.getChart().getCategoryPlot().getRenderer().setSeriesOutlineStroke(result.getDataset().getRowIndex(result.getRowKey()), (Stroke)stroke);
            businessObject = data.getBusinessObject(((CategoryItemEntity)entity).getRowKey(), ((CategoryItemEntity)entity).getColumnKey());
            data.getMaxValue(((CategoryItemEntity)entity).getRowKey(), ((CategoryItemEntity)entity).getColumnKey());
            this.lastSelectedSeries = result.getDataset().getRowIndex(result.getRowKey());
            newSelection = businessObject;
            if (newSelection != null) {
                if (newSelection != oldSelection) {
                    sece = new SelectionContextChangeEvent(src, 2084, this.getIdent(), oldSelection, newSelection);
                    sece.setSelected(newSelection);
                }
            } else {
                sece = new SelectionContextChangeEvent(src, 2084, this.getIdent(), oldSelection, newSelection);
                sece.setSelected(newSelection);
            }
            if (event.getTrigger().getClickCount() == 2 && businessObject != null) {
                EFCResDiagramDialog optionPane = new EFCResDiagramDialog(this, "FA umterminieren", "prd/TdPrdDocOpr_ResDiagInfo.xml", new BusinessObjectModel(businessObject));
                EFCDesktop.getInstance().add(optionPane);
                EFCDesktop.getInstance().moveToFront(optionPane);
                EFCDesktop.getInstance().setSelectedFrame(optionPane);
                try {
                    optionPane.setSelected(true);
                }
                catch (PropertyVetoException e) {
                    logger.error("", (Throwable)e);
                }
            }
        } else {
            sece = new SelectionContextChangeEvent(src, 2084, this.getIdent(), oldSelection, newSelection);
            sece.setSelected(newSelection);
        }
        if (sece != null) {
            DataChangeManager dcm = this.getDataChangeManager();
            if (dcm != null) {
                dcm.onSelectionContextChanged(sece);
            }
            this.lastSelection = newSelection;
        }
    }

    public void chartMouseMoved(ChartMouseEvent event) {
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public SlidingCategoryDataset getSlide() {
        return this.slide;
    }

    @Override
    public void terminate() {
        this.chartPanel = null;
        this.slide = null;
        this.lastSelectedSeries = null;
        this.lastSelection = null;
        this.glass = null;
        this.removeAll();
    }

    public class CustomGroupedStackedBarRenderer
    extends GroupedStackedBarRenderer {
        private static final long serialVersionUID = 3748132900436694420L;

        public Paint getItemPaint(int row, int column) {
            Color color;
            SlidingCategoryDataset data;
            if (this.getPlot().getDataset() instanceof SlidingCategoryDataset && (data = (SlidingCategoryDataset)this.getPlot().getDataset()).getUnderlyingDataset() instanceof EFCDefaultCategoryDataset && (color = ((EFCDefaultCategoryDataset)data.getUnderlyingDataset()).getColor(row, column)) != null) {
                return color;
            }
            return this.lookupSeriesPaint(row);
        }
    }
}

