/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.gui.components.panel.EFCGlassPanel;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.util.UnitConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class EFCSplitPanel
extends EFCPanel {
    public static final long serialVersionUID = -734563L;
    private EFCGlassPanel glass1;
    private EFCGlassPanel glass2;
    private JSplitPane pane;
    private ComponentListener resizeListener = new MyComponentListener();
    private double orientationPercent;
    private boolean usePercent;
    private boolean fixed;
    private boolean lockable = false;

    public EFCSplitPanel(ElementManager eManager, DataChangeManager dcManager, String ident, String parentIdent, boolean border, int orientation, boolean fixed, boolean lockable, JComponent panel1, JComponent panel2) {
        super(eManager, dcManager, ident, parentIdent, border);
        this.fixed = fixed;
        this.lockable = lockable;
        this.setLayout(new BorderLayout());
        if (lockable) {
            this.glass1 = new EFCGlassPanel(panel1);
            this.glass2 = new EFCGlassPanel(panel2);
            this.pane = new JSplitPane(orientation, this.glass1, this.glass2);
        } else {
            this.pane = new JSplitPane(orientation, panel1, panel2);
        }
        this.pane.setUI(new BasicSplitPaneUI(){

            @Override
            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){
                    private static final long serialVersionUID = 7737373160390078226L;

                    @Override
                    public void setBorder(Border b) {
                    }
                };
            }
        });
        this.pane.setBorder(null);
        if (fixed) {
            this.pane.setDividerSize(0);
        } else {
            this.pane.setOneTouchExpandable(true);
        }
        this.pane.getInputMap(1).put(KeyStroke.getKeyStroke(112, 0), "none");
        this.pane.getInputMap(1).put(KeyStroke.getKeyStroke(113, 0), "none");
        this.pane.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0), "none");
        this.pane.getInputMap(1).put(KeyStroke.getKeyStroke(115, 0), "none");
        this.pane.getInputMap(1).put(KeyStroke.getKeyStroke(116, 0), "none");
        this.pane.getInputMap(1).put(KeyStroke.getKeyStroke(117, 0), "none");
        this.pane.getInputMap(1).put(KeyStroke.getKeyStroke(118, 0), "none");
        this.pane.getInputMap(1).put(KeyStroke.getKeyStroke(119, 0), "none");
        this.pane.getInputMap(1).put(KeyStroke.getKeyStroke(120, 0), "none");
        this.pane.getInputMap(1).put(KeyStroke.getKeyStroke(121, 0), "none");
        this.pane.getInputMap(1).put(KeyStroke.getKeyStroke(122, 0), "none");
        this.pane.getInputMap(1).put(KeyStroke.getKeyStroke(123, 0), "none");
        this.add((Component)this.pane, "Center");
        this.addComponentListener(this.resizeListener);
    }

    public JSplitPane getPane() {
        return this.pane;
    }

    public void setDividerLocation(int location) {
        Component panel1 = this.pane.getLeftComponent();
        Component panel2 = this.pane.getRightComponent();
        Dimension locactionDimension = UnitConverter.sizeFromDLU(new Dimension(location, location), this);
        panel1.setPreferredSize(locactionDimension);
        if (this.fixed) {
            panel1.setMinimumSize(locactionDimension);
        } else {
            Dimension minimumSize = new Dimension(0, 0);
            panel1.setMinimumSize(minimumSize);
            panel2.setMinimumSize(minimumSize);
            panel2.setPreferredSize(locactionDimension);
            if (this.pane.getOrientation() == 1) {
                this.pane.setDividerLocation(locactionDimension.width);
            } else {
                this.pane.setDividerLocation(locactionDimension.height);
            }
        }
        this.usePercent = false;
    }

    public void setRelativeDividerLocation(double percent) {
        Component panel1 = this.pane.getLeftComponent();
        Component panel2 = this.pane.getRightComponent();
        Dimension minimumSize = new Dimension(0, 0);
        panel1.setMinimumSize(minimumSize);
        if (panel2 != null) {
            panel2.setMinimumSize(minimumSize);
        }
        panel1.setSize(this.getMinimumSize());
        this.orientationPercent = percent;
        this.usePercent = true;
        this.resizeListener.componentResized(new ComponentEvent(this, 101));
    }

    public void lockPanel1(boolean locked) {
        if (this.glass1 != null) {
            this.glass1.setEnabled(!locked);
            if (locked) {
                this.setCursor(new Cursor(3));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    public void lockPanel2(boolean locked) {
        if (this.glass2 != null) {
            this.glass2.setEnabled(!locked);
            if (locked) {
                this.setCursor(new Cursor(3));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    @Override
    public void terminate() {
        this.removeComponentListener(this.resizeListener);
        this.resizeListener = null;
        this.removeAll();
        this.pane = null;
        super.terminate();
    }

    private class MyComponentListener
    implements ComponentListener {
        private MyComponentListener() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (EFCSplitPanel.this.usePercent) {
                if (EFCSplitPanel.this.pane != null) {
                    EFCSplitPanel.this.pane.setDividerLocation(EFCSplitPanel.this.orientationPercent / 100.0);
                }
                if (EFCSplitPanel.this.fixed) {
                    Dimension dim2;
                    Dimension dim1;
                    Component panel1 = EFCSplitPanel.this.pane.getLeftComponent();
                    Component panel2 = EFCSplitPanel.this.pane.getRightComponent();
                    if (EFCSplitPanel.this.pane.getOrientation() == 0) {
                        dim1 = new Dimension(EFCSplitPanel.this.getWidth(), (int)((double)panel1.getHeight() * EFCSplitPanel.this.orientationPercent) / 100);
                        dim2 = new Dimension(EFCSplitPanel.this.getWidth(), EFCSplitPanel.this.getHeight() - (int)((double)panel1.getHeight() * EFCSplitPanel.this.orientationPercent) / 100);
                    } else {
                        dim1 = new Dimension((int)((double)EFCSplitPanel.this.getWidth() * EFCSplitPanel.this.orientationPercent) / 100, panel1.getHeight());
                        dim2 = new Dimension(EFCSplitPanel.this.getWidth() - (int)((double)EFCSplitPanel.this.getWidth() * EFCSplitPanel.this.orientationPercent) / 100, panel2.getHeight());
                    }
                    panel1.setMinimumSize((Dimension)dim1.clone());
                    panel1.setMaximumSize((Dimension)dim1.clone());
                    panel1.setPreferredSize((Dimension)dim1.clone());
                    panel1.setSize((Dimension)dim1.clone());
                    if (panel2 != null) {
                        panel2.setMinimumSize((Dimension)dim2.clone());
                        panel2.setMaximumSize((Dimension)dim2.clone());
                        panel2.setPreferredSize((Dimension)dim2.clone());
                        panel2.setSize((Dimension)dim2.clone());
                    }
                }
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }
}

