/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.panel.EFCGlassPanel;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.data.BusinessObjectModel;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import java.awt.Component;
import java.awt.Cursor;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class EFCSubPanel
extends EFCPanel {
    private static final long serialVersionUID = -1666330772156008605L;
    private boolean dataLoaded = true;
    private String layout;
    private EFCController controller;
    private BusinessObjectModel boModel;
    private Class<?> dataClass;
    private boolean isLayoutLoaded = false;
    private SwingWorker<Object, Object> loadWorker;
    private EFCGlassPanel glass;

    public EFCSubPanel(ElementManager elementManager, DataChangeManager dataChangeManager, Class<?> dataclass, BusinessObjectModel boModel, String ident, String subLayout, EFCController controller) {
        super(elementManager, dataChangeManager, ident);
        this.layout = subLayout;
        this.controller = controller;
        this.boModel = boModel;
        this.dataClass = dataclass;
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                EFCSubPanel.this.updatePanel();
            }
        });
    }

    private void loadLayout() {
        if (this.controller.getBusObj() != null) {
            new SwingWorker<JComponent, Object>(){

                @Override
                protected JComponent doInBackground() throws Exception {
                    return EFCPanelSingleton.getInstance().generatePanel(EFCSubPanel.this.layout, EFCSubPanel.this.dataClass, EFCSubPanel.this.getElementManager(), EFCSubPanel.this.getDataChangeManager(), EFCSubPanel.this.boModel, EFCSubPanel.this.controller);
                }

                @Override
                protected void done() {
                    JComponent comp = null;
                    try {
                        comp = (JComponent)this.get();
                        if (comp != null) {
                            EFCSubPanel.this.glass = new EFCGlassPanel(comp);
                            EFCSubPanel.this.add((Component)EFCSubPanel.this.glass, "Center");
                            EFCSubPanel.this.isLayoutLoaded = true;
                            EFCSubPanel.this.controller.resetPanels();
                            EFCSubPanel.this.dataLoaded = false;
                            EFCSubPanel.this.loadDataInBackground();
                        }
                    }
                    catch (InterruptedException | ExecutionException e) {
                        EFCDesktop.reportError(e);
                    }
                }
            }.execute();
        }
    }

    public void updatePanel() {
        if (this.controller.getBusObj() != null && !this.isLayoutLoaded) {
            this.loadLayout();
        }
    }

    public void setLocked(boolean locked) {
        if (this.glass != null) {
            this.glass.setEnabled(!locked);
            if (locked) {
                this.setCursor(new Cursor(3));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void loadDataInBackground() {
        if (!this.dataLoaded) {
            this.setLocked(true);
            if (this.loadWorker == null) {
                this.loadWorker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        if (!EFCSubPanel.this.dataLoaded) {
                            EFCSubPanel.this.controller.onSubPanelDataLoading(EFCSubPanel.this.getIdent());
                        }
                        EFCSubPanel.this.dataLoaded = true;
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                            EFCSubPanel.this.controller.onSubPanelDataLoadFinished(EFCSubPanel.this.getIdent());
                            EFCSubPanel.this.setLocked(false);
                            EFCSubPanel.this.loadWorker = null;
                        }
                        catch (InterruptedException | ExecutionException e) {
                            EFCDesktop.reportError(e);
                        }
                    }
                };
                this.loadWorker.execute();
            }
        }
    }

    public void setDataNotLoaded() {
        if (this.controller.getBusObj() != null) {
            if (this.isLayoutLoaded) {
                this.dataLoaded = false;
                this.loadDataInBackground();
            } else {
                this.loadLayout();
            }
        }
    }

    @Override
    public void terminate() {
        super.terminate();
    }
}

