/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.panel.EFCTabEntity;
import de.effectivecompany.gui.events.SelectionContextChangeEvent;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.Component;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCTabPanel
extends EFCPanel {
    private static final long serialVersionUID = 1758153332237353707L;
    private static Logger logger = LoggerFactory.getLogger(EFCTabPanel.class);
    protected boolean tabChangeNotifing = true;
    private JTabbedPane pane = new JTabbedPane(1, EFCLookAndFeelManager.TAB_LAYOUT_POLICY);
    protected CopyOnWriteArrayList<EFCTabEntity> tabEntities = new CopyOnWriteArrayList();
    public static int tabbedPaneCounter;
    private int oldActiveId = -1;

    public EFCTabPanel(ElementManager eManager, DataChangeManager dcManager, String ident, String parentIdent, boolean border) {
        super(eManager, dcManager, ident, parentIdent, border);
        this.pane.setFont(EFCLookAndFeelManager.FONT_TABPAGE_HEADER);
        this.pane.addChangeListener(new TabFocusListener());
        this.add(this.pane);
        logger.debug("TabbedPanes created: {}", (Object)(++tabbedPaneCounter));
        this.setFocusable(true);
    }

    public void setTabPaneComponent(EFCTabEntity comp) {
        this.pane.setComponentAt(this.pane.indexOfTab(comp.getTitle()), comp.getComponent());
    }

    public void updatePane() {
        this.tabChangeNotifing = false;
        Component selected = this.pane.getSelectedComponent();
        this.pane.removeAll();
        for (EFCTabEntity tabEntity : this.tabEntities) {
            if (!tabEntity.isVisible()) continue;
            this.pane.add(tabEntity.getTitle(), tabEntity.getComponent());
            JComponent component = tabEntity.getComponent();
            if (component != selected) continue;
            this.pane.setSelectedComponent(component);
        }
        this.tabChangeNotifing = true;
    }

    public void addAll(List<EFCTabEntity> tabEntities) {
        this.tabEntities.addAll(tabEntities);
        if (!this.tabEntities.isEmpty()) {
            this.tabEntities.get(0).setVisible(true);
            this.oldActiveId = 0;
        }
        this.updatePane();
    }

    public void remove(EFCPanel panel) {
        for (int i = 0; i < this.tabEntities.size(); ++i) {
            if (this.tabEntities.get(i).getComponent() != panel) continue;
            this.tabEntities.remove(i);
            --i;
        }
        this.updatePane();
    }

    public String getActiveTabId() {
        return this.getActiveTab().getIdent();
    }

    public EFCPanel getActiveTab() {
        Component c = this.pane.getSelectedComponent();
        if (c instanceof EFCPanel) {
            return (EFCPanel)c;
        }
        return null;
    }

    public int getTabId(String ident) {
        for (int i = 0; i < this.tabEntities.size(); ++i) {
            if (!this.tabEntities.get(i).getIdent().equalsIgnoreCase(ident)) continue;
            return i;
        }
        return -1;
    }

    public EFCTabEntity getTabEntity(String ident) {
        for (int i = 0; i < this.tabEntities.size(); ++i) {
            if (!this.tabEntities.get(i).getIdent().equalsIgnoreCase(ident)) continue;
            return this.tabEntities.get(i);
        }
        return null;
    }

    public int getTabId(EFCPanel panel) {
        for (int i = 0; i < this.tabEntities.size(); ++i) {
            if (this.tabEntities.get(i).getComponent() != panel) continue;
            return i;
        }
        return -1;
    }

    public void setTabVisible(String ident, boolean visible) {
        int id = this.getTabId(ident);
        if (id >= 0) {
            this.tabEntities.get(id).setVisible(visible);
        }
        this.updatePane();
    }

    public void setTabVisible(EFCPanel panel, boolean visible) {
        int id = this.getTabId(panel);
        if (id >= 0) {
            this.tabEntities.get(id).setVisible(visible);
        }
        this.updatePane();
    }

    public void setTabVisible(int id, boolean visible) {
        this.tabEntities.get(id).setVisible(visible);
        this.updatePane();
    }

    public boolean isTabVisible(String ident) {
        int id = this.getTabId(ident);
        if (id >= 0) {
            return this.tabEntities.get(id).isVisible();
        }
        throw new IllegalArgumentException("no tab with ident '" + ident + "' found");
    }

    public boolean isTabVisible(int id) {
        return this.tabEntities.get(id).isVisible();
    }

    public void setTabEnabled(String ident, boolean enabled) {
        int id = this.getTabId(ident);
        if (id >= 0) {
            this.tabEntities.get(id).setEnable(enabled);
        }
        this.updatePane();
    }

    public void setTabActiv(String ident) {
        int indexVisible = -1;
        for (int i = 0; i < this.tabEntities.size(); ++i) {
            if (this.tabEntities.get(i).isVisible()) {
                ++indexVisible;
            }
            if (!this.tabEntities.get(i).getIdent().equalsIgnoreCase(ident) || indexVisible < 0) continue;
            this.pane.setSelectedIndex(indexVisible);
        }
    }

    public void setTabEnabled(EFCPanel panel, boolean enabled) {
        int id = this.getTabId(panel);
        if (id >= 0) {
            this.tabEntities.get(id).setEnable(enabled);
        }
        this.updatePane();
    }

    public void setTabEnabled(int id, boolean enabled) {
        this.tabEntities.get(id).setEnable(enabled);
        this.updatePane();
    }

    public boolean isTabEnabled(String ident) {
        int id = this.getTabId(ident);
        if (id >= 0) {
            return this.tabEntities.get(id).isEnable();
        }
        throw new IllegalArgumentException("no tab with ident '" + ident + "' found");
    }

    public boolean isTabEnabled(int id) {
        return this.tabEntities.get(id).isEnable();
    }

    public void setTabTitle(String ident, String text) {
        int id = this.getTabId(ident);
        if (id >= 0) {
            this.tabEntities.get(id).setTitle(text);
        }
        this.updatePane();
    }

    public void setTabTitle(EFCPanel panel, String text) {
        int id = this.getTabId(panel);
        if (id >= 0) {
            this.tabEntities.get(id).setTitle(text);
        }
        this.updatePane();
    }

    public void setTabTitle(int id, String text) {
        this.tabEntities.get(id).setTitle(text);
        this.updatePane();
    }

    public String getTabTitle(String ident) {
        int id = this.getTabId(ident);
        if (id >= 0) {
            return this.tabEntities.get(id).getTitle();
        }
        throw new IllegalArgumentException("no tab with ident '" + ident + "' found");
    }

    public String getTabTitle(int id) {
        return this.tabEntities.get(id).getTitle();
    }

    @Override
    public void terminate() {
        for (ChangeListener changeListener : this.pane.getChangeListeners()) {
            this.pane.removeChangeListener(changeListener);
        }
        this.removeAll();
        this.pane = null;
        this.tabEntities = null;
        super.terminate();
    }

    public JTabbedPane getPane() {
        return this.pane;
    }

    private class TabFocusListener
    implements ChangeListener {
        private TabFocusListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            DataChangeManager dcm;
            if (!EFCTabPanel.this.tabChangeNotifing) {
                return;
            }
            String oldIdent = null;
            String newIdent = null;
            JTabbedPane sourceTabbedPane = (JTabbedPane)e.getSource();
            int newActiveId = sourceTabbedPane.getSelectedIndex();
            logger.debug("selected Tab: {}", (Object)newActiveId);
            if (EFCTabPanel.this.oldActiveId >= 0) {
                oldIdent = EFCTabPanel.this.tabEntities.get(EFCTabPanel.this.oldActiveId).getIdent();
            } else {
                for (EFCTabEntity tabEntity : EFCTabPanel.this.tabEntities) {
                    if (!tabEntity.isVisible()) continue;
                    oldIdent = tabEntity.getIdent();
                    break;
                }
            }
            if (newActiveId >= 0) {
                newIdent = EFCTabPanel.this.tabEntities.get(newActiveId).getIdent();
            }
            if ((dcm = EFCTabPanel.this.getDataChangeManager()) != null) {
                dcm.onSelectionContextChanged(new SelectionContextChangeEvent(EFCTabPanel.this, 2080, EFCTabPanel.this.getIdent(), oldIdent, newIdent));
            }
            EFCTabPanel.this.oldActiveId = newActiveId;
        }
    }
}

