/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.styleeditor;

import de.effectivecompany.gui.components.editor.EFCDefaultStyledDocument;
import de.effectivecompany.gui.components.swing.EFCSmallToggleButton;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.rtf.RTFEditorKit;

public class StyleEditor
extends JPanel {
    private static final long serialVersionUID = 6817029528544330660L;
    private JTextPane textPane;
    private EFCDefaultStyledDocument document;
    private RTFEditorKit rtfKit;
    private JToolBar toolBar;
    private JComboBox<String> cbFonts;
    private JComboBox<String> cbSizes;
    private EFCSmallToggleButton boldButton;
    private EFCSmallToggleButton italicButton;
    private String fontName = "";
    private int defaultfontSize = 0;
    private boolean skipUpdate;
    private int defaultXStart = -1;
    private int defaultXFinish = -1;
    private EFCSmallToggleButton underlineButton;
    private static StyleEditor instance;

    public static StyleEditor getInstance() {
        if (instance == null) {
            instance = new StyleEditor();
        }
        return instance;
    }

    private StyleEditor() {
        this.setLayout(new BorderLayout());
        this.textPane = new JTextPane();
        this.rtfKit = new RTFEditorKit();
        this.textPane.setEditorKit(this.rtfKit);
        this.document = new EFCDefaultStyledDocument();
        this.textPane.setFont(new Font("Arial", 0, 12));
        this.textPane.setDocument(this.document);
        JScrollPane ps = new JScrollPane(this.textPane);
        this.add((Component)ps, "Center");
        this.createMenuBar();
        this.setVisible(true);
        CaretListener lst = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                StyleEditor.this.showAttributes(e.getDot());
            }
        };
        this.textPane.addCaretListener(lst);
        FocusListener flst = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (StyleEditor.this.defaultXStart >= 0 && StyleEditor.this.defaultXFinish >= 0) {
                    if (StyleEditor.this.textPane.getCaretPosition() == StyleEditor.this.defaultXStart) {
                        StyleEditor.this.textPane.setCaretPosition(StyleEditor.this.defaultXFinish);
                        StyleEditor.this.textPane.moveCaretPosition(StyleEditor.this.defaultXStart);
                    } else {
                        StyleEditor.this.textPane.select(StyleEditor.this.defaultXStart, StyleEditor.this.defaultXFinish);
                    }
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                StyleEditor.this.defaultXStart = StyleEditor.this.textPane.getSelectionStart();
                StyleEditor.this.defaultXFinish = StyleEditor.this.textPane.getSelectionEnd();
            }
        };
        this.textPane.addFocusListener(flst);
        this.showAttributes(0);
    }

    public void setDefaultFont(Font font) {
        this.textPane.setFont(font);
    }

    public String getText() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.rtfKit.write(out, (Document)this.document, 0, this.document.getLength());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return out.toString();
    }

    public void setText(String text) {
        ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes());
        this.document = new EFCDefaultStyledDocument();
        try {
            this.rtfKit.read(in, (Document)this.document, 0);
            for (int i = this.document.getLength() - 1; i >= 0 && this.document.getData().getString(i, 1).equals("\n"); --i) {
                this.document.remove(i, 1);
            }
            this.textPane.setDocument(this.document);
            ((InputStream)in).close();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void createMenuBar() {
        String[] fonts = new String[]{"Andale Mono", "Arial Black", "Arial", "Comic Sans MS", "Courier New", "Georgia", "Impact", "Times New Roman", "Trebuchet", "Verdana"};
        ArrayList<String> availableFonts = new ArrayList<String>();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        List<String> systemFontNames = Arrays.asList(ge.getAvailableFontFamilyNames());
        for (int i = 0; i < fonts.length; ++i) {
            if (!systemFontNames.contains(fonts[i])) continue;
            availableFonts.add(fonts[i]);
        }
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.addSeparator();
        this.cbFonts = new JComboBox<String>(availableFonts.toArray(new String[availableFonts.size()]));
        this.cbFonts.setMaximumSize(this.cbFonts.getPreferredSize());
        this.cbFonts.setEditable(true);
        ActionListener lst = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleEditor.this.fontName = StyleEditor.this.cbFonts.getSelectedItem().toString();
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setFontFamily(attr, StyleEditor.this.fontName);
                StyleEditor.this.setAttributeSet(attr);
                StyleEditor.this.textPane.grabFocus();
            }
        };
        this.cbFonts.addActionListener(lst);
        this.toolBar.add(this.cbFonts);
        this.toolBar.addSeparator();
        this.cbSizes = new JComboBox<String>(new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"});
        this.cbSizes.setMaximumSize(this.cbSizes.getPreferredSize());
        this.cbSizes.setEditable(true);
        lst = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int fontSize = 0;
                try {
                    fontSize = Integer.parseInt(StyleEditor.this.cbSizes.getSelectedItem().toString());
                }
                catch (NumberFormatException ex) {
                    return;
                }
                StyleEditor.this.defaultfontSize = fontSize;
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setFontSize(attr, fontSize);
                StyleEditor.this.setAttributeSet(attr);
                StyleEditor.this.textPane.grabFocus();
            }
        };
        this.cbSizes.addActionListener(lst);
        this.toolBar.add(this.cbSizes);
        this.toolBar.addSeparator();
        ImageIcon img1 = EFCLookAndFeelManager.ICON_TOOLBAR_FORMAT_BOLD;
        this.boldButton = new EFCSmallToggleButton(false, img1, img1, "Fett", true);
        lst = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setBold(attr, StyleEditor.this.boldButton.isSelected());
                StyleEditor.this.setAttributeSet(attr);
                StyleEditor.this.textPane.grabFocus();
            }
        };
        this.boldButton.addActionListener(lst);
        this.toolBar.add(this.boldButton);
        img1 = EFCLookAndFeelManager.ICON_TOOLBAR_FORMAT_ITALIC;
        this.italicButton = new EFCSmallToggleButton(false, img1, img1, "Kursiv", true);
        lst = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setItalic(attr, StyleEditor.this.italicButton.isSelected());
                StyleEditor.this.setAttributeSet(attr);
                StyleEditor.this.textPane.grabFocus();
            }
        };
        this.italicButton.addActionListener(lst);
        this.toolBar.add(this.italicButton);
        img1 = EFCLookAndFeelManager.ICON_TOOLBAR_FORMAT_UNDELINE;
        this.underlineButton = new EFCSmallToggleButton(false, img1, img1, "Unterstreichen", true);
        lst = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setUnderline(attr, StyleEditor.this.underlineButton.isSelected());
                StyleEditor.this.setAttributeSet(attr);
                StyleEditor.this.textPane.grabFocus();
            }
        };
        this.underlineButton.addActionListener(lst);
        this.toolBar.add(this.underlineButton);
        this.add((Component)this.toolBar, "North");
    }

    protected void showAttributes(int p) {
        boolean italic;
        boolean bold;
        int size;
        this.skipUpdate = true;
        AttributeSet a = this.document.getCharacterElement(p).getAttributes();
        String name = StyleConstants.getFontFamily(a);
        if (!this.fontName.equals(name)) {
            this.fontName = name;
            this.cbFonts.setSelectedItem(name);
        }
        if (this.defaultfontSize != (size = StyleConstants.getFontSize(a))) {
            this.defaultfontSize = size;
            this.cbSizes.setSelectedItem(Integer.toString(this.defaultfontSize));
        }
        if ((bold = StyleConstants.isBold(a)) != this.boldButton.isSelected()) {
            this.boldButton.setSelected(bold);
        }
        if ((italic = StyleConstants.isItalic(a)) != this.italicButton.isSelected()) {
            this.italicButton.setSelected(italic);
        }
        this.skipUpdate = false;
    }

    protected void setAttributeSet(AttributeSet attr) {
        if (this.skipUpdate) {
            return;
        }
        int xStart = this.textPane.getSelectionStart();
        int xFinish = this.textPane.getSelectionEnd();
        if (!this.textPane.hasFocus()) {
            xStart = this.defaultXStart;
            xFinish = this.defaultXFinish;
        }
        if (xStart != xFinish) {
            this.document.setCharacterAttributes(xStart, xFinish - xStart, attr, false);
        } else {
            MutableAttributeSet inputAttributes = this.rtfKit.getInputAttributes();
            inputAttributes.addAttributes(attr);
        }
    }

    public void enableCbFonts(boolean isEnabled) {
        this.cbFonts.setEnabled(isEnabled);
    }

    public void enableCbFontSize(boolean isEnabled) {
        this.cbSizes.setEnabled(isEnabled);
    }

    public void enableFontStyleButtons(boolean isEnabled) {
        this.boldButton.setEnabled(isEnabled);
        this.italicButton.setEnabled(isEnabled);
        this.underlineButton.setEnabled(isEnabled);
    }

    public void setEditable(boolean aFlag) {
        this.textPane.setEditable(this.textPane.isEnabled());
    }

    public boolean isEditable() {
        return this.textPane.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textPane.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.textPane.isEnabled();
    }
}

