/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class DefaultTableCellHeaderRenderer
extends DefaultTableCellRenderer
implements UIResource {
    private static final long serialVersionUID = 5771692480274693752L;
    private boolean horizontalTextPositionSet;

    public DefaultTableCellHeaderRenderer() {
        this.setHorizontalAlignment(0);
    }

    @Override
    public void setHorizontalTextPosition(int textPosition) {
        this.horizontalTextPositionSet = true;
        super.setHorizontalTextPosition(textPosition);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean isPaintingForPrint = false;
        if (table != null) {
            JTableHeader header = table.getTableHeader();
            if (header != null) {
                Color fgColor = null;
                Color bgColor = null;
                if (hasFocus) {
                    fgColor = UIManager.getColor("TableHeader.focusCellForeground");
                    bgColor = UIManager.getColor("TableHeader.focusCellBackground");
                }
                if (fgColor == null) {
                    fgColor = header.getForeground();
                }
                if (bgColor == null) {
                    bgColor = header.getBackground();
                }
                this.setForeground(fgColor);
                this.setBackground(bgColor);
                this.setFont(header.getFont());
                isPaintingForPrint = header.isPaintingForPrint();
            }
            if (!isPaintingForPrint && table.getRowSorter() != null && !this.horizontalTextPositionSet) {
                this.setHorizontalTextPosition(10);
            }
        }
        this.setText(value == null ? "" : value.toString());
        Border border = null;
        if (hasFocus) {
            border = UIManager.getBorder("TableHeader.focusCellBorder");
        }
        if (border == null) {
            border = UIManager.getBorder("TableHeader.cellBorder");
        }
        this.setBorder(border);
        return this;
    }
}

