/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing;

import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.gui.components.swing.DefaultTableCellHeaderRenderer;
import de.effectivecompany.gui.components.swing.EFCBoCellComponent;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class EFCBoHeaderRenderer
extends DefaultTableCellHeaderRenderer {
    private static final long serialVersionUID = 7709138557570561977L;
    private String cellLayout;
    private double sizeMultiplier;
    private boolean onlyLabels;
    private int cellWidth;
    private int cellHeight;
    Map<String, EFCBoCellComponent> panels = new HashMap<String, EFCBoCellComponent>();

    public void setValuesChanged(boolean valuesChanged) {
        Iterator<Map.Entry<String, EFCBoCellComponent>> iter = this.panels.entrySet().iterator();
        while (iter.hasNext()) {
            EFCBoCellComponent cellComp = this.panels.get(iter.next().getKey());
            cellComp.setValueSet(false);
        }
    }

    public EFCBoHeaderRenderer(String cellLayout, double sizeMultiplier, boolean onlyLabels, int cellWidth, int cellHeight) {
        this.cellLayout = cellLayout;
        this.sizeMultiplier = sizeMultiplier;
        this.onlyLabels = onlyLabels;
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        String key = row + "-" + column;
        if (!(value instanceof String)) {
            EFCBoCellComponent boCellComponent;
            if (!this.panels.containsKey(key)) {
                boCellComponent = new EFCBoCellComponent(this.cellLayout, (BusinessObject)value, this.sizeMultiplier, this.onlyLabels);
                this.panels.put(key, boCellComponent);
            } else {
                boCellComponent = this.panels.get(key);
            }
            if (boCellComponent != null) {
                if (value != null) {
                    boCellComponent.updateData((BusinessObject)value, isSelected, table);
                }
                if (this.cellHeight == 0 && boCellComponent.getBoCellComponent() != null && table.getRowHeight() < boCellComponent.getBoCellComponent().getHeight()) {
                    table.setRowHeight(boCellComponent.getBoCellComponent().getHeight() + 10);
                }
                if (this.cellWidth == 0 && comp != null && table.getColumnModel().getColumnCount() > 0) {
                    for (int i = 0; i < table.getColumnCount(); ++i) {
                        if (boCellComponent.getBoCellComponent() == null) continue;
                        TableColumn tableColumn = table.getColumnModel().getColumn(i);
                        tableColumn.setPreferredWidth((int)((double)boCellComponent.getBoCellComponent().getWidth() / (this.onlyLabels ? 2.1 : 1.4)));
                        tableColumn.setResizable(true);
                    }
                }
                return boCellComponent;
            }
        }
        return comp;
    }

    public void clearPanels() {
        this.panels.clear();
    }
}

