/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing;

import de.effectivecompany.gui.components.model.table.EFCBoModel;
import de.effectivecompany.gui.components.swing.EFCBoCellRenderer;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.JXTable;

public class EFCBoTableRowHeader
extends JXTable
implements ChangeListener,
PropertyChangeListener {
    private static final long serialVersionUID = 9208887497946994203L;
    private JTable main;
    private TableColumn column;

    public EFCBoTableRowHeader(JTable table, String cellLayout, double sizeMultiplier, boolean onlyLabels, Integer cellWidth) {
        this.main = table;
        this.main.addPropertyChangeListener(this);
        this.setSortable(true);
        this.setAutoCreateRowSorter(true);
        this.setFocusable(false);
        this.setAutoCreateColumnsFromModel(false);
        this.setModel(this.main.getModel());
        this.setRowSelectionAllowed(false);
        this.setCellSelectionEnabled(true);
        this.setSelectionModel(this.main.getSelectionModel());
        this.column = new TableColumn();
        this.column.setResizable(true);
        this.column.setCellRenderer(new EFCBoCellRenderer(cellLayout, sizeMultiplier, onlyLabels, cellWidth, null));
        if (cellWidth != null) {
            this.column.setPreferredWidth(cellWidth);
        }
    }

    public void updateTable() {
        if (this.getColumnModel().getColumnCount() == 0) {
            this.column.setHeaderValue(" ");
            this.addColumn(this.column);
        }
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
        ((EFCBoCellRenderer)this.column.getCellRenderer()).setValuesChanged(true);
    }

    public void addNotify() {
        super.addNotify();
        Container c = this.getParent();
        if (c instanceof JViewport) {
            JViewport viewport = (JViewport)c;
            viewport.addChangeListener(this);
        }
    }

    public int getRowCount() {
        return this.main.getRowCount();
    }

    public int getRowHeight(int row) {
        return this.main.getRowHeight(row);
    }

    public Object getValueAt(int row, int column) {
        return ((EFCBoModel)this.getModel()).getRowName(row);
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JViewport viewport = (JViewport)e.getSource();
        JScrollPane scrollPane = (JScrollPane)viewport.getParent();
        scrollPane.getVerticalScrollBar().setValue(viewport.getViewPosition().y);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("rowHeight".equals(e.getPropertyName())) {
            this.updateRowHeight();
        }
        if ("selectionModel".equals(e.getPropertyName())) {
            // empty if block
        }
        if ("model".equals(e.getPropertyName())) {
            this.updateModel();
        }
    }

    private void updateModel() {
        this.setModel(this.main.getModel());
    }

    private void updateRowHeight() {
        this.setRowHeight(this.main.getRowHeight());
    }
}

