/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing;

import de.effectivecompany.gui.components.swing.Model;
import javafx.application.Application;
import javafx.embed.swing.JFXPanel;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCCalculatorPanel
extends JFXPanel {
    private static Logger logger = LoggerFactory.getLogger(EFCCalculatorPanel.class);
    private static final long serialVersionUID = 2917147368064722753L;
    private TextField output;
    private String valueNum;
    private String valueOp;
    private String operator = "";
    private String calcOperator = "";
    private double number1 = 0.0;
    private double number2 = 0.0;
    private boolean start = true;
    private Model model = new Model();

    public EFCCalculatorPanel() {
        BorderPane border = new BorderPane();
        HBox hbox = this.addHBox();
        border.setTop((Node)hbox);
        border.setCenter((Node)this.addGridPane());
        border.setRight((Node)this.addFlowPane());
        Scene scene = new Scene((Parent)border);
        Application.setUserAgentStylesheet((String)ClassLoader.getSystemResource("css/EFCStyleStandard.css").toExternalForm());
        this.setScene(scene);
    }

    private HBox addHBox() {
        HBox hbox = new HBox();
        hbox.getStyleClass().add((Object)"calcHbox");
        this.output = new TextField("");
        HBox.setHgrow((Node)this.output, (Priority)Priority.ALWAYS);
        this.output.setEditable(false);
        this.output.getStyleClass().add((Object)"calcTextField");
        hbox.getChildren().add((Object)this.output);
        return hbox;
    }

    private FlowPane addFlowPane() {
        FlowPane flow = new FlowPane();
        flow.getStyleClass().add((Object)"calcFlowPane");
        return flow;
    }

    private GridPane addGridPane() {
        Button button1 = new Button("1");
        button1.getStyleClass().add((Object)"calcButton");
        Button button2 = new Button("2");
        button2.getStyleClass().add((Object)"calcButton");
        Button button3 = new Button("3");
        button3.getStyleClass().add((Object)"calcButton");
        Button button4 = new Button("4");
        button4.getStyleClass().add((Object)"calcButton");
        Button button5 = new Button("5");
        button5.getStyleClass().add((Object)"calcButton");
        Button button6 = new Button("6");
        button6.getStyleClass().add((Object)"calcButton");
        Button button7 = new Button("7");
        button7.getStyleClass().add((Object)"calcButton");
        Button button8 = new Button("8");
        button8.getStyleClass().add((Object)"calcButton");
        Button button9 = new Button("9");
        button9.getStyleClass().add((Object)"calcButton");
        Button button0 = new Button("0");
        button0.getStyleClass().add((Object)"calcButton");
        Button button11 = new Button("/");
        button11.getStyleClass().add((Object)"calcButton");
        Button button12 = new Button("*");
        button12.getStyleClass().add((Object)"calcButton");
        Button button13 = new Button("-");
        button13.getStyleClass().add((Object)"calcButton");
        Button button14 = new Button("+");
        button14.getStyleClass().add((Object)"calcButton");
        Button button15 = new Button("=");
        button15.getStyleClass().add((Object)"calcButton");
        Button button16 = new Button(".");
        button16.getStyleClass().add((Object)"calcButton");
        Button button17 = new Button("\u221a");
        button17.getStyleClass().add((Object)"calcButton");
        Button button18 = new Button("1/x");
        button18.getStyleClass().add((Object)"calcButton");
        Button button19 = new Button("%");
        button19.getStyleClass().add((Object)"calcButton");
        Button button20 = new Button("+/-");
        button20.getStyleClass().add((Object)"calcButton");
        Button button21 = new Button("CE");
        button21.getStyleClass().add((Object)"calcButton");
        Button button22 = new Button("C");
        button22.getStyleClass().add((Object)"calcButton");
        button1.setOnAction(event -> this.processNumpad((ActionEvent)event));
        button2.setOnAction(event -> this.processNumpad((ActionEvent)event));
        button3.setOnAction(event -> this.processNumpad((ActionEvent)event));
        button4.setOnAction(event -> this.processNumpad((ActionEvent)event));
        button5.setOnAction(event -> this.processNumpad((ActionEvent)event));
        button6.setOnAction(event -> this.processNumpad((ActionEvent)event));
        button7.setOnAction(event -> this.processNumpad((ActionEvent)event));
        button8.setOnAction(event -> this.processNumpad((ActionEvent)event));
        button9.setOnAction(event -> this.processNumpad((ActionEvent)event));
        button0.setOnAction(event -> this.processNumpad((ActionEvent)event));
        button11.setOnAction(event -> this.processOperator((ActionEvent)event));
        button12.setOnAction(event -> this.processOperator((ActionEvent)event));
        button13.setOnAction(event -> this.processOperator((ActionEvent)event));
        button14.setOnAction(event -> this.processOperator((ActionEvent)event));
        button15.setOnAction(event -> this.processOperator((ActionEvent)event));
        button16.setOnAction(event -> this.processDecimalPoint((ActionEvent)event));
        button17.setOnAction(event -> this.processSqrt((ActionEvent)event));
        button18.setOnAction(event -> this.processOperator((ActionEvent)event));
        button19.setOnAction(event -> this.processProcent((ActionEvent)event));
        button20.setOnAction(event -> this.processOperator((ActionEvent)event));
        button21.setOnAction(event -> this.processClearEntry((ActionEvent)event));
        button22.setOnAction(event -> this.processClear((ActionEvent)event));
        GridPane gridPane = new GridPane();
        for (int rowIndex = 0; rowIndex < 7; ++rowIndex) {
            RowConstraints rc = new RowConstraints();
            rc.setVgrow(Priority.ALWAYS);
            rc.setFillHeight(true);
            gridPane.getRowConstraints().add((Object)rc);
        }
        for (int colIndex = 0; colIndex < 6; ++colIndex) {
            ColumnConstraints cc = new ColumnConstraints();
            cc.setHgrow(Priority.ALWAYS);
            cc.setFillWidth(true);
            gridPane.getColumnConstraints().add((Object)cc);
        }
        gridPane.getStyleClass().add((Object)"calcGridPane");
        gridPane.add((Node)button7, 2, 1, 1, 1);
        gridPane.add((Node)button8, 3, 1, 1, 1);
        gridPane.add((Node)button9, 4, 1, 1, 1);
        gridPane.add((Node)button11, 5, 1, 1, 1);
        gridPane.add((Node)button4, 2, 2, 1, 1);
        gridPane.add((Node)button5, 3, 2, 1, 1);
        gridPane.add((Node)button6, 4, 2, 1, 1);
        gridPane.add((Node)button12, 5, 2, 1, 1);
        gridPane.add((Node)button1, 2, 3, 1, 1);
        gridPane.add((Node)button2, 3, 3, 1, 1);
        gridPane.add((Node)button3, 4, 3, 1, 1);
        gridPane.add((Node)button13, 5, 3, 1, 1);
        gridPane.add((Node)button19, 2, 4, 1, 1);
        gridPane.add((Node)button0, 3, 4, 1, 1);
        gridPane.add((Node)button16, 4, 4, 1, 1);
        gridPane.add((Node)button14, 5, 4, 1, 1);
        gridPane.add((Node)button21, 2, 5, 1, 1);
        gridPane.add((Node)button22, 3, 5, 1, 1);
        gridPane.add((Node)button17, 4, 5, 1, 1);
        gridPane.add((Node)button15, 5, 5, 1, 1);
        return gridPane;
    }

    private void processProcent(ActionEvent event) {
        this.valueOp = ((Button)event.getSource()).getText();
        if (!this.operator.isEmpty()) {
            this.number1 = Double.parseDouble(this.output.getText());
            this.number1 /= 100.0;
            this.output.setText(String.valueOf(this.number1));
            this.operator = "";
            this.start = true;
            return;
        }
        this.operator = this.valueOp;
        try {
            this.number1 = Double.parseDouble(this.output.getText());
        }
        catch (NumberFormatException nfe) {
            this.processClear(event);
            this.start = true;
            return;
        }
        this.number1 = Double.parseDouble(this.output.getText()) / 100.0;
        this.output.setText(String.valueOf(this.number1));
        this.operator = "";
    }

    private void processSqrt(ActionEvent event) {
        this.valueOp = ((Button)event.getSource()).getText();
        if (!this.operator.isEmpty()) {
            this.number2 = Double.parseDouble(this.output.getText());
            this.output.setText(String.valueOf(this.model.calculate(this.number1, this.number2, this.operator)));
            this.number1 = Double.parseDouble(this.output.getText());
            this.number1 = Math.sqrt(this.number1);
            this.output.setText(String.valueOf(this.number1));
            this.start = true;
            this.operator = "";
            return;
        }
        this.operator = this.valueOp;
        try {
            this.number1 = Double.parseDouble(this.output.getText());
        }
        catch (NumberFormatException nfe) {
            this.processClear(event);
            this.output.clear();
            this.start = true;
            return;
        }
        this.number1 = Math.sqrt(this.number1);
        this.output.setText(String.valueOf(this.number1));
        this.operator = "";
    }

    private void processDecimalPoint(ActionEvent event) {
        this.valueOp = ((Button)event.getSource()).getText();
        this.output.setText(this.output.getText() + this.valueOp);
    }

    private void processClearEntry(ActionEvent event) {
        this.number2 = 0.0;
        this.output.setText("");
    }

    private void processClear(ActionEvent event) {
        this.output.clear();
        this.number1 = 0.0;
        this.number2 = 0.0;
        this.operator = "";
        this.valueOp = "";
    }

    public void processNumpad(ActionEvent event) {
        if (this.start) {
            this.output.clear();
            this.output.setText("");
            this.start = false;
        }
        this.valueNum = ((Button)event.getSource()).getText();
        this.output.setText(this.output.getText() + this.valueNum);
    }

    private void processOperator(ActionEvent event) {
        this.valueOp = ((Button)event.getSource()).getText();
        if (!"=".equals(this.valueOp)) {
            if (!this.operator.isEmpty()) {
                this.calcOperator = this.operator;
                try {
                    this.number2 = Double.parseDouble(this.output.getText());
                }
                catch (NumberFormatException nfe) {
                    this.processClear(event);
                    return;
                }
                this.output.setText(String.valueOf(this.model.calculate(this.number1, this.number2, this.calcOperator)));
                this.operator = this.valueOp;
                this.number1 = Double.parseDouble(this.output.getText());
                this.start = true;
                return;
            }
            this.operator = this.valueOp;
            try {
                this.number1 = Double.parseDouble(this.output.getText());
            }
            catch (NumberFormatException nfe) {
                this.processClear(event);
                return;
            }
            this.output.setText("");
        } else {
            if (this.operator.isEmpty()) {
                return;
            }
            try {
                this.number2 = Double.parseDouble(this.output.getText());
            }
            catch (NumberFormatException nfe) {
                System.out.println("Invalid value provided for second value");
            }
            this.output.setText(String.valueOf(this.model.calculate(this.number1, this.number2, this.operator)));
            this.operator = "";
            this.start = true;
        }
    }
}

