/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing;

import de.effectivecompany.gui.components.swing.EFCRangeSlider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;

class EFCRangeSliderUI
extends BasicSliderUI
implements SwingConstants {
    private Color rangeColor = Color.LIGHT_GRAY;
    private Rectangle upperThumbRect;
    private boolean upperThumbSelected;
    private transient boolean lowerDragging;
    private transient boolean upperDragging;
    private Color shadow = UIManager.getColor("controlShadow");
    private Color darkShadow = UIManager.getColor("controlDkShadow");
    private Color highlight = UIManager.getColor("controlLtHighlight");

    public EFCRangeSliderUI(EFCRangeSlider b) {
        super(b);
    }

    @Override
    public void installUI(JComponent c) {
        this.upperThumbRect = new Rectangle();
        super.installUI(c);
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new RangeTrackListener();
    }

    @Override
    protected ChangeListener createChangeListener(JSlider slider) {
        return new ChangeHandler();
    }

    @Override
    protected void calculateThumbSize() {
        super.calculateThumbSize();
        this.upperThumbRect.setSize(this.thumbRect.width, this.thumbRect.height);
    }

    @Override
    protected void calculateThumbLocation() {
        int upperPosition;
        super.calculateThumbLocation();
        if (this.slider.getSnapToTicks()) {
            int upperValue;
            int snappedValue = upperValue = this.slider.getValue() + this.slider.getExtent();
            int majorTickSpacing = this.slider.getMajorTickSpacing();
            int minorTickSpacing = this.slider.getMinorTickSpacing();
            int tickSpacing = 0;
            if (minorTickSpacing > 0) {
                tickSpacing = minorTickSpacing;
            } else if (majorTickSpacing > 0) {
                tickSpacing = majorTickSpacing;
            }
            if (tickSpacing != 0) {
                if ((upperValue - this.slider.getMinimum()) % tickSpacing != 0) {
                    float temp = (float)(upperValue - this.slider.getMinimum()) / (float)tickSpacing;
                    int whichTick = Math.round(temp);
                    snappedValue = this.slider.getMinimum() + whichTick * tickSpacing;
                }
                if (snappedValue != upperValue) {
                    this.slider.setExtent(snappedValue - this.slider.getValue());
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            upperPosition = this.xPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.upperThumbRect.x = upperPosition - this.upperThumbRect.width / 2;
            this.upperThumbRect.y = this.trackRect.y;
        } else {
            upperPosition = this.yPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.upperThumbRect.x = this.trackRect.x;
            this.upperThumbRect.y = upperPosition - this.upperThumbRect.height / 2;
        }
    }

    @Override
    protected Dimension getThumbSize() {
        return new Dimension(12, 12);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Rectangle clipRect = g.getClipBounds();
        if (this.upperThumbSelected) {
            if (clipRect.intersects(this.thumbRect)) {
                this.paintLowerThumb(g);
            }
            if (clipRect.intersects(this.upperThumbRect)) {
                this.paintUpperThumb(g);
            }
        } else {
            if (clipRect.intersects(this.upperThumbRect)) {
                this.paintUpperThumb(g);
            }
            if (clipRect.intersects(this.thumbRect)) {
                this.paintLowerThumb(g);
            }
        }
    }

    @Override
    public void paintTrack(Graphics g) {
        super.paintTrack(g);
        Rectangle trackBounds = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int lowerX = this.thumbRect.x + this.thumbRect.width / 2;
            int upperX = this.upperThumbRect.x + this.upperThumbRect.width / 2;
            int cy = trackBounds.height / 2 - 2;
            Color oldColor = g.getColor();
            g.translate(trackBounds.x, trackBounds.y + cy);
            g.setColor(this.rangeColor);
            for (int y = 0; y <= 2; ++y) {
                g.drawLine(lowerX - trackBounds.x, y, upperX - trackBounds.x, y);
            }
            g.translate(-trackBounds.x, -(trackBounds.y + cy));
            g.setColor(oldColor);
        } else {
            int lowerY = this.thumbRect.x + this.thumbRect.width / 2;
            int upperY = this.upperThumbRect.x + this.upperThumbRect.width / 2;
            int cx = trackBounds.width / 2 - 2;
            Color oldColor = g.getColor();
            g.translate(trackBounds.x + cx, trackBounds.y);
            g.setColor(this.rangeColor);
            for (int x = 0; x <= 3; ++x) {
                g.drawLine(x, lowerY - trackBounds.y, x, upperY - trackBounds.y);
            }
            g.translate(-(trackBounds.x + cx), -trackBounds.y);
            g.setColor(oldColor);
        }
    }

    @Override
    public void paintThumb(Graphics g) {
    }

    private void paintLowerThumb(Graphics g) {
        Rectangle knobBounds = this.thumbRect;
        int w = knobBounds.width;
        int h = knobBounds.height;
        Graphics2D g2d = (Graphics2D)g.create();
        Shape thumbShape = this.createThumbShape(w - 1, h - 1);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(knobBounds.x, knobBounds.y);
        g2d.setColor(UIManager.getColor("control"));
        g2d.fill(thumbShape);
        g2d.setColor(Color.BLACK);
        g2d.draw(thumbShape);
        int size = Math.min((h - 4) / 3, (w - 4) / 3);
        size = Math.max(size, 4);
        this.paintTriangle(g2d, (w - size) / 2, (h - size) / 2, size, 3, true);
        g2d.dispose();
    }

    private void paintUpperThumb(Graphics g) {
        Rectangle knobBounds = this.upperThumbRect;
        int w = knobBounds.width;
        int h = knobBounds.height;
        Graphics2D g2d = (Graphics2D)g.create();
        Shape thumbShape = this.createThumbShape(w - 1, h - 1);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(knobBounds.x, knobBounds.y);
        g2d.setColor(UIManager.getColor("control"));
        g2d.fill(thumbShape);
        g2d.setColor(Color.BLACK);
        g2d.draw(thumbShape);
        int size = Math.min((h - 4) / 3, (w - 4) / 3);
        size = Math.max(size, 4);
        this.paintTriangle(g2d, (w - size) / 2, (h - size) / 2, size, 7, true);
        g2d.dispose();
    }

    private Shape createThumbShape(int width, int height) {
        Rectangle2D.Double shape = new Rectangle2D.Double(0.0, 0.0, width, height);
        return shape;
    }

    private void setUpperThumbLocation(int x, int y) {
        Rectangle upperUnionRect = new Rectangle();
        upperUnionRect.setBounds(this.upperThumbRect);
        this.upperThumbRect.setLocation(x, y);
        SwingUtilities.computeUnion(this.upperThumbRect.x, this.upperThumbRect.y, this.upperThumbRect.width, this.upperThumbRect.height, upperUnionRect);
        this.slider.repaint(upperUnionRect.x, upperUnionRect.y, upperUnionRect.width, upperUnionRect.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByBlock(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int blockIncrement = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (blockIncrement <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                blockIncrement = 1;
            }
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            if (this.upperThumbSelected) {
                int oldValue = ((EFCRangeSlider)this.slider).getUpperValue();
                ((EFCRangeSlider)this.slider).setUpperValue(oldValue + delta);
            } else {
                int oldValue = this.slider.getValue();
                this.slider.setValue(oldValue + delta);
            }
        }
    }

    public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
        Color oldColor = g.getColor();
        int j = 0;
        size = Math.max(size, 2);
        int mid = size / 2 - 1;
        g.translate(x, y);
        if (isEnabled) {
            g.setColor(this.darkShadow);
        } else {
            g.setColor(this.shadow);
        }
        switch (direction) {
            case 1: {
                int i;
                for (i = 0; i < size; ++i) {
                    g.drawLine(mid - i, i, mid + i, i);
                }
                if (isEnabled) break;
                g.setColor(this.highlight);
                g.drawLine(mid - i + 2, i, mid + i, i);
                break;
            }
            case 5: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(this.highlight);
                    for (i = size - 1; i >= 0; --i) {
                        g.drawLine(mid - i, j, mid + i, j);
                        ++j;
                    }
                    g.translate(-1, -1);
                    g.setColor(this.shadow);
                }
                j = 0;
                for (i = size - 1; i >= 0; --i) {
                    g.drawLine(mid - i, j, mid + i, j);
                    ++j;
                }
                break;
            }
            case 7: {
                int i;
                for (i = 0; i < size; ++i) {
                    g.drawLine(i, mid - i, i, mid + i);
                }
                if (isEnabled) break;
                g.setColor(this.highlight);
                g.drawLine(i, mid - i + 2, i, mid + i);
                break;
            }
            case 3: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(this.highlight);
                    for (i = size - 1; i >= 0; --i) {
                        g.drawLine(j, mid - i, j, mid + i);
                        ++j;
                    }
                    g.translate(-1, -1);
                    g.setColor(this.shadow);
                }
                j = 0;
                for (i = size - 1; i >= 0; --i) {
                    g.drawLine(j, mid - i, j, mid + i);
                    ++j;
                }
                break;
            }
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByUnit(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int delta = 1 * (direction > 0 ? 1 : -1);
            if (this.upperThumbSelected) {
                int oldValue = ((EFCRangeSlider)this.slider).getUpperValue();
                ((EFCRangeSlider)this.slider).setUpperValue(oldValue + delta);
            } else {
                int oldValue = this.slider.getValue();
                this.slider.setValue(oldValue + delta);
            }
        }
    }

    public class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        public RangeTrackListener() {
            super(EFCRangeSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!EFCRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (EFCRangeSliderUI.this.slider.isRequestFocusEnabled()) {
                EFCRangeSliderUI.this.slider.requestFocus();
            }
            boolean lowerPressed = false;
            boolean upperPressed = false;
            if (EFCRangeSliderUI.this.upperThumbSelected || EFCRangeSliderUI.this.slider.getMinimum() == EFCRangeSliderUI.this.slider.getValue()) {
                if (EFCRangeSliderUI.this.upperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    upperPressed = true;
                } else if (EFCRangeSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    lowerPressed = true;
                }
            } else if (EFCRangeSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                lowerPressed = true;
            } else if (EFCRangeSliderUI.this.upperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                upperPressed = true;
            }
            if (lowerPressed) {
                switch (EFCRangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((EFCRangeSliderUI)EFCRangeSliderUI.this).thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((EFCRangeSliderUI)EFCRangeSliderUI.this).thumbRect.x;
                    }
                }
                EFCRangeSliderUI.this.upperThumbSelected = false;
                EFCRangeSliderUI.this.lowerDragging = true;
                return;
            }
            EFCRangeSliderUI.this.lowerDragging = false;
            if (upperPressed) {
                switch (EFCRangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - EFCRangeSliderUI.this.upperThumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - EFCRangeSliderUI.this.upperThumbRect.x;
                    }
                }
                EFCRangeSliderUI.this.upperThumbSelected = true;
                EFCRangeSliderUI.this.upperDragging = true;
                return;
            }
            EFCRangeSliderUI.this.upperDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            EFCRangeSliderUI.this.lowerDragging = false;
            EFCRangeSliderUI.this.upperDragging = false;
            EFCRangeSliderUI.this.slider.setValueIsAdjusting(false);
            super.mouseReleased(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!EFCRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (EFCRangeSliderUI.this.lowerDragging) {
                EFCRangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveLowerThumb();
            } else if (EFCRangeSliderUI.this.upperDragging) {
                EFCRangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveUpperThumb();
            }
        }

        @Override
        public boolean shouldScroll(int direction) {
            return false;
        }

        private void moveLowerThumb() {
            int thumbMiddle = 0;
            switch (EFCRangeSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int halfThumbHeight = ((EFCRangeSliderUI)EFCRangeSliderUI.this).thumbRect.height / 2;
                    int thumbTop = this.currentMouseY - this.offset;
                    int trackTop = ((EFCRangeSliderUI)EFCRangeSliderUI.this).trackRect.y;
                    int trackBottom = ((EFCRangeSliderUI)EFCRangeSliderUI.this).trackRect.y + (((EFCRangeSliderUI)EFCRangeSliderUI.this).trackRect.height - 1);
                    int vMax = EFCRangeSliderUI.this.yPositionForValue(EFCRangeSliderUI.this.slider.getValue() + EFCRangeSliderUI.this.slider.getExtent());
                    if (EFCRangeSliderUI.this.drawInverted()) {
                        trackBottom = vMax;
                    } else {
                        trackTop = vMax;
                    }
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    EFCRangeSliderUI.this.setThumbLocation(((EFCRangeSliderUI)EFCRangeSliderUI.this).thumbRect.x, thumbTop);
                    thumbMiddle = thumbTop + halfThumbHeight;
                    EFCRangeSliderUI.this.slider.setValue(EFCRangeSliderUI.this.valueForYPosition(thumbMiddle));
                    break;
                }
                case 0: {
                    int halfThumbWidth = ((EFCRangeSliderUI)EFCRangeSliderUI.this).thumbRect.width / 2;
                    int thumbLeft = this.currentMouseX - this.offset;
                    int trackLeft = ((EFCRangeSliderUI)EFCRangeSliderUI.this).trackRect.x;
                    int trackRight = ((EFCRangeSliderUI)EFCRangeSliderUI.this).trackRect.x + (((EFCRangeSliderUI)EFCRangeSliderUI.this).trackRect.width - 1);
                    int hMax = EFCRangeSliderUI.this.xPositionForValue(EFCRangeSliderUI.this.slider.getValue() + EFCRangeSliderUI.this.slider.getExtent());
                    if (EFCRangeSliderUI.this.drawInverted()) {
                        trackLeft = hMax;
                    } else {
                        trackRight = hMax;
                    }
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    EFCRangeSliderUI.this.setThumbLocation(thumbLeft, ((EFCRangeSliderUI)EFCRangeSliderUI.this).thumbRect.y);
                    thumbMiddle = thumbLeft + halfThumbWidth;
                    EFCRangeSliderUI.this.slider.setValue(EFCRangeSliderUI.this.valueForXPosition(thumbMiddle));
                    break;
                }
                default: {
                    return;
                }
            }
        }

        private void moveUpperThumb() {
            int thumbMiddle = 0;
            switch (EFCRangeSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int halfThumbHeight = ((EFCRangeSliderUI)EFCRangeSliderUI.this).thumbRect.height / 2;
                    int thumbTop = this.currentMouseY - this.offset;
                    int trackTop = ((EFCRangeSliderUI)EFCRangeSliderUI.this).trackRect.y;
                    int trackBottom = ((EFCRangeSliderUI)EFCRangeSliderUI.this).trackRect.y + (((EFCRangeSliderUI)EFCRangeSliderUI.this).trackRect.height - 1);
                    int vMin = EFCRangeSliderUI.this.yPositionForValue(EFCRangeSliderUI.this.slider.getValue());
                    if (EFCRangeSliderUI.this.drawInverted()) {
                        trackTop = vMin;
                    } else {
                        trackBottom = vMin;
                    }
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    EFCRangeSliderUI.this.setUpperThumbLocation(((EFCRangeSliderUI)EFCRangeSliderUI.this).thumbRect.x, thumbTop);
                    thumbMiddle = thumbTop + halfThumbHeight;
                    EFCRangeSliderUI.this.slider.setExtent(EFCRangeSliderUI.this.valueForYPosition(thumbMiddle) - EFCRangeSliderUI.this.slider.getValue());
                    break;
                }
                case 0: {
                    int halfThumbWidth = ((EFCRangeSliderUI)EFCRangeSliderUI.this).thumbRect.width / 2;
                    int thumbLeft = this.currentMouseX - this.offset;
                    int trackLeft = ((EFCRangeSliderUI)EFCRangeSliderUI.this).trackRect.x;
                    int trackRight = ((EFCRangeSliderUI)EFCRangeSliderUI.this).trackRect.x + (((EFCRangeSliderUI)EFCRangeSliderUI.this).trackRect.width - 1);
                    int hMin = EFCRangeSliderUI.this.xPositionForValue(EFCRangeSliderUI.this.slider.getValue());
                    if (EFCRangeSliderUI.this.drawInverted()) {
                        trackRight = hMin;
                    } else {
                        trackLeft = hMin;
                    }
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    EFCRangeSliderUI.this.setUpperThumbLocation(thumbLeft, ((EFCRangeSliderUI)EFCRangeSliderUI.this).thumbRect.y);
                    thumbMiddle = thumbLeft + halfThumbWidth;
                    EFCRangeSliderUI.this.slider.setExtent(EFCRangeSliderUI.this.valueForXPosition(thumbMiddle) - EFCRangeSliderUI.this.slider.getValue());
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent arg0) {
            if (!EFCRangeSliderUI.this.lowerDragging && !EFCRangeSliderUI.this.upperDragging) {
                EFCRangeSliderUI.this.calculateThumbLocation();
                EFCRangeSliderUI.this.slider.repaint();
            }
        }
    }
}

