/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing;

import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.datatypes.EFCDate;
import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.base.datatypes.EFCLong;
import de.effectivecompany.base.datatypes.EFCMoney;
import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.datatypes.EFCQuantity;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.gui.components.editor.interfaces.EFCCellEditor;
import de.effectivecompany.gui.components.editor.table.EFCAbstractCellEditor;
import de.effectivecompany.gui.components.editor.table.EFCBooleanCellEditor;
import de.effectivecompany.gui.components.editor.table.EFCDateCellEditor;
import de.effectivecompany.gui.components.editor.table.EFCDateTimeCellEditor;
import de.effectivecompany.gui.components.editor.table.EFCGenericCellEditor;
import de.effectivecompany.gui.components.editor.table.EFCIntegerCellEditor;
import de.effectivecompany.gui.components.editor.table.EFCNumberCellEditor;
import de.effectivecompany.gui.components.editor.table.EFCOptionCellEditor;
import de.effectivecompany.gui.components.model.interfaces.CellClassModel;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class EFCTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 4536494362373417360L;
    private EFCCellEditor editor;
    private Map<Class<?>, EFCCellEditor> editors = new HashMap();
    private Object editStart;
    private Object editResult;

    public EFCTableCellEditor(boolean allowEmpty) {
        EFCAbstractCellEditor cellEditor = new EFCBooleanCellEditor(allowEmpty);
        this.editors.put(EFCBoolean.class, cellEditor);
        this.editors.put(Boolean.class, cellEditor);
        cellEditor = new EFCOptionCellEditor(allowEmpty);
        this.editors.put(EFCOption.class, cellEditor);
        cellEditor = new EFCNumberCellEditor();
        this.editors.put(Float.class, cellEditor);
        this.editors.put(Double.class, cellEditor);
        this.editors.put(EFCMoney.class, cellEditor);
        this.editors.put(EFCQuantity.class, cellEditor);
        cellEditor = new EFCIntegerCellEditor();
        this.editors.put(Long.class, cellEditor);
        this.editors.put(Integer.class, cellEditor);
        this.editors.put(EFCInteger.class, cellEditor);
        this.editors.put(EFCLong.class, cellEditor);
        cellEditor = new EFCDateCellEditor();
        this.editors.put(EFCDate.class, cellEditor);
        cellEditor = new EFCDateTimeCellEditor();
        this.editors.put(Date.class, cellEditor);
        this.editors.put(EFCDateTime.class, cellEditor);
        cellEditor = new EFCGenericCellEditor();
        cellEditor.getComponent().setFont(EFCLookAndFeelManager.FONT_TABLE_CELLS);
        this.editors.put(Object.class, cellEditor);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        TableModel model = table.getModel();
        Class<?> cellClass = model instanceof CellClassModel ? ((CellClassModel)model).getCellClass(table.convertRowIndexToModel(row), table.convertColumnIndexToModel(column)) : model.getColumnClass(table.convertColumnIndexToModel(column));
        this.editStart = value;
        this.editor = this.editors.get(cellClass);
        if (this.editor == null) {
            while ((cellClass = cellClass.getSuperclass()) != null) {
                this.editor = this.editors.get(cellClass);
                if (this.editor == null) continue;
            }
        }
        if (this.editor == null) {
            this.editor = this.editors.get(Object.class);
        }
        if (value instanceof Type) {
            this.editor.setValue((Type)value);
        } else {
            this.editor.setValue(value);
        }
        if (isSelected) {
            this.editor.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.editor.setBorder(EFCLookAndFeelManager.TABLE_CELL_EDITOR_NOFOCUSBORDER);
        }
        return this.editor.getComponent();
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        if (event instanceof MouseEvent) {
            return ((MouseEvent)event).getClickCount() == 1;
        }
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.editResult = this.editStart;
        super.cancelCellEditing();
    }

    @Override
    public boolean stopCellEditing() {
        if (this.editor == null) {
            this.editResult = null;
            return true;
        }
        if (this.editor.isContentValid()) {
            this.editResult = this.editor.getValue() instanceof String ? ((String)this.editor.getValue()).trim() : this.editor.getValue();
            return super.stopCellEditing();
        }
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editResult;
    }
}

