/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing;

import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.gui.data.SearchResult;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.gui.interfaces.SelectResult;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.meta.ColorInfo;
import de.effectivecompany.gui.components.model.table.BOTableModel;
import de.effectivecompany.gui.components.model.table.EFCColumnModel;
import de.effectivecompany.gui.components.model.table.SearchServiceTableModel;
import de.effectivecompany.gui.components.model.table.SelectServiceTableModel;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import de.effectivecompany.gui.interfaces.model.EFCModel;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.EUCellStyler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.table.TableColumnExt;

public class EFCTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 757517374444029100L;
    private DecimalFormat format;
    private EFCMap<String, Font> columnFonts;
    private boolean recolor;

    public EFCTableCellRenderer() {
        this(false);
    }

    public EFCTableCellRenderer(EFCMap<String, Font> columnFonts) {
        this(false);
        this.columnFonts = columnFonts;
    }

    public EFCTableCellRenderer(boolean recolorDisabled) {
        DecimalFormatSymbols formatSymbols;
        this.recolor = recolorDisabled;
        this.format = new DecimalFormat();
        this.format.setGroupingUsed(true);
        if (EFCPanelSingleton.DECIMAL_SEPARATOR != null) {
            formatSymbols = this.format.getDecimalFormatSymbols();
            formatSymbols.setDecimalSeparator(EFCPanelSingleton.DECIMAL_SEPARATOR.charValue());
            this.format.setDecimalFormatSymbols(formatSymbols);
        }
        if (EFCPanelSingleton.GROUPING_SEPARATOR != null) {
            formatSymbols = this.format.getDecimalFormatSymbols();
            formatSymbols.setGroupingSeparator(EFCPanelSingleton.GROUPING_SEPARATOR.charValue());
            this.format.setDecimalFormatSymbols(formatSymbols);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        SelectServiceTableModel selectModel;
        SelectResult selectResult;
        SearchResult colorInfo;
        BusinessObject currentBo;
        EFCModel boModel;
        JComponent component = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TableModel tableModel = table.getModel();
        component.setFont(EFCLookAndFeelManager.FONT_TABLE_CELLS);
        if (this.columnFonts != null && !this.columnFonts.isEmpty()) {
            TableColumnExt colExt = (TableColumnExt)((EFCColumnModel)((Object)table.getColumnModel())).getColumn(column);
            Font cellFont = null;
            if (colExt != null && colExt.getIdentifier() != null && (cellFont = (Font)this.columnFonts.get(colExt.getIdentifier())) != null) {
                component.setFont(cellFont);
            }
        }
        if (isSelected) {
            component.setBorder(EFCLookAndFeelManager.TABLE_CELL_BORRDER_HIGHLIGHT);
        } else {
            component.setBorder(EFCLookAndFeelManager.TABLE_CELL_BORRDER_EMPTYBORDER);
        }
        if (value instanceof EFCOption) {
            EFCOption option = (EFCOption)value;
            if (option.optainValue() != null) {
                String optClassName = ((EFCOption)value).getOptionClass().getSimpleName().toUpperCase();
                String key = "OPT_" + optClassName + "_" + ((EFCOption)value).toString() + "_S";
                value = Translator.tr((String)key);
            } else {
                value = "";
            }
        }
        if (value instanceof EFCBoolean) {
            JCheckBox box = new JCheckBox();
            box.setBorderPainted(true);
            if (isSelected) {
                box.setBorder(EFCLookAndFeelManager.TABLE_CELL_BORRDER_HIGHLIGHT);
            } else {
                box.setBorder(EFCLookAndFeelManager.TABLE_CELL_BORRDER_EMPTYBORDER);
            }
            box.setSelected(value != null && ((EFCBoolean)value).getBoolean() != null && ((EFCBoolean)value).getBoolean() != false);
            box.setHorizontalAlignment(0);
            if (isSelected) {
                box.setForeground(table.getSelectionForeground());
                box.setBackground(table.getSelectionBackground());
            } else {
                box.setForeground(table.getForeground());
                box.setBackground(table.getBackground());
            }
            component = box;
        } else {
            EUCellStyler.styleCellComponent(component, value);
        }
        if (this.recolor) {
            if (tableModel.isCellEditable(row, column)) {
                component.setBackground(SystemColor.text);
            } else {
                component.setBackground(SystemColor.LIGHT_GRAY);
            }
            component.setForeground(SystemColor.textText);
        }
        if (tableModel instanceof BOTableModel) {
            boModel = (BOTableModel)tableModel;
            currentBo = ((BOTableModel)boModel).getObjectAtRow(table.convertRowIndexToModel(row));
            if (currentBo != null) {
                if (currentBo._isRemoved()) {
                    component.setForeground(EFCLookAndFeelManager.COLOR_TABLE_TEXT_DELETEDROW);
                } else if (!currentBo._isStored()) {
                    component.setForeground(EFCLookAndFeelManager.COLOR_TABLE_TEXT_NEWROW);
                } else {
                    component.setForeground(SystemColor.textText);
                }
                if (currentBo instanceof ColorInfo) {
                    colorInfo = (ColorInfo)currentBo;
                    component.setBackground(colorInfo.getColor() == null ? null : colorInfo.getColor());
                    if (component.getBackground() != null && component.getBackground().equals(Color.BLACK)) {
                        component.setForeground(Color.WHITE);
                    }
                    TableColumnExt colExt = (TableColumnExt)((EFCColumnModel)((Object)table.getColumnModel())).getColumn(column);
                    Color cellColor = null;
                    if (colExt != null && colExt.getIdentifier() != null && (cellColor = (Color)colorInfo.getColorMap().get(colExt.getIdentifier())) != null) {
                        component.setBackground(cellColor);
                    }
                }
            }
        } else if (tableModel instanceof EFCModel) {
            boModel = (EFCModel)((Object)tableModel);
            currentBo = boModel.getObjectAtRow(table.convertRowIndexToModel(row));
            if (currentBo._isRemoved()) {
                component.setForeground(EFCLookAndFeelManager.COLOR_TABLE_TEXT_DELETEDROW);
            } else {
                component.setForeground(SystemColor.textText);
            }
            if (currentBo instanceof ColorInfo) {
                colorInfo = (ColorInfo)currentBo;
                component.setBackground(colorInfo.getColor() == null ? null : colorInfo.getColor());
                TableColumnExt colExt = (TableColumnExt)((EFCColumnModel)((Object)table.getColumnModel())).getColumn(column);
                Color cellColor = null;
                if (colExt != null && colExt.getIdentifier() != null && (cellColor = (Color)colorInfo.getColorMap().get(colExt.getIdentifier())) != null) {
                    component.setBackground(cellColor);
                }
            }
        } else if (tableModel instanceof SearchServiceTableModel) {
            SearchServiceTableModel searchModel = (SearchServiceTableModel)tableModel;
            SearchResult searchResult = searchModel.getObjectAt(table.convertRowIndexToModel(row));
            if (searchResult instanceof ColorInfo) {
                colorInfo = searchResult;
                component.setBackground(colorInfo.getColor() == null ? null : colorInfo.getColor());
                Color cellColor = null;
                if (searchModel != null && searchModel.getColumnIdentifier(column) != null && (cellColor = (Color)colorInfo.getColorMap().get(searchModel.getColumnIdentifier(column))) != null) {
                    component.setBackground(cellColor);
                }
            }
        } else if (tableModel instanceof SelectServiceTableModel && (selectResult = (selectModel = (SelectServiceTableModel)tableModel).getObjectAt(table.convertRowIndexToModel(row))) instanceof ColorInfo) {
            colorInfo = selectResult;
            component.setBackground(colorInfo.getColor() == null ? null : colorInfo.getColor());
            Color cellColor = null;
            if (selectModel != null && colorInfo.getColorMap() != null && selectModel.getColumnIdentifier(column) != null && (cellColor = (Color)colorInfo.getColorMap().get(selectModel.getColumnIdentifier(column))) != null) {
                component.setBackground(cellColor);
            }
        }
        return component;
    }
}

