/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing;

import de.effectivecompany.gui.components.swing.event.SelectionEvent;
import de.effectivecompany.gui.components.swing.event.SelectionListener;
import de.effectivecompany.gui.components.swing.event.ZoomEvent;
import de.effectivecompany.gui.components.swing.event.ZoomListener;
import de.effectivecompany.gui.components.swing.gantt.EGanttGraphView;
import de.effectivecompany.gui.components.swing.gantt.EGanttTreeView;
import de.effectivecompany.gui.components.swing.model.gantt.DefaultGanttElement;
import de.effectivecompany.gui.components.swing.model.gantt.DefaultGanttModel;
import de.effectivecompany.gui.components.swing.model.gantt.DefaultGanttTask;
import de.effectivecompany.gui.components.swing.model.gantt.DefaultGanttTaskLink;
import de.effectivecompany.gui.components.swing.model.gantt.GanttModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;

public class EGanttChart
extends JComponent {
    private static final long serialVersionUID = 7410604552754380958L;
    private JSplitPane split;
    private JScrollPane viewScroll;
    private JViewport treeViewport;
    private JScrollBar hTreeScroll;
    private EGanttGraphView graphView;
    private EGanttTreeView treeView;
    private ZoomListener zoomListener;
    private Vector<SelectionListener> selectionListener = new Vector();

    public EGanttChart() {
        SelectionHandler selHandler = new SelectionHandler();
        this.setLayout(new BorderLayout());
        this.zoomListener = new ZoomHandler();
        this.graphView = new EGanttGraphView();
        this.treeView = new EGanttTreeView();
        this.split = new JSplitPane(1);
        this.viewScroll = new JScrollPane();
        this.treeViewport = new JViewport();
        this.hTreeScroll = new JScrollBar(0);
        this.viewScroll.setViewportView(this.graphView);
        this.treeViewport.setView(this.treeView);
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BorderLayout());
        treePanel.add((Component)this.treeViewport, "Center");
        treePanel.add((Component)this.hTreeScroll, "South");
        this.split.add((Component)treePanel, "left");
        this.graphView.addZoomListener(this.zoomListener);
        this.split.add((Component)this.graphView, "right");
        this.add((Component)this.split, "Center");
        this.graphView.addSelectionListener(selHandler);
    }

    public EGanttChart(GanttModel model) {
        this();
        this.setModel(model);
    }

    public void setGraphView(EGanttGraphView graphView) {
        this.graphView = graphView;
    }

    public EGanttGraphView getGraphView() {
        return this.graphView;
    }

    public GanttModel getModel() {
        return this.graphView.getModel();
    }

    public void setModel(GanttModel model) {
        this.graphView.setModel(model);
        this.treeView.setModel(model);
    }

    public void addSelectionListener(SelectionListener l) {
        this.selectionListener.add(l);
    }

    public SelectionListener[] getSelectionListener() {
        return this.selectionListener.toArray(new SelectionListener[this.selectionListener.size()]);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.selectionListener.remove(l);
    }

    public static void main(String[] args) {
        DefaultGanttModel model = new DefaultGanttModel();
        DefaultGanttElement element = new DefaultGanttElement("test 1");
        DefaultGanttTask task1 = new DefaultGanttTask();
        task1.setPercent(25.0);
        element.addTask(task1);
        DefaultGanttTask task4 = new DefaultGanttTask();
        task4.setStart(new Date(System.currentTimeMillis() + 1800000L));
        task4.setEnd(new Date(System.currentTimeMillis() + 3600000L));
        element.addTask(task4);
        model.add(element);
        element = new DefaultGanttElement("test 2");
        DefaultGanttTask task2 = new DefaultGanttTask(new Date(System.currentTimeMillis() + 300000L), new Date(System.currentTimeMillis() + 3600000L));
        task2.setPercent(75.0);
        element.addTask(task2);
        model.add(element);
        element = new DefaultGanttElement("test 3 abc");
        DefaultGanttTask task3 = new DefaultGanttTask(new Date(System.currentTimeMillis() + 3600000L), new Date(System.currentTimeMillis() + 10800000L));
        task3.setPercent(85.0);
        element.addTask(task3);
        model.add(element);
        model.add(new DefaultGanttTaskLink(task2, task3));
        model.add(new DefaultGanttTaskLink(task2, task1));
        model.add(new DefaultGanttTaskLink(task1, task4));
        model.add(new DefaultGanttTaskLink(task3, task1));
        model.add(new DefaultGanttTaskLink(task4, task2));
        JFrame frm = new JFrame();
        frm.add(new EGanttChart(model));
        frm.setDefaultCloseOperation(2);
        frm.setVisible(true);
    }

    private class SelectionHandler
    implements SelectionListener {
        private SelectionHandler() {
        }

        @Override
        public void onSelect(SelectionEvent e) {
            for (SelectionListener l : EGanttChart.this.selectionListener) {
                l.onSelect(e);
            }
        }

        @Override
        public void onDeselect(SelectionEvent e) {
            for (SelectionListener l : EGanttChart.this.selectionListener) {
                l.onDeselect(e);
            }
        }
    }

    private class ZoomHandler
    implements ZoomListener {
        private ZoomHandler() {
        }

        @Override
        public void handleZoomChange(ZoomEvent e) {
            if (e.getSource() == EGanttChart.this.graphView) {
                EGanttChart.this.treeView.setZoom(e.getZoom());
            }
        }
    }
}

