/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing.gantt;

import de.effectivecompany.gui.components.model.interfaces.Selectable;
import de.effectivecompany.gui.components.swing.event.SelectionEvent;
import de.effectivecompany.gui.components.swing.event.SelectionListener;
import de.effectivecompany.gui.components.swing.event.ZoomEvent;
import de.effectivecompany.gui.components.swing.event.ZoomListener;
import de.effectivecompany.gui.components.swing.gantt.EGanttGraphPainter;
import de.effectivecompany.gui.components.swing.gantt.EGanttGraphTaskPainter;
import de.effectivecompany.gui.components.swing.model.gantt.GanttElement;
import de.effectivecompany.gui.components.swing.model.gantt.GanttModel;
import de.effectivecompany.gui.components.swing.model.gantt.GanttTask;
import de.effectivecompany.gui.components.swing.model.gantt.GanttTaskLink;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.Scrollable;

public class EGanttGraphView
extends JComponent
implements Scrollable {
    private static final long serialVersionUID = -5828135439982438198L;
    public static final double F_DEFAULT = 2.0E-5;
    private Date viewportStart = new Date();
    private Date gridStart = new Date();
    private Date rangeStart = new Date(System.currentTimeMillis() - 86400000L);
    private Date rangeEnd = new Date(System.currentTimeMillis() + 604800000L);
    private int barHeight = 10;
    private double barWidthFactor = 2.0E-5;
    private double zoom = 1.0;
    private int subStepSize = 900000;
    private int stepSubSteps = 4;
    private GanttModel model;
    private EGanttGraphPainter mainPainter = new EGanttGraphPainter();
    private EGanttGraphTaskPainter taskPainter = new EGanttGraphTaskPainter();
    private boolean antiAlias = true;
    private static final Color lineColor = new Color(200, 200, 200);
    private Vector<ZoomListener> zoomListener = new Vector();
    private Vector<SelectionListener> selectionListener = new Vector();
    private Point dragPoint;
    private Dimension prefDim = null;

    public EGanttGraphView() {
        MouseHandler mh = new MouseHandler();
        this.addMouseWheelListener(mh);
        this.addMouseListener(mh);
        this.addMouseMotionListener(mh);
        this.setFocusable(true);
    }

    public EGanttGraphTaskPainter getTaskPainter() {
        return this.taskPainter;
    }

    public void setTaskPainter(EGanttGraphTaskPainter taskPainter) {
        this.taskPainter = taskPainter;
    }

    public EGanttGraphPainter getMainPainter() {
        return this.mainPainter;
    }

    public void setMainPainter(EGanttGraphPainter mainPainter) {
        this.mainPainter = mainPainter;
    }

    public Date getGridStart() {
        return this.gridStart;
    }

    public Date getRangeStart() {
        return this.rangeStart;
    }

    public void setRangeStart(Date rangeStart) {
        this.rangeStart = rangeStart;
    }

    public Date getRangeEnd() {
        return this.rangeEnd;
    }

    public void setRangeEnd(Date rangeEnd) {
        this.rangeEnd = rangeEnd;
    }

    public void addZoomListener(ZoomListener l) {
        this.zoomListener.add(l);
    }

    public void removeZoomListener(ZoomListener l) {
        this.zoomListener.remove(l);
    }

    public void addSelectionListener(SelectionListener l) {
        this.selectionListener.add(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.selectionListener.remove(l);
    }

    public void fireZoomChanged(double old, double zoom) {
        ZoomEvent ze = new ZoomEvent(this, old, zoom);
        for (ZoomListener l : this.zoomListener) {
            l.handleZoomChange(ze);
        }
    }

    public void fireElementUnselected(Object item) {
        SelectionEvent se = new SelectionEvent(this, 150102, item);
        for (SelectionListener l : this.selectionListener) {
            l.onDeselect(se);
        }
    }

    public void fireElementSelected(Object item) {
        SelectionEvent se = new SelectionEvent(this, 150101, item);
        for (SelectionListener l : this.selectionListener) {
            l.onSelect(se);
        }
    }

    public double getBarWidthFactor() {
        return this.barWidthFactor;
    }

    public void setBarWidthFactor(double barWidthFactor) {
        this.barWidthFactor = barWidthFactor;
    }

    public GanttModel getModel() {
        return this.model;
    }

    public void setModel(GanttModel model) {
        this.model = model;
    }

    public int getSubStepSize() {
        return this.subStepSize;
    }

    public void setSubStepSize(int size) {
        this.subStepSize = size;
    }

    public int getStepSubSteps() {
        return this.stepSubSteps;
    }

    public void setStepSubSteps(int stepSubSteps) {
        this.stepSubSteps = stepSubSteps;
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public void setBarHeight(int barHeight) {
        this.barHeight = barHeight;
    }

    public int getLineHeight() {
        return this.getBarHeight() + 10;
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        double old = this.zoom;
        this.zoom = zoom;
        this.fireZoomChanged(old, zoom);
    }

    public Date getViewportStart() {
        return this.viewportStart;
    }

    public void setViewStart(long viewStart) {
        this.setViewStart(new Date(viewStart));
    }

    public void setViewStart(Date viewStart) {
        this.viewportStart.setTime(viewStart.getTime());
        Date old = new Date(this.viewportStart.getTime());
        if (this.viewportStart.getTime() < this.rangeStart.getTime()) {
            this.viewportStart.setTime(this.rangeStart.getTime());
        } else if (this.viewportStart.getTime() > this.rangeEnd.getTime()) {
            this.viewportStart.setTime(this.rangeEnd.getTime());
        }
        if (old.getTime() != this.viewportStart.getTime()) {
            this.firePropertyChange("viewStart", old, viewStart);
        }
    }

    public Point getStartPoint(GanttTask task) {
        int rows = this.model.getRowCount();
        for (int i = 0; i < rows; ++i) {
            GanttTask[] tasks = this.model.getTasksForRow(i);
            if (!Arrays.asList(tasks).contains(task)) continue;
            Point p = new Point();
            long lineStart = this.getViewportStart().getTime();
            long taskStart = task.getStart().getTime();
            p.y = (int)((double)(i * this.getLineHeight() + this.getLineHeight() / 2) * this.zoom);
            p.x = (int)((double)(taskStart - lineStart) * this.barWidthFactor * this.zoom);
            return p;
        }
        return null;
    }

    public Point getEndPoint(GanttTask task) {
        Point p = this.getStartPoint(task);
        p.x = (int)((double)p.x + (double)(task.getEnd().getTime() - task.getStart().getTime()) * this.getBarWidthFactor() * this.zoom);
        return p;
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        this.prefDim = preferredSize;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.prefDim != null) {
            return this.prefDim;
        }
        Dimension dim = new Dimension();
        int rowCount = 0;
        if (this.model != null) {
            rowCount = this.model.getRowCount();
        }
        dim.height = (int)((double)(rowCount * this.getLineHeight()) * this.getZoom()) + 20;
        dim.width = (int)((double)(this.rangeEnd.getTime() - this.rangeStart.getTime()) * this.barWidthFactor * this.zoom);
        return dim;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 1;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 1;
    }

    @Override
    protected void paintComponent(Graphics g) {
        GanttTaskLink[] links;
        super.paintComponent(g);
        if (this.antiAlias && g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int width = g.getClipBounds().width;
        int height = g.getClipBounds().height;
        int rows = 0;
        if (this.model != null) {
            rows = this.model.getRowCount();
        }
        this.mainPainter.paintHeader(g, this);
        this.mainPainter.paintGrid(g, lineColor, Color.GRAY, this);
        if (this.model == null) {
            return;
        }
        Graphics subGraphics = g.create(0, 20, width, height - 20);
        subGraphics.setColor(lineColor);
        for (GanttTaskLink link : links = this.model.getTaskLinks()) {
            this.taskPainter.paintLink(subGraphics, link, this);
        }
        for (int i = 0; i < rows; ++i) {
            GanttTask[] tasks = this.model.getTasksForRow(i);
            if (tasks == null) continue;
            for (GanttTask task : tasks) {
                this.taskPainter.paintTask(subGraphics, task, this);
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            EGanttGraphView.this.setZoom(EGanttGraphView.this.getZoom() + (double)e.getWheelRotation() * 0.1);
            EGanttGraphView.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            EGanttGraphView.this.dragPoint = e.getPoint();
            long timePos = e.getX();
            int row = e.getY();
            Selectable selectedTask = null;
            row = (int)((double)(e.getY() - 20) / ((double)EGanttGraphView.this.getLineHeight() * EGanttGraphView.this.zoom));
            timePos = EGanttGraphView.this.viewportStart.getTime() + (long)((double)e.getX() / (EGanttGraphView.this.barWidthFactor * EGanttGraphView.this.zoom));
            if (EGanttGraphView.this.model != null) {
                for (int i = 0; i < EGanttGraphView.this.model.getRowCount(); ++i) {
                    GanttElement element = EGanttGraphView.this.model.getElement(i);
                    if (element == null) continue;
                    for (GanttTask task : element.getTasks()) {
                        if (i == row) {
                            if (task.getStart().getTime() <= timePos && task.getEnd().getTime() >= timePos) {
                                selectedTask = task;
                                continue;
                            }
                            if (task.isSelected()) {
                                EGanttGraphView.this.fireElementUnselected(task);
                            }
                            task.setSelected(false);
                            continue;
                        }
                        if (task.isSelected()) {
                            EGanttGraphView.this.fireElementUnselected(task);
                        }
                        task.setSelected(false);
                    }
                }
            }
            if (selectedTask != null) {
                boolean fireEvent = !selectedTask.isSelected();
                selectedTask.setSelected(true);
                if (fireEvent) {
                    EGanttGraphView.this.fireElementSelected(selectedTask);
                }
            }
            super.mouseClicked(e);
            EGanttGraphView.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            EGanttGraphView.this.dragPoint = null;
            super.mouseReleased(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int relX = EGanttGraphView.this.dragPoint.x - e.getPoint().x;
            EGanttGraphView.this.setViewStart((long)((double)EGanttGraphView.this.viewportStart.getTime() + (double)relX / (EGanttGraphView.this.barWidthFactor * EGanttGraphView.this.zoom)));
            EGanttGraphView.this.dragPoint = e.getPoint();
            EGanttGraphView.this.repaint();
        }
    }
}

