/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing.model.explorer;

import de.effectivecompany.gui.components.swing.model.explorer.ETreeElement;
import de.effectivecompany.gui.components.swing.model.explorer.ETreeListener;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ETreeModel
implements TreeModel {
    private ETreeElement root;
    private EventHandler eventHandler;
    private Vector<TreeModelListener> listener = new Vector();

    public ETreeModel() {
        this.eventHandler = new EventHandler(this);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    public void setRoot(ETreeElement e) {
        if (this.root != null) {
            this.root.removeListener(this.eventHandler);
        }
        this.root = e;
        if (e == null) {
            return;
        }
        this.root.addListener(this.eventHandler);
        this.fireStructureChanged();
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof ETreeElement) {
            ETreeElement e = (ETreeElement)parent;
            return e.getChilds()[index];
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof ETreeElement) {
            ETreeElement e = (ETreeElement)parent;
            return e.getChilds().length;
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof ETreeElement) {
            ETreeElement e = (ETreeElement)parent;
            ETreeElement[] childs = e.getChilds();
            for (int i = 0; i < childs.length; ++i) {
                if (childs[i] != child) continue;
                return i;
            }
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof ETreeElement) {
            return ((ETreeElement)node).getChilds().length == 0;
        }
        return false;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listener.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listener.remove(l);
    }

    public void fireStructureChanged() {
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{this.getRoot()});
        TreeModelListener[] myListeners = this.listener.toArray(new TreeModelListener[0]);
        for (int i = 0; i < myListeners.length; ++i) {
            myListeners[i].treeStructureChanged(e);
        }
    }

    private class EventHandler
    implements ETreeListener {
        private ETreeModel myMaster;

        public EventHandler(ETreeModel master) {
            this.myMaster = master;
        }

        @Override
        public void nodeChanged() {
            this.myMaster.fireStructureChanged();
        }
    }
}

