/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing.popup;

import de.effectivecompany.base.gui.data.SearchService;
import de.effectivecompany.base.gui.filter.Filter;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.components.model.table.SearchServiceTableModel;
import de.effectivecompany.gui.components.panel.EFCGlassPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.swing.EFCTable;
import de.effectivecompany.gui.components.table.EFCColumnResizer;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCSearchTablePopupMenu
extends JPopupMenu {
    private static Logger logger = LoggerFactory.getLogger(EFCSearchTablePopupMenu.class);
    private static final long serialVersionUID = 447567456158609582L;
    private EFCTable searchPopupTable;
    private SearchServiceTableModel searchPopupTableModel;
    private EFCAbstractPrimaryEditor parent;
    private EFCController parentController;
    private String searchListKey;
    private SearchService searchService;
    private String searchlist;
    private String[] orderFields;
    private boolean isEnabled = true;
    private String selectKey;
    private EFCGlassPanel glass;

    public void setLocked(boolean locked) {
        if (this.glass != null) {
            this.glass.setEnabled(!locked);
            if (locked) {
                this.setCursor(new Cursor(3));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    public EFCSearchTablePopupMenu(EFCController parentController, EFCAbstractPrimaryEditor parent, SearchService svc, String searchlist, String searchListKey, String[] orderFields, String selectKey) {
        this.parent = parent;
        this.parentController = parentController;
        this.searchListKey = searchListKey;
        this.searchService = svc;
        this.searchlist = searchlist;
        this.orderFields = orderFields;
        this.selectKey = selectKey;
        this.setLayout(new BorderLayout());
        if (parent.getEditorComponent() instanceof JTextField) {
            JTextField textField = (JTextField)parent.getEditorComponent();
            textField.addKeyListener(new SearchTextFieldKeyListerner());
        }
    }

    private void initSearchTable() {
        this.searchPopupTableModel = new SearchServiceTableModel(this.searchService, this.searchlist, this.orderFields);
        this.searchPopupTable = new EFCTable(this.searchPopupTableModel);
        this.searchPopupTable.setHorizontalScrollEnabled(true);
        this.searchPopupTable.setColumnControlVisible(false);
        this.searchPopupTable.setAutoResizeMode(0);
        this.searchPopupTable.addMouseListener(new PopupMouseClickHandler());
        this.searchPopupTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "SOME_ACTION");
        this.searchPopupTable.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "SOME_ACTION");
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = -2783835902590454456L;

            @Override
            public void actionPerformed(ActionEvent e) {
                EFCSearchTablePopupMenu.this.setVisible(false);
            }
        };
        this.searchPopupTable.getActionMap().put("SOME_ACTION", action);
        this.searchPopupTable.setSelectionMode(0);
        this.addPopupMenuListener(new SearchPopupStateHandler());
        JScrollPane searchPopupScroll = new JScrollPane((Component)((Object)this.searchPopupTable));
        searchPopupScroll.setPreferredSize(new Dimension(EFCLookAndFeelManager.SEARCH_TABLE_WIDTH, EFCLookAndFeelManager.SEARCH_TABLE_HEIGHT));
        searchPopupScroll.setMaximumSize(new Dimension(EFCLookAndFeelManager.SEARCH_TABLE_WIDTH, EFCLookAndFeelManager.SEARCH_TABLE_HEIGHT));
        this.glass = new EFCGlassPanel(searchPopupScroll);
        this.add((Component)this.glass, "Center");
    }

    public SearchService getSearchService() {
        return this.searchPopupTableModel.getSearchService();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public void terminate() {
        if (this.searchPopupTable != null) {
            for (MouseListener listener : this.searchPopupTable.getMouseListeners()) {
                this.searchPopupTable.removeMouseListener(listener);
                listener = null;
            }
            this.searchPopupTable.removeAll();
            this.searchPopupTable = null;
        }
        if (this.searchPopupTableModel != null) {
            this.searchPopupTableModel = null;
        }
        if (this.glass != null) {
            this.glass.removeAll();
            this.glass = null;
        }
        if (this.parent != null) {
            this.parent = null;
        }
        this.removeAll();
    }

    private class SearchPopupStateHandler
    implements PopupMenuListener {
        boolean isCanceled = false;

        private SearchPopupStateHandler() {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
            logger.debug("SearchPopupStateHandler.popupMenuWillBecomeInvisible()");
            this.handleCloseEvent(event);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.isCanceled = true;
        }

        private void handleCloseEvent(PopupMenuEvent event) {
            try {
                EFCSearchTablePopupMenu.this.parent.setFocusHandling(true);
                if (!this.isCanceled) {
                    EFCTable table = EFCSearchTablePopupMenu.this.searchPopupTable;
                    int selectedRow = table.getSelectedRow();
                    if (selectedRow == -1) {
                        return;
                    }
                    SearchServiceTableModel model = EFCSearchTablePopupMenu.this.searchPopupTableModel;
                    String ident = null;
                    ident = EFCSearchTablePopupMenu.this.searchListKey != null && !EFCSearchTablePopupMenu.this.searchListKey.isEmpty() ? EFCSearchTablePopupMenu.this.searchListKey : EFCSearchTablePopupMenu.this.parent.getIdent();
                    if (EFCSearchTablePopupMenu.this.selectKey != null && !EFCSearchTablePopupMenu.this.selectKey.isEmpty()) {
                        ident = EFCSearchTablePopupMenu.this.selectKey;
                    }
                    if (ident != null && ident.contains(".")) {
                        ident = ident.substring(ident.lastIndexOf(".") + 1, ident.length());
                    }
                    Map valueMap = model.getObjectAt(table.convertRowIndexToModel(selectedRow)).getData();
                    if (ident != null && valueMap.containsKey(ident.toUpperCase())) {
                        this.handleNewValue(EFCSearchTablePopupMenu.this.parent.getOriginalValue(), (String)valueMap.get(ident.toUpperCase()), valueMap);
                    }
                } else {
                    EFCSearchTablePopupMenu.this.parent.setValue(EFCSearchTablePopupMenu.this.parent.getOriginalValue());
                }
            }
            catch (Exception ex) {
                EFCDesktop.reportError(ex);
            }
        }

        private void handleNewValue(Object oldValue, String newValue, Map<String, String> valueMap) {
            if (EFCSearchTablePopupMenu.this.parent.isScrollMode() && (EFCSearchTablePopupMenu.this.parent.getMetadata().isScroll() || EFCSearchTablePopupMenu.this.parent.getMetadata().isKey())) {
                EFCSearchTablePopupMenu.this.parentController.handleSearchUpdate(EFCSearchTablePopupMenu.this.searchPopupTableModel.getKeyAt(EFCSearchTablePopupMenu.this.searchPopupTable.convertRowIndexToModel(EFCSearchTablePopupMenu.this.searchPopupTable.getSelectedRow())), null, EFCSearchTablePopupMenu.this.searchPopupTableModel.getSearchService().getId(), EFCSearchTablePopupMenu.this.searchPopupTableModel.getSearchFilter());
            } else if (!newValue.equals(EFCSearchTablePopupMenu.this.parent.getOriginalValue() != null ? EFCSearchTablePopupMenu.this.parent.getOriginalValue().toString() : "")) {
                EFCSearchTablePopupMenu.this.parentController.handleSearchFieldUpdate(EFCSearchTablePopupMenu.this.parent, oldValue, newValue, valueMap);
            } else {
                EFCSearchTablePopupMenu.this.parent.setValue(EFCSearchTablePopupMenu.this.parent.getOriginalValue());
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.isCanceled = false;
        }
    }

    private class PopupMouseClickHandler
    extends MouseAdapter {
        private PopupMouseClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2 && event.getButton() == 1) {
                event.consume();
                EFCSearchTablePopupMenu.this.setVisible(false);
            }
        }
    }

    protected class SearchTextFieldKeyListerner
    implements KeyListener {
        protected SearchTextFieldKeyListerner() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (EFCSearchTablePopupMenu.this.isEnabled && e.getKeyCode() == 40 && e.getModifiers() == 0) {
                if (EFCSearchTablePopupMenu.this.searchPopupTable == null) {
                    EFCSearchTablePopupMenu.this.initSearchTable();
                } else {
                    EFCSearchTablePopupMenu.this.searchPopupTableModel.clearData();
                }
                JComponent editor = EFCSearchTablePopupMenu.this.parent.getEditorComponent();
                if (EFCSearchTablePopupMenu.this.isVisible()) {
                    EFCSearchTablePopupMenu.this.setVisible(false);
                } else {
                    EFCSearchTablePopupMenu.this.parent.setFocusHandling(false);
                    try {
                        EFCSearchTablePopupMenu.this.show(EFCSearchTablePopupMenu.this.parent, editor.getX(), editor.getY() + editor.getHeight());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        EFCDesktop.reportError(ex);
                    }
                }
                EFCThreadUtil.edtBuilder(th -> {
                    EFCSearchTablePopupMenu.this.setLocked(true);
                    th.doOutside(() -> {
                        Filter filter = new Filter();
                        Filter baseFilter = EFCSearchTablePopupMenu.this.parentController.getSearchFieldFilter(EFCSearchTablePopupMenu.this.parent.getIdent());
                        if (baseFilter != null) {
                            filter.addSubfilter(baseFilter);
                        }
                        String ident = null;
                        ident = EFCSearchTablePopupMenu.this.searchListKey != null && !EFCSearchTablePopupMenu.this.searchListKey.isEmpty() ? EFCSearchTablePopupMenu.this.searchListKey : EFCSearchTablePopupMenu.this.parent.getIdent();
                        EFCSearchTablePopupMenu.this.searchPopupTableModel.loadData(ident, (String)EFCSearchTablePopupMenu.this.parent.getSimpleValue(), filter);
                        EFCColumnResizer.sizeColumnsToFit((JTable)((Object)EFCSearchTablePopupMenu.this.searchPopupTable), 5);
                        th.edt(() -> {
                            EFCSearchTablePopupMenu.this.setLocked(false);
                            EFCSearchTablePopupMenu.this.searchPopupTable.requestFocus();
                        });
                    });
                });
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

