/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.constants;

import de.effectivecompany.gui.constants.EFCAction;
import de.effectivecompany.gui.constants.EFCMenu;
import de.effectivecompany.gui.constants.EFCMenuElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public enum EFCPredefinedMenu {
    P_NO_MENU(new EFCMenu[0]),
    P_MAINFRAME(EFCMenu.M_FILE, EFCMenu.M_FAVORITES, EFCMenu.M_FRAMES, EFCMenu.M_TOOL_MAINFRAME, EFCMenu.M_HELP),
    P_DASHBOARD(EFCMenu.M_INFO, EFCMenu.M_GOTO),
    M_FRAME_MASTER(EFCMenu.M_EDIT, EFCMenu.M_FUNCTIONS, EFCMenu.M_INVENTORY, EFCMenu.M_STATUS, EFCMenu.M_LISTING, EFCMenu.M_ANALYSIS, EFCMenu.M_PRINT, EFCMenu.M_TOOLS, EFCMenu.M_INFO, EFCMenu.M_GOTO, EFCMenu.M_CUSTOMIZE, EFCMenu.M_HELP),
    M_FRAME_SEARCH(EFCMenu.M_EDIT, EFCMenu.M_HELP);

    private List<EFCMenu> menuElements = new ArrayList<EFCMenu>();

    private EFCPredefinedMenu(EFCMenu ... menuItems) {
        this.menuElements.addAll(Arrays.asList(menuItems));
    }

    public List<EFCMenu> getMenuElements() {
        return this.menuElements;
    }

    public static EnumSet<EFCAction> getActions(EFCPredefinedMenu predmenu) {
        EnumSet<EFCAction> actions = EnumSet.noneOf(EFCAction.class);
        for (EFCMenu menu : predmenu.getMenuElements()) {
            for (EFCMenuElement element : menu.getElements()) {
                EFCPredefinedMenu.addActionsFromElement(actions, element);
            }
        }
        return actions;
    }

    private static void addActionsFromElement(EnumSet<EFCAction> actions, EFCMenuElement element) {
        if (element instanceof EFCAction) {
            EFCAction action = (EFCAction)element;
            actions.add(action);
        }
        for (EFCMenuElement subElement : element.getElements()) {
            EFCPredefinedMenu.addActionsFromElement(actions, subElement);
        }
    }
}

