/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.data;

import de.effectivecompany.base.datatypes.BaseType;
import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.meta.MetaInfo;
import de.effectivecompany.base.meta.TypeInfo;
import de.effectivecompany.base.util.ObjectUtil2;
import de.effectivecompany.base.util.StringUtil;
import de.effectivecompany.gui.exceptions.InvalidTableSelectionException;
import de.effectivecompany.gui.interfaces.listeners.DataChangeListener;
import de.effectivecompany.gui.interfaces.listeners.ListChangeListener;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessObjectModel
implements Serializable,
Cloneable {
    private static Logger logger = LoggerFactory.getLogger(BusinessObjectModel.class);
    private static final long serialVersionUID = 7277051276516418253L;
    private BusinessObject object;
    private boolean modified;
    private Map<String, Integer> selectedListItems = new HashMap<String, Integer>();
    private Map<String, Integer> lastSelectedListItems = new HashMap<String, Integer>();
    private Vector<DataChangeListener> dataSetListener = new Vector(5, 5);
    private Vector<ListChangeListener> listChangeListener = new Vector(5, 5);
    private String cacheLastDomain;
    private TypeInfo cacheTypeInfo;
    private Class<? extends BusinessObject> businessObjectClass;
    private static MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();

    public BusinessObjectModel() {
        this(null);
    }

    public BusinessObjectModel(BusinessObject object) {
        this.setObject(object);
    }

    public Class<? extends BusinessObject> getBusinessObjectClass() {
        return this.businessObjectClass;
    }

    public void setBusinessObjectClass(Class<? extends BusinessObject> businessObjectClass) {
        this.businessObjectClass = businessObjectClass;
    }

    public void addDataSetListener(DataChangeListener l) {
        this.dataSetListener.add(l);
    }

    public void removeDataSetListener(DataChangeListener l) {
        this.dataSetListener.remove(l);
    }

    public DataChangeListener[] getDataSetListener() {
        return this.dataSetListener.toArray(new DataChangeListener[this.dataSetListener.size()]);
    }

    public void addListChangeListener(ListChangeListener l) {
        this.listChangeListener.add(l);
    }

    public void removeListChangeListener(ListChangeListener l) {
        this.listChangeListener.remove(l);
    }

    public BusinessObject getObject() {
        return this.object;
    }

    public void setObject(BusinessObject object) {
        this.object = object;
        this.cacheLastDomain = null;
        this.cacheTypeInfo = null;
    }

    public void setSelectedListItemIndex(String listIdent, int index) {
        Integer oldIndex = this.selectedListItems.get(listIdent = listIdent.toLowerCase());
        oldIndex = oldIndex == null ? -1 : oldIndex;
        if (oldIndex == -1) {
            this.setLastSelectedListItemIndex(listIdent, index);
        }
        this.selectedListItems.put(listIdent, index);
        for (ListChangeListener l : this.listChangeListener) {
            l.selectedElementChanged(listIdent, oldIndex, index);
        }
    }

    public void setLastSelectedListItemIndex() {
        this.lastSelectedListItems.putAll(this.selectedListItems);
    }

    public void setLastSelectedListItemIndex(String listIdent, int index) {
        this.lastSelectedListItems.put(listIdent.toLowerCase(), index);
    }

    public boolean isLastSelectedListItemsEmpty() {
        return this.lastSelectedListItems.isEmpty();
    }

    public int getSelectedListItemIndex(String listIdent) {
        Integer selected = this.selectedListItems.get(listIdent.toLowerCase());
        return selected == null ? -1 : selected;
    }

    public int getLastSelectedListItemIndex(String listIdent) {
        Integer selected = this.lastSelectedListItems.get(listIdent.toLowerCase());
        return selected == null ? -1 : selected;
    }

    public Map<String, Integer> getSelectedItems() {
        return this.selectedListItems;
    }

    public void fireListSizeChanged(String listIdent) {
        for (ListChangeListener l : this.listChangeListener) {
            l.listSizeChanged(listIdent);
        }
    }

    private void putValueInObject(String domain, String prefix, Object value, Object target) {
        int nextpos = domain.indexOf(".");
        if (target instanceof EFCList) {
            EFCList objectList = (EFCList)target;
            int selected = this.getLastSelectedListItemIndex(prefix);
            if (selected < 0 || selected >= objectList.size()) {
                throw new InvalidTableSelectionException("invalid selection on " + prefix);
            }
            target = objectList.get(selected);
        }
        if (nextpos == -1) {
            if (target == null) {
                throw new NullPointerException("could not put value in " + domain + ": target is null");
            }
            try {
                if (value != null && value instanceof Boolean) {
                    value = new EFCBoolean((Boolean)value);
                }
                ObjectUtil2.setObjectAttrBySetter((Object)target, (String)domain, (Object)value);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            String newDomain = domain.substring(nextpos + 1);
            String attribName = domain.substring(0, nextpos);
            prefix = "".equals(prefix) ? attribName : prefix + "." + attribName;
            Object newTarget = ObjectUtil2.getObjectAttributeByName((Object)target, (String)attribName);
            this.putValueInObject(newDomain, prefix, value, newTarget);
        }
    }

    public void setValueInObject(String domain, Object value) {
        Object oldValue = this.getValueFromObject(domain);
        this.putValueInObject(domain, "", value, this.object);
        for (DataChangeListener dcl : this.dataSetListener) {
            dcl.attributeChanged(domain, oldValue, value);
        }
    }

    private Object getValueFromObject(String domain, String prefix, Object target) {
        Type targetEfcType = null;
        boolean useIsGetter = false;
        if (!(target instanceof BusinessObject)) {
            if (target instanceof Type) {
                targetEfcType = (Type)target;
                if (targetEfcType instanceof EFCBoolean) {
                    useIsGetter = true;
                }
            } else if (target instanceof Boolean) {
                useIsGetter = true;
            }
        }
        if (target instanceof EFCList) {
            EFCList objectList = (EFCList)target;
            int selected = this.getSelectedListItemIndex(prefix);
            if (selected < 0 || selected >= objectList.size()) {
                throw new InvalidTableSelectionException("invalid selection on " + prefix);
            }
            target = objectList.get(selected);
        }
        if (target == null) {
            return null;
        }
        int nextPos = domain.indexOf(".");
        Object result = null;
        if (nextPos == -1) {
            MethodHandle getterMethod = null;
            String methodName = StringUtil.getterName((String)domain, useIsGetter ? Boolean.class : Object.class);
            String className = target.getClass().getName() + ".";
            String fullMethodName = className + methodName;
            if (ObjectUtil2.getterMethodCache.containsKey((Object)fullMethodName)) {
                getterMethod = (MethodHandle)ObjectUtil2.getterMethodCache.get((Object)fullMethodName);
            } else {
                try {
                    logger.debug("try method for getter: " + fullMethodName);
                    MethodType mt = MethodType.methodType(this.object.getClass().getMethod(methodName, null).getReturnType());
                    getterMethod = publicLookup.findVirtual(target.getClass(), methodName, mt);
                    ObjectUtil2.getterMethodCache.put((Object)fullMethodName, (Object)getterMethod);
                }
                catch (Throwable mt) {
                    // empty catch block
                }
                if (getterMethod == null) {
                    Method[] methods;
                    logger.debug("inspecting method list for getter: " + fullMethodName);
                    for (Method method : methods = target.getClass().getMethods()) {
                        if (!method.getName().equalsIgnoreCase(methodName) || method.getParameterTypes().length != 0) continue;
                        try {
                            MethodType mt = MethodType.methodType(method.getReturnType());
                            getterMethod = publicLookup.findVirtual(target.getClass(), method.getName(), mt);
                            ObjectUtil2.getterMethodCache.put((Object)fullMethodName, (Object)getterMethod);
                        }
                        catch (Throwable throwable) {}
                        break;
                    }
                }
            }
            if (getterMethod == null) {
                throw new NullPointerException("could not find getter " + methodName + " for field " + prefix + domain + " on " + target.getClass().getName());
            }
            try {
                result = getterMethod.invoke(target);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (Throwable th) {
                throw new RuntimeException("method call failed", th);
            }
        } else {
            String newDomain = domain.substring(nextPos + 1);
            String attribName = domain.substring(0, nextPos);
            prefix = "".equals(prefix) ? attribName : prefix + "." + attribName;
            Object newTarget = ObjectUtil2.getObjectAttributeByName((Object)target, (String)attribName);
            result = this.getValueFromObject(newDomain, prefix, newTarget);
        }
        return result;
    }

    public Object getValueFromObject(String domain) {
        return this.getValueFromObject(domain, "", this.object);
    }

    public Class<?> initGetterSetter(String domain) {
        return this.initGetterSetter(domain, this.businessObjectClass);
    }

    private Class<?> initGetterSetter(String domain, Class target) {
        Class newTarget = null;
        boolean useIsGetter = false;
        Class type = null;
        String prefix = null;
        prefix = domain.contains(".") ? domain.substring(0, domain.indexOf(".")) : domain;
        if (target != null) {
            Field field = null;
            for (Field f : target.getDeclaredFields()) {
                if (!f.getName().equalsIgnoreCase(prefix)) continue;
                field = f;
                break;
            }
            if (field != null) {
                type = field.getType();
            }
            if (type != null && BusinessObject.class.isAssignableFrom(type)) {
                newTarget = type;
            } else if (type != null && target != null && Boolean.class.isAssignableFrom(type)) {
                useIsGetter = true;
            } else if (type != null && type.isAssignableFrom(EFCList.class)) {
                Field listField = null;
                for (Field f : target.getDeclaredFields()) {
                    if (!f.getName().equalsIgnoreCase(prefix)) continue;
                    listField = f;
                    break;
                }
                ParameterizedType listType = (ParameterizedType)listField.getGenericType();
                newTarget = (Class)listType.getActualTypeArguments()[0];
            }
        }
        if (target == null) {
            return null;
        }
        int nextPos = domain.indexOf(".");
        Class<?> result = null;
        if (nextPos == -1) {
            MethodHandle getterMethod = null;
            String getterMethodName = StringUtil.getterName((String)domain, useIsGetter ? Boolean.class : Object.class);
            String className = target.getName() + ".";
            String fullGetterMethodName = className + getterMethodName;
            Method[] methods = target.getMethods();
            if (ObjectUtil2.getterMethodCache.containsKey((Object)fullGetterMethodName)) {
                getterMethod = (MethodHandle)ObjectUtil2.getterMethodCache.get((Object)fullGetterMethodName);
            } else {
                block23: {
                    try {
                        logger.debug("try method for getter: " + fullGetterMethodName);
                        MethodType mt = MethodType.methodType(this.object.getClass().getMethod(getterMethodName, null).getReturnType());
                        getterMethod = publicLookup.findVirtual(target, getterMethodName, mt);
                        ObjectUtil2.getterMethodCache.put((Object)fullGetterMethodName, (Object)getterMethod);
                    }
                    catch (Throwable ex) {
                        if (!getterMethodName.endsWith("list")) break block23;
                        String nextTry = ObjectUtil2.convertListToFirstUpper((String)getterMethodName);
                        try {
                            MethodType mt = MethodType.methodType(this.object.getClass().getMethod(nextTry, null).getReturnType());
                            getterMethod = publicLookup.findVirtual(target, getterMethodName, mt);
                            ObjectUtil2.getterMethodCache.put((Object)fullGetterMethodName, (Object)getterMethod);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                if (getterMethod == null) {
                    logger.debug("inspecting method list for getter: " + fullGetterMethodName);
                    for (Method method : methods) {
                        if (!method.getName().equalsIgnoreCase(getterMethodName) || method.getParameterTypes().length != 0) continue;
                        try {
                            MethodType mt = MethodType.methodType(method.getReturnType());
                            getterMethod = publicLookup.findVirtual(target, method.getName(), mt);
                            ObjectUtil2.getterMethodCache.put((Object)fullGetterMethodName, (Object)getterMethod);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                }
            }
            if (getterMethod == null) {
                throw new NullPointerException("could not find getter " + getterMethodName + " for field " + prefix + domain + " on " + target.getName());
            }
        } else {
            String newDomain = domain.substring(nextPos + 1);
            result = this.initGetterSetter(newDomain, newTarget);
        }
        return result;
    }

    private TypeInfo getAttributeInfo(String domain, MetaInfo baseObject) throws ClassNotFoundException {
        if ("".equals(domain)) {
            return new TypeInfo(baseObject.getClass().getName());
        }
        if (domain.contains(".")) {
            Class dummyAttributeClass;
            int separatorLocation = domain.indexOf(".");
            String attributeName = domain.substring(0, separatorLocation);
            String subDomain = domain.substring(separatorLocation + 1);
            TypeInfo attributeInfo = (TypeInfo)baseObject.fieldTypeMap().get(attributeName);
            if (attributeInfo.isList()) {
                dummyAttributeClass = ClassUtils.getClass((String)attributeInfo.getListElementTypeClassName());
            } else {
                if (attributeInfo.isMap()) {
                    logger.error("MAP attribute lookup not supported atm! Domain=" + domain);
                    return null;
                }
                dummyAttributeClass = ClassUtils.getClass((String)attributeInfo.getClassName());
            }
            try {
                Object dummyAttribute = dummyAttributeClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (dummyAttribute instanceof MetaInfo) {
                    return this.getAttributeInfo(subDomain, (MetaInfo)dummyAttribute);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            TypeInfo typeInfo = (TypeInfo)baseObject.fieldTypeMap().get(domain);
            if (typeInfo == null) {
                logger.error("no TYPEINFO found for domain " + domain);
                logger.error("available fields in the base object: " + baseObject.fieldTypeMap());
            } else if (typeInfo.getMinSize() == -1 || typeInfo.getMaxSize() == -1) {
                Class c = ClassUtils.getClass((String)typeInfo.getClassName());
                try {
                    Object bType = c.newInstance();
                    if (bType instanceof BaseType) {
                        typeInfo.setSizes((int)((BaseType)bType).getMetadata().getMinsize(), (int)((BaseType)bType).getMetadata().getMaxsize());
                    }
                }
                catch (InstantiationException ex) {
                    ex.printStackTrace();
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
            }
            return typeInfo;
        }
        return null;
    }

    public TypeInfo getAttributeInfo(String domain) {
        if (this.cacheLastDomain != null && this.cacheLastDomain.equals(domain)) {
            return new TypeInfo(this.cacheTypeInfo);
        }
        try {
            if (this.object instanceof MetaInfo) {
                TypeInfo info = this.getAttributeInfo(domain, (MetaInfo)this.object);
                if (info == null) {
                    return null;
                }
                this.cacheLastDomain = domain;
                this.cacheTypeInfo = new TypeInfo(info);
                return info;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return null;
    }

    public Class<?> getAttributeClass(String domain) {
        TypeInfo info = this.getAttributeInfo(domain);
        if (info == null) {
            return null;
        }
        try {
            return ClassUtils.getClass((String)info.getClassName());
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean isAttributeAList(String domain) {
        TypeInfo info = this.getAttributeInfo(domain);
        if (info == null) {
            return false;
        }
        return info.isList();
    }

    public boolean isAttributeAMap(String domain) {
        TypeInfo info = this.getAttributeInfo(domain);
        if (info == null) {
            return false;
        }
        return info.isMap();
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void printDebugInfo() {
        logger.debug("DEBUG: current bo=" + (this.object == null ? "null" : this.object.getClass().getName()));
        logger.debug("DEBUG: selected list elements:");
        for (Map.Entry<String, Integer> entry : this.selectedListItems.entrySet()) {
            logger.debug("DEBUG: +- " + entry.getKey() + " => " + entry.getValue());
        }
    }
}

