/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.factory;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.TcpConnection;
import de.effectivecompany.app.syscl.ClSysPrnSrv;
import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.data.EFCReportContainer;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaTray;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCPrintFactory {
    private static Logger logger = LoggerFactory.getLogger(EFCPrintFactory.class);

    public void print(EFCReportContainer efcReportContainer) {
        logger.info("Print report: {}", (Object)efcReportContainer.getClSysPrnSrv().getPrnrptid());
        ClSysPrnSrv clSysPrnSrv = efcReportContainer.getClSysPrnSrv();
        PDDocument pdDocument = null;
        if (clSysPrnSrv.getPrntype() == null || !clSysPrnSrv.getPrntype().equals(30)) {
            if (efcReportContainer.getDocument() instanceof PDDocument) {
                pdDocument = (PDDocument)efcReportContainer.getDocument();
            } else {
                return;
            }
        }
        Integer copies = null;
        if (efcReportContainer != null) {
            copies = efcReportContainer.getCopyCount();
        }
        if (copies == null || copies.equals(0)) {
            copies = 1;
        }
        logger.debug("Number of pages: {}", (Object)copies);
        String printerName = clSysPrnSrv.getPrnprintername().getData();
        if (printerName != null && printerName.equals("")) {
            printerName = null;
        }
        logger.debug("Printername: {}", (Object)printerName);
        EFCBoolean isPrinterSelection = clSysPrnSrv.getIsprnselect();
        if (isPrinterSelection.getBoolean() == null) {
            isPrinterSelection.setData(Boolean.valueOf(true));
        }
        logger.debug("Printer selected: {}", (Object)isPrinterSelection.getBoolean());
        int traySelected = -1;
        if (!clSysPrnSrv.getPrnprintersrc().toString().equals("")) {
            traySelected = Integer.parseInt(clSysPrnSrv.getPrnprintersrc().toString());
            logger.debug("Tray selected: {}", (Object)traySelected);
        }
        if (clSysPrnSrv.getPrntype() != null && clSysPrnSrv.getPrntype().equals(30)) {
            this.printToZPL(efcReportContainer, clSysPrnSrv, copies, printerName, isPrinterSelection, traySelected);
        } else {
            this.printToPrinter(efcReportContainer, clSysPrnSrv, pdDocument, copies, printerName, isPrinterSelection, traySelected);
        }
    }

    private void printToZPL(EFCReportContainer efcReportContainer, ClSysPrnSrv clSysPrnSrv, Integer copies, String printerName, EFCBoolean isPrinterSelection, int traySelected) {
        TcpConnection thePrinterConn = new TcpConnection(printerName, 9100);
        try {
            thePrinterConn.open();
            thePrinterConn.write(efcReportContainer.getEfcBlob().getData());
        }
        catch (ConnectionException e) {
            logger.error("Keine Verbindung zu dem Drucker m\u00f6glich IP: " + printerName + ", Fehler: " + e.getMessage());
            throw new IllegalStateException("No Printer found");
        }
        finally {
            try {
                thePrinterConn.close();
            }
            catch (ConnectionException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void printToPrinter(EFCReportContainer efcReportContainer, ClSysPrnSrv clSysPrnSrv, PDDocument pdDocument, Integer copies, String printerName, EFCBoolean isPrinterSelection, int traySelected) {
        try {
            void var15_23;
            DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
            HashPrintRequestAttributeSet attrSet = new HashPrintRequestAttributeSet();
            PrintService[] printServices = PrintServiceLookup.lookupPrintServices(flavor, attrSet);
            PrintService printService = null;
            if (printerName != null) {
                for (PrintService printService2 : printServices) {
                    if (printService2.getName().toLowerCase().indexOf(printerName.toLowerCase()) == -1) continue;
                    printService = printService2;
                    break;
                }
            }
            if (printService == null) {
                printService = PrintServiceLookup.lookupDefaultPrintService();
            }
            if (printService == null) {
                throw new IllegalStateException("No Printer found");
            }
            attrSet.add(new Copies(copies));
            Object jobName = "";
            if (clSysPrnSrv.getStext().getData() != null) {
                jobName = clSysPrnSrv.getStext().getData();
            }
            if (efcReportContainer.getParamMap().get("EFC_PARAM2") != null) {
                jobName = (String)jobName + " " + efcReportContainer.getParamMap().get("EFC_PARAM2");
            }
            if (efcReportContainer.getParamMap().get("EFC_PARAM3") != null) {
                jobName = (String)jobName + "-" + efcReportContainer.getParamMap().get("EFC_PARAM3");
            }
            attrSet.add(new JobName((String)jobName, null));
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPrintService(printService);
            if (printerName != null && job.getPrintService().getName().toLowerCase().contains(printerName.toLowerCase()) || printerName == null) {
                Media[] mediaTrays;
                for (Media media : mediaTrays = (Media[])job.getPrintService().getSupportedAttributeValues(Media.class, null, null)) {
                    if (!(media instanceof MediaTray) || media.getValue() != traySelected) continue;
                    MediaTray mediaTray = (MediaTray)media;
                    attrSet.add(mediaTray);
                    logger.debug("MediaTray available: {}", (Object)(media.toString() + " : " + media.getValue()));
                }
            }
            job.setPageable((Pageable)new PDFPageable(pdDocument));
            Media[] medias = (Media[])job.getPrintService().getSupportedAttributeValues(Media.class, null, null);
            Object var15_22 = null;
            for (Media media : medias) {
                if (efcReportContainer != null && efcReportContainer.getClSysPrnSrv() != null && efcReportContainer.getClSysPrnSrv().getPrnprintformat() != null && efcReportContainer.getClSysPrnSrv().getPrnprintformat().getData() != null && efcReportContainer.getClSysPrnSrv().getPrnprintformat().getData().equalsIgnoreCase(media.toString()) && var15_23 == null) {
                    Media media2 = media;
                }
                logger.debug("Media available: {}", (Object)media.toString());
            }
            if (var15_23 != null) {
                attrSet.add((Attribute)var15_23);
            }
            if (isPrinterSelection.getBoolean().booleanValue()) {
                if (job.printDialog(attrSet)) {
                    job.print(attrSet);
                }
            } else {
                job.print(attrSet);
            }
        }
        catch (PrinterException pe) {
            pe.printStackTrace();
        }
        finally {
            if (pdDocument != null) {
                // empty if block
            }
        }
    }
}

