/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.factory;

import de.effectivecompany.base.datatypes.EFCBlob;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.gui.data.SearchResult;
import de.effectivecompany.base.gui.key.Key;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.data.EFCReportContainer;
import de.effectivecompany.data.EFCReportSelectionListEntry;
import de.effectivecompany.gui.components.fx.components.EFCTableColumn;
import de.effectivecompany.gui.components.fx.components.EFCTableView;
import de.effectivecompany.gui.components.model.table.BOTableModel;
import de.effectivecompany.gui.components.model.table.EFCColumnModel;
import de.effectivecompany.gui.components.model.table.ListTableModel;
import de.effectivecompany.gui.components.model.table.StatisticDataTableModel;
import de.effectivecompany.report.EFCReportService;
import de.effectivecompany.report.jasper.ReportInfoVerifier;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCReportSingleton {
    private static Logger logger = LoggerFactory.getLogger(EFCReportSingleton.class);
    private static EFCReportSingleton instance = new EFCReportSingleton();
    private EFCReportService efcReportService = (EFCReportService)SpringHelper.getBean((String)"svReports");

    private EFCReportSingleton() {
    }

    public static EFCReportSingleton getInstance() {
        return instance;
    }

    public EFCReportContainer buildReport(EFCTableView<SearchResult> table) {
        SimpleBooleanProperty isFirstColumn = new SimpleBooleanProperty(true);
        LinkedHashMap columns = new LinkedHashMap();
        EFCList formats = new EFCList();
        EFCList dataBlock = new EFCList();
        if (!table.getSelectionModel().getSelectedCells().isEmpty()) {
            table.getSelectionModel().getSelectedCells().forEach(arg_0 -> EFCReportSingleton.lambda$buildReport$0(columns, (List)formats, arg_0));
            for (Integer tablePosition : table.getSelectionModel().getSelectedIndices()) {
                EFCMap value = new EFCMap();
                for (TableColumn column : table.getVisibleLeafColumns()) {
                    if (column.getId() == null) continue;
                    try {
                        Object val = column.getCellData(tablePosition.intValue());
                        if (val == null) continue;
                        value.put(column.getId().toUpperCase(), val);
                    }
                    catch (Throwable th) {
                        logger.error("", th);
                    }
                }
                if (value.isEmpty()) continue;
                dataBlock.add(value);
            }
        } else {
            table.getVisibleLeafColumns().forEach(arg_0 -> EFCReportSingleton.lambda$buildReport$1(columns, (List)formats, arg_0));
            isFirstColumn.set(true);
            table.getItems().forEach(arg_0 -> EFCReportSingleton.lambda$buildReport$2((List)dataBlock, arg_0));
        }
        return new EFCReportContainer(this.efcReportService.createTableReportPDF("Daten-Export", columns, (List)formats, (List)dataBlock, (List)new EFCList()));
    }

    public EFCReportContainer buildReport(JTable table) {
        LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>();
        EFCList formats = new EFCList();
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            TableColumnExt colExt;
            if (table.getModel() instanceof BOTableModel && table.getColumnModel() instanceof EFCColumnModel && ((TableColumnExt)((EFCColumnModel)((Object)table.getColumnModel())).getActColumns().get(i)).isVisible()) {
                colExt = ((EFCColumnModel)((Object)table.getColumnModel())).getActColumns().get(i);
                columns.put(colExt.getIdentifier().toString(), colExt.getHeaderValue().toString());
                formats.add(table.getModel().getColumnClass(i));
                continue;
            }
            if (!(table.getModel() instanceof DefaultTableModel) && !(table.getModel() instanceof StatisticDataTableModel) && !(table.getModel() instanceof ListTableModel) || !((DefaultTableColumnModelExt)table.getColumnModel()).getColumnExt(i).isVisible()) continue;
            colExt = ((DefaultTableColumnModelExt)table.getColumnModel()).getColumnExt(i);
            columns.put(colExt.getIdentifier().toString(), colExt.getHeaderValue().toString());
            formats.add(table.getModel().getColumnClass(i));
        }
        EFCList dataBlock = new EFCList();
        for (int i = 0; i < table.getModel().getRowCount(); ++i) {
            EFCMap data = new EFCMap();
            for (int j = 0; j < table.getColumnModel().getColumnCount(); ++j) {
                TableColumnExt colExt;
                if (table.getModel() instanceof BOTableModel && table.getColumnModel() instanceof EFCColumnModel && ((TableColumnExt)((EFCColumnModel)((Object)table.getColumnModel())).getActColumns().get(j)).isVisible()) {
                    colExt = ((EFCColumnModel)((Object)table.getColumnModel())).getActColumns().get(j);
                    data.put(colExt.getIdentifier().toString(), table.getModel().getValueAt(i, colExt.getModelIndex()).toString());
                    continue;
                }
                if (!(table.getModel() instanceof DefaultTableModel) && !(table.getModel() instanceof StatisticDataTableModel) && !(table.getModel() instanceof ListTableModel) || !((DefaultTableColumnModelExt)table.getColumnModel()).getColumnExt(j).isVisible()) continue;
                colExt = ((DefaultTableColumnModelExt)table.getColumnModel()).getColumnExt(j);
                try {
                    Number[] numberArrayValue;
                    Number numberValue;
                    Object dataValue = table.getModel().getValueAt(i, colExt.getModelIndex());
                    String val = dataValue instanceof Number[] ? ((numberValue = (numberArrayValue = (Number[])dataValue)[0]) != null ? numberValue.toString() : "") : table.getModel().getValueAt(i, colExt.getModelIndex()).toString();
                    data.put(colExt.getIdentifier().toString(), val);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            dataBlock.add(data);
        }
        EFCList rowNames = new EFCList();
        if (table.getModel() instanceof StatisticDataTableModel) {
            for (int i = 0; i < ((StatisticDataTableModel)table.getModel()).getRowCount(); ++i) {
                rowNames.add((Object)((StatisticDataTableModel)table.getModel()).getRowName(i));
            }
        }
        return new EFCReportContainer(this.efcReportService.createTableReportPDF("Daten-Export", columns, (List)formats, (List)dataBlock, (List)rowNames));
    }

    public EFCReportContainer buildReport(EFCReportSelectionListEntry listEntry, ReportInfoVerifier verifier) {
        return this.buildReport(listEntry, verifier, null);
    }

    public EFCReportContainer buildReport(EFCReportSelectionListEntry listEntry, ReportInfoVerifier verifier, Key key) {
        Map paramMap = this.efcReportService.getReportParamMap(listEntry.getClSysPrnSrv());
        verifier.validateReportInfo(paramMap, key);
        verifier.validateReportInfo(listEntry, key);
        EFCBlob efcBlob = null;
        if (listEntry.getClSysPrnSrv() != null && listEntry.getClSysPrnSrv().getPrntype() != null && listEntry.getClSysPrnSrv().getPrntype().equals(30)) {
            logger.debug("building ZPL report...");
            efcBlob = this.efcReportService.createReportZPL(listEntry.getCompany(), listEntry.getPrnrptId(), paramMap);
        } else {
            logger.debug("building PDF report...");
            efcBlob = this.efcReportService.createReportPDF(listEntry.getCompany(), listEntry.getPrnrptId(), paramMap);
        }
        EFCReportContainer efcReportContainer = new EFCReportContainer(listEntry.getReportName(), listEntry.getClSysPrnSrv(), efcBlob.getData(), paramMap);
        verifier.validateReportInfo(efcReportContainer, key);
        logger.debug("building done");
        return efcReportContainer;
    }

    private static /* synthetic */ void lambda$buildReport$2(List dataBlock, SearchResult item) {
        dataBlock.add(item.getData());
    }

    private static /* synthetic */ void lambda$buildReport$1(Map columns, List formats, TableColumn col) {
        EFCTableColumn tableColumn;
        if (col instanceof EFCTableColumn && (tableColumn = (EFCTableColumn)col).getId() != null && !columns.containsKey(tableColumn.getId())) {
            columns.put(tableColumn.getId().toUpperCase(), tableColumn.getText());
            formats.add(tableColumn.getColumnClass());
        }
    }

    private static /* synthetic */ void lambda$buildReport$0(Map columns, List formats, TablePosition tablePosition) {
        TableColumn tableColumn = tablePosition.getTableColumn();
        if (tableColumn.getId() != null && !columns.containsKey(tableColumn.getId())) {
            columns.put(tableColumn.getId().toUpperCase(), tableColumn.getText());
            if (tableColumn instanceof EFCTableColumn) {
                formats.add(((EFCTableColumn)tableColumn).getColumnClass());
            }
        }
    }
}

