/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.factory;

import de.effectivecompany.base.datatypes.EFCBlob;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.editor.EFCImageEditor;
import de.effectivecompany.gui.components.frame.EFCExcelViewer;
import de.effectivecompany.gui.components.frame.EFCPDFViewer;
import de.effectivecompany.gui.components.frame.EFCSimpleTextViewer;
import de.effectivecompany.gui.components.frame.EFCSimpleTextViewerPane;
import de.effectivecompany.gui.components.fx.EFCExcelViewerPane;
import de.effectivecompany.gui.components.fx.EFCPDFBoxViewer;
import de.effectivecompany.gui.components.image.EFCImageViewer;
import de.effectivecompany.gui.components.panel.EFCTabEntity;
import de.effectivecompany.gui.components.panel.EFCTabPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.factory.ViewerType;
import de.effectivecompany.gui.interfaces.element.PictureContainer;
import de.effectivecompany.gui.manager.EFCFileManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCViewerFactory {
    private static Logger logger = LoggerFactory.getLogger(EFCViewerFactory.class);

    private EFCViewerFactory() {
    }

    public static void createViewer(Object viewableObject) {
        if (viewableObject instanceof BufferedImage) {
            new EFCImageViewer((BufferedImage)viewableObject);
        }
    }

    public static void createViewer(EFCBlob blob) {
        EFCViewerFactory.createViewer(null, null, blob);
    }

    public static void createViewer(String name, EFCBlob blob) {
        EFCViewerFactory.createViewer(null, name, blob);
    }

    public static void createViewer(EFCController parent, String name, EFCBlob blob) {
        try {
            switch (EFCViewerFactory.checkType(name, blob)) {
                case PDF: {
                    EFCDesktop.getInstance().add(new EFCPDFViewer(blob));
                    break;
                }
                case IMAGE: {
                    new EFCImageViewer(blob);
                    break;
                }
                case EXCEL: {
                    EFCDesktop.getInstance().add(new EFCExcelViewer(name, blob));
                    break;
                }
                case TEXT: {
                    EFCDesktop.getInstance().add(new EFCSimpleTextViewer(blob.getData()));
                    break;
                }
                case NO_DATA: {
                    EFCDesktop.getInstance();
                    EFCDesktop.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_BLOBDATA_FOUND_FOR_VIEWER"));
                    break;
                }
                case EML: {
                    EFCMap dlgParam = new EFCMap();
                    parent.onCreateMailViewer((EFCMap<EFCString, EFCString>)dlgParam, blob);
                    break;
                }
                case OPEN_BY_OS: {
                    EFCViewerFactory.openExternal(name, blob);
                    break;
                }
                default: {
                    EFCViewerFactory.handleNotSupported(name, blob);
                    break;
                }
            }
        }
        catch (Exception e) {
            EFCViewerFactory.handleNotSupported(name, blob);
        }
    }

    private static void handleNotSupported(String name, EFCBlob blob) {
        EFCDesktop.getInstance();
        int result = EFCDesktop.showOptionDlg(Translator.tr((String)"MSG_FRAME_NO_VIEWER_FOUND"), "", new String[]{Translator.tr((String)"_ACTION_OPEN_EXTERNAL"), Translator.tr((String)"ACTION_SAVE"), Translator.tr((String)"_CANCEL")}, 0);
        switch (result) {
            case 0: {
                EFCViewerFactory.openExternal(name, blob);
                break;
            }
            case 1: {
                EFCViewerFactory.saveFile(blob.getData());
                break;
            }
        }
    }

    public static void checkForLoading(EFCTabPanel tab, EFCTabEntity comp, PictureContainer data) {
        EFCThreadUtil.edtBuilder(th -> {
            EFCImageEditor imageViewer = new EFCImageEditor("imagepreview", false, false, null, true);
            imageViewer.setData(data);
            comp.setComponent(imageViewer);
            tab.setTabPaneComponent(comp);
        });
    }

    public static JPanel createPanel(String name, EFCBlob blob) {
        return EFCViewerFactory.createPanel(name, blob, true);
    }

    public static JPanel createPanel(String name, EFCBlob blob, boolean withErrorMessage) {
        JPanel panel = null;
        switch (EFCViewerFactory.checkType(name, blob)) {
            case PDF: {
                EFCPDFBoxViewer pdfviewer = new EFCPDFBoxViewer("pdfpreview");
                pdfviewer.load(blob);
                panel = pdfviewer;
                break;
            }
            case IMAGE: {
                EFCImageEditor imageViewer = new EFCImageEditor("imagepreview", false, false, null, true);
                imageViewer.setValue(blob);
                panel = imageViewer;
                break;
            }
            case EXCEL: {
                panel = new EFCExcelViewerPane(name, blob);
                break;
            }
            case TEXT: {
                panel = new EFCSimpleTextViewerPane(blob.getData());
                break;
            }
            case NO_DATA: {
                panel = new JPanel();
                if (!withErrorMessage) break;
                EFCDesktop.getInstance();
                EFCDesktop.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_BLOBDATA_FOUND_FOR_VIEWER"));
                break;
            }
            default: {
                panel = new JPanel();
                if (!withErrorMessage) break;
                EFCDesktop.getInstance();
                EFCDesktop.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_VIEWER_FOUND"));
            }
        }
        return panel;
    }

    private static ViewerType checkType(String name, EFCBlob blob) {
        if (blob == null || blob.getData() == null) {
            return ViewerType.NO_DATA;
        }
        byte[] blobData = blob.getData();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 1000 && i < blobData.length; ++i) {
            sb.append((char)blobData[i]);
        }
        if (sb.substring(1, 4).contains("PDF")) {
            return ViewerType.PDF;
        }
        if (sb.substring(0, 2).contains("BM")) {
            return ViewerType.IMAGE;
        }
        if (sb.substring(1, 4).contains("PNG")) {
            return ViewerType.IMAGE;
        }
        if (name != null && name.toUpperCase().contains(".EML")) {
            return ViewerType.EML;
        }
        if (name != null && name.toUpperCase().contains(".DXF")) {
            return ViewerType.OPEN_BY_OS;
        }
        if (name != null && name.toUpperCase().contains(".DWG")) {
            return ViewerType.OPEN_BY_OS;
        }
        if (name != null && name.toUpperCase().contains(".TIF")) {
            return ViewerType.IMAGE;
        }
        if (EFCViewerFactory.byteToInt(blobData[0]) == 255 && EFCViewerFactory.byteToInt(blobData[1]) == 216 && EFCViewerFactory.byteToInt(blobData[2]) == 255) {
            return ViewerType.IMAGE;
        }
        if (sb.toString().contains("http://www.w3.org/2000/svg")) {
            return ViewerType.SVG;
        }
        if ((double)EFCViewerFactory.detectPlainTextPercentage(blobData) >= 0.9) {
            return ViewerType.TEXT;
        }
        if (name != null && (name.toLowerCase().endsWith(".xlsx") || name.toLowerCase().endsWith(".xls"))) {
            return ViewerType.EXCEL;
        }
        return ViewerType.NOT_SUPPORTED;
    }

    public static void openExternal(String name, EFCBlob blob) {
        EFCFileManager.openFile(EFCFileManager.saveTemporaryFile(new EFCString(name), blob.getData()));
    }

    public static void saveFile(byte[] blobData) {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(null);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            try {
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(blobData);
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static int byteToInt(byte b) {
        if (b < 0) {
            return b + 256;
        }
        return b;
    }

    private static float detectPlainTextPercentage(byte[] source) {
        int plainTextCounter = 0;
        for (int i = 0; i < source.length; ++i) {
            int ascii = EFCViewerFactory.byteToInt(source[i]);
            if (ascii < 10 || ascii >= 160) continue;
            ++plainTextCounter;
        }
        return (float)plainTextCounter / (float)source.length;
    }
}

