/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.handlers;

import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.frame.EFCInternalFrameView;
import de.effectivecompany.gui.components.model.table.BOTableModel;
import de.effectivecompany.gui.components.model.table.EFCBoModel;
import de.effectivecompany.gui.components.model.table.ListTableModel;
import de.effectivecompany.gui.components.panel.EFCBOTablePanel;
import de.effectivecompany.gui.components.panel.EFCBusinessDataTablePanel;
import de.effectivecompany.gui.components.panel.EFCExplorerPanel;
import de.effectivecompany.gui.components.panel.EFCGraphPanel;
import de.effectivecompany.gui.components.panel.EFCListTablePanel;
import de.effectivecompany.gui.events.BusinessTableInteractionEvent;
import de.effectivecompany.gui.events.DragEvent;
import de.effectivecompany.gui.events.FocusChangeEvent;
import de.effectivecompany.gui.events.ListTableDataLoadedEvent;
import de.effectivecompany.gui.events.SelectionContextChangeEvent;
import de.effectivecompany.gui.events.UserInputEvent;
import de.effectivecompany.gui.events.UserInteractionEvent;
import de.effectivecompany.gui.events.ValueChangeEvent;
import de.effectivecompany.gui.interfaces.ListTableDataListener;
import de.effectivecompany.gui.interfaces.frame.BOFrame;
import de.effectivecompany.gui.interfaces.listeners.BusinessTableInteractionListener;
import de.effectivecompany.gui.interfaces.listeners.DragEventListener;
import de.effectivecompany.gui.interfaces.listeners.FocusChangeListener;
import de.effectivecompany.gui.interfaces.listeners.SelectionContextChangeListener;
import de.effectivecompany.gui.interfaces.listeners.UserInputListener;
import de.effectivecompany.gui.interfaces.listeners.UserInteractionListener;
import de.effectivecompany.gui.interfaces.listeners.ValueChangeListener;
import java.awt.event.KeyEvent;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;

public class GenericEventHandler
implements UserInputListener,
UserInteractionListener,
FocusChangeListener,
ValueChangeListener,
SelectionContextChangeListener,
BusinessTableInteractionListener,
ListTableDataListener,
DragEventListener {
    private WeakReference<BOFrame> frame;
    private boolean tableSelectionHandled = true;
    private boolean listTableSelectionHandled = true;
    private boolean statTableSelectionHandled = true;
    private boolean businessTableSelectionHandled = true;

    public GenericEventHandler(BOFrame frame) {
        this.frame = new WeakReference<BOFrame>(frame);
    }

    public void setTableSelectionHandled(boolean tableSelectionHandled) {
        this.tableSelectionHandled = tableSelectionHandled;
    }

    public boolean isTableSelectionHandled() {
        return this.tableSelectionHandled;
    }

    public void setListTableSelectionHandled(boolean listTableSelectionHandled) {
        this.listTableSelectionHandled = listTableSelectionHandled;
    }

    public boolean isListTableSelectionHandled() {
        return this.listTableSelectionHandled;
    }

    @Override
    public void onUserInput(UserInputEvent event) {
        EFCController controller;
        BOFrame boFrame;
        KeyEvent keyEvent;
        if (event.getID() == 2061 && ((keyEvent = (KeyEvent)event.getParentEvent()).getKeyCode() == 10 || keyEvent.getModifiersEx() == 512) && (boFrame = (BOFrame)this.frame.get()) != null) {
            boFrame.handleKey(keyEvent.getKeyCode(), event.getIdent(), keyEvent.getModifiersEx());
        }
        if (event.isMouseEvent() && (controller = (EFCController)this.frame.get()) != null) {
            EFCInternalFrameView view = controller.getView();
            view.fireChangeEvent("lastfield", "", event.getIdent());
        }
    }

    @Override
    public void onUserInteraction(UserInteractionEvent event) {
        BOFrame boFrame = (BOFrame)this.frame.get();
        if (boFrame != null) {
            switch (event.getID()) {
                case 2039: {
                    boFrame.handleElementPopupOpen(event.getIdent());
                    break;
                }
                case 2040: {
                    boFrame.handleElementPopupClose(event.getIdent());
                    break;
                }
                case 2041: {
                    boFrame.handleGraphActualizeAction(event.getIdent());
                    break;
                }
                case 2042: {
                    boFrame.handleDiagramOpenPopupAction();
                    break;
                }
                case 2043: {
                    boFrame.handleDiagramClosePopupAction();
                    break;
                }
                case 2044: {
                    boFrame.handleFrameScrollSearchAction(event.getIdent(), event.getValue());
                }
            }
        }
    }

    @Override
    public void onBusinessTableInteraction(BusinessTableInteractionEvent event) {
        BOFrame boFrame = (BOFrame)this.frame.get();
        if (boFrame != null) {
            switch (event.getID()) {
                case 2045: {
                    boFrame.handleBusinessTableDragAndDrop(event.getTargetRow(), event.getStartColumn(), event.getCopyList());
                }
            }
        }
    }

    @Override
    public void onFocusChanged(FocusChangeEvent event) {
        BOFrame boFrame = (BOFrame)this.frame.get();
        if (boFrame != null) {
            if (event.getID() == 2030) {
                boFrame.handleElementGainedFocus(event.getIdent());
            }
            if (event.getID() == 2029) {
                boFrame.handleElementLostFocus(event.getIdent());
            }
        }
    }

    @Override
    public void onValueChanged(ValueChangeEvent event) {
        BOFrame boFrame = (BOFrame)this.frame.get();
        if (boFrame != null && event.getID() == 2019) {
            if (event.getScbchrkey() != null) {
                boFrame.handleElementDataChanged(event.getIdent(), event.getOldValue(), event.getNewValue(), true, event.getScbchrkey());
            } else {
                boFrame.handleElementDataChanged(event.getIdent(), event.getOldValue(), event.getNewValue(), true);
            }
        }
    }

    @Override
    public void onSelectionContextChanged(SelectionContextChangeEvent event) {
        BOFrame boFrame = (BOFrame)this.frame.get();
        JComponent sourceComponent = null;
        if (event.getSource() instanceof JComponent) {
            sourceComponent = (JComponent)event.getSource();
        }
        if (boFrame != null) {
            switch (event.getID()) {
                case 2080: {
                    boFrame.handleTabSelectionChanged(event.getIdent(), event.getOldSelection().toString(), event.getNewSelection().toString());
                    break;
                }
                case 2079: {
                    if (this.tableSelectionHandled && sourceComponent instanceof EFCBOTablePanel) {
                        EFCBOTablePanel tablePanel = (EFCBOTablePanel)sourceComponent;
                        int columnIndex = tablePanel.getSelectedColumn();
                        String column = "";
                        if (columnIndex >= 0) {
                            column = ((BOTableModel)tablePanel.getTableModel()).getColumnId(columnIndex);
                        }
                        BusinessObject selected = tablePanel.getSelectedObject();
                        boFrame.handleTableSelectionChanged(event.getIdent(), column, selected);
                        break;
                    }
                    if (this.listTableSelectionHandled && sourceComponent instanceof EFCListTablePanel) {
                        EFCListTablePanel tablePanel = (EFCListTablePanel)sourceComponent;
                        int columnIndex = tablePanel.getSelectedColumn();
                        String column = null;
                        if (columnIndex != -1) {
                            column = ((ListTableModel)tablePanel.getTableModel()).getColumnId(columnIndex);
                        }
                        BusinessObject selected = tablePanel.getSelectedObject();
                        boFrame.handleListTableSelectionChanged(event.getIdent(), column, selected);
                        break;
                    }
                    if (!this.businessTableSelectionHandled || !(sourceComponent instanceof EFCBusinessDataTablePanel)) break;
                    EFCBusinessDataTablePanel tablePanel = (EFCBusinessDataTablePanel)sourceComponent;
                    int columnIndex = tablePanel.getSelectedColumn();
                    String column = ((EFCBoModel)tablePanel.getTableModel()).getColumnName(columnIndex);
                    BusinessObject selected = (BusinessObject)event.getSelected();
                    boFrame.handleBusinessTableSelectionChanged(event.getIdent(), column, selected);
                    break;
                }
                case 2081: {
                    EFCGraphPanel graphPanel = (EFCGraphPanel)sourceComponent;
                    if (!(event.getNewSelection() instanceof BusinessObject)) break;
                    boFrame.handleGraphSelectionChanged((BusinessObject)event.getNewSelection());
                    break;
                }
                case 2085: {
                    if (!(event.getNewSelection() instanceof BusinessObject)) break;
                    boFrame.handleGraphBpmSelectionAction((BusinessObject)event.getNewSelection());
                    break;
                }
                case 2086: {
                    boFrame.handleGridSelectionChanged(event.getIdent(), (BusinessObject)event.getSelected());
                    break;
                }
                case 2082: {
                    EFCExplorerPanel explorerPanel = (EFCExplorerPanel)sourceComponent;
                    boFrame.handleExplorerSelectionChanged(event.getIdent(), explorerPanel.getSelectedElement());
                    break;
                }
                case 2083: {
                    boFrame.handleGanttSelectionChanged((BusinessObject)event.getNewSelection());
                    break;
                }
                case 2084: {
                    boFrame.handleChartSelectionChanged((BusinessObject)event.getNewSelection());
                }
            }
        }
    }

    public void terminate() {
        this.frame = null;
    }

    public boolean isStatTableSelectionHandled() {
        return this.statTableSelectionHandled;
    }

    public void setStatTableSelectionHandled(boolean statTableSelectionHandled) {
        this.statTableSelectionHandled = statTableSelectionHandled;
    }

    public boolean isBusinessTableSelectionHandled() {
        return this.businessTableSelectionHandled;
    }

    public void setBusinessTableSelectionHandled(boolean businessTableSelectionHandled) {
        this.businessTableSelectionHandled = businessTableSelectionHandled;
    }

    @Override
    public void onListTableDataLoaded(ListTableDataLoadedEvent event) {
        BOFrame boFrame = (BOFrame)this.frame.get();
        if (boFrame != null) {
            switch (event.getID()) {
                case 2089: {
                    boFrame.handleListTableDataLoaded(event.getIdent());
                }
            }
        }
    }

    @Override
    public void onDrag(DragEvent dragEvent) {
        BOFrame boFrame = (BOFrame)this.frame.get();
        if (boFrame != null) {
            switch (dragEvent.getID()) {
                case 2089: {
                    if (!(dragEvent.getDraged() instanceof BusinessObject)) break;
                    boFrame.handleGanttElementDragEnd((BusinessObject)dragEvent.getDraged(), dragEvent.getLabel(), dragEvent.getStart(), dragEvent.getEnd(), dragEvent.getMin(), dragEvent.getMax(), dragEvent.getLiveMovedElements());
                }
            }
        }
    }
}

