/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.manager;

import de.effectivecompany.app.syswfl.BoWflTask;
import de.effectivecompany.base.data.AbstractBusinessDataList;
import de.effectivecompany.base.data.AbstractLazyList;
import de.effectivecompany.base.data.AbstractStatisticListData;
import de.effectivecompany.base.data.BusinessDataObject;
import de.effectivecompany.base.data.StatisticDataObject;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.meta.MetaInfo;
import de.effectivecompany.gui.actions.EFCAbstractAction;
import de.effectivecompany.gui.actions.EFCActionWflTask;
import de.effectivecompany.gui.actions.EFCAdditionalAction;
import de.effectivecompany.gui.actions.EFCAdditionalActionInfo;
import de.effectivecompany.gui.actions.EFCDefaultAction;
import de.effectivecompany.gui.components.EFCActionAccelerator;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.EFCMainMenu;
import de.effectivecompany.gui.components.EFCToolBar;
import de.effectivecompany.gui.components.editor.EFCAbstractEditor;
import de.effectivecompany.gui.components.editor.EFCImageEditor;
import de.effectivecompany.gui.components.model.interfaces.TreeModel;
import de.effectivecompany.gui.components.panel.EFCBOTablePanel;
import de.effectivecompany.gui.components.panel.EFCBpmGraphPanel;
import de.effectivecompany.gui.components.panel.EFCBusinessDataTablePanel;
import de.effectivecompany.gui.components.panel.EFCCalendarPanel;
import de.effectivecompany.gui.components.panel.EFCExplorerPanel;
import de.effectivecompany.gui.components.panel.EFCGraphPanel;
import de.effectivecompany.gui.components.panel.EFCListTablePanel;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.panel.EFCResourceDiagramListPanel;
import de.effectivecompany.gui.components.panel.EFCResourceGanttPanel;
import de.effectivecompany.gui.components.panel.EFCSubPanel;
import de.effectivecompany.gui.components.panel.EFCTabPanel;
import de.effectivecompany.gui.constants.EFCAction;
import de.effectivecompany.gui.constants.EFCActionAcceleratorKey;
import de.effectivecompany.gui.constants.EFCMenu;
import de.effectivecompany.gui.data.chart.EFCDefaultBarChartList;
import de.effectivecompany.gui.data.explorer.ExplorerElement;
import de.effectivecompany.gui.data.gantt.EFCDefaultResourceGantt;
import de.effectivecompany.gui.data.graph.Graph;
import de.effectivecompany.gui.factory.EFCViewerFactory;
import de.effectivecompany.gui.interfaces.element.EditorComponent;
import de.effectivecompany.gui.interfaces.element.PictureContainer;
import de.effectivecompany.gui.interfaces.element.PrimaryEditorComponent;
import de.effectivecompany.gui.interfaces.handler.ActionHandler;
import de.effectivecompany.gui.interfaces.manager.EFCViewManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.interfaces.panel.BusinessPanel;
import de.effectivecompany.gui.interfaces.panel.StatisticPanel;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCBaseViewManager
implements EFCViewManager,
ElementManager {
    private static Logger logger = LoggerFactory.getLogger(EFCBaseViewManager.class);
    private EFCMainMenu mainMenu;
    private ActionHandler menuActionHandler;
    private String activeField;
    private String activeIdent;
    private String lastActiveIdent;
    private String lastActiveField;
    private String activeTableSelectionFocusIdent;
    private Map<String, CopyOnWriteArrayList<WeakReference<JComponent>>> scrollfields = new ConcurrentSkipListMap<String, CopyOnWriteArrayList<WeakReference<JComponent>>>();
    private Map<String, CopyOnWriteArrayList<WeakReference<JComponent>>> fields = new ConcurrentHashMap<String, CopyOnWriteArrayList<WeakReference<JComponent>>>();
    private Map<String, CopyOnWriteArrayList<WeakReference<JComponent>>> keyfields = new ConcurrentHashMap<String, CopyOnWriteArrayList<WeakReference<JComponent>>>();
    private Map<String, CopyOnWriteArrayList<WeakReference<JComponent>>> subkeyfields = new ConcurrentHashMap<String, CopyOnWriteArrayList<WeakReference<JComponent>>>();
    private Map<String, CopyOnWriteArrayList<WeakReference<JPanel>>> panels = new ConcurrentHashMap<String, CopyOnWriteArrayList<WeakReference<JPanel>>>();
    private Map<String, CopyOnWriteArrayList<WeakReference<JComponent>>> groups = new ConcurrentHashMap<String, CopyOnWriteArrayList<WeakReference<JComponent>>>();
    private Map<String, String> firstFocusFields = new HashMap<String, String>();
    private CopyOnWriteArrayList<EFCImageEditor> imageEditors = new CopyOnWriteArrayList();
    private JTextField firstFocusableField;
    private JTextField focusableField;
    private Component lastFocusOwner;

    public EFCBaseViewManager(EFCMainMenu mainMenu, ActionHandler actionHandler) {
        this.mainMenu = mainMenu;
        if (mainMenu == null) {
            this.mainMenu = new EFCMainMenu();
        }
        this.menuActionHandler = actionHandler;
    }

    public EFCBaseViewManager() {
    }

    public EFCMainMenu getMainMenu() {
        return this.mainMenu;
    }

    public EFCToolBar getToolBar() {
        return this.mainMenu.getToolBar();
    }

    public ActionHandler getActionHandler() {
        return this.menuActionHandler;
    }

    public void setActiveIdent(String ident) {
        this.activeIdent = ident;
        if (ident != null) {
            this.lastActiveIdent = ident;
        }
    }

    public String getActiveIdent() {
        return this.getActiveIdent(true);
    }

    public String getLastActiveIdent() {
        return this.lastActiveIdent;
    }

    public void setLastActiveIdent(String ident) {
        this.lastActiveIdent = ident;
    }

    public String getLastActiveField() {
        return this.lastActiveField;
    }

    public void setLastActiveField(String ident) {
        this.lastActiveField = ident;
    }

    public String getActiveIdent(boolean withoutFocus) {
        return withoutFocus ? this.lastActiveIdent : this.activeIdent;
    }

    protected void addItemToMenu(JMenu menu, String title, String action) {
        if (!menu.isVisible()) {
            menu.setVisible(true);
        }
        EFCDefaultAction defaultAction = new EFCDefaultAction(title, action);
        defaultAction.setActionHandler(this.menuActionHandler);
        menu.add(defaultAction);
    }

    protected void addItemToMenu(String menuName, JMenu menu, ArrayList<String> title, ArrayList<String> action) {
        if (!menu.isVisible()) {
            menu.setVisible(true);
        }
        if (title.size() != action.size()) {
            throw new IllegalArgumentException("size of arrays must be identical");
        }
        JMenu subMenu = new JMenu(menuName);
        for (int i = 0; i < title.size(); ++i) {
            EFCDefaultAction defaultAction = new EFCDefaultAction(title.get(i), action.get(i));
            defaultAction.setActionHandler(this.menuActionHandler);
            subMenu.add(defaultAction);
        }
        menu.add(subMenu);
    }

    protected void addItemToMenu(JMenu menu, EFCAbstractAction action) {
        if (!menu.isVisible()) {
            menu.setVisible(true);
        }
        action.setActionHandler(this.menuActionHandler);
        JMenuItem menuitem = new JMenuItem(action);
        menu.add(menuitem);
    }

    protected void addItemToMenu(String menuName, JMenu menu, ArrayList<EFCAdditionalAction> actions) {
        if (!menu.isVisible()) {
            menu.setVisible(true);
        }
        JMenu subMenu = new JMenu(menuName);
        for (int i = 0; i < actions.size(); ++i) {
            EFCAbstractAction a = actions.get(i);
            a.setActionHandler(this.menuActionHandler);
            JMenuItem menuitem = new JMenuItem(a);
            menuitem.setIcon(null);
            subMenu.add(menuitem);
        }
        menu.add(subMenu);
    }

    public void addToMenuListing(String title, String action) {
        JMenu menu = this.getMenuListing();
        this.addItemToMenu(menu, title, action);
    }

    public void addToMenuListing(EFCAdditionalActionInfo action) {
        JMenu menu = this.getMenuListing();
        this.addItemToMenu(menu, new EFCAdditionalAction(action));
    }

    public void addToMenuListing(EFCAdditionalAction action) {
        JMenu menu = this.getMenuListing();
        this.addItemToMenu(menu, action);
    }

    public void addToMenuListing(String menuName, ArrayList<String> title, ArrayList<String> action) {
        JMenu menu = this.getMenuListing();
        this.addItemToMenu(menuName, menu, title, action);
    }

    public void addToMenuListing(String menuName, ArrayList<EFCAdditionalAction> actions) {
        JMenu menu = this.getMenuListing();
        this.addItemToMenu(menuName, menu, actions);
    }

    public void addToMenuStatus(String title, String action) {
        JMenu menu = this.getMenuStatus();
        this.addItemToMenu(menu, title, action);
    }

    public void addToMenuStatus(EFCAdditionalActionInfo action) {
        JMenu menu = this.getMenuStatus();
        this.addItemToMenu(menu, new EFCAdditionalAction(action));
    }

    public void addToMenuStatus(EFCAdditionalAction action) {
        JMenu menu = this.getMenuStatus();
        this.addItemToMenu(menu, action);
    }

    public void addToMenuStatus(String menuName, ArrayList<String> title, ArrayList<String> action) {
        JMenu menu = this.getMenuStatus();
        this.addItemToMenu(menuName, menu, title, action);
    }

    public void addToMenuStatus(String menuName, ArrayList<EFCAdditionalAction> actions) {
        JMenu menu = this.getMenuStatus();
        this.addItemToMenu(menuName, menu, actions);
    }

    public void addToMenuInventory(String title, String action) {
        JMenu menu = this.getMenuInventory();
        this.addItemToMenu(menu, title, action);
    }

    public void addToMenuInventory(EFCAdditionalActionInfo action) {
        JMenu menu = this.getMenuInventory();
        this.addItemToMenu(menu, new EFCAdditionalAction(action));
    }

    public void addToMenuInventory(EFCAdditionalAction action) {
        JMenu menu = this.getMenuInventory();
        this.addItemToMenu(menu, action);
    }

    public void addToMenuInventory(String menuName, ArrayList<String> title, ArrayList<String> action) {
        JMenu menu = this.getMenuInventory();
        this.addItemToMenu(menuName, menu, title, action);
    }

    public void addToMenuInventory(String menuName, ArrayList<EFCAdditionalAction> actions) {
        JMenu menu = this.getMenuInventory();
        this.addItemToMenu(menuName, menu, actions);
    }

    public void addToMenuInfo(EFCAdditionalActionInfo action) {
        JMenu menu = this.getMenuInfo();
        this.addItemToMenu(menu, new EFCAdditionalAction(action));
    }

    public void addToMenuInfo(EFCAdditionalAction action) {
        JMenu menu = this.getMenuInfo();
        this.addItemToMenu(menu, action);
    }

    public void addToMenuInfo(EFCAbstractAction action) {
        JMenu menu = this.getMenuInfo();
        this.addItemToMenu(menu, action);
    }

    public void addToMenuGoto(EFCAdditionalAction action) {
        JMenu menu = this.getMenuGoto();
        this.addItemToMenu(menu, action);
    }

    public void addToMenuGoto(EFCAbstractAction action) {
        JMenu menu = this.getMenuGoto();
        this.addItemToMenu(menu, action);
    }

    public void addToMenuInfo(String title, String action) {
        JMenu menu = this.getMenuInfo();
        this.addItemToMenu(menu, title, action);
    }

    public void addToMenuInfo(String menuName, ArrayList<String> title, ArrayList<String> action) {
        JMenu menu = this.getMenuInfo();
        this.addItemToMenu(menuName, menu, title, action);
    }

    public void addToMenuInfo(String menuName, ArrayList<EFCAdditionalAction> actions) {
        JMenu menu = this.getMenuInfo();
        this.addItemToMenu(menuName, menu, actions);
    }

    public void addToMenuAnalysis(String title, String action) {
        JMenu menu = this.getMenuAnalysis();
        this.addItemToMenu(menu, title, action);
    }

    public void addToMenuAnalysis(EFCAdditionalActionInfo action) {
        JMenu menu = this.getMenuAnalysis();
        this.addItemToMenu(menu, new EFCAdditionalAction(action));
    }

    public void addToMenuAnalysis(EFCAdditionalAction action) {
        JMenu menu = this.getMenuAnalysis();
        this.addItemToMenu(menu, action);
    }

    public void addToMenuAnalysis(String menuName, ArrayList<String> title, ArrayList<String> action) {
        JMenu menu = this.getMenuAnalysis();
        this.addItemToMenu(menuName, menu, title, action);
    }

    public void addToMenuAnalysis(String menuName, ArrayList<EFCAdditionalAction> actions) {
        JMenu menu = this.getMenuAnalysis();
        this.addItemToMenu(menuName, menu, actions);
    }

    public void addToMenuCustomize(String title, String action) {
        JMenu menu = this.getMenuCustomize();
        this.addItemToMenu(menu, title, action);
    }

    public void addToMenuCustomize(EFCAdditionalActionInfo action) {
        JMenu menu = this.getMenuCustomize();
        this.addItemToMenu(menu, new EFCAdditionalAction(action));
    }

    public void addToMenuCustomize(EFCAdditionalAction action) {
        JMenu menu = this.getMenuCustomize();
        this.addItemToMenu(menu, action);
    }

    public void addToMenuCustomize(String menuName, ArrayList<String> title, ArrayList<String> action) {
        JMenu menu = this.getMenuCustomize();
        this.addItemToMenu(menuName, menu, title, action);
    }

    public void addToMenuCustomize(String menuName, ArrayList<EFCAdditionalAction> actions) {
        JMenu menu = this.getMenuCustomize();
        this.addItemToMenu(menuName, menu, actions);
    }

    public void addToMenuFunctions(String title, String action) {
        JMenu menu = this.getMenuFunctions();
        this.addItemToMenu(menu, title, action);
    }

    public void addToMenuFunctions(EFCAdditionalActionInfo action) {
        JMenu menu = this.getMenuFunctions();
        this.addItemToMenu(menu, new EFCAdditionalAction(action));
    }

    public void addToMenuFunctions(EFCAdditionalAction action) {
        JMenu menu = this.getMenuFunctions();
        this.addItemToMenu(menu, action);
    }

    public void addToMenuFunctions(String menuName, ArrayList<String> title, ArrayList<String> action) {
        JMenu menu = this.getMenuFunctions();
        this.addItemToMenu(menuName, menu, title, action);
    }

    public void addToMenuFunctions(String menuName, ArrayList<EFCAdditionalAction> actions) {
        JMenu menu = this.getMenuFunctions();
        this.addItemToMenu(menuName, menu, actions);
    }

    public void setMenuActionsDisabled(EFCAction ... menuConstants) {
        EFCThreadUtil.doLater(() -> this.getMainMenu().disableActions(menuConstants));
    }

    public void setMenuActionsDisabled(EnumSet<EFCAction> ... menuConstants) {
        ArrayList all = new ArrayList();
        for (EnumSet<EFCAction> set : menuConstants) {
            set.stream().forEach(item -> all.add(item));
        }
        EFCThreadUtil.doLater(() -> this.getMainMenu().disableActions(all.toArray(new EFCAction[all.size()])));
    }

    public void setMenuActionsEnabled(EFCAction ... menuConstants) {
        EFCThreadUtil.doLater(() -> this.getMainMenu().enableActions(menuConstants));
    }

    public void setMenuActionsEnabled(EnumSet<EFCAction> ... menuConstants) {
        EFCThreadUtil.doLater(() -> {
            ArrayList all = new ArrayList();
            for (EnumSet set : menuConstants) {
                set.stream().forEach(item -> all.add(item));
            }
            this.getMainMenu().enableActions(all.toArray(new EFCAction[all.size()]));
        });
    }

    public JMenu getMenuFunctions() {
        return this.getMainMenu().getMenu(EFCMenu.M_FUNCTIONS);
    }

    public JMenu getMenuListing() {
        return this.getMainMenu().getMenu(EFCMenu.M_LISTING);
    }

    public JMenu getMenuAnalysis() {
        return this.getMainMenu().getMenu(EFCMenu.M_ANALYSIS);
    }

    public JMenu getMenuCustomize() {
        return this.getMainMenu().getMenu(EFCMenu.M_CUSTOMIZE);
    }

    public JMenu getMenuInfo() {
        return this.getMainMenu().getMenu(EFCMenu.M_INFO);
    }

    public JMenu getMenuGoto() {
        return this.getMainMenu().getMenu(EFCMenu.M_GOTO);
    }

    public JMenu getMenuStatus() {
        return this.getMainMenu().getMenu(EFCMenu.M_STATUS);
    }

    public JMenu getMenuInventory() {
        return this.getMainMenu().getMenu(EFCMenu.M_INVENTORY);
    }

    public void setMenuFunctionsVisible(Boolean visible) {
        EFCThreadUtil.doLater(() -> {
            JMenu menu = this.getMenuFunctions();
            if (menu != null) {
                menu.setVisible(visible);
            }
        });
    }

    public void setMenuListingVisible(Boolean visible) {
        EFCThreadUtil.doLater(() -> {
            JMenu menu = this.getMenuListing();
            if (menu != null) {
                menu.setVisible(visible);
            }
        });
    }

    public void setMenuInventoryVisible(Boolean visible) {
        JMenu menu = this.getMenuInventory();
        if (menu != null) {
            menu.setVisible(visible);
        }
    }

    public void setMenuAnalysisVisible(Boolean visible) {
        EFCThreadUtil.doLater(() -> {
            JMenu menu = this.getMenuAnalysis();
            if (menu != null) {
                menu.setVisible(visible);
            }
        });
    }

    public void setMenuCustomizeVisible(Boolean visible) {
        EFCThreadUtil.doLater(() -> {
            JMenu menu = this.getMenuCustomize();
            if (menu != null) {
                menu.setVisible(visible);
            }
        });
    }

    public void setMenuInfoVisible(Boolean visible) {
        EFCThreadUtil.doLater(() -> {
            JMenu menu = this.getMenuInfo();
            if (menu != null) {
                menu.setVisible(visible);
            }
        });
    }

    public void setMenuGotoVisible(Boolean visible) {
        EFCThreadUtil.doLater(() -> {
            JMenu menu = this.getMenuGoto();
            if (menu != null) {
                menu.setVisible(visible);
            }
        });
    }

    public void setMenuWflVisible(Boolean visible) {
        EFCThreadUtil.doLater(() -> {
            JMenu menu = this.getMenuWfl();
            if (menu != null) {
                menu.setVisible(visible);
            }
        });
    }

    public JMenu getMenuWfl() {
        return this.getMainMenu().getMenu(EFCMenu.M_WFL);
    }

    public void addMenuWflItem(BoWflTask task, EFCController controller) {
        EFCActionWflTask taskAction = new EFCActionWflTask(task, controller);
        taskAction.setActionHandler(this.menuActionHandler);
        this.getMenuWfl().setVisible(true);
        this.getMenuWfl().add(new JMenuItem(taskAction));
    }

    public void addMenuWflItemTask(BoWflTask task, EFCController controller) {
        EFCActionWflTask taskAction = new EFCActionWflTask(task, controller);
        taskAction.setActionHandler(this.menuActionHandler);
        this.getMenuWfl().setVisible(true);
        this.getMenuWfl().add(new JMenuItem(taskAction));
    }

    public void setMenuStatusVisible(Boolean visible) {
        EFCThreadUtil.doLater(() -> {
            JMenu menu = this.getMenuStatus();
            if (menu != null) {
                menu.setVisible(visible);
            }
        });
    }

    public void setToolbarButtonVisible(EnumSet<EFCAction> constant, boolean visible) {
        EFCThreadUtil.doLater(() -> {
            for (EFCAction set : constant) {
                EFCToolBar toolbar = this.getToolBar();
                if (toolbar == null) continue;
                toolbar.setButtonVisible(this.getMainMenu().getAction(set), visible);
            }
        });
    }

    public void setToolbarButtonVisible(EFCAction constant, boolean visible) {
        EFCThreadUtil.doLater(() -> this.getToolBar().setButtonVisible(this.getMainMenu().getAction(constant), visible));
    }

    public void setTabPageVisible(String registerIdent, String tabIdent, boolean visible) {
        EFCThreadUtil.doLater(() -> {
            CopyOnWriteArrayList<EFCPanel> list = this.getPanels(registerIdent);
            for (JPanel jPanel : list) {
                if (jPanel == null || !(jPanel instanceof EFCTabPanel)) continue;
                EFCTabPanel tPanel = (EFCTabPanel)jPanel;
                tPanel.setTabVisible(tabIdent, visible);
            }
        });
    }

    public void setTabPageActiv(String registerIdent, String tabIdent) {
        EFCThreadUtil.doLater(() -> {
            CopyOnWriteArrayList<EFCPanel> list = this.getPanels(registerIdent);
            for (JPanel jPanel : list) {
                if (jPanel == null || !(jPanel instanceof EFCTabPanel)) continue;
                EFCTabPanel tPanel = (EFCTabPanel)jPanel;
                tPanel.setTabActiv(tabIdent);
            }
        });
    }

    public void setTabPageEnabled(String registerIdent, String tabIdent, boolean visible) {
        EFCThreadUtil.doLater(() -> {
            CopyOnWriteArrayList<EFCPanel> list = this.getPanels(registerIdent);
            for (JPanel jPanel : list) {
                if (jPanel == null || !(jPanel instanceof EFCTabPanel)) continue;
                EFCTabPanel tPanel = (EFCTabPanel)jPanel;
                tPanel.setTabEnabled(tabIdent, visible);
            }
        });
    }

    public void setFieldEdgeIcon(String fieldIdent, ImageIcon img, int edge) {
        CopyOnWriteArrayList<JComponent> fields = this.getFields(fieldIdent);
        for (JComponent comp : fields) {
            if (!(comp instanceof EditorComponent)) continue;
            ((EditorComponent)((Object)comp)).setEdgeImage(img, edge);
        }
    }

    public void setFieldIconSearch(String fieldIdent, boolean enabled) {
        if (enabled) {
            this.setFieldEdgeIcon(fieldIdent, EFCLookAndFeelManager.ICON_FIELDINFO_SEARCH, 3);
        } else {
            this.setFieldEdgeIcon(fieldIdent, null, 3);
        }
    }

    public EFCExplorerPanel getSelectedExplorerPanel(String ident) {
        EFCPanel pnl = (EFCPanel)this.getPanel(ident);
        if (pnl instanceof EFCExplorerPanel) {
            return (EFCExplorerPanel)pnl;
        }
        return null;
    }

    public ExplorerElement getSelectedExplorerPanelElement(String ident) {
        EFCPanel pnl = (EFCPanel)this.getPanel(ident);
        if (pnl instanceof EFCExplorerPanel) {
            return (ExplorerElement)((EFCExplorerPanel)pnl).getSelectedElement();
        }
        return null;
    }

    public EFCSubPanel getSubPanel(String ident) {
        JPanel panel = this.getPanel(ident);
        if (panel == null) {
            return null;
        }
        if (panel instanceof EFCSubPanel) {
            return (EFCSubPanel)panel;
        }
        return null;
    }

    public EFCGraphPanel getGraphPanel(String ident) {
        EFCPanel pnl = (EFCPanel)this.getPanel(ident);
        if (pnl instanceof EFCGraphPanel) {
            return (EFCGraphPanel)pnl;
        }
        return null;
    }

    public String getSelectedTabPageId(String tabident) {
        EFCPanel pnl = (EFCPanel)this.getPanel(tabident);
        if (pnl instanceof EFCTabPanel) {
            return ((EFCTabPanel)pnl).getActiveTabId();
        }
        return null;
    }

    public EFCPanel getSelectedTabPagePanel(String tabident) {
        EFCPanel pnl = (EFCPanel)this.getPanel(tabident);
        if (pnl instanceof EFCTabPanel) {
            return ((EFCTabPanel)pnl).getActiveTab();
        }
        return null;
    }

    public EFCBOTablePanel getTablePanel(String ident) {
        EFCPanel pnl = (EFCPanel)this.getPanel(ident);
        if (pnl instanceof EFCBOTablePanel) {
            return (EFCBOTablePanel)pnl;
        }
        return null;
    }

    public EFCListTablePanel getListTablePanel(String ident) {
        EFCPanel pnl = (EFCPanel)this.getPanel(ident);
        if (pnl instanceof EFCListTablePanel) {
            return (EFCListTablePanel)pnl;
        }
        return null;
    }

    public EFCBusinessDataTablePanel getBusinessTablePanel(String ident) {
        EFCPanel pnl = (EFCPanel)this.getPanel(ident);
        if (pnl instanceof EFCBusinessDataTablePanel) {
            return (EFCBusinessDataTablePanel)pnl;
        }
        return null;
    }

    public int getSelectedTablePanelIndex(String ident) {
        EFCPanel pnl = (EFCPanel)this.getPanel(ident);
        if (pnl instanceof EFCBOTablePanel) {
            return ((EFCBOTablePanel)pnl).getSelectedIndex();
        }
        return -1;
    }

    public String getSelectedTablePanelId() {
        String tbl = this.getLastActiveIdent();
        while (tbl != null && !tbl.isEmpty()) {
            EFCPanel pnl = (EFCPanel)this.getPanel(tbl);
            if (pnl instanceof EFCBOTablePanel) {
                return tbl;
            }
            if (tbl.contains(".")) {
                tbl = tbl.substring(0, tbl.lastIndexOf("."));
                continue;
            }
            tbl = null;
        }
        return null;
    }

    public String getSelectedListTablePanelId() {
        String tbl = this.getLastActiveIdent();
        while (tbl != null && !tbl.isEmpty()) {
            EFCPanel pnl = (EFCPanel)this.getPanel(tbl);
            if (pnl instanceof EFCListTablePanel) {
                return tbl;
            }
            if (tbl.contains(".")) {
                tbl = tbl.substring(0, tbl.lastIndexOf("."));
                continue;
            }
            tbl = null;
        }
        return null;
    }

    public BusinessObject getSelectedListTablePanelBusObj(String ident) {
        while (ident != null && !ident.toString().isEmpty()) {
            EFCPanel pnl = (EFCPanel)this.getPanel(ident);
            if (pnl instanceof EFCListTablePanel) {
                return ((EFCListTablePanel)pnl).getSelectedObject();
            }
            if (ident.contains(".")) {
                ident = ident.substring(0, ident.lastIndexOf("."));
                continue;
            }
            ident = null;
        }
        return null;
    }

    public boolean setSelectedTablePanelId(String tableIdent) {
        while (tableIdent != null && !tableIdent.isEmpty()) {
            EFCPanel pnl = (EFCPanel)this.getPanel(tableIdent);
            if (!(pnl instanceof EFCBOTablePanel)) continue;
            this.setActiveIdent(tableIdent);
            return true;
        }
        return false;
    }

    public BusinessObject getSelectedTablePanelBusObj(String ident) {
        while (ident != null && !ident.toString().isEmpty()) {
            EFCPanel pnl = (EFCPanel)this.getPanel(ident);
            if (pnl instanceof EFCBOTablePanel) {
                return ((EFCBOTablePanel)pnl).getSelectedObject();
            }
            if (ident.contains(".")) {
                ident = ident.substring(0, ident.lastIndexOf("."));
                continue;
            }
            ident = null;
        }
        return null;
    }

    public void setFocusToNextField() {
        EFCThreadUtil.doLater(() -> KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent());
    }

    public void setFocusToFirstField() {
        JTextField firstField = this.getFirstFocusableField();
        if (firstField != null && firstField.isEditable()) {
            EFCThreadUtil.doLater(() -> firstField.requestFocusInWindow());
        }
    }

    @Override
    public void terminate() {
        if (this.mainMenu != null) {
            this.mainMenu.terminate();
            this.mainMenu = null;
        }
        this.menuActionHandler = null;
        this.firstFocusableField = null;
        this.firstFocusableField = null;
        this.terminateFields();
        this.terminatePanels();
    }

    public String getActiveTableSelectionFocusIdent() {
        return this.activeTableSelectionFocusIdent;
    }

    public void setActiveTableSelectionFocusIdent(String activeTableSelectionFocusIdent) {
        this.activeTableSelectionFocusIdent = activeTableSelectionFocusIdent;
    }

    @Override
    public void addField(String name, JComponent component) {
        if (name == null || "".equals(name)) {
            return;
        }
        CopyOnWriteArrayList<WeakReference<JComponent>> comp = this.fields.get(name = name.toLowerCase());
        if (comp == null) {
            comp = new CopyOnWriteArrayList();
            this.fields.put(name, comp);
        }
        comp.add(new WeakReference<JComponent>(component));
        if (name.contains(".")) {
            for (Component subcomp : component.getComponents()) {
                if (!(subcomp instanceof JTextField)) continue;
                String key = name.substring(0, name.lastIndexOf("."));
                if (this.firstFocusFields.containsKey(key)) {
                    return;
                }
                this.firstFocusFields.put(key, name);
            }
        }
        if (this.firstFocusableField == null) {
            for (Component subcomp : component.getComponents()) {
                if (!(subcomp instanceof JTextField)) continue;
                this.firstFocusableField = (JTextField)subcomp;
            }
        }
    }

    @Override
    public void removeField(String ident) {
        ident = ident.toLowerCase();
        this.fields.remove(ident);
    }

    @Override
    public boolean fieldExists(String ident) {
        ident = ident.toLowerCase();
        return this.fields.containsKey(ident);
    }

    @Override
    public JComponent getField(String ident) {
        if (ident == null || "".equals(ident)) {
            return null;
        }
        CopyOnWriteArrayList<JComponent> myFields = this.getFields(ident);
        if (myFields.size() <= 0) {
            return null;
        }
        return (JComponent)myFields.get(0);
    }

    @Override
    public Object getFieldValue(String ident) {
        CopyOnWriteArrayList<JComponent> fields = this.getFields(ident);
        for (JComponent component : fields) {
            if (component instanceof EditorComponent) {
                return ((EditorComponent)((Object)component)).getValue();
            }
            if (!(component instanceof JTextComponent)) continue;
            return ((JTextComponent)component).getText();
        }
        logger.warn("getting value of {} failed: field doesn't exist", (Object)ident);
        return null;
    }

    @Override
    public void setFieldValue(String ident, Object value) {
        CopyOnWriteArrayList<JComponent> fields = this.getFields(ident);
        if (fields.size() <= 0) {
            logger.info("tryed to access non-existing list of fields ", (Object)ident);
            return;
        }
        for (JComponent comp : fields) {
            if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).setText(value != null ? value.toString() : null);
                continue;
            }
            if (comp instanceof EditorComponent) {
                ((EditorComponent)((Object)comp)).setValue(value);
                continue;
            }
            if (comp instanceof JLabel) {
                ((JLabel)comp).setText(value != null ? value.toString() : null);
                continue;
            }
            if (!(comp instanceof EFCBOTablePanel)) continue;
            ((EFCBOTablePanel)comp).setData(value instanceof List ? (List)value : null);
        }
    }

    @Override
    public void resetField(String ident) {
        CopyOnWriteArrayList<JComponent> fields = this.getFields(ident);
        if (fields.size() <= 0) {
            logger.info("resetting value of {} failed: field doesn't exist", (Object)ident);
            return;
        }
        for (JComponent component : fields) {
            if (component instanceof EditorComponent) {
                ((EditorComponent)((Object)component)).setValue(null);
                continue;
            }
            if (!(component instanceof JTextComponent)) continue;
            ((JTextComponent)component).setText("");
        }
    }

    @Override
    public CopyOnWriteArrayList<JComponent> getFields(String ident) {
        List part;
        CopyOnWriteArrayList<JComponent> result = new CopyOnWriteArrayList<JComponent>();
        if (ident == null || "".equals(ident)) {
            return result;
        }
        if (ident.indexOf(":") != -1) {
            return result;
        }
        ident = ident.toLowerCase();
        if (this.fields != null && (part = (List)this.fields.get(ident)) != null) {
            for (WeakReference ref : part) {
                JComponent component = (JComponent)ref.get();
                if (component == null) continue;
                result.add(component);
            }
        }
        return result;
    }

    @Override
    public CopyOnWriteArrayList<JComponent> getAllFields() {
        CopyOnWriteArrayList<JComponent> list = new CopyOnWriteArrayList<JComponent>();
        if (this.fields != null) {
            for (Map.Entry<String, CopyOnWriteArrayList<WeakReference<JComponent>>> mapEntry : this.fields.entrySet()) {
                this.addComponents(list, mapEntry);
            }
        }
        return list;
    }

    @Override
    public CopyOnWriteArrayList<JComponent> getAllFieldsVisible() {
        CopyOnWriteArrayList<JComponent> list = new CopyOnWriteArrayList<JComponent>();
        if (this.fields != null) {
            for (Map.Entry<String, CopyOnWriteArrayList<WeakReference<JComponent>>> mapEntry : this.fields.entrySet()) {
                if (!this.isFieldVisible(mapEntry.getKey())) continue;
                this.addComponents(list, mapEntry);
            }
        }
        return list;
    }

    @Override
    public CopyOnWriteArrayList<JComponent> getAllFields(String prefix) {
        String prefixLowerCase = prefix.toLowerCase();
        CopyOnWriteArrayList<JComponent> list = new CopyOnWriteArrayList<JComponent>();
        for (Map.Entry<String, CopyOnWriteArrayList<WeakReference<JComponent>>> mapEntry : this.fields.entrySet()) {
            if (!mapEntry.getKey().toLowerCase().startsWith(prefixLowerCase)) continue;
            this.addComponents(list, mapEntry);
        }
        return list;
    }

    @Override
    public CopyOnWriteArrayList<JComponent> getAllFields(Pattern pattern) {
        CopyOnWriteArrayList<JComponent> list = new CopyOnWriteArrayList<JComponent>();
        if (this.fields != null) {
            for (Map.Entry<String, CopyOnWriteArrayList<WeakReference<JComponent>>> mapEntry : this.fields.entrySet()) {
                if (!pattern.matcher(mapEntry.getKey()).matches()) continue;
                this.addComponents(list, mapEntry);
            }
        }
        return list;
    }

    @Override
    public CopyOnWriteArrayList<String> getAllFieldIdents() {
        if (this.fields != null) {
            return new CopyOnWriteArrayList<String>(this.fields.keySet());
        }
        return new CopyOnWriteArrayList<String>();
    }

    @Override
    public CopyOnWriteArrayList<String> getAllFieldIdentsVisible() {
        CopyOnWriteArrayList<String> list = new CopyOnWriteArrayList<String>();
        if (this.fields != null) {
            for (Map.Entry<String, CopyOnWriteArrayList<WeakReference<JComponent>>> mapEntry : this.fields.entrySet()) {
                if (!this.isFieldVisible(mapEntry.getKey())) continue;
                list.add(mapEntry.getKey());
            }
        }
        return list;
    }

    @Override
    public Map<String, CopyOnWriteArrayList<WeakReference<JComponent>>> getAllFieldsForReload() {
        HashMap<String, CopyOnWriteArrayList<WeakReference<JComponent>>> list = new HashMap<String, CopyOnWriteArrayList<WeakReference<JComponent>>>();
        if (this.fields != null) {
            for (Map.Entry<String, CopyOnWriteArrayList<WeakReference<JComponent>>> mapEntry : this.fields.entrySet()) {
                list.put(mapEntry.getKey(), mapEntry.getValue());
            }
        }
        return list;
    }

    @Override
    public Map<String, CopyOnWriteArrayList<WeakReference<JComponent>>> getAllFieldsForReload(String prefix) {
        String prefixLowerCase = prefix.toLowerCase();
        HashMap<String, CopyOnWriteArrayList<WeakReference<JComponent>>> list = new HashMap<String, CopyOnWriteArrayList<WeakReference<JComponent>>>();
        if (this.fields != null) {
            for (Map.Entry<String, CopyOnWriteArrayList<WeakReference<JComponent>>> mapEntry : this.fields.entrySet()) {
                if (!mapEntry.getKey().toLowerCase().startsWith(prefixLowerCase)) continue;
                list.put(mapEntry.getKey(), mapEntry.getValue());
            }
        }
        return list;
    }

    @Override
    public void setFieldEnabled(String ident, boolean enabled) {
        EFCThreadUtil.doLater(() -> {
            CopyOnWriteArrayList<JComponent> fields = this.getFields(ident);
            if (fields.size() <= 0) {
                logger.info("getting editable of {} failed: field doesn't exist", (Object)ident);
                return;
            }
            for (JComponent component : fields) {
                component.setEnabled(enabled);
            }
        });
    }

    @Override
    public boolean isFieldEnabled(String ident) {
        CopyOnWriteArrayList<JComponent> fields = this.getFields(ident);
        if (fields.size() > 0) {
            return ((JComponent)fields.get(0)).isEnabled();
        }
        logger.info("getting enabled of {} failed: field doesn't exist", (Object)ident);
        return false;
    }

    @Override
    public void setFieldVisible(String ident, boolean visible, boolean withFocusRequest) {
        EFCThreadUtil.doLater(() -> {
            CopyOnWriteArrayList<JComponent> fields = this.getFields(ident);
            if (fields.size() <= 0) {
                logger.info("setting visibility of {} failed: field doesn't exist", (Object)ident);
                return;
            }
            this.setComponentsVisible(visible, fields, withFocusRequest);
        });
    }

    @Override
    public void setFieldVisible(String ident, boolean visible) {
        this.setFieldVisible(ident, visible, false);
    }

    @Override
    public boolean isFieldVisible(String ident) {
        CopyOnWriteArrayList<JComponent> fields = this.getFields(ident);
        if (fields.size() > 0) {
            return ((JComponent)fields.get(0)).isVisible();
        }
        logger.info("getting visibility of {} failed: field doesn't exist", (Object)ident);
        return false;
    }

    @Override
    public void setFieldEditable(String ident, boolean editable) {
        CopyOnWriteArrayList<JComponent> fields = this.getFields(ident);
        if (fields.size() <= 0) {
            logger.debug("getting editable of {} failed: field doesn't exist", (Object)ident);
            return;
        }
        this.setFieldsEditable(editable, fields);
    }

    @Override
    public boolean isFieldEditable(String ident) {
        CopyOnWriteArrayList<JComponent> fields = this.getFields(ident);
        for (JComponent component : fields) {
            if (component instanceof EditorComponent) {
                return ((EditorComponent)((Object)component)).isEditable();
            }
            if (!(component instanceof JTextComponent)) continue;
            return ((JTextComponent)component).isEditable();
        }
        logger.debug("getting editable of {} failed: field doesn't exist", (Object)ident);
        return false;
    }

    @Override
    public void addScrollField(String ident, JComponent element) {
        CopyOnWriteArrayList<WeakReference<JComponent>> list = this.scrollfields.get(ident = ident.toLowerCase());
        if (list == null) {
            list = new CopyOnWriteArrayList();
            this.scrollfields.put(ident, list);
        }
        list.add(new WeakReference<JComponent>(element));
    }

    @Override
    public void removeScrollField(String ident) {
        ident = ident.toLowerCase();
        this.scrollfields.remove(ident);
    }

    @Override
    public boolean isScrollField(String ident) {
        ident = ident.toLowerCase();
        return this.scrollfields.keySet().contains(ident);
    }

    @Override
    public CopyOnWriteArrayList<JComponent> getAllScrollFields() {
        CopyOnWriteArrayList<JComponent> list = new CopyOnWriteArrayList<JComponent>();
        for (Map.Entry<String, CopyOnWriteArrayList<WeakReference<JComponent>>> entry : this.scrollfields.entrySet()) {
            this.addComponents(list, entry);
        }
        return list;
    }

    @Override
    public CopyOnWriteArrayList<String> getAllScrollFieldIdents() {
        return new CopyOnWriteArrayList<String>(this.scrollfields.keySet());
    }

    @Override
    public void addKeyField(String ident, JComponent element) {
        EFCThreadUtil.doLater(() -> {
            String identVal = ident.toLowerCase();
            CopyOnWriteArrayList<WeakReference<JComponent>> list = this.keyfields.get(identVal);
            if (list == null) {
                list = new CopyOnWriteArrayList();
                this.keyfields.put(identVal, list);
            }
            list.add(new WeakReference<JComponent>(element));
        });
    }

    @Override
    public void removeKeyField(String ident) {
        ident = ident.toLowerCase();
        this.keyfields.remove(ident);
    }

    @Override
    public boolean isKeyField(String ident) {
        ident = ident.toLowerCase();
        return this.keyfields.keySet().contains(ident);
    }

    @Override
    public CopyOnWriteArrayList<JComponent> getAllKeyFields() {
        CopyOnWriteArrayList<JComponent> list = new CopyOnWriteArrayList<JComponent>();
        for (Map.Entry<String, CopyOnWriteArrayList<WeakReference<JComponent>>> entry : this.keyfields.entrySet()) {
            this.addComponents(list, entry);
        }
        return list;
    }

    @Override
    public void setKeyFieldsEnabled(boolean enabled) {
        this.enableComponents(this.getAllKeyFields(), enabled);
    }

    @Override
    public void setSubKeyFieldsEditable(String prefix, boolean editable) {
        CopyOnWriteArrayList<JComponent> fields = this.getAllSubKeyFields(prefix);
        this.setFieldsEditable(editable, fields);
    }

    @Override
    public void addSubKeyField(String ident, JComponent element) {
        EFCThreadUtil.doLater(() -> {
            String identVal = ident.toLowerCase();
            CopyOnWriteArrayList<WeakReference<JComponent>> list = this.subkeyfields.get(identVal);
            if (list == null) {
                list = new CopyOnWriteArrayList();
                this.subkeyfields.put(identVal, list);
            }
            list.add(new WeakReference<JComponent>(element));
        });
    }

    @Override
    public void removeSubKeyField(String ident) {
        ident = ident.toLowerCase();
        this.subkeyfields.remove(ident);
    }

    @Override
    public CopyOnWriteArrayList<JComponent> getAllSubKeyFields() {
        CopyOnWriteArrayList<JComponent> list = new CopyOnWriteArrayList<JComponent>();
        for (Map.Entry<String, CopyOnWriteArrayList<WeakReference<JComponent>>> entry : this.subkeyfields.entrySet()) {
            this.addComponents(list, entry);
        }
        return list;
    }

    @Override
    public CopyOnWriteArrayList<JComponent> getAllSubKeyFields(String prefix) {
        prefix = prefix.toLowerCase();
        CopyOnWriteArrayList<JComponent> list = new CopyOnWriteArrayList<JComponent>();
        for (Map.Entry<String, CopyOnWriteArrayList<WeakReference<JComponent>>> entry : this.subkeyfields.entrySet()) {
            if (!entry.getKey().toLowerCase().startsWith(prefix)) continue;
            this.addComponents(list, entry);
        }
        return list;
    }

    @Override
    public boolean isSubKeyField(String ident) {
        ident = ident.toLowerCase();
        return this.subkeyfields.containsKey(ident);
    }

    @Override
    public void setSubKeyFieldsEnabled(boolean enabled) {
        this.enableComponents(this.getAllSubKeyFields(), enabled);
    }

    @Override
    public void setSubKeyFieldsEditable(boolean editable) {
        CopyOnWriteArrayList<JComponent> fields = this.getAllSubKeyFields();
        this.setFieldsEditable(editable, fields);
    }

    @Override
    public void setAllFieldsEnabled(boolean enable) {
        this.setFieldState(enable, this.getAllFields());
    }

    @Override
    public void setAllFieldsEnabled(String prefix, boolean enable) {
        CopyOnWriteArrayList<JComponent> fields = this.getAllFields(prefix);
        this.setFieldState(enable, fields);
    }

    @Override
    public void setAllFieldsEnabled(Pattern pattern, boolean enable) {
        CopyOnWriteArrayList<JComponent> fields = this.getAllFields(pattern);
        this.setFieldState(enable, fields);
    }

    @Override
    public void setAllFieldsVisible(boolean visible) {
        CopyOnWriteArrayList<JComponent> list = this.getAllFields();
        this.setComponentsVisible(visible, list, false);
    }

    @Override
    public void setAllFieldsVisible(String prefix, boolean visible) {
        CopyOnWriteArrayList<JComponent> fields = this.getAllFields(prefix);
        if (fields == null) {
            logger.info("setting visibility failed: no fields");
            return;
        }
        this.setComponentsVisible(visible, fields, false);
    }

    @Override
    public void setAllFieldsVisible(Pattern pattern, boolean visible) {
        CopyOnWriteArrayList<JComponent> list = this.getAllFields(pattern);
        if (list == null) {
            logger.info("setting visibility failed: no fields");
            return;
        }
        this.setComponentsVisible(visible, list, false);
    }

    @Override
    public void setAllFieldsEditable(String prefix, boolean editable) {
        CopyOnWriteArrayList<JComponent> fields = this.getAllFields(prefix);
        this.setFieldsEditable(editable, fields);
    }

    @Override
    public void setAllFieldsEditable(Pattern pattern, boolean editable) {
        CopyOnWriteArrayList<JComponent> fields = this.getAllFields(pattern);
        this.setFieldsEditable(editable, fields);
    }

    public void setAllFieldsForEdit() {
        for (JComponent editor : this.getAllKeyFields()) {
            ((EFCAbstractEditor)editor).setScrollMode(false);
        }
        for (JComponent editor : this.getAllScrollFields()) {
            ((EFCAbstractEditor)editor).setScrollMode(false);
            if (!(editor instanceof PrimaryEditorComponent)) continue;
            ((PrimaryEditorComponent)((Object)editor)).setSearchPopupEnabled(true);
        }
        this.setAllFieldsEditable(true);
        this.setAllFieldsEnabled(true);
        this.setKeyFieldsEnabled(false);
        this.setSubKeyFieldsEnabled(false);
    }

    public void setAllFieldsForNew() {
        for (JComponent editor : this.getAllKeyFields()) {
            ((EFCAbstractEditor)editor).setScrollMode(false);
        }
        for (JComponent editor : this.getAllScrollFields()) {
            ((EFCAbstractEditor)editor).setScrollMode(false);
            if (!(editor instanceof PrimaryEditorComponent)) continue;
            ((PrimaryEditorComponent)((Object)editor)).setSearchPopupEnabled(false);
        }
        this.setAllFieldsEditable(true);
        this.setAllFieldsEnabled(true);
    }

    public void setAllFieldsForScroll() {
        for (JComponent editor : this.getAllKeyFields()) {
            ((EFCAbstractEditor)editor).setScrollMode(true);
        }
        for (JComponent editor : this.getAllScrollFields()) {
            ((EFCAbstractEditor)editor).setScrollMode(true);
            if (!(editor instanceof PrimaryEditorComponent)) continue;
            ((PrimaryEditorComponent)((Object)editor)).setSearchPopupEnabled(true);
        }
        this.setAllFieldsEditable(true);
        this.setAllFieldsEnabled(false);
        this.setScrollFieldsEnabled(true);
    }

    public void setAllFieldsForInfo() {
        for (JComponent editor : this.getAllKeyFields()) {
            ((EFCAbstractEditor)editor).setScrollMode(true);
        }
        for (JComponent editor : this.getAllScrollFields()) {
            ((EFCAbstractEditor)editor).setScrollMode(true);
            if (!(editor instanceof PrimaryEditorComponent)) continue;
            ((PrimaryEditorComponent)((Object)editor)).setSearchPopupEnabled(true);
        }
        this.setAllFieldsEditable(false);
        this.setAllFieldsEnabled(false);
    }

    public void setAllFieldsForInfoScroll() {
        for (JComponent editor : this.getAllKeyFields()) {
            ((EFCAbstractEditor)editor).setScrollMode(true);
        }
        for (JComponent editor : this.getAllScrollFields()) {
            ((EFCAbstractEditor)editor).setScrollMode(true);
            if (!(editor instanceof PrimaryEditorComponent)) continue;
            ((PrimaryEditorComponent)((Object)editor)).setSearchPopupEnabled(true);
        }
        this.setAllFieldsEditable(false);
        this.setAllFieldsEnabled(false);
        this.setScrollFieldsEnabled(true);
        this.setScrollFieldsEditable(true);
    }

    @Override
    public void resetAllFields() {
        this.resetAllFields("");
    }

    @Override
    public void resetAllFields(String prefix) {
        prefix = prefix.toLowerCase();
        CopyOnWriteArrayList<String> fieldsForReset = new CopyOnWriteArrayList<String>();
        if (this.fields != null) {
            for (String string : this.fields.keySet()) {
                if (!string.toLowerCase().startsWith(prefix)) continue;
                fieldsForReset.add(string);
            }
        }
        for (String field : fieldsForReset) {
            this.resetField(field);
        }
        this.unlinkAllEditorsFromObjects(prefix);
    }

    @Override
    public void resetAllFields(Pattern pattern) {
        CopyOnWriteArrayList<String> fieldsForReset = new CopyOnWriteArrayList<String>();
        if (this.fields != null) {
            for (String string : this.fields.keySet()) {
                if (!pattern.matcher(string).matches()) continue;
                fieldsForReset.add(string);
            }
        }
        for (String field : fieldsForReset) {
            this.resetField(field);
        }
    }

    @Override
    public void addFieldToGroup(String group, JComponent element) {
        CopyOnWriteArrayList<WeakReference<JComponent>> list = this.groups.get(group = group.toLowerCase());
        if (list == null) {
            list = new CopyOnWriteArrayList();
            this.groups.put(group, list);
        }
        list.add(new WeakReference<JComponent>(element));
    }

    @Override
    public void removeFieldFromGroup(String group, JComponent element) {
        CopyOnWriteArrayList<WeakReference<JComponent>> list = this.groups.get(group = group.toLowerCase());
        if (list != null) {
            ListIterator<WeakReference<JComponent>> iter = list.listIterator();
            while (iter.hasNext()) {
                WeakReference ref = (WeakReference)iter.next();
                JComponent component = (JComponent)ref.get();
                if (component != null && component != element) continue;
                iter.remove();
            }
        }
    }

    @Override
    public void removeGroup(String group) {
        CopyOnWriteArrayList<WeakReference<JComponent>> list = this.groups.get(group = group.toLowerCase());
        if (list != null) {
            list.clear();
            this.groups.remove(group);
        }
    }

    @Override
    public boolean groupExists(String group) {
        group = group.toLowerCase();
        return this.groups.containsKey(group);
    }

    public CopyOnWriteArrayList<JComponent> getGroupElements(String group) {
        group = group.toLowerCase();
        CopyOnWriteArrayList<JComponent> result = new CopyOnWriteArrayList<JComponent>();
        CopyOnWriteArrayList<WeakReference<JComponent>> refList = this.groups.get(group);
        if (refList == null) {
            return result;
        }
        for (WeakReference<JComponent> ref : refList) {
            JComponent component = (JComponent)ref.get();
            if (ref == null) continue;
            result.add(component);
        }
        return result;
    }

    @Override
    public void setGroupVisible(String group, boolean visible) {
        EFCThreadUtil.doLater(() -> {
            List componentList = this.getGroupElements(group);
            for (JComponent component : componentList) {
                if (component instanceof EFCPanel) {
                    JPanel parent = this.getPanel(((EFCPanel)component).getParentIdent());
                    if (parent == null || !(parent instanceof EFCTabPanel)) continue;
                    EFCTabPanel tabpanel = (EFCTabPanel)parent;
                    tabpanel.setTabVisible((EFCPanel)component, visible);
                    continue;
                }
                component.setVisible(visible);
            }
        });
    }

    @Override
    public boolean isGroupVisible(String group) {
        List list = this.getGroupElements(group);
        if (list.size() == 0) {
            return false;
        }
        return ((JComponent)list.get(0)).isVisible();
    }

    @Override
    public void setGroupEnabled(String group, boolean enable) {
        EFCThreadUtil.doLater(() -> {
            List componentList = this.getGroupElements(group);
            for (JComponent component : componentList) {
                if (component instanceof EFCPanel) {
                    Container parent = component.getParent();
                    if (parent == null || !(parent instanceof JTabbedPane) || (parent = parent.getParent()) == null || !(parent instanceof EFCTabPanel)) continue;
                    EFCTabPanel tabpanel = (EFCTabPanel)parent;
                    tabpanel.setTabEnabled((EFCPanel)component, enable);
                    continue;
                }
                component.setEnabled(enable);
            }
        });
    }

    @Override
    public boolean isGroupEnabled(String group) {
        List componentList = this.getGroupElements(group);
        if (((CopyOnWriteArrayList)componentList).size() == 0) {
            return false;
        }
        return ((JComponent)((CopyOnWriteArrayList)componentList).get(0)).isEnabled();
    }

    @Override
    public void setGroupEditable(String group, boolean editable) {
        EFCThreadUtil.doLater(() -> {
            for (JComponent component : this.getGroupElements(group)) {
                if (component instanceof EditorComponent) {
                    ((EditorComponent)((Object)component)).setEditable(editable);
                    continue;
                }
                if (!(component instanceof JTextComponent)) continue;
                ((JTextComponent)component).setEditable(editable);
            }
        });
    }

    @Override
    public boolean isGroupEditable(String group) {
        List list = this.getGroupElements(group);
        if (((CopyOnWriteArrayList)list).size() == 0) {
            return false;
        }
        for (JComponent component : list) {
            if (component instanceof EditorComponent) {
                return ((EditorComponent)((Object)component)).isEditable();
            }
            if (!(component instanceof JTextComponent)) continue;
            return ((JTextComponent)component).isEditable();
        }
        return false;
    }

    @Override
    public void resetGroup(String group) {
        for (JComponent component : this.getGroupElements(group)) {
            if (component instanceof EditorComponent) {
                ((EditorComponent)((Object)component)).setValue(null);
                continue;
            }
            if (!(component instanceof JTextComponent)) continue;
            ((JTextComponent)component).setText(null);
        }
    }

    @Override
    public void addPanel(String ident, JPanel panel) {
        if (ident == null) {
            logger.warn("could not add component of type {} with null ident", (Object)panel.getClass().getSimpleName());
            return;
        }
        ident = ident.toLowerCase();
        if (panel == null) {
            logger.warn("could not add null component with ident {}", (Object)ident);
        } else {
            if (!this.panels.containsKey(ident)) {
                this.panels.put(ident, new CopyOnWriteArrayList());
            }
            this.panels.get(ident).add(new WeakReference<JPanel>(panel));
        }
    }

    @Override
    public void removePanels(String ident) {
        ident = ident.toLowerCase();
        this.panels.remove(ident);
    }

    @Override
    public void removePanel(String ident, JPanel panel) {
        if (this.panels.get(ident = ident.toLowerCase()) != null) {
            this.panels.get(ident).remove(panel);
        }
    }

    @Override
    public boolean panelExists(String ident) {
        ident = ident.toLowerCase();
        return this.panels.containsKey(ident);
    }

    @Override
    public JPanel getPanel(String ident) {
        if (ident == null) {
            return null;
        }
        if (!this.panels.containsKey(ident = ident.toLowerCase()) || this.panels.get(ident) == null || this.panels.get(ident).size() == 0) {
            return null;
        }
        if (this.panels.get(ident).size() > 1) {
            logger.error("there's more than one panel with ident " + ident);
            return null;
        }
        WeakReference<JPanel> ref = this.panels.get(ident).get(0);
        if (ref == null) {
            return null;
        }
        return (JPanel)ref.get();
    }

    @Override
    public CopyOnWriteArrayList<EFCPanel> getPanels(String ident) {
        ident = ident.toLowerCase();
        CopyOnWriteArrayList<EFCPanel> result = new CopyOnWriteArrayList<EFCPanel>();
        if (this.panels == null || !this.panels.containsKey(ident) || this.panels.get(ident) == null) {
            return result;
        }
        for (WeakReference<JPanel> ref : this.panels.get(ident)) {
            JPanel panel = (JPanel)ref.get();
            if (panel == null) continue;
            result.add((EFCPanel)panel);
        }
        return result;
    }

    @Override
    public CopyOnWriteArrayList<JPanel> getAllPanels() {
        CopyOnWriteArrayList<JPanel> list = new CopyOnWriteArrayList<JPanel>();
        if (this.panels != null) {
            for (List list2 : this.panels.values()) {
                for (WeakReference ref : list2) {
                    JPanel panel = (JPanel)ref.get();
                    if (panel == null) continue;
                    list.add(panel);
                }
            }
        }
        return list;
    }

    @Override
    public CopyOnWriteArrayList<EFCPanel> getAllPanels(String prefix) {
        String prefixLowerCase = prefix.toLowerCase();
        ArrayList<EFCPanel> list = new ArrayList<EFCPanel>();
        if (this.panels != null) {
            for (Map.Entry<String, CopyOnWriteArrayList<WeakReference<JPanel>>> ref : this.panels.entrySet()) {
                if (!ref.getKey().toLowerCase().startsWith(prefixLowerCase)) continue;
                for (WeakReference<JPanel> panelRef : ref.getValue()) {
                    JPanel panel = (JPanel)panelRef.get();
                    if (panel == null) continue;
                    list.add((EFCPanel)panel);
                }
            }
        }
        Collections.sort(list);
        return new CopyOnWriteArrayList<EFCPanel>(list);
    }

    @Override
    public CopyOnWriteArrayList<String> getAllPanelIdents() {
        if (this.panels != null) {
            return new CopyOnWriteArrayList<String>(this.panels.keySet());
        }
        return new CopyOnWriteArrayList<String>();
    }

    @Override
    public void setPanelVisible(String ident, boolean visible) {
        EFCThreadUtil.doLater(() -> {
            for (JPanel jPanel : this.getPanels(ident)) {
                jPanel.setVisible(visible);
            }
        });
    }

    @Override
    public boolean isPanelVisible(String ident) {
        JPanel panel = this.getPanel(ident);
        if (panel == null) {
            return false;
        }
        return panel.isVisible();
    }

    @Override
    public void setPanelEnabled(String ident, boolean enabled) {
        EFCThreadUtil.doLater(() -> {
            for (JPanel jPanel : this.getPanels(ident)) {
                jPanel.setEnabled(enabled);
            }
        });
    }

    @Override
    public boolean isPanelEnabled(String ident) {
        JPanel panel = this.getPanel(ident);
        if (panel == null) {
            return false;
        }
        return panel.isEnabled();
    }

    @Override
    public void setSubPanelDataNotLoaded(String ident) {
        JPanel subPanel = this.getPanel(ident);
        if (subPanel != null && subPanel instanceof EFCSubPanel) {
            ((EFCSubPanel)subPanel).setDataNotLoaded();
        }
    }

    @Override
    public JTextField getFirstFocusableField() {
        return this.firstFocusableField;
    }

    @Override
    public void setFirstFocusableField(JTextField field) {
        this.firstFocusableField = field;
    }

    @Override
    public void setFirstFocusableField(String fieldname) {
        CopyOnWriteArrayList<WeakReference<JComponent>> components = this.fields.get(fieldname.toLowerCase());
        if (components == null) {
            logger.debug("Focusable field {} not found", (Object)fieldname);
            return;
        }
        for (WeakReference<JComponent> weakReference : components) {
            for (Component fieldComponent : ((JComponent)weakReference.get()).getComponents()) {
                if (!(fieldComponent instanceof JTextField)) continue;
                this.focusableField = (JTextField)fieldComponent;
                this.setFirstFocusableField(this.focusableField);
                return;
            }
        }
    }

    @Override
    public JTextField getFocusableField() {
        return this.focusableField;
    }

    @Override
    public void setFocusableField(JTextField focusableField) {
        this.focusableField = focusableField;
    }

    @Override
    public void addImageEditor(EFCImageEditor imageEditor) {
        this.imageEditors.add(imageEditor);
    }

    @Override
    public EFCImageEditor getImageEditorByIdent(String editorIdent) {
        for (EFCImageEditor editor : this.imageEditors) {
            if (!editor.getIdent().equals(editorIdent)) continue;
            return editor;
        }
        return null;
    }

    @Override
    public CopyOnWriteArrayList<EFCImageEditor> getImageEditors() {
        return this.imageEditors;
    }

    @Override
    public void setFirstFocusField(String ident) {
        this.setFocusToField(this.firstFocusFields.get(ident.toLowerCase()));
    }

    @Override
    public void addFirstFocusField(String name) {
        if ((name = name.toLowerCase()).contains(".")) {
            String key = name.substring(0, name.lastIndexOf("."));
            this.firstFocusFields.put(key, name);
        }
    }

    @Override
    public void resetForLayout() {
        this.fields = new ConcurrentHashMap<String, CopyOnWriteArrayList<WeakReference<JComponent>>>();
        this.scrollfields = new ConcurrentSkipListMap<String, CopyOnWriteArrayList<WeakReference<JComponent>>>();
        this.keyfields = new ConcurrentHashMap<String, CopyOnWriteArrayList<WeakReference<JComponent>>>();
        this.subkeyfields = new ConcurrentHashMap<String, CopyOnWriteArrayList<WeakReference<JComponent>>>();
        this.panels = new ConcurrentHashMap<String, CopyOnWriteArrayList<WeakReference<JPanel>>>();
        this.groups = new ConcurrentHashMap<String, CopyOnWriteArrayList<WeakReference<JComponent>>>();
        this.firstFocusFields = new HashMap<String, String>();
        this.imageEditors = new CopyOnWriteArrayList();
    }

    @Override
    public CopyOnWriteArrayList<JPanel> getAllTablePanels() {
        CopyOnWriteArrayList<JPanel> list = new CopyOnWriteArrayList<JPanel>();
        for (CopyOnWriteArrayList<WeakReference<JPanel>> panelList : this.panels.values()) {
            for (WeakReference<JPanel> ref : panelList) {
                JPanel panel = (JPanel)ref.get();
                if (panel == null || !(panel instanceof EFCBOTablePanel) && !(panel instanceof EFCListTablePanel)) continue;
                list.add(panel);
            }
        }
        return list;
    }

    @Override
    public CopyOnWriteArrayList<JPanel> getAllListTablePanels() {
        CopyOnWriteArrayList<JPanel> list = new CopyOnWriteArrayList<JPanel>();
        for (CopyOnWriteArrayList<WeakReference<JPanel>> panelList : this.panels.values()) {
            for (WeakReference<JPanel> ref : panelList) {
                JPanel panel = (JPanel)ref.get();
                if (panel == null || !(panel instanceof EFCListTablePanel)) continue;
                list.add(panel);
            }
        }
        return list;
    }

    @Override
    public CopyOnWriteArrayList<EFCBOTablePanel> getAllBOTablePanels() {
        CopyOnWriteArrayList<EFCBOTablePanel> list = new CopyOnWriteArrayList<EFCBOTablePanel>();
        for (CopyOnWriteArrayList<WeakReference<JPanel>> panelList : this.panels.values()) {
            for (WeakReference<JPanel> ref : panelList) {
                JPanel panel = (JPanel)ref.get();
                if (panel == null || !(panel instanceof EFCBOTablePanel)) continue;
                list.add((EFCBOTablePanel)panel);
            }
        }
        return list;
    }

    @Override
    public CopyOnWriteArrayList<EFCBOTablePanel> getAllBOTablePanels(String prefix) {
        String prefixLowerCase = prefix.toLowerCase();
        ArrayList<EFCBOTablePanel> list = new ArrayList<EFCBOTablePanel>();
        if (this.panels != null) {
            for (Map.Entry<String, CopyOnWriteArrayList<WeakReference<JPanel>>> ref : this.panels.entrySet()) {
                if (!ref.getKey().toLowerCase().startsWith(prefixLowerCase)) continue;
                for (WeakReference<JPanel> panelRef : ref.getValue()) {
                    JPanel panel = (JPanel)panelRef.get();
                    if (panel == null || !(panel instanceof EFCBOTablePanel)) continue;
                    list.add((EFCBOTablePanel)panel);
                }
            }
        }
        Collections.sort(list);
        return new CopyOnWriteArrayList<EFCBOTablePanel>(list);
    }

    @Override
    public void setScrollFieldsEnabled(boolean enable) {
        CopyOnWriteArrayList<JComponent> fields = this.getAllScrollFields();
        this.setFieldState(enable, fields);
    }

    @Override
    public void setScrollFieldsEditable(boolean editable) {
        CopyOnWriteArrayList<JComponent> fields = this.getAllScrollFields();
        this.setFieldsEditable(editable, fields);
    }

    @Override
    public void setSubKeyFieldsEnabled(String prefix, boolean enabled) {
        this.enableComponents(this.getAllSubKeyFields(prefix), enabled);
    }

    @Override
    public void setKeyFieldsEditable(boolean editable) {
        CopyOnWriteArrayList<JComponent> fields = this.getAllKeyFields();
        this.setFieldsEditable(editable, fields);
    }

    private void addComponents(CopyOnWriteArrayList<JComponent> list, Map.Entry<String, CopyOnWriteArrayList<WeakReference<JComponent>>> entry) {
        for (WeakReference<JComponent> ref : entry.getValue()) {
            JComponent component = (JComponent)ref.get();
            if (component == null) continue;
            list.add(component);
        }
    }

    private void enableComponents(CopyOnWriteArrayList<JComponent> componentList, boolean enabled) {
        CopyOnWriteArrayList<JComponent> list = componentList;
        this.setFieldState(enabled, list);
    }

    private void setFieldState(boolean enable, List<JComponent> fields) {
        EFCThreadUtil.doLater(() -> {
            for (JComponent component : fields) {
                component.setEnabled(enable);
            }
        });
    }

    private void setFieldsEditable(boolean editable, CopyOnWriteArrayList<JComponent> fields) {
        EFCThreadUtil.doLater(() -> {
            for (JComponent component : fields) {
                if (component instanceof EditorComponent) {
                    ((EditorComponent)((Object)component)).setEditable(editable);
                    continue;
                }
                if (!(component instanceof JTextComponent)) continue;
                ((JTextComponent)component).setEditable(editable);
            }
        });
    }

    private void unlinkAllEditorsFromObjects(String prefix) {
        for (JComponent component : this.getAllFields(prefix)) {
            if (!(component instanceof EditorComponent)) continue;
            ((EditorComponent)((Object)component)).setLinkedWithObject(false);
            logger.debug("{} now unlinked from Object {}", (Object)component.getClass().getSimpleName(), (Object)prefix);
        }
        logger.debug("Keine Editoren verlinkt mit Objekten");
    }

    private void setComponentsVisible(boolean visible, CopyOnWriteArrayList<JComponent> list, boolean withFokusRequest) {
        EFCThreadUtil.doLater(() -> {
            for (JComponent component : list) {
                component.setVisible(visible);
                if (!visible || !withFokusRequest || !(component instanceof EditorComponent) || !((EditorComponent)((Object)component)).isEditable() || !((EditorComponent)((Object)component)).isEnabled()) continue;
                ((EditorComponent)((Object)component)).getEditorComponent().requestFocusInWindow();
            }
        });
    }

    @Override
    public void setAllFieldsEditable(boolean editable) {
        CopyOnWriteArrayList<JComponent> fields = this.getAllFields();
        this.setFieldsEditable(editable, fields);
    }

    @Override
    public void setFocusToField(String ident) {
        EFCThreadUtil.doLater(() -> {
            if (ident == null) {
                logger.debug("Focusable field 'null' not found");
                return;
            }
            CopyOnWriteArrayList<WeakReference<JComponent>> components = this.fields.get(ident.toLowerCase());
            if (components == null) {
                logger.debug("Focusable field {} not found", (Object)ident);
                return;
            }
            for (WeakReference<JComponent> weakReference : components) {
                for (Component fieldComponent : ((JComponent)weakReference.get()).getComponents()) {
                    if (fieldComponent instanceof JTextField) {
                        this.focusableField = (JTextField)fieldComponent;
                        this.focusableField.requestFocusInWindow();
                        return;
                    }
                    if (!(fieldComponent instanceof JCheckBox)) continue;
                    fieldComponent.requestFocusInWindow();
                    return;
                }
            }
        });
    }

    public String getActiveField() {
        return this.activeField;
    }

    public void setActiveField(String activeField) {
        this.activeField = activeField;
    }

    public Component getLastFocusOwner() {
        return this.lastFocusOwner;
    }

    public void setLastFocusOwner(Component lastFocusOwner) {
        this.lastFocusOwner = lastFocusOwner;
    }

    private void terminateFields() {
        for (Component component : this.getAllFields()) {
            if (!(component instanceof EFCAbstractEditor)) continue;
            this.removeField(((EFCAbstractEditor)component).getIdent());
            ((EFCAbstractEditor)component).terminate();
        }
        if (this.fields != null) {
            this.fields.clear();
        }
    }

    private void terminatePanels() {
        for (JPanel panel : this.getAllPanels()) {
            if (!(panel instanceof EFCPanel)) continue;
            this.removePanel(((EFCPanel)panel).getIdent(), panel);
            ((EFCPanel)panel).terminate();
        }
        if (this.panels != null) {
            this.panels.clear();
        }
    }

    public void addMenuInvDocItemToMenuListing() {
        ArrayList<EFCAdditionalAction> actionList = new ArrayList<EFCAdditionalAction>();
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_INVDOCITEM_TOP));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_INVDOCITEM_MONTHACT));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_INVDOCITEM_MONTHPRE));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_INVDOCITEM_WEEKSACT4));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_INVDOCITEM));
        this.addToMenuListing(Translator.tr((String)"MENU_ADDITIONAL_INVDOCITEMLIST"), actionList);
    }

    public void addMenuInvDocItemStkplcToMenuListing() {
        ArrayList<EFCAdditionalAction> actionList = new ArrayList<EFCAdditionalAction>();
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_INVDOCITEM_TOP_STKPLC));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_INVDOCITEM_MONTHACT_STKPLC));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_INVDOCITEM_MONTHPRE_STKPLC));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_INVDOCITEM_WEEKSACT4_STKPLC));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_INVDOCITEM_STKPLC));
        this.addToMenuListing(Translator.tr((String)"MENU_ADDITIONAL_INVDOCITEMLIST_STKPLC"), actionList);
    }

    public void addMenuIntDocToMenuListing() {
        ArrayList<EFCAdditionalAction> actionList = new ArrayList<EFCAdditionalAction>();
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCINTERNAL_COO));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCINTERNAL_COO_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCINTERNAL_COO_COMPLETED));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCDIV_FWD));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCDIV_FWD_TOP));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCDIV_FWD_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCDIV_LONGTERMDEC));
        this.addToMenuListing(Translator.tr((String)"MENU_ADDITIONAL_INTDOCLIST"), actionList);
    }

    public void addMenuIntDocItemToMenuListing() {
        ArrayList<EFCAdditionalAction> actionList = new ArrayList<EFCAdditionalAction>();
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMINTERNAL_COO));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMINTERNAL_COO_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMINTERNAL_COO_DEFICIT));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMINTERNAL_COO_COMPLETED));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMDIV_LONGTERMDEC));
        this.addToMenuListing(Translator.tr((String)"MENU_ADDITIONAL_INTDOCITEMLIST"), actionList);
    }

    public void addMenuSalDocToMenuListing() {
        ArrayList<EFCAdditionalAction> actionList = new ArrayList<EFCAdditionalAction>();
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSAL));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSAL_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALINVTRN_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALINQ));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALINQ_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALOFF));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALOFF_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALDLC));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALDLC_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALCTT));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALCTT_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALORD));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALORD_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALDLN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALDLN_TOP));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALDLN_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALIVC));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALIVC_TOP));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALIVC_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALCPL));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCSALCPL_OPEN));
        this.addToMenuListing(Translator.tr((String)"MENU_ADDITIONAL_SALDOCLIST"), actionList);
    }

    public void addMenuSalDocItemToMenuListing() {
        ArrayList<EFCAdditionalAction> actionList = new ArrayList<EFCAdditionalAction>();
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSAL));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSAL_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSALINVTRN_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSALINQ));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSALINQ_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSALOFF));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSALOFF_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSALCTT));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSALCTT_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSALORD));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSALORD_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSALDLN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSALDLN_TOP));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSALDLN_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSALIVC));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSALIVC_TOP));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSALIVC_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSALCPL));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMSALCPL_OPEN));
        this.addToMenuListing(Translator.tr((String)"MENU_ADDITIONAL_SALDOCITEMLIST"), actionList);
    }

    public void addMenuPurDocToMenuListing() {
        ArrayList<EFCAdditionalAction> actionList = new ArrayList<EFCAdditionalAction>();
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPUR));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPUR_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPURINVTRN_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPURINQ));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPURINQ_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPUROFF));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPUROFF_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPURDLC));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPURDLC_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPURCTT));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPURCTT_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPURORD));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPURORD_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPURDLN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPURDLN_TOP));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPURDLN_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPURIVC));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPURIVC_TOP));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPURIVC_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPURCPL));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCPURCPL_OPEN));
        this.addToMenuListing(Translator.tr((String)"MENU_ADDITIONAL_PURDOCLIST"), actionList);
    }

    public void addMenuPurDocItemToMenuListing() {
        ArrayList<EFCAdditionalAction> actionList = new ArrayList<EFCAdditionalAction>();
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPUR));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPUR_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPURINVTRN_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPURINQ));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPURINQ_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPUROFF));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPUROFF_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPURCTT));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPURCTT_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPURORD));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPURORD_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPURDLN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPURDLN_TOP));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPURDLN_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPURIVC));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPURIVC_TOP));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPURIVC_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPURCPL));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_DOCITEMPURCPL_OPEN));
        this.addToMenuListing(Translator.tr((String)"MENU_ADDITIONAL_PURDOCITEMLIST"), actionList);
    }

    public void addMenuQltDocToMenuListing() {
        ArrayList<EFCAdditionalAction> actionList = new ArrayList<EFCAdditionalAction>();
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_QLTDOC));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_QLTDOCCPLDOC));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_QLTDOCERRCOL));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_QLTDOCINSPCERT));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_QLTDOCRELEASEDRAW));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_QLTDOCRELEASEMAT));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_QLTDOCRELEASESAMPLE));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_QLTDOCRELEASESPECIAL));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_QLTDOCRELEASEPRDLOT));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_QLTDOCREPORT8D));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_QLTDOCTESTDOC));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_QLTDOCTESTINST));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_QLTDOCTESTORD));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_QLTDOCVENRATINGBAT));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_QLTDOCVENRATINGDOC));
        this.addToMenuListing(Translator.tr((String)"MENU_ADDITIONAL_QLTDOCLIST"), actionList);
    }

    public void addMenuPrdToMenuListing() {
        ArrayList<EFCAdditionalAction> actionList = new ArrayList<EFCAdditionalAction>();
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_PRDDOC));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_PRDDOC_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_PRDDOCITEM));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_PRDDOCITEM_OPEN));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_PRDDOCOPR));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_PRDDOCOPR_OPEN));
        this.addToMenuListing(Translator.tr((String)"MENU_ADDITIONAL_PRDDOCLIST"), actionList);
    }

    public void addMenuPrdConfToMenuListing() {
        ArrayList<EFCAdditionalAction> actionList = new ArrayList<EFCAdditionalAction>();
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_PRDCONFTOP));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_PRDCONF));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_PRDCONFTOP_WITHQTY));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_PRDCONF_WITHQTY));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_PRDCONFTOP_WITHSCRAP));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_PRDCONF_WITHSCRAP));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_PRDCONFTOP_WITHTIME));
        actionList.add(new EFCAdditionalAction(EFCAdditionalActionInfo.LIST_PRDCONF_WITHTIME));
        this.addToMenuListing(Translator.tr((String)"MENU_ADDITIONAL_PRDCONFLIST"), actionList);
    }

    public void addMenuDocFlowToMenuFunctions() {
        JMenu menu = this.getMainMenu().getMenu(EFCMenu.M_FUNCTIONS);
        this.addItemToMenu(menu, this.getMainMenu().getAction(EFCAction.A_FLOW_CON));
        this.setToolbarButtonVisible(EFCAction.A_FLOW_CON, true);
        this.addItemToMenu(menu, this.getMainMenu().getAction(EFCAction.A_FLOW_GET));
        this.setToolbarButtonVisible(EFCAction.A_FLOW_GET, true);
        this.addItemToMenu(menu, this.getMainMenu().getAction(EFCAction.A_FLOW_CLS));
        this.setToolbarButtonVisible(EFCAction.A_FLOW_CLS, true);
    }

    public void addMenuDocFlowCloseToMenuFunctions() {
        JMenu menu = this.getMainMenu().getMenu(EFCMenu.M_FUNCTIONS);
        this.addItemToMenu(menu, this.getMainMenu().getAction(EFCAction.A_FLOW_CLS));
        this.setToolbarButtonVisible(EFCAction.A_FLOW_CLS, true);
    }

    public void addMenuDocFlowContinueToMenuFunctions() {
        JMenu menu = this.getMainMenu().getMenu(EFCMenu.M_FUNCTIONS);
        this.addItemToMenu(menu, this.getMainMenu().getAction(EFCAction.A_FLOW_CON));
        this.setToolbarButtonVisible(EFCAction.A_FLOW_CON, true);
    }

    public void updateImage(String scomp, PictureContainer container) {
        EFCImageEditor editor = this.getImageEditorByIdent(scomp);
        if (editor != null) {
            editor.setData(container);
        }
    }

    public void updateBlob(String tabIdent, String tabPageIdent, PictureContainer container) {
        JPanel panel = this.getPanel(tabIdent);
        if (panel instanceof EFCTabPanel) {
            EFCViewerFactory.checkForLoading((EFCTabPanel)panel, ((EFCTabPanel)panel).getTabEntity(tabPageIdent), container);
        }
    }

    public void updateExplorer(String scomp, TreeModel data) {
        CopyOnWriteArrayList<EFCPanel> list = this.getPanels(scomp);
        for (EFCPanel jc : list) {
            if (!(jc instanceof EFCExplorerPanel)) continue;
            EFCExplorerPanel exp = (EFCExplorerPanel)jc;
            exp.setData(data);
        }
    }

    public void updateExplorers(ArrayList<String> scomp, TreeModel data) {
        for (String key : scomp) {
            this.updateExplorer(key, data);
        }
    }

    public void updateGantt(String scomp, EFCDefaultResourceGantt data) {
        CopyOnWriteArrayList<EFCPanel> list = this.getPanels(scomp);
        for (EFCPanel jc : list) {
            if (!(jc instanceof EFCResourceGanttPanel)) continue;
            EFCResourceGanttPanel exp = (EFCResourceGanttPanel)jc;
            exp.setDataset(data);
        }
    }

    public void updateGantts(ArrayList<String> scomp, EFCDefaultResourceGantt data) {
        for (String key : scomp) {
            this.updateGantt(key, data);
        }
    }

    public void updateResourceDiagram(String scomp, EFCDefaultBarChartList data) {
        CopyOnWriteArrayList<EFCPanel> list = this.getPanels(scomp);
        for (EFCPanel jc : list) {
            if (!(jc instanceof EFCResourceDiagramListPanel)) continue;
            EFCResourceDiagramListPanel exp = (EFCResourceDiagramListPanel)jc;
            exp.setDatasetList(data);
        }
    }

    public void updateResourceDiagrams(ArrayList<String> scomp, EFCDefaultBarChartList data) {
        for (String key : scomp) {
            this.updateResourceDiagram(key, data);
        }
    }

    public void updateGraph(String scomp, Graph data) {
        CopyOnWriteArrayList<EFCPanel> list = this.getPanels(scomp);
        for (EFCPanel jc : list) {
            if (!(jc instanceof EFCGraphPanel)) continue;
            EFCGraphPanel gp = (EFCGraphPanel)jc;
            gp.setData(data);
        }
    }

    public void updateGraphs(ArrayList<String> scomp, Graph data) {
        for (String key : scomp) {
            this.updateGraph(key, data);
        }
    }

    public void updateBpmGraphs(ArrayList<String> scomp, Graph data) {
        for (String key : scomp) {
            CopyOnWriteArrayList<EFCPanel> list = this.getPanels(key);
            for (EFCPanel jc : list) {
                if (!(jc instanceof EFCBpmGraphPanel)) continue;
                EFCBpmGraphPanel gp = (EFCBpmGraphPanel)jc;
                gp.setData(data);
            }
        }
    }

    public void updateListTable(String scomp, List<MetaInfo> data) {
        EFCThreadUtil.doLater(() -> {
            CopyOnWriteArrayList<EFCPanel> list = this.getPanels(scomp);
            for (EFCPanel jc : list) {
                if (!(jc instanceof EFCListTablePanel)) continue;
                EFCListTablePanel ltp = (EFCListTablePanel)jc;
                ltp.setData(data);
            }
        });
    }

    public void updateCalendar(String scomp, AbstractLazyList data) {
        EFCThreadUtil.doLaterFAT(() -> {
            CopyOnWriteArrayList<EFCPanel> list = this.getPanels(scomp);
            for (EFCPanel jc : list) {
                if (!(jc instanceof EFCCalendarPanel)) continue;
                EFCCalendarPanel ltp = (EFCCalendarPanel)jc;
                ltp.setData(data);
            }
        });
    }

    public void updateListTables(ArrayList<String> scomp, List<MetaInfo> data) {
        for (String key : scomp) {
            this.updateListTable(key, data);
        }
    }

    public void updatePivotTable(String scomp, List<BusinessObject> data) {
        EFCThreadUtil.doLater(() -> {
            CopyOnWriteArrayList<EFCPanel> list = this.getPanels(scomp);
        });
    }

    public void updatePivotTables(ArrayList<String> scomp, List<BusinessObject> data) {
        for (String key : scomp) {
            CopyOnWriteArrayList<EFCPanel> copyOnWriteArrayList = this.getPanels(key);
        }
    }

    public void updateStatistic(String scomp, AbstractStatisticListData sdata) {
        CopyOnWriteArrayList<EFCPanel> list = this.getPanels(scomp);
        for (EFCPanel jc : list) {
            if (!(jc instanceof StatisticPanel)) continue;
            StatisticPanel sp = (StatisticPanel)((Object)jc);
            sp.setDataSource((StatisticDataObject)sdata);
        }
    }

    public void updateStatistics(List<String> scomp, AbstractStatisticListData sdata) {
        for (String key : scomp) {
            this.updateStatistic(key, sdata);
        }
    }

    public void updateBusinessData(String scomp, AbstractBusinessDataList sdata) {
        CopyOnWriteArrayList<EFCPanel> list = this.getPanels(scomp);
        for (EFCPanel jc : list) {
            if (!(jc instanceof BusinessPanel)) continue;
            BusinessPanel sp = (BusinessPanel)((Object)jc);
            sp.setDataSource((BusinessDataObject)sdata);
        }
    }

    public void updateBusinessData(String scomp, AbstractBusinessDataList sdata, Runnable loader) {
        CopyOnWriteArrayList<EFCPanel> list = this.getPanels(scomp);
        for (EFCPanel jc : list) {
            if (!(jc instanceof BusinessPanel)) continue;
            BusinessPanel sp = (BusinessPanel)((Object)jc);
            sp.setDataSource((BusinessDataObject)sdata, loader);
        }
    }

    public void updateBusinessData(List<String> scomp, AbstractBusinessDataList sdata) {
        for (String key : scomp) {
            this.updateBusinessData(key, sdata);
        }
    }

    public void addAcceleratorKeyToAction(EFCActionAccelerator action, EFCActionAcceleratorKey accelerator) {
        action.addAccelerator(accelerator);
    }

    public void addAcceleratorKeyToAction(String actionIdent, EFCActionAcceleratorKey accelerator) {
        EFCAbstractAction efcAction = null;
        EFCMenu[] ma = EFCMenu.values();
        for (int i = 0; i < ma.length && (efcAction = this.getAbstractAction(this.getMainMenu().getMenu(ma[i]), actionIdent)) == null; ++i) {
        }
        if (efcAction != null) {
            logger.info("Setze Tastenkuerzel: " + accelerator.toString() + " fuer ActionIdent: " + actionIdent);
            this.addAcceleratorKeyToAction(efcAction, accelerator);
        }
    }

    private EFCAbstractAction getAbstractAction(JMenu menu, String actionIdent) {
        if (menu == null || menu.getItemCount() == 0) {
            return null;
        }
        for (int i = 0; i < menu.getItemCount(); ++i) {
            EFCAbstractAction efcAction;
            JMenuItem jMenuItem = menu.getItem(i);
            if (!(jMenuItem != null && jMenuItem.getAction() != null && jMenuItem.getAction() instanceof EFCAbstractAction ? (efcAction = (EFCAbstractAction)jMenuItem.getAction()).getIdent().equals(actionIdent) : jMenuItem != null && jMenuItem instanceof JMenu && (efcAction = this.getAbstractAction((JMenu)jMenuItem, actionIdent)) != null)) continue;
            return efcAction;
        }
        return null;
    }
}

