/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.manager;

import de.effectivecompany.gui.events.BusinessTableInteractionEvent;
import de.effectivecompany.gui.events.DragEvent;
import de.effectivecompany.gui.events.FocusChangeEvent;
import de.effectivecompany.gui.events.ListTableDataLoadedEvent;
import de.effectivecompany.gui.events.SelectionContextChangeEvent;
import de.effectivecompany.gui.events.UserInputEvent;
import de.effectivecompany.gui.events.UserInteractionEvent;
import de.effectivecompany.gui.events.ValueChangeEvent;
import de.effectivecompany.gui.interfaces.ListTableDataListener;
import de.effectivecompany.gui.interfaces.listeners.BusinessTableInteractionListener;
import de.effectivecompany.gui.interfaces.listeners.DataChangeListener;
import de.effectivecompany.gui.interfaces.listeners.DragEventListener;
import de.effectivecompany.gui.interfaces.listeners.FocusChangeListener;
import de.effectivecompany.gui.interfaces.listeners.SelectionContextChangeListener;
import de.effectivecompany.gui.interfaces.listeners.UserInputListener;
import de.effectivecompany.gui.interfaces.listeners.UserInteractionListener;
import de.effectivecompany.gui.interfaces.listeners.ValueChangeListener;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCDataChangeManager
implements DataChangeManager,
DataChangeListener {
    private static Logger logger = LoggerFactory.getLogger(EFCDataChangeManager.class);
    private String baseIdent;
    private boolean notifyFocusChange = true;
    private Vector<FocusChangeListener> focusChangeListeners = new Vector();
    private Vector<SelectionContextChangeListener> selctionChangeListeners = new Vector();
    private Vector<DragEventListener> dragListeners = new Vector();
    private Vector<UserInputListener> inputListeners = new Vector();
    private Vector<UserInteractionListener> interactionListeners = new Vector();
    private Vector<ValueChangeListener> valueChangeListeners = new Vector();
    private Vector<BusinessTableInteractionListener> businessInteractionListeners = new Vector();
    private Vector<ListTableDataListener> listTableDataListeners = new Vector();
    private WeakReference<DataChangeManager> parentManager;
    private List<DataChangeManager> childManager = new ArrayList<DataChangeManager>();

    public EFCDataChangeManager() {
    }

    public EFCDataChangeManager(String baseIdent) {
        this.baseIdent = baseIdent;
    }

    public String getBaseIdent() {
        return this.baseIdent;
    }

    @Override
    public void attributeChanged(String domain, Object oldValue, Object newValue) {
        logger.debug("DCM: bo attribute changed");
    }

    @Override
    public void businessObjectChanged() {
        logger.debug("DCM: bo changed");
    }

    @Override
    public void addFocusChangeListener(FocusChangeListener l) {
        this.focusChangeListeners.add(l);
    }

    @Override
    public FocusChangeListener[] getFocusChangeListeners() {
        return this.focusChangeListeners.toArray(new FocusChangeListener[0]);
    }

    @Override
    public void removeFocusChangeListener(FocusChangeListener l) {
        this.focusChangeListeners.remove(l);
    }

    @Override
    public void addSelectionContextChangeListener(SelectionContextChangeListener l) {
        this.selctionChangeListeners.add(l);
    }

    @Override
    public SelectionContextChangeListener[] getSelectionContextChangeListeners() {
        return this.selctionChangeListeners.toArray(new SelectionContextChangeListener[0]);
    }

    @Override
    public void removeSelectionContextChangeListener(SelectionContextChangeListener l) {
        this.selctionChangeListeners.remove(l);
    }

    @Override
    public void addDragEventListener(DragEventListener l) {
        this.dragListeners.add(l);
    }

    @Override
    public DragEventListener[] getDragEventListeners() {
        return this.dragListeners.toArray(new DragEventListener[0]);
    }

    @Override
    public void removeDragEventListener(DragEventListener l) {
        this.dragListeners.remove(l);
    }

    @Override
    public void addUserInputListener(UserInputListener l) {
        this.inputListeners.add(l);
    }

    @Override
    public UserInputListener[] getUserInputListeners() {
        return this.inputListeners.toArray(new UserInputListener[0]);
    }

    @Override
    public void removeUserInputListener(UserInputListener l) {
        this.inputListeners.remove(l);
    }

    @Override
    public void addUserInteractionListener(UserInteractionListener l) {
        this.interactionListeners.add(l);
    }

    @Override
    public UserInteractionListener[] getUserInteractionListeners() {
        return this.interactionListeners.toArray(new UserInteractionListener[0]);
    }

    @Override
    public void removeUserInteractionListener(ValueChangeListener l) {
        this.interactionListeners.remove(l);
    }

    @Override
    public void addBusinessTableInteractionListener(BusinessTableInteractionListener l) {
        this.businessInteractionListeners.add(l);
    }

    @Override
    public BusinessTableInteractionListener[] getBusinessTableInteractionListeners() {
        return this.businessInteractionListeners.toArray(new BusinessTableInteractionListener[0]);
    }

    @Override
    public void removeBusinessTableInteractionListener(BusinessTableInteractionListener l) {
        this.businessInteractionListeners.remove(l);
    }

    @Override
    public void addValueChangeListener(ValueChangeListener l) {
        this.valueChangeListeners.add(l);
    }

    @Override
    public ValueChangeListener[] getValueChangeListeners() {
        return this.valueChangeListeners.toArray(new ValueChangeListener[0]);
    }

    @Override
    public void removeValueChangeListener(ValueChangeListener l) {
        this.valueChangeListeners.remove(l);
    }

    @Override
    public void setFocusListening(boolean isListening) {
        this.notifyFocusChange = isListening;
    }

    @Override
    public boolean isFocusListening() {
        return this.notifyFocusChange;
    }

    @Override
    public void setParentManager(DataChangeManager parent) {
        this.parentManager = new WeakReference<DataChangeManager>(parent);
    }

    @Override
    public DataChangeManager getParentManager() {
        if (this.parentManager == null) {
            return null;
        }
        return (DataChangeManager)this.parentManager.get();
    }

    @Override
    public void addChildManager(DataChangeManager child) {
        this.childManager.add(child);
        child.setParentManager(this);
    }

    @Override
    public DataChangeManager[] getChildManagers() {
        return this.childManager.toArray(new DataChangeManager[0]);
    }

    @Override
    public void removeChildManager(DataChangeManager child) {
        child.setParentManager(null);
        this.childManager.remove(child);
    }

    @Override
    public void onFocusChanged(FocusChangeEvent event) {
        for (FocusChangeListener listener : this.getFocusChangeListeners()) {
            listener.onFocusChanged(event);
        }
        DataChangeManager parent = this.getParentManager();
        if (parent != null) {
            event = new FocusChangeEvent(event);
            event.setIdent(this.baseIdent + ":" + event.getIdent());
            parent.onFocusChanged(event);
        }
    }

    @Override
    public void onSelectionContextChanged(SelectionContextChangeEvent event) {
        SelectionContextChangeListener[] listeners;
        for (SelectionContextChangeListener listener : listeners = this.getSelectionContextChangeListeners()) {
            listener.onSelectionContextChanged(event);
        }
        DataChangeManager parent = this.getParentManager();
        if (parent != null) {
            event = new SelectionContextChangeEvent(event);
            event.setIdent(this.baseIdent + ":" + event.getIdent());
            parent.onSelectionContextChanged(event);
        }
    }

    @Override
    public void onUserInput(UserInputEvent event) {
        UserInputListener[] listeners;
        for (UserInputListener listener : listeners = this.getUserInputListeners()) {
            listener.onUserInput(event);
        }
        DataChangeManager parent = this.getParentManager();
        if (parent != null) {
            event = new UserInputEvent(event);
            event.setIdent(this.baseIdent + ":" + event.getIdent());
            parent.onUserInput(event);
        }
    }

    @Override
    public void onUserInteraction(UserInteractionEvent event) {
        for (UserInteractionListener listener : this.getUserInteractionListeners()) {
            listener.onUserInteraction(event);
        }
        DataChangeManager parent = this.getParentManager();
        if (parent != null) {
            event = new UserInteractionEvent(event);
            event.setIdent(this.baseIdent + ":" + event.getIdent());
            parent.onUserInteraction(event);
        }
    }

    @Override
    public void onValueChanged(ValueChangeEvent event) {
        for (ValueChangeListener listener : this.valueChangeListeners) {
            listener.onValueChanged(event);
        }
        DataChangeManager parent = this.getParentManager();
        if (parent != null) {
            event = new ValueChangeEvent(event);
            event.setIdent(this.baseIdent + ":" + event.getIdent());
            parent.onValueChanged(event);
        }
    }

    @Override
    public void onBusinessTableInteraction(BusinessTableInteractionEvent event) {
        for (BusinessTableInteractionListener listener : this.getBusinessTableInteractionListeners()) {
            listener.onBusinessTableInteraction(event);
        }
        DataChangeManager parent = this.getParentManager();
        if (parent != null) {
            event = new BusinessTableInteractionEvent(event);
            event.setIdent(this.baseIdent + ":" + event.getIdent());
            parent.onBusinessTableInteraction(event);
        }
    }

    @Override
    public void onListTableDataLoaded(ListTableDataLoadedEvent event) {
        for (ListTableDataListener listener : this.getListTableDataListeners()) {
            listener.onListTableDataLoaded(event);
        }
        DataChangeManager parent = this.getParentManager();
        if (parent != null) {
            event = new ListTableDataLoadedEvent(event);
            event.setIdent(this.baseIdent + ":" + event.getIdent());
            parent.onListTableDataLoaded(event);
        }
    }

    @Override
    public void addListTableDataListener(ListTableDataListener l) {
        this.listTableDataListeners.add(l);
    }

    @Override
    public ListTableDataListener[] getListTableDataListeners() {
        return this.listTableDataListeners.toArray(new ListTableDataListener[0]);
    }

    @Override
    public void removeListTableDataListener(ListTableDataListener l) {
        this.listTableDataListeners.remove(l);
    }

    @Override
    public void onDrag(DragEvent dragEvent) {
        DragEventListener[] listeners;
        for (DragEventListener listener : listeners = this.getDragEventListeners()) {
            listener.onDrag(dragEvent);
        }
        DataChangeManager parent = this.getParentManager();
        if (parent != null) {
            dragEvent = new DragEvent(dragEvent);
            dragEvent.setIdent(this.baseIdent + ":" + dragEvent.getIdent());
            parent.onDrag(dragEvent);
        }
    }
}

