/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.util;

import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.datatypes.EFCFloat;
import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.gui.data.SearchResult;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.model.MapComboBoxModel;
import de.effectivecompany.gui.components.model.table.BOTableModel;
import de.effectivecompany.gui.components.model.table.EFCColumnModel;
import de.effectivecompany.gui.components.model.table.ListTableModel;
import de.effectivecompany.gui.components.model.table.StatisticDataTableModel;
import de.effectivecompany.gui.util.EUFieldStyler;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;

public class CSVUtil {
    private static String csvSeparator = ";";

    public static String tableToCSVFX(TableView<SearchResult> table) {
        SimpleBooleanProperty isFirstColumn = new SimpleBooleanProperty(true);
        StringBuffer sb = new StringBuffer();
        ArrayList columns = new ArrayList();
        if (!table.getSelectionModel().getSelectedCells().isEmpty()) {
            table.getSelectionModel().getSelectedCells().forEach(tablePosition -> {
                TableColumn tableColumn = tablePosition.getTableColumn();
                if (tableColumn != null && tableColumn.getId() != null && !tableColumn.getText().equals("#") && !columns.contains("\"" + tableColumn.getText() + "\"")) {
                    columns.add("\"" + tableColumn.getText() + "\"");
                }
            });
            sb.append(String.join((CharSequence)csvSeparator, columns));
            sb.append("\n");
            isFirstColumn.set(true);
            AtomicReference lastTablePosition = new AtomicReference();
            table.getSelectionModel().getSelectedCells().forEach(arg_0 -> CSVUtil.lambda$tableToCSVFX$1(lastTablePosition, (BooleanProperty)isFirstColumn, sb, arg_0));
        } else {
            table.getVisibleLeafColumns().forEach(arg_0 -> CSVUtil.lambda$tableToCSVFX$2((BooleanProperty)isFirstColumn, sb, arg_0));
            isFirstColumn.set(true);
            sb.append("\n");
            table.getItems().forEach(arg_0 -> CSVUtil.lambda$tableToCSVFX$4(table, (BooleanProperty)isFirstColumn, sb, arg_0));
        }
        return sb.toString();
    }

    public static String tableToCSV(JTable model) {
        return CSVUtil.tableToCSV(model, 0, 0, model.getModel().getColumnCount(), model.getRowCount());
    }

    public static String tableToCSV(JTable table, int startx, int starty, int width, int height) {
        int i;
        int tmpWidth = width;
        boolean isFirstColumn = true;
        StringBuffer sb = new StringBuffer();
        EUFieldStyler.getInstance();
        for (i = startx; i < table.getColumnModel().getColumnCount(); ++i) {
            TableColumnExt colExt;
            if (table.getModel() instanceof BOTableModel && table.getColumnModel() instanceof EFCColumnModel && ((TableColumnExt)((EFCColumnModel)((Object)table.getColumnModel())).getActColumns().get(i)).isVisible()) {
                if (!isFirstColumn) {
                    sb.append(csvSeparator);
                }
                isFirstColumn = false;
                colExt = ((EFCColumnModel)((Object)table.getColumnModel())).getActColumns().get(i);
                sb.append("\"" + colExt.getHeaderValue() + "\"");
                --width;
            } else if ((table.getModel() instanceof DefaultTableModel || table.getModel() instanceof StatisticDataTableModel || table.getModel() instanceof ListTableModel) && ((DefaultTableColumnModelExt)table.getColumnModel()).getColumnExt(i).isVisible()) {
                if (!isFirstColumn) {
                    sb.append(csvSeparator);
                }
                isFirstColumn = false;
                colExt = ((DefaultTableColumnModelExt)table.getColumnModel()).getColumnExt(i);
                sb.append("\"" + colExt.getHeaderValue() + "\"");
                --width;
            }
            if (width == 0) break;
        }
        sb.append("\n");
        isFirstColumn = true;
        width = tmpWidth;
        for (int j = starty; j < starty + height; ++j) {
            for (i = startx; i < table.getColumnModel().getColumnCount(); ++i) {
                Object val;
                TableColumnExt colExt;
                if (table.getModel() instanceof BOTableModel && table.getColumnModel() instanceof EFCColumnModel && ((TableColumnExt)((EFCColumnModel)((Object)table.getColumnModel())).getActColumns().get(i)).isVisible()) {
                    if (!isFirstColumn) {
                        sb.append(csvSeparator);
                    }
                    isFirstColumn = false;
                    colExt = ((EFCColumnModel)((Object)table.getColumnModel())).getActColumns().get(i);
                    val = table.getModel().getValueAt(j, colExt.getModelIndex());
                    if (val instanceof EFCString) {
                        sb.append((String)(val == null ? "" : "\"" + val + "\""));
                    } else {
                        if (val != null && val instanceof EFCFloat && ((EFCFloat)val).getData() != null) {
                            val = NumberFormat.getInstance().format(((EFCFloat)val).getData());
                        }
                        if (val != null && val instanceof EFCOption) {
                            val = Translator.tr((String)MapComboBoxModel.genKeyShort(val.toString(), ((EFCOption)val).getOptionClass().getSimpleName().toUpperCase()));
                        }
                        if (val != null && val instanceof EFCBoolean && ((EFCBoolean)val).getData() != null) {
                            val = EUFieldStyler.getObjectAsString(val);
                        }
                        sb.append(val == null ? "" : val);
                    }
                    --width;
                } else if ((table.getModel() instanceof DefaultTableModel || table.getModel() instanceof StatisticDataTableModel || table.getModel() instanceof ListTableModel) && ((DefaultTableColumnModelExt)table.getColumnModel()).getColumnExt(i).isVisible()) {
                    if (!isFirstColumn) {
                        sb.append(csvSeparator);
                    }
                    isFirstColumn = false;
                    colExt = ((DefaultTableColumnModelExt)table.getColumnModel()).getColumnExt(i);
                    val = table.getModel().getValueAt(j, colExt.getModelIndex());
                    if (val instanceof EFCString) {
                        sb.append((String)(val == null ? "" : "\"" + val + "\""));
                    } else {
                        if (val != null && val instanceof EFCFloat && ((EFCFloat)val).getData() != null) {
                            val = NumberFormat.getInstance().format(((EFCFloat)val).getData());
                        }
                        if (val != null && val instanceof EFCOption) {
                            val = Translator.tr((String)MapComboBoxModel.genKeyShort(val.toString(), ((EFCOption)val).getOptionClass().getSimpleName().toUpperCase()));
                        }
                        if (val != null && val instanceof EFCBoolean && ((EFCBoolean)val).getData() != null) {
                            val = EUFieldStyler.getObjectAsString(val);
                        }
                        sb.append(val == null ? "" : val);
                    }
                    --width;
                }
                if (width == 0) break;
            }
            width = tmpWidth;
            isFirstColumn = true;
            sb.append("\n");
        }
        return sb.toString();
    }

    private static /* synthetic */ void lambda$tableToCSVFX$4(TableView table, BooleanProperty isFirstColumn, StringBuffer sb, SearchResult item) {
        table.getVisibleLeafColumns().forEach(tableColumn -> {
            if (!isFirstColumn.get()) {
                sb.append(csvSeparator);
            }
            isFirstColumn.set(false);
            if (tableColumn.getId() != null && item.getData().containsKey(tableColumn.getId().toUpperCase())) {
                sb.append((String)(item.getData().get(tableColumn.getId().toUpperCase()) == null ? "\"\\\"\"" : "\"" + EUFieldStyler.getObjectAsString(tableColumn.getCellData((Object)item)) + "\""));
            }
        });
        isFirstColumn.set(true);
        sb.append("\n");
    }

    private static /* synthetic */ void lambda$tableToCSVFX$2(BooleanProperty isFirstColumn, StringBuffer sb, TableColumn col) {
        if (col instanceof TableColumn && !col.getText().equals("#")) {
            TableColumn tableColumn = col;
            if (!isFirstColumn.get()) {
                sb.append(csvSeparator);
            }
            isFirstColumn.set(false);
            sb.append("\"" + tableColumn.getText() + "\"");
        }
    }

    private static /* synthetic */ void lambda$tableToCSVFX$1(AtomicReference lastTablePosition, BooleanProperty isFirstColumn, StringBuffer sb, TablePosition tablePosition) {
        if (tablePosition.getTableColumn().getId() != null) {
            if (lastTablePosition.get() != null && ((TablePosition)lastTablePosition.get()).getRow() != tablePosition.getRow()) {
                isFirstColumn.set(true);
                sb.append("\n");
            }
            TableColumn tableColumn = tablePosition.getTableColumn();
            if (!isFirstColumn.get()) {
                sb.append(csvSeparator);
            }
            isFirstColumn.set(false);
            if (tableColumn != null && tableColumn.getId() != null) {
                sb.append((String)(tableColumn.getCellData(tablePosition.getRow()) == null ? "\"\\\"\"" : "\"" + EUFieldStyler.getObjectAsString(tableColumn.getCellData(tablePosition.getRow())) + "\""));
            }
            lastTablePosition.set(tablePosition);
        }
    }
}

