/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.util;

import de.effectivecompany.base.datatypes.EFCCalMonth;
import de.effectivecompany.base.datatypes.EFCCalWeek;
import de.effectivecompany.base.datatypes.EFCDate;
import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.base.datatypes.EFCFloat;
import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.base.datatypes.EFCLong;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import de.effectivecompany.gui.util.EUFieldStyler;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EUCellStyler
extends EUFieldStyler {
    private static Logger logger = LoggerFactory.getLogger(EUCellStyler.class);
    private static EUCellStyler instance = new EUCellStyler();

    protected EUCellStyler() {
        DecimalFormatSymbols formatSymbols;
        this.numberFormat = (DecimalFormat)DecimalFormat.getInstance().clone();
        this.numberFormat.setMinimumFractionDigits(2);
        this.numberFormat.setMaximumFractionDigits(2);
        EFCPanelSingleton.getInstance();
        if (EFCPanelSingleton.DECIMAL_SEPARATOR != null) {
            formatSymbols = this.numberFormat.getDecimalFormatSymbols();
            formatSymbols.setDecimalSeparator(EFCPanelSingleton.DECIMAL_SEPARATOR.charValue());
            this.numberFormat.setDecimalFormatSymbols(formatSymbols);
        }
        if (EFCPanelSingleton.GROUPING_SEPARATOR != null) {
            formatSymbols = this.numberFormat.getDecimalFormatSymbols();
            formatSymbols.setGroupingSeparator(EFCPanelSingleton.GROUPING_SEPARATOR.charValue());
            this.numberFormat.setDecimalFormatSymbols(formatSymbols);
        }
    }

    public static EUCellStyler getInstance() {
        return instance;
    }

    public static void styleCellComponent(Component component, Object value) {
        if (component instanceof JLabel) {
            ((JLabel)component).setText(EUCellStyler.getObjectAsString(value));
            ((JLabel)component).setHorizontalAlignment(2);
        }
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setText(EUCellStyler.getObjectAsString(value));
        }
        if (value instanceof EFCInteger || value instanceof EFCLong || value instanceof EFCFloat || value instanceof Number) {
            if (component instanceof JLabel) {
                ((JLabel)component).setHorizontalAlignment(4);
            } else {
                logger.debug("unhandled component: {}", (Object)component.getClass().getSimpleName());
            }
        }
        if (value instanceof EFCDate || value instanceof Date || value instanceof EFCDateTime || value instanceof EFCCalWeek || value instanceof EFCCalMonth) {
            if (component instanceof JLabel) {
                ((JLabel)component).setHorizontalAlignment(0);
            } else {
                logger.debug("unhandled component: ", (Object)component.getClass().getSimpleName());
            }
        }
    }
}

