/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.websocket;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.effectivecompany.app.doc.DcCooStatus;
import de.effectivecompany.app.invcdn.DcJhrCdnChanged;
import de.effectivecompany.app.prd.DcPrdOprStatus;
import de.effectivecompany.app.prd.DcPrdQuantity;
import de.effectivecompany.app.prd.DcPrdResStatus;
import de.effectivecompany.app.sys.DcShutdownReminder;
import de.effectivecompany.app.sys.ProgressMsg;
import de.effectivecompany.app.sys.SystemMsg;
import de.effectivecompany.app.sys.TextMsg;
import de.effectivecompany.app.syswfl.ActivitiChanged;
import de.effectivecompany.base.efcbl.error.ApplicationException;
import de.effectivecompany.base.msg.ErrAppMsg;
import de.effectivecompany.base.msg.IMsg;
import de.effectivecompany.base.msg.Msg;
import de.effectivecompany.gui.components.root.EFCMainFrame;
import de.effectivecompany.gui.events.ActivitiChangedEvent;
import de.effectivecompany.gui.events.DcCooStatusEvent;
import de.effectivecompany.gui.events.DcJhrCdnChangedEvent;
import de.effectivecompany.gui.events.DcPrdOprStatusEvent;
import de.effectivecompany.gui.events.DcPrdQuantityEvent;
import de.effectivecompany.gui.events.DcPrdResStatusEvent;
import de.effectivecompany.gui.events.DcShutdownReminderEvent;
import de.effectivecompany.gui.events.ProgressEvent;
import de.effectivecompany.gui.events.TextMsgEvent;
import de.effectivecompany.gui.events.util.ActivitiChangedDeserializer;
import de.effectivecompany.gui.events.util.DcCooStatusDeserializer;
import de.effectivecompany.gui.events.util.DcJhrCdnChangedDeserializer;
import de.effectivecompany.gui.events.util.DcPrdOprStatusDeserializer;
import de.effectivecompany.gui.events.util.DcPrdQuantityDeserializer;
import de.effectivecompany.gui.events.util.DcPrdResStatusDeserializer;
import de.effectivecompany.gui.events.util.DcShutdownReminderDeserializer;
import de.effectivecompany.gui.events.util.EFCEventBus;
import de.effectivecompany.gui.events.util.ProgressMsgDeserializer;
import de.effectivecompany.gui.events.util.SystemMsgDeserializer;
import de.effectivecompany.gui.events.util.TextMsgDeserializer;
import de.effectivecompany.msg.Msg3;
import de.effectivecompany.progress.Progress;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompFrameHandler;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandlerAdapter;

public class EFCStompSessionHandler
extends StompSessionHandlerAdapter {
    private static Logger logger = LoggerFactory.getLogger(EFCStompSessionHandler.class);
    private ObjectMapper mapper = new ObjectMapper();
    private SimpleModule module = new SimpleModule();
    private CountDownLatch latch;
    private StompSession.Subscription subscription;

    public EFCStompSessionHandler(CountDownLatch latch) {
        this.latch = latch;
        this.module.addDeserializer(ActivitiChanged.class, (JsonDeserializer)new ActivitiChangedDeserializer());
        this.module.addDeserializer(SystemMsg.class, (JsonDeserializer)new SystemMsgDeserializer());
        this.module.addDeserializer(DcJhrCdnChanged.class, (JsonDeserializer)new DcJhrCdnChangedDeserializer());
        this.module.addDeserializer(ProgressMsg.class, (JsonDeserializer)new ProgressMsgDeserializer());
        this.module.addDeserializer(TextMsg.class, (JsonDeserializer)new TextMsgDeserializer());
        this.module.addDeserializer(DcShutdownReminder.class, (JsonDeserializer)new DcShutdownReminderDeserializer());
        this.module.addDeserializer(DcPrdQuantity.class, (JsonDeserializer)new DcPrdQuantityDeserializer());
        this.module.addDeserializer(DcPrdResStatus.class, (JsonDeserializer)new DcPrdResStatusDeserializer());
        this.module.addDeserializer(DcPrdOprStatus.class, (JsonDeserializer)new DcPrdOprStatusDeserializer());
        this.module.addDeserializer(DcCooStatus.class, (JsonDeserializer)new DcCooStatusDeserializer());
        this.mapper.registerModule((Module)this.module);
    }

    public void afterConnected(StompSession session, StompHeaders connectedHeaders) {
        this.subscribeTo(session);
    }

    private void subscribeTo(StompSession session) {
        StompHeaders headers = new StompHeaders();
        headers.add("destination", "system_message");
        String currentUser = "";
        try {
            currentUser = EFCMainFrame.getInstance().getPanel().getSysInfo().getEfcUserName().getData();
        }
        catch (Exception e) {
            logger.error("createProgress: no user logged in???");
            throw new ApplicationException((Msg)new ErrAppMsg((IMsg)new Msg3(Arrays.asList("No user logged in"))));
        }
        String selector = "(efcUser = '" + currentUser + "' OR efcUser = '' OR efcUser is null) AND (systextmsgtarget = '20' OR systextmsgtarget = '10' OR systextmsgtarget IS NULL)";
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            selector = selector + " AND (resource = '" + hostName + "' OR resource IS NULL)";
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        headers.add("selector", selector);
        this.subscription = session.subscribe(headers, new StompFrameHandler(){

            public Type getPayloadType(StompHeaders stompHeaders) {
                return String.class;
            }

            public void handleFrame(StompHeaders stompHeaders, Object payload) {
                String msg = (String)payload;
                if (msg != null && msg.length() > 0) {
                    try {
                        JsonNode rootNode = (JsonNode)EFCStompSessionHandler.this.mapper.readValue(msg, JsonNode.class);
                        String msgId = rootNode.get("_msgID_").textValue();
                        if (msgId != null) {
                            switch (msgId) {
                                case "ACTIVITICHANGED": {
                                    ActivitiChanged ac = (ActivitiChanged)EFCStompSessionHandler.this.mapper.readValue(msg, ActivitiChanged.class);
                                    ActivitiChangedEvent event = new ActivitiChangedEvent();
                                    event.setData(ac);
                                    EFCEventBus.getInstance().post(event);
                                    break;
                                }
                                case "TEXTMSG": {
                                    TextMsg textMsg = (TextMsg)EFCStompSessionHandler.this.mapper.readValue(msg, TextMsg.class);
                                    TextMsgEvent textMsgEvt = new TextMsgEvent();
                                    textMsgEvt.setData(textMsg);
                                    EFCEventBus.getInstance().post(textMsgEvt);
                                    break;
                                }
                                case "DCSHUTDOWNREMINDER": {
                                    DcShutdownReminder dcShutdownReminder = (DcShutdownReminder)EFCStompSessionHandler.this.mapper.readValue(msg, DcShutdownReminder.class);
                                    DcShutdownReminderEvent dcShutdownReminderEvt = new DcShutdownReminderEvent();
                                    dcShutdownReminderEvt.setData(dcShutdownReminder);
                                    EFCEventBus.getInstance().post(dcShutdownReminderEvt);
                                    break;
                                }
                                case "DCJHRCDNCHANGED": {
                                    DcJhrCdnChanged jcc = (DcJhrCdnChanged)EFCStompSessionHandler.this.mapper.readValue(msg, DcJhrCdnChanged.class);
                                    DcJhrCdnChangedEvent jccevent = new DcJhrCdnChangedEvent();
                                    jccevent.setData(jcc);
                                    EFCEventBus.getInstance().post(jccevent);
                                    break;
                                }
                                case "SYSTEMMSG": {
                                    SystemMsg sc = (SystemMsg)EFCStompSessionHandler.this.mapper.readValue(msg, SystemMsg.class);
                                    if (sc.getMsgType() == null || sc.getMsgType().getData() != 10) break;
                                    logger.info("Server shutdown received, we have to kill the client.");
                                    EFCMainFrame.getInstance().terminate();
                                    break;
                                }
                                case "PROGRESSMSG": {
                                    ProgressMsg progMsg = (ProgressMsg)EFCStompSessionHandler.this.mapper.readValue(msg, ProgressMsg.class);
                                    ProgressEvent progEvent = new ProgressEvent();
                                    progEvent.setProgress(new Progress(progMsg.getMsgId().toLong(), progMsg.getMsg().getData(), progMsg.getProgress().getData().doubleValue(), progMsg.getUser().getData(), progMsg.getIsFinished().getData().booleanValue()));
                                    EFCEventBus.getInstance().post(progEvent);
                                    break;
                                }
                                case "DCPRDRESSTATUS": {
                                    DcPrdResStatus dcPrdResStatusMsg = (DcPrdResStatus)EFCStompSessionHandler.this.mapper.readValue(msg, DcPrdResStatus.class);
                                    DcPrdResStatusEvent dcPrdResStatusEvent = new DcPrdResStatusEvent(dcPrdResStatusMsg);
                                    EFCEventBus.getInstance().post(dcPrdResStatusEvent);
                                    break;
                                }
                                case "DCPRDQUANTITY": {
                                    DcPrdQuantity dcPrdQuantityMsg = (DcPrdQuantity)EFCStompSessionHandler.this.mapper.readValue(msg, DcPrdQuantity.class);
                                    DcPrdQuantityEvent dcPrdQuantityEvent = new DcPrdQuantityEvent(dcPrdQuantityMsg);
                                    EFCEventBus.getInstance().post(dcPrdQuantityEvent);
                                    break;
                                }
                                case "DCPRDOPRSTATUS": {
                                    DcPrdOprStatus dcPrdOprStatus = (DcPrdOprStatus)EFCStompSessionHandler.this.mapper.readValue(msg, DcPrdOprStatus.class);
                                    DcPrdOprStatusEvent dcPrdOprStatusEvent = new DcPrdOprStatusEvent(dcPrdOprStatus);
                                    EFCEventBus.getInstance().post(dcPrdOprStatusEvent);
                                    break;
                                }
                                case "DCCOOSTATUS": {
                                    DcCooStatus dcCooStatus = (DcCooStatus)EFCStompSessionHandler.this.mapper.readValue(msg, DcCooStatus.class);
                                    DcCooStatusEvent dcCooStatusEvent = new DcCooStatusEvent(dcCooStatus);
                                    EFCEventBus.getInstance().post(dcCooStatusEvent);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("EFC message error: ", (Throwable)e);
                    }
                }
            }
        });
        logger.info("Subscribed to message bus.");
    }

    public void handleException(StompSession session, StompCommand command, StompHeaders headers, byte[] payload, Throwable exception) {
        logger.error("STOMP Session handling error: ", exception);
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
        this.latch.countDown();
    }

    public void handleTransportError(StompSession session, Throwable exception) {
        logger.error("STOMP Session transport handling error: ", exception);
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
        this.latch.countDown();
    }

    public void unsubscribe() {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
        }
    }
}

