/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.frame;

import de.effectivecompany.app.app.service.SvSysMail;
import de.effectivecompany.app.sys.BoSysMail;
import de.effectivecompany.app.sys.BoSysMailBase;
import de.effectivecompany.app.sys.DcSysMailAddress;
import de.effectivecompany.app.sys.DcSysMailAttachmentEntry;
import de.effectivecompany.base.datatypes.EFCBlob;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.EFCBaseDialog;
import de.effectivecompany.gui.components.EFCBaseFrame;
import de.effectivecompany.gui.components.panel.EFCPDFViewerPanel;
import de.effectivecompany.gui.components.panel.EFCTabPanel;
import de.effectivecompany.gui.constants.EFCAction;
import de.effectivecompany.gui.factory.EFCViewerFactory;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.Dimension;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class EFCMailViewer
extends EFCBaseDialog {
    private SvSysMail svSysMail = (SvSysMail)SpringHelper.getService(SvSysMail.class);

    public EFCMailViewer(EFCBaseFrame parent, Class<? extends BusinessObject> boClass, Map<String, Object> launchParam, EFCBlob data) {
        super(parent, Translator.tr((String)"DLG_TITLE_SYSMAILVIEWER"), "sys/BoSysMail_Viewer.xml", EFCAction.M_NO_MENU, new Dimension(750, 500), boClass, true);
        this.viewManager.getTablePanel("attachedFiles").setEmptySelectionAllowed(true);
        this.viewManager.getTablePanel("attachedFiles").setSelectedIndex(-1);
        EFCThreadUtil.edtBuilder(th -> th.doOutside(() -> {
            BoSysMail mail = this.svSysMail.getBoSysMailForEML(data);
            this.checkTO(mail);
            this.checkCC(mail);
            this.checkBCC(mail);
            this.updateFields((BusinessObject)mail);
        }));
    }

    public void initPDFPreview(EFCBlob pdf) {
        JPanel panel;
        if (pdf != null && pdf.getData() != null && (panel = this.viewManager.getPanel("pdfpreview")) instanceof EFCPDFViewerPanel) {
            EFCPDFViewerPanel pdfviewer = (EFCPDFViewerPanel)panel;
            pdfviewer.initDoc(pdf);
        }
    }

    @Override
    public void execute(BusinessObject input, List<String> options) {
        this.checkTO((BoSysMail)input);
        this.checkCC((BoSysMail)input);
        this.checkBCC((BoSysMail)input);
        super.execute(input, options);
    }

    public BoSysMail getBusObj() {
        return (BoSysMail)super.getBusObj();
    }

    @Override
    public void handleTableSelectionChanged(String tableIdent, String columnName, BusinessObject selectedObject) {
        super.handleTableSelectionChanged(tableIdent, columnName, selectedObject);
        switch (tableIdent) {
            case "attachedFiles": {
                if (!(selectedObject instanceof DcSysMailAttachmentEntry)) break;
                DcSysMailAttachmentEntry entry = (DcSysMailAttachmentEntry)selectedObject;
                EFCThreadUtil.edtBuilder(th -> th.doOutside(() -> {
                    EFCBlob blob = this.svSysMail.getAttachmentForPreview(entry);
                    th.edt(() -> {
                        JPanel panel = this.viewManager.getPanel("tab_preview");
                        if (panel instanceof EFCTabPanel) {
                            ((EFCTabPanel)panel).getTabEntity("tp_preview").setComponent((JComponent)EFCViewerFactory.createPanel((String)entry.getFilename().getData(), (EFCBlob)blob));
                            ((EFCTabPanel)panel).updatePane();
                        }
                    });
                }));
            }
        }
    }

    private void checkTO(BoSysMail bo) {
        if (bo != null && !bo.getToList().isEmpty()) {
            bo.setTo(((DcSysMailAddress)bo.getToList().get(0)).getAddress());
            this.updateFields((BusinessObject)bo);
        }
    }

    private void checkCC(BoSysMail bo) {
        if (bo != null && !bo.getCcList().isEmpty()) {
            bo.setCc(((DcSysMailAddress)bo.getCcList().get(0)).getAddress());
            this.updateFields((BusinessObject)bo);
        }
    }

    private void checkBCC(BoSysMail bo) {
        if (bo != null && !bo.getBccList().isEmpty()) {
            bo.setBcc(((DcSysMailAddress)bo.getBccList().get(0)).getAddress());
            this.updateFields((BusinessObject)bo);
        }
    }

    @Override
    protected void onElementDataChanged(String ident, Object oldval, Object newval) {
        super.onElementDataChanged(ident, oldval, newval);
        switch (ident) {
            case "toList.address": {
                this.checkTO(this.getBusObj());
                break;
            }
            case "ccList.address": {
                this.checkCC(this.getBusObj());
                break;
            }
            case "bccList.address": {
                this.checkBCC(this.getBusObj());
            }
        }
    }

    private void checkTO(BoSysMailBase bo) {
        if (bo != null && !bo.getToList().isEmpty()) {
            bo.setTo(((DcSysMailAddress)bo.getToList().get(0)).getAddress());
            this.updateFields((BusinessObject)bo);
        }
    }

    private void checkCC(BoSysMailBase bo) {
        if (bo != null && !bo.getCcList().isEmpty()) {
            bo.setCc(((DcSysMailAddress)bo.getCcList().get(0)).getAddress());
            this.updateFields((BusinessObject)bo);
        }
    }

    private void checkBCC(BoSysMailBase bo) {
        if (bo != null && !bo.getBccList().isEmpty()) {
            bo.setBcc(((DcSysMailAddress)bo.getBccList().get(0)).getAddress());
            this.updateFields((BusinessObject)bo);
        }
    }

    @Override
    protected void terminate() {
        super.terminate();
    }
}

