/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.frame;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import de.effectivecompany.app.rou.MdRouRes;
import de.effectivecompany.app.rou.service.SvMdRouRes;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.msg.MsgType;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.client.forms.sst.FrSoRpt;
import de.effectivecompany.client.serial.EFCSerial;
import de.effectivecompany.gui.actions.EFCActionExit;
import de.effectivecompany.gui.actions.EFCAdditionalAction;
import de.effectivecompany.gui.components.EFCBaseFrame;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.editor.EFCAbstractAlphaNumericEditor;
import de.effectivecompany.gui.components.editor.EFCAbstractNumberEditor;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.components.editor.EFCAbstractTextEditor;
import de.effectivecompany.gui.components.editor.EFCBooleanEditor;
import de.effectivecompany.gui.components.editor.EFCDateEditor;
import de.effectivecompany.gui.components.editor.EFCDateTimeEditor;
import de.effectivecompany.gui.components.editor.EFCObjectListEditor;
import de.effectivecompany.gui.components.fx.EFCFxButton;
import de.effectivecompany.gui.components.panel.EFCBOTablePanel;
import de.effectivecompany.gui.components.panel.EFCFormPanel;
import de.effectivecompany.gui.components.panel.EFCKeyboardPanel;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.panel.EFCTabPanel;
import de.effectivecompany.gui.components.swing.DefaultTableCellHeaderRenderer;
import de.effectivecompany.gui.components.swing.EFCNumberTableCellRenderer;
import de.effectivecompany.gui.components.swing.EFCTableCellRenderer;
import de.effectivecompany.gui.components.table.EFCNumberTable;
import de.effectivecompany.gui.constants.EFCAction;
import de.effectivecompany.gui.enums.EFCWindowMode;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import groovy.lang.Closure;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTitledSeparator;

public abstract class EFCTerminalFrame
extends EFCBaseFrame {
    private EFCPanel contentPanel;
    private JPanel basePanel;
    protected Double sizeMultiplier;
    private JFXPanel topPanel;
    private HBox topHbox;
    private EFCAdditionalAction action1;
    private EFCAdditionalAction action2;
    private EFCAdditionalAction action3;
    private EFCAdditionalAction action4;
    private EFCAdditionalAction action5;
    private EFCAdditionalAction action6;
    private EFCAdditionalAction action7;
    private EFCAdditionalAction action8;
    private EFCAdditionalAction action9;
    private EFCAdditionalAction action10;
    private EFCAdditionalAction action11;
    private EFCAdditionalAction action12;
    private JButton button1;
    private JButton button2;
    private JButton button3;
    private JButton button4;
    private JButton button5;
    private JButton button6;
    private JButton button7;
    private JButton button8;
    private JButton button9;
    private JButton button10;
    private JButton button11;
    private JButton button12;
    private EFCActionExit actionExit;
    protected ArrayList<String> xciEventIdents = new ArrayList();
    private SvMdRouRes svMdRouRes = (SvMdRouRes)SpringHelper.getService(SvMdRouRes.class);
    protected EFCSerial serialPort;

    public EFCTerminalFrame(EFCController parent, String title, String mainService, Class<?> mainClass, String mainLayout, Map<String, Object> param, ArrayList<String> actionIdents) {
        this(parent, title, (EnumSet<EFCAction>)EFCAction.M_NO_MENU, EFCLookAndFeelManager.SIZE_FRAME_STANDARD, mainService, mainClass, mainLayout, param, actionIdents);
    }

    public EFCTerminalFrame(EFCController parent, String title, EnumSet<EFCAction> menu, Dimension dimension, String mainService, Class<?> mainClass, String mainLayout, Map<String, Object> param, ArrayList<String> actionIdents) {
        super(parent, title, menu, dimension, mainService, param);
        MdRouRes serialMdRoures;
        this.setFrameIcon(EFCLookAndFeelManager.ICON_APP_TERMINAL);
        if (param.containsKey("SIZE")) {
            try {
                this.sizeMultiplier = Double.parseDouble(param.get("SIZE").toString());
            }
            catch (NumberFormatException nfex) {
                this.logger.warn("PARAM SIZE not parsable -> default size 1.0 ");
                this.sizeMultiplier = 1.0;
            }
        } else {
            this.sizeMultiplier = this instanceof FrSoRpt ? Double.valueOf(1.0) : Double.valueOf(1.5);
        }
        if (this.launchParam != null && this.launchParam.containsKey("PRINTLISTID")) {
            this.logger.error("Der Parameter PRINTLISTID ist 'deprecated' - PRNGRP benutzen!");
            this.setPrintListId((String)this.launchParam.get("PRINTLISTID"));
        }
        if (this.launchParam != null && this.launchParam.containsKey("PRNGRP")) {
            this.setPrintListId((String)this.launchParam.get("PRNGRP"));
        }
        if (param.containsKey("LAYOUT")) {
            mainLayout = param.get("LAYOUT").toString();
        }
        if (param.containsKey("SERIALRES") && param.containsKey("COMPANY") && (serialMdRoures = this.svMdRouRes.getMdRouRes(param.get("COMPANY").toString(), param.get("SERIALRES").toString())) != null && serialMdRoures.getCompleteMsgList().getMaxSeverity() != MsgType.ERROR) {
            this.initSerial(serialMdRoures);
        }
        this.title = title;
        this.layoutFile = mainLayout;
        this.businessObjectClass = mainClass;
        this.basePanel = new JPanel(new BorderLayout());
        try {
            this.setBusObj((BusinessObject)mainClass.newInstance());
            this.contentPanel = EFCPanelSingleton.getInstance().generatePanel(mainLayout, mainClass, (ElementManager)this.viewManager, this.getDataChangeManager(), this.getBusinessObjectModel(), (EFCController)this);
        }
        catch (Exception ex) {
            this.reportError(ex);
        }
        this.basePanel.add((Component)this.contentPanel, "Center");
        if (param.containsKey("ACTIONIDENTS")) {
            actionIdents = new ArrayList<String>(Arrays.asList(param.get("ACTIONIDENTS").toString().split("\\|", -1)));
        }
        JPanel buttonPanel = new JPanel();
        if (!(this instanceof FrSoRpt) || actionIdents != null && actionIdents.size() > 0) {
            this.initButtonPanel(buttonPanel, actionIdents, this.sizeMultiplier);
            this.basePanel.add((Component)buttonPanel, "East");
        }
        if (param.containsKey("XCIEVENTIDENTS")) {
            this.xciEventIdents = new ArrayList<String>(Arrays.asList(param.get("XCIEVENTIDENTS").toString().split("\\|", -1)));
        }
        this.view.setMainPanel((JComponent)this.basePanel);
        this.progressDialog.dispose();
        this.progressDialog = null;
        this.setViewVisible();
        this.setWindowMode(EFCWindowMode.MODE_INFO);
        this.initSizeMultipli(this.sizeMultiplier);
        int maxWidth = 0;
        for (Component comp : buttonPanel.getComponents()) {
            if (!(comp.getMaximumSize().getWidth() > (double)maxWidth)) continue;
            maxWidth = comp.getMaximumSize().width;
        }
        for (Component comp : buttonPanel.getComponents()) {
            comp.setMaximumSize(new Dimension(maxWidth, comp.getMaximumSize().height));
        }
        if (!(this instanceof FrSoRpt)) {
            try {
                this.view.setMaximum(true);
            }
            catch (PropertyVetoException e) {
                this.handleException(e);
            }
        }
        this.view.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                EFCTerminalFrame.this.resizeTopPane();
                EFCTerminalFrame.this.view.validate();
            }
        });
        this.view.addInternalFrameListener((InternalFrameListener)new InternalFrameAdapter(){

            @Override
            public void internalFrameDeiconified(InternalFrameEvent e) {
                super.internalFrameDeiconified(e);
                EFCTerminalFrame.this.view.validate();
            }
        });
    }

    protected EFCSerial initSerial(MdRouRes mdRouRes) {
        this.serialPort = new EFCSerial(mdRouRes.getHostname().getData());
        this.logger.info("Serielle Schnittstelle f\u00fcr Resource: " + mdRouRes.getResource() + " auf Port " + mdRouRes.getHostname().getData() + " initialisiert.");
        return this.serialPort;
    }

    private void resizeTopPane() {
        if (this.topPanel != null && this.topHbox != null && this.view != null) {
            int height = (int)(this.view.getContentPane().getSize().getHeight() * 0.1 * this.sizeMultiplier);
            int width = (int)(this.view.getContentPane().getSize().getWidth() * 0.1 * this.sizeMultiplier);
            this.topHbox.setPrefHeight((double)(height - 15));
            this.topPanel.setPreferredSize(new Dimension(width, height));
            if (this.isTopButtonPaneVisible()) {
                this.setTopButtonPaneVisible(false);
                this.setTopButtonPaneVisible(true);
            }
        }
    }

    protected boolean isTopButtonPaneVisible() {
        if (this.topPanel != null) {
            return this.topPanel.isVisible();
        }
        return false;
    }

    protected void setTopButtonPaneVisible(boolean visible) {
        if (this.topPanel != null) {
            this.topPanel.setVisible(visible);
        }
    }

    public Button addTopButton(String text, int index) {
        if (this.topHbox == null) {
            this.topPanel = new JFXPanel();
            this.topHbox = new HBox();
            this.topHbox.setFillHeight(true);
            ScrollPane topScroll = new ScrollPane((Node)this.topHbox);
            topScroll.setHbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
            BorderPane topBorder = new BorderPane((Node)topScroll);
            Button buttonScrollLeft = new Button("<");
            buttonScrollLeft.setMaxHeight(Double.MAX_VALUE);
            buttonScrollLeft.setMaxWidth(Double.MAX_VALUE);
            buttonScrollLeft.setPrefWidth(100.0);
            buttonScrollLeft.setAlignment(Pos.CENTER);
            buttonScrollLeft.setStyle(".arrow-button");
            buttonScrollLeft.prefHeightProperty().bindBidirectional((Property)this.topHbox.prefHeightProperty());
            Button buttonScrollRight = new Button(">");
            buttonScrollRight.setMaxHeight(Double.MAX_VALUE);
            buttonScrollRight.setMaxWidth(Double.MAX_VALUE);
            buttonScrollRight.setAlignment(Pos.CENTER);
            buttonScrollRight.setPrefWidth(100.0);
            buttonScrollRight.prefHeightProperty().bindBidirectional((Property)this.topHbox.prefHeightProperty());
            topBorder.setLeft((Node)buttonScrollLeft);
            topBorder.setRight((Node)buttonScrollRight);
            buttonScrollLeft.setOnAction(e -> topScroll.setHvalue(topScroll.getHvalue() - 0.05));
            buttonScrollRight.setOnAction(e -> topScroll.setHvalue(topScroll.getHvalue() + 0.05));
            this.topPanel.setScene(new Scene((Parent)topBorder));
            this.resizeTopPane();
            this.basePanel.add((Component)this.topPanel, "North");
        }
        final EFCFxButton button = new EFCFxButton(text, String.valueOf(index), null, null);
        button.setAlignment(Pos.CENTER);
        button.setMaxHeight(Double.MAX_VALUE);
        button.setMaxWidth(Double.MAX_VALUE);
        button.setPrefWidth(100.0 * this.sizeMultiplier);
        button.setFont(javafx.scene.text.Font.font((String)EFCLookAndFeelManager.FONT_EFC_STANDARD.getFontName(), (FontWeight)FontWeight.NORMAL, (double)((int)((double)EFCLookAndFeelManager.FONT_EFC_STANDARD.getSize() * this.sizeMultiplier))));
        button.setTextAlignment(TextAlignment.CENTER);
        button.prefHeightProperty().bindBidirectional((Property)this.topHbox.prefHeightProperty());
        button.setOnAction(e -> this.handleTopButtonAction(Integer.valueOf(((EFCFxButton)e.getSource()).getId())));
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EFCTerminalFrame.this.topHbox.getChildren().add((Object)button);
            }
        });
        return button;
    }

    protected void handleTopButtonAction(Integer index) {
    }

    protected void loadLayout(String mainLayout, Class<? extends BusinessObject> objectclass) {
        try {
            this.viewManager.resetForLayout();
            this.basePanel.remove((Component)this.contentPanel);
            BusinessObject currentBO = this.getBusObj();
            this.setBusObj((BusinessObject)this.businessObjectClass.newInstance());
            this.contentPanel = EFCPanelSingleton.getInstance().generatePanel(mainLayout, this.businessObjectClass, (ElementManager)this.viewManager, this.getDataChangeManager(), this.getBusinessObjectModel(), (EFCController)this);
            this.basePanel.add((Component)this.contentPanel, "Center");
            this.view.setMainPanel((JComponent)this.basePanel);
            this.initSizeMultipli(this.sizeMultiplier);
            this.layoutFile = mainLayout;
            this.setWindowMode(this.getWindowMode());
            this.setBusObj(currentBO);
            this.initLayoutInfo();
        }
        catch (Exception ex) {
            this.reportError(ex);
        }
    }

    protected abstract void onAction1();

    protected abstract void onAction2();

    protected abstract void onAction3();

    protected abstract void onAction4();

    protected abstract void onAction5();

    protected abstract void onAction6();

    protected abstract void onAction7();

    protected abstract void onAction8();

    protected abstract void onAction9();

    protected abstract void onAction10();

    protected abstract void onAction11();

    protected abstract void onAction12();

    protected void action1() {
        this.handleOutside(new Closure[]{new Closure<Void>((Object)this){
            private static final long serialVersionUID = 1L;

            public Void call(Object ... args) {
                EFCTerminalFrame.this.onAction1();
                return null;
            }
        }});
    }

    protected void action2() {
        this.handleOutside(new Closure[]{new Closure<Void>((Object)this){
            private static final long serialVersionUID = 1L;

            public Void call(Object ... args) {
                EFCTerminalFrame.this.onAction2();
                return null;
            }
        }});
    }

    protected void action3() {
        this.handleOutside(new Closure[]{new Closure<Void>((Object)this){
            private static final long serialVersionUID = 1L;

            public Void call(Object ... args) {
                EFCTerminalFrame.this.onAction3();
                return null;
            }
        }});
    }

    protected void action4() {
        this.handleOutside(new Closure[]{new Closure<Void>((Object)this){
            private static final long serialVersionUID = 1L;

            public Void call(Object ... args) {
                EFCTerminalFrame.this.onAction4();
                return null;
            }
        }});
    }

    protected void action5() {
        this.handleOutside(new Closure[]{new Closure<Void>((Object)this){
            private static final long serialVersionUID = 1L;

            public Void call(Object ... args) {
                EFCTerminalFrame.this.onAction5();
                return null;
            }
        }});
    }

    protected void action6() {
        this.handleOutside(new Closure[]{new Closure<Void>((Object)this){
            private static final long serialVersionUID = 1L;

            public Void call(Object ... args) {
                EFCTerminalFrame.this.onAction6();
                return null;
            }
        }});
    }

    protected void action7() {
        this.handleOutside(new Closure[]{new Closure<Void>((Object)this){
            private static final long serialVersionUID = 1L;

            public Void call(Object ... args) {
                EFCTerminalFrame.this.onAction7();
                return null;
            }
        }});
    }

    protected void action8() {
        this.handleOutside(new Closure[]{new Closure<Void>((Object)this){
            private static final long serialVersionUID = 1L;

            public Void call(Object ... args) {
                EFCTerminalFrame.this.onAction8();
                return null;
            }
        }});
    }

    protected void action9() {
        this.handleOutside(new Closure[]{new Closure<Void>((Object)this){
            private static final long serialVersionUID = 1L;

            public Void call(Object ... args) {
                EFCTerminalFrame.this.onAction9();
                return null;
            }
        }});
    }

    protected void action10() {
        this.handleOutside(new Closure[]{new Closure<Void>((Object)this){
            private static final long serialVersionUID = 1L;

            public Void call(Object ... args) {
                EFCTerminalFrame.this.onAction10();
                return null;
            }
        }});
    }

    protected void action11() {
        this.handleOutside(new Closure[]{new Closure<Void>((Object)this){
            private static final long serialVersionUID = 1L;

            public Void call(Object ... args) {
                EFCTerminalFrame.this.onAction11();
                return null;
            }
        }});
    }

    protected void action12() {
        this.handleOutside(new Closure[]{new Closure<Void>((Object)this){
            private static final long serialVersionUID = 1L;

            public Void call(Object ... args) {
                EFCTerminalFrame.this.onAction12();
                return null;
            }
        }});
    }

    public EFCAdditionalAction getAction1() {
        return this.action1;
    }

    public EFCAdditionalAction getAction2() {
        return this.action2;
    }

    public EFCAdditionalAction getAction3() {
        return this.action3;
    }

    public EFCAdditionalAction getAction4() {
        return this.action4;
    }

    public EFCAdditionalAction getAction5() {
        return this.action5;
    }

    public EFCAdditionalAction getAction6() {
        return this.action6;
    }

    public EFCAdditionalAction getAction7() {
        return this.action7;
    }

    public EFCAdditionalAction getAction8() {
        return this.action8;
    }

    public EFCAdditionalAction getAction9() {
        return this.action9;
    }

    public EFCAdditionalAction getAction10() {
        return this.action10;
    }

    public EFCAdditionalAction getAction11() {
        return this.action11;
    }

    public EFCAdditionalAction getAction12() {
        return this.action12;
    }

    public JButton getButton1() {
        return this.button1;
    }

    public JButton getButton2() {
        return this.button2;
    }

    public JButton getButton3() {
        return this.button3;
    }

    public JButton getButton4() {
        return this.button4;
    }

    public JButton getButton5() {
        return this.button5;
    }

    public JButton getButton6() {
        return this.button6;
    }

    public JButton getButton7() {
        return this.button7;
    }

    public JButton getButton8() {
        return this.button8;
    }

    public JButton getButton9() {
        return this.button9;
    }

    public JButton getButton10() {
        return this.button10;
    }

    public JButton getButton11() {
        return this.button11;
    }

    public JButton getButton12() {
        return this.button12;
    }

    @Override
    public void handleAction(String ident, Object param) {
        if (this.action1 != null && this.action1.getIdent().equals(ident)) {
            this.action1();
        } else if (this.action2 != null && this.action2.getIdent().equals(ident)) {
            this.action2();
        } else if (this.action3 != null && this.action3.getIdent().equals(ident)) {
            this.action3();
        } else if (this.action4 != null && this.action4.getIdent().equals(ident)) {
            this.action4();
        } else if (this.action5 != null && this.action5.getIdent().equals(ident)) {
            this.action5();
        } else if (this.action6 != null && this.action6.getIdent().equals(ident)) {
            this.action6();
        } else if (this.action7 != null && this.action7.getIdent().equals(ident)) {
            this.action7();
        } else if (this.action8 != null && this.action8.getIdent().equals(ident)) {
            this.action8();
        } else if (this.action9 != null && this.action9.getIdent().equals(ident)) {
            this.action9();
        } else if (this.action10 != null && this.action10.getIdent().equals(ident)) {
            this.action10();
        } else if (this.action11 != null && this.action11.getIdent().equals(ident)) {
            this.action11();
        } else if (this.action12 != null && this.action12.getIdent().equals(ident)) {
            this.action12();
        }
        super.handleAction(ident, param);
    }

    private void initButtonPanel(JPanel buttonPanel, ArrayList<String> actionIdents, Double sizeMultiplier) {
        BoxLayout boxLayout = new BoxLayout(buttonPanel, 1);
        buttonPanel.setLayout(boxLayout);
        Font buttonFont = EFCLookAndFeelManager.FONT_EFC_STANDARD.deriveFont((float)((double)EFCLookAndFeelManager.FONT_EFC_STANDARD.getSize() * sizeMultiplier));
        buttonPanel.add(Box.createVerticalGlue());
        block14: for (int i = 0; i < actionIdents.size(); ++i) {
            if (actionIdents.get(i) == null || actionIdents.get(i).isEmpty()) {
                buttonPanel.add(Box.createVerticalGlue());
                continue;
            }
            switch (i) {
                case 0: {
                    this.action1 = new EFCAdditionalAction(actionIdents.get(i), actionIdents.get(i));
                    this.action1.putValue("AcceleratorKey", (Object)KeyStroke.getAWTKeyStroke(112, 0));
                    this.action1.setActionHandler(this.viewManager.getActionHandler());
                    this.button1 = new JButton((Action)this.action1);
                    this.button1.setFont(buttonFont);
                    this.button1.getActionMap().put(this.action1.getIdent(), (Action)this.action1);
                    this.button1.getInputMap(2).put((KeyStroke)this.action1.getValue("AcceleratorKey"), this.action1.getIdent());
                    this.button1.setHorizontalAlignment(2);
                    this.button1.setText(KeyEvent.getKeyText(112) + " - " + this.button1.getText());
                    buttonPanel.add(this.button1);
                    buttonPanel.add(Box.createVerticalGlue());
                    continue block14;
                }
                case 1: {
                    this.action2 = new EFCAdditionalAction(actionIdents.get(i), actionIdents.get(i));
                    this.action2.putValue("AcceleratorKey", (Object)KeyStroke.getAWTKeyStroke(113, 0));
                    this.action2.setActionHandler(this.viewManager.getActionHandler());
                    this.button2 = new JButton((Action)this.action2);
                    this.button2.setFont(buttonFont);
                    this.button2.getActionMap().put(this.action2.getIdent(), (Action)this.action2);
                    this.button2.getInputMap(2).put((KeyStroke)this.action2.getValue("AcceleratorKey"), this.action2.getIdent());
                    this.button2.setHorizontalAlignment(2);
                    this.button2.setText(KeyEvent.getKeyText(113) + " - " + this.button2.getText());
                    buttonPanel.add(this.button2);
                    buttonPanel.add(Box.createVerticalGlue());
                    continue block14;
                }
                case 2: {
                    this.action3 = new EFCAdditionalAction(actionIdents.get(i), actionIdents.get(i));
                    this.action3.putValue("AcceleratorKey", (Object)KeyStroke.getAWTKeyStroke(114, 0));
                    this.action3.setActionHandler(this.viewManager.getActionHandler());
                    this.button3 = new JButton((Action)this.action3);
                    this.button3.setFont(buttonFont);
                    this.button3.getActionMap().put(this.action3.getIdent(), (Action)this.action3);
                    this.button3.getInputMap(2).put((KeyStroke)this.action3.getValue("AcceleratorKey"), this.action3.getIdent());
                    this.button3.setHorizontalAlignment(2);
                    this.button3.setText(KeyEvent.getKeyText(114) + " - " + this.button3.getText());
                    buttonPanel.add(this.button3);
                    buttonPanel.add(Box.createVerticalGlue());
                    continue block14;
                }
                case 3: {
                    this.action4 = new EFCAdditionalAction(actionIdents.get(i), actionIdents.get(i));
                    this.action4.putValue("AcceleratorKey", (Object)KeyStroke.getAWTKeyStroke(115, 0));
                    this.action4.setActionHandler(this.viewManager.getActionHandler());
                    this.button4 = new JButton((Action)this.action4);
                    this.button4.setFont(buttonFont);
                    this.button4.getActionMap().put(this.action4.getIdent(), (Action)this.action4);
                    this.button4.getInputMap(2).put((KeyStroke)this.action4.getValue("AcceleratorKey"), this.action4.getIdent());
                    this.button4.setHorizontalAlignment(2);
                    this.button4.setText(KeyEvent.getKeyText(115) + " - " + this.button4.getText());
                    buttonPanel.add(this.button4);
                    buttonPanel.add(Box.createVerticalGlue());
                    continue block14;
                }
                case 4: {
                    this.action5 = new EFCAdditionalAction(actionIdents.get(i), actionIdents.get(i));
                    this.action5.putValue("AcceleratorKey", (Object)KeyStroke.getAWTKeyStroke(116, 0));
                    this.action5.setActionHandler(this.viewManager.getActionHandler());
                    this.button5 = new JButton((Action)this.action5);
                    this.button5.setFont(buttonFont);
                    this.button5.getActionMap().put(this.action5.getIdent(), (Action)this.action5);
                    this.button5.getInputMap(2).put((KeyStroke)this.action5.getValue("AcceleratorKey"), this.action5.getIdent());
                    this.button5.setHorizontalAlignment(2);
                    this.button5.setText(KeyEvent.getKeyText(116) + " - " + this.button5.getText());
                    buttonPanel.add(this.button5);
                    buttonPanel.add(Box.createVerticalGlue());
                    continue block14;
                }
                case 5: {
                    this.action6 = new EFCAdditionalAction(actionIdents.get(i), actionIdents.get(i));
                    this.action6.putValue("AcceleratorKey", (Object)KeyStroke.getAWTKeyStroke(117, 0));
                    this.action6.setActionHandler(this.viewManager.getActionHandler());
                    this.button6 = new JButton((Action)this.action6);
                    this.button6.setFont(buttonFont);
                    this.button6.getActionMap().put(this.action6.getIdent(), (Action)this.action6);
                    this.button6.getInputMap(2).put((KeyStroke)this.action6.getValue("AcceleratorKey"), this.action6.getIdent());
                    this.button6.setHorizontalAlignment(2);
                    this.button6.setText(KeyEvent.getKeyText(117) + " - " + this.button6.getText());
                    buttonPanel.add(this.button6);
                    buttonPanel.add(Box.createVerticalGlue());
                    continue block14;
                }
                case 6: {
                    this.action7 = new EFCAdditionalAction(actionIdents.get(i), actionIdents.get(i));
                    this.action7.putValue("AcceleratorKey", (Object)KeyStroke.getAWTKeyStroke(118, 0));
                    this.action7.setActionHandler(this.viewManager.getActionHandler());
                    this.button7 = new JButton((Action)this.action7);
                    this.button7.setFont(buttonFont);
                    this.button7.getActionMap().put(this.action7.getIdent(), (Action)this.action7);
                    this.button7.getInputMap(2).put((KeyStroke)this.action7.getValue("AcceleratorKey"), this.action7.getIdent());
                    this.button7.setHorizontalAlignment(2);
                    this.button7.setText(KeyEvent.getKeyText(118) + " - " + this.button7.getText());
                    buttonPanel.add(this.button7);
                    buttonPanel.add(Box.createVerticalGlue());
                    continue block14;
                }
                case 7: {
                    this.action8 = new EFCAdditionalAction(actionIdents.get(i), actionIdents.get(i));
                    this.action8.putValue("AcceleratorKey", (Object)KeyStroke.getAWTKeyStroke(119, 0));
                    this.action8.setActionHandler(this.viewManager.getActionHandler());
                    this.button8 = new JButton((Action)this.action8);
                    this.button8.setFont(buttonFont);
                    this.button8.getActionMap().put(this.action8.getIdent(), (Action)this.action8);
                    this.button8.getInputMap(2).put((KeyStroke)this.action8.getValue("AcceleratorKey"), this.action8.getIdent());
                    this.button8.setHorizontalAlignment(2);
                    this.button8.setText(KeyEvent.getKeyText(119) + " - " + this.button8.getText());
                    buttonPanel.add(this.button8);
                    buttonPanel.add(Box.createVerticalGlue());
                    continue block14;
                }
                case 8: {
                    this.action9 = new EFCAdditionalAction(actionIdents.get(i), actionIdents.get(i));
                    this.action9.putValue("AcceleratorKey", (Object)KeyStroke.getAWTKeyStroke(120, 0));
                    this.action9.setActionHandler(this.viewManager.getActionHandler());
                    this.button9 = new JButton((Action)this.action9);
                    this.button9.setFont(buttonFont);
                    this.button9.getActionMap().put(this.action9.getIdent(), (Action)this.action9);
                    this.button9.getInputMap(2).put((KeyStroke)this.action9.getValue("AcceleratorKey"), this.action9.getIdent());
                    this.button9.setHorizontalAlignment(2);
                    this.button9.setText(KeyEvent.getKeyText(120) + " - " + this.button9.getText());
                    buttonPanel.add(this.button9);
                    buttonPanel.add(Box.createVerticalGlue());
                    continue block14;
                }
                case 9: {
                    this.action10 = new EFCAdditionalAction(actionIdents.get(i), actionIdents.get(i));
                    this.action10.putValue("AcceleratorKey", (Object)KeyStroke.getAWTKeyStroke(121, 0));
                    this.action10.setActionHandler(this.viewManager.getActionHandler());
                    this.button10 = new JButton((Action)this.action10);
                    this.button10.setFont(buttonFont);
                    this.button10.getActionMap().put(this.action10.getIdent(), (Action)this.action10);
                    this.button10.getInputMap(2).put((KeyStroke)this.action10.getValue("AcceleratorKey"), this.action10.getIdent());
                    this.button10.setHorizontalAlignment(2);
                    this.button10.setText(KeyEvent.getKeyText(121) + " - " + this.button10.getText());
                    buttonPanel.add(this.button10);
                    buttonPanel.add(Box.createVerticalGlue());
                    continue block14;
                }
                case 10: {
                    this.action11 = new EFCAdditionalAction(actionIdents.get(i), actionIdents.get(i));
                    this.action11.putValue("AcceleratorKey", (Object)KeyStroke.getAWTKeyStroke(122, 0));
                    this.action11.setActionHandler(this.viewManager.getActionHandler());
                    this.button11 = new JButton((Action)this.action11);
                    this.button11.setFont(buttonFont);
                    this.button11.getActionMap().put(this.action11.getIdent(), (Action)this.action11);
                    this.button11.getInputMap(2).put((KeyStroke)this.action11.getValue("AcceleratorKey"), this.action11.getIdent());
                    this.button11.setHorizontalAlignment(2);
                    this.button11.setText(KeyEvent.getKeyText(122) + " - " + this.button11.getText());
                    buttonPanel.add(this.button11);
                    buttonPanel.add(Box.createVerticalGlue());
                    continue block14;
                }
                case 11: {
                    this.action12 = new EFCAdditionalAction(actionIdents.get(i), actionIdents.get(i));
                    this.action12.putValue("AcceleratorKey", (Object)KeyStroke.getAWTKeyStroke(123, 0));
                    this.action12.setActionHandler(this.viewManager.getActionHandler());
                    this.button12 = new JButton((Action)this.action12);
                    this.button12.setFont(buttonFont);
                    this.button12.getActionMap().put(this.action12.getIdent(), (Action)this.action12);
                    this.button12.getInputMap(2).put((KeyStroke)this.action12.getValue("AcceleratorKey"), this.action12.getIdent());
                    this.button12.setHorizontalAlignment(2);
                    this.button12.setText(KeyEvent.getKeyText(123) + " - " + this.button12.getText());
                    buttonPanel.add(this.button12);
                    buttonPanel.add(Box.createVerticalGlue());
                }
            }
        }
        this.actionExit = new EFCActionExit();
        this.actionExit.setActionHandler(this.viewManager.getActionHandler());
        JButton button = new JButton((Action)this.actionExit);
        button.setFont(buttonFont);
        button.getActionMap().put("exit", (Action)this.actionExit);
        button.getInputMap(2).put((KeyStroke)this.actionExit.getValue("AcceleratorKey"), "exit");
        button.setHorizontalAlignment(2);
        button.setText(KeyEvent.getKeyText(((KeyStroke)this.actionExit.getValue("AcceleratorKey")).getKeyCode()) + " - " + button.getText());
        buttonPanel.add(button);
    }

    private void initSizeMultipli(Double sizeMultiplier) {
        if (sizeMultiplier == 1.0) {
            return;
        }
        for (JComponent comp : this.viewManager.getAllFields()) {
            if (!(comp instanceof EFCAbstractPrimaryEditor)) continue;
            EFCAbstractPrimaryEditor editor = (EFCAbstractPrimaryEditor)comp;
            if (editor.getLinkedLabel() != null) {
                editor.getLinkedLabel().setFont(editor.getLinkedLabel().getFont().deriveFont((float)((double)editor.getLinkedLabel().getFont().getSize() * sizeMultiplier)));
            }
            if (editor.getInfotextComponent() != null) {
                editor.getInfotextComponent().setFont(editor.getInfotextComponent().getFont().deriveFont((float)((double)editor.getInfotextComponent().getFont().getSize() * sizeMultiplier)));
            }
            if (editor instanceof EFCAbstractTextEditor) {
                EFCAbstractTextEditor textEditor = (EFCAbstractTextEditor)editor;
                ((EFCAbstractTextEditor)editor).getEditorComponent().setFont(((EFCAbstractTextEditor)editor).getEditorComponent().getFont().deriveFont((float)((double)((EFCAbstractTextEditor)editor).getEditorComponent().getFont().getSize() * sizeMultiplier)));
                textEditor.setColumns((int)((double)textEditor.getColumns() * sizeMultiplier));
                textEditor.setRows((int)((double)textEditor.getRows() * sizeMultiplier));
            } else if (editor instanceof EFCDateEditor) {
                EFCDateEditor dateEditor = (EFCDateEditor)editor;
                dateEditor.getDateField().setFont(dateEditor.getDateField().getFont().deriveFont((float)((double)dateEditor.getDateField().getFont().getSize() * sizeMultiplier)));
                dateEditor.getDayNameField().setFont(dateEditor.getDayNameField().getFont().deriveFont((float)((double)dateEditor.getDayNameField().getFont().getSize() * sizeMultiplier)));
            } else if (editor instanceof EFCDateTimeEditor) {
                EFCDateTimeEditor dateTimeEditor = (EFCDateTimeEditor)editor;
                dateTimeEditor.getDateField().setFont(dateTimeEditor.getDateField().getFont().deriveFont((float)((double)dateTimeEditor.getDateField().getFont().getSize() * sizeMultiplier)));
                dateTimeEditor.getDayNameField().setFont(dateTimeEditor.getDayNameField().getFont().deriveFont((float)((double)dateTimeEditor.getDayNameField().getFont().getSize() * sizeMultiplier)));
            } else if (editor instanceof EFCObjectListEditor) {
                EFCObjectListEditor objectListEditor = (EFCObjectListEditor)editor;
                objectListEditor.getEditorComponent().setFont(objectListEditor.getEditorComponent().getFont().deriveFont((float)((double)objectListEditor.getEditorComponent().getFont().getSize() * sizeMultiplier)));
            } else {
                editor.setEditorSizing((int)((double)editor.getEditorSizing() * sizeMultiplier));
                editor.reorganize();
            }
            if (editor instanceof EFCAbstractAlphaNumericEditor) {
                EFCAbstractAlphaNumericEditor stringEditor = (EFCAbstractAlphaNumericEditor)editor;
                stringEditor.getEditorComponent().setFont(stringEditor.getEditorComponent().getFont().deriveFont((float)((double)stringEditor.getEditorComponent().getFont().getSize() * sizeMultiplier)));
                continue;
            }
            if (editor instanceof EFCAbstractNumberEditor) {
                EFCAbstractNumberEditor numberEditor = (EFCAbstractNumberEditor)editor;
                numberEditor.getEditorComponent().setFont(numberEditor.getEditorComponent().getFont().deriveFont((float)((double)numberEditor.getEditorComponent().getFont().getSize() * sizeMultiplier)));
                continue;
            }
            if (!(editor instanceof EFCBooleanEditor)) continue;
            Iterator booleanEditor = (EFCBooleanEditor)editor;
            booleanEditor.getEditorComponent().setFont(booleanEditor.getEditorComponent().getFont().deriveFont((float)((double)booleanEditor.getEditorComponent().getFont().getSize() * sizeMultiplier)));
        }
        for (JComponent comp : this.viewManager.getAllPanels()) {
            if (comp instanceof EFCKeyboardPanel) {
                EFCKeyboardPanel keyBoardPanel = (EFCKeyboardPanel)comp;
                for (JButton keyButton : keyBoardPanel.getButtons()) {
                    keyButton.setFont(keyButton.getFont().deriveFont((float)((double)keyButton.getFont().getSize() * sizeMultiplier)));
                }
            }
            if (comp instanceof EFCFormPanel) {
                int size;
                String startCode;
                String code;
                ColumnSpec spec;
                int i;
                EFCFormPanel formPanel = (EFCFormPanel)comp;
                for (i = 1; i <= ((FormLayout)formPanel.getLayout()).getColumnCount(); ++i) {
                    spec = ((FormLayout)formPanel.getLayout()).getColumnSpec(i);
                    startCode = code = spec.encode();
                    if (!Pattern.matches("\\d+", code)) {
                        code = code.replaceAll("\\D+", "");
                    }
                    size = (int)((double)Integer.parseInt(code) * sizeMultiplier);
                    startCode = startCode.replaceAll("\\d+", String.valueOf(size));
                    ((FormLayout)formPanel.getLayout()).setColumnSpec(i, ColumnSpec.decode((String)startCode));
                }
                for (i = 1; i <= ((FormLayout)formPanel.getLayout()).getRowCount(); ++i) {
                    spec = ((FormLayout)formPanel.getLayout()).getRowSpec(i);
                    startCode = code = spec.encode();
                    if (!Pattern.matches("\\d+", code)) {
                        code = code.replaceAll("\\D+", "");
                    }
                    size = (int)((double)Integer.parseInt(code) * sizeMultiplier);
                    startCode = startCode.replaceAll("\\d+", String.valueOf(size));
                    ((FormLayout)formPanel.getLayout()).setRowSpec(i, RowSpec.decode((String)startCode));
                }
                for (Component compo : formPanel.getComponents()) {
                    if (compo instanceof JXTitledSeparator) {
                        compo.setFont(compo.getFont().deriveFont((float)((double)compo.getFont().getSize() * sizeMultiplier)));
                    }
                    if (!(compo instanceof JScrollPane) || !(((JScrollPane)compo).getViewport().getView() instanceof JTextArea)) continue;
                    Component view = ((JScrollPane)compo).getViewport().getView();
                    view.setFont(compo.getFont().deriveFont((float)((double)view.getFont().getSize() * sizeMultiplier)));
                }
                continue;
            }
            if (comp instanceof EFCBOTablePanel) {
                EFCBOTablePanel tablePanel = (EFCBOTablePanel)comp;
                tablePanel.setSizeColumnMulti(sizeMultiplier);
                tablePanel.getTable().setRowHeight((int)((double)tablePanel.getTable().getRowHeight() * sizeMultiplier));
                tablePanel.getTable().setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new EFCTerminalTableCellRenderer(sizeMultiplier)));
                tablePanel.getTable().getTableHeader().setDefaultRenderer((TableCellRenderer)((Object)new EFCTerminalTableHeaderCellRenderer(sizeMultiplier)));
                EFCNumberTable numberTable = tablePanel.getRowTable();
                numberTable.setRowHeight((int)((double)numberTable.getRowHeight() * sizeMultiplier));
                numberTable.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new EFCTerminalNumberTableCellRenderer(sizeMultiplier)));
                continue;
            }
            if (!(comp instanceof EFCTabPanel)) continue;
            EFCTabPanel tabPanel = (EFCTabPanel)comp;
            tabPanel.getPane().setFont(tabPanel.getFont().deriveFont((float)((double)tabPanel.getFont().getSize() * sizeMultiplier)));
        }
    }

    protected void handleListIteration(EFCBOTablePanel tablePanel, Boolean forward) {
        if (tablePanel == null) {
            return;
        }
        int idx = tablePanel.getTable().getSelectedRow();
        int rowCount = tablePanel.getTableModel().getRowCount();
        int newIndex = forward != false ? idx + 1 : idx - 1;
        if (newIndex >= rowCount) {
            newIndex = rowCount - 1;
        }
        if (newIndex < 0) {
            newIndex = 0;
        }
        if (newIndex < rowCount && newIndex != idx) {
            tablePanel.getTable().changeSelection(newIndex, 0, true, false);
        }
    }

    @Override
    protected void terminate() {
        super.terminate();
        if (this.serialPort != null) {
            this.serialPort.disconnect();
        }
    }

    private class EFCTerminalTableHeaderCellRenderer
    extends DefaultTableCellHeaderRenderer {
        private static final long serialVersionUID = -1595848532320537608L;
        private Double sizeMulti;

        public EFCTerminalTableHeaderCellRenderer(Double sizeMultiplierer) {
            this.sizeMulti = sizeMultiplierer;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setFont(component.getFont().deriveFont((float)((double)component.getFont().getSize() * this.sizeMulti)));
            return component;
        }
    }

    private class EFCTerminalNumberTableCellRenderer
    extends EFCNumberTableCellRenderer {
        private static final long serialVersionUID = -655256334507378768L;
        private Double sizeMulti;

        public EFCTerminalNumberTableCellRenderer(Double sizeMultiplierer) {
            this.sizeMulti = sizeMultiplierer;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setFont(component.getFont().deriveFont((float)((double)component.getFont().getSize() * this.sizeMulti)));
            component.setSize((int)((double)component.getSize().width * this.sizeMulti), (int)((double)component.getSize().width * this.sizeMulti));
            int height = Double.valueOf(this.getPreferredSize().getHeight()).intValue();
            if (table.getRowHeight(row) < height) {
                table.setRowHeight(row, height);
            }
            return component;
        }
    }

    private class EFCTerminalTableCellRenderer
    extends EFCTableCellRenderer {
        private static final long serialVersionUID = 930281026988422464L;
        private Double sizeMulti;

        public EFCTerminalTableCellRenderer(Double sizeMultiplierer) {
            this.sizeMulti = sizeMultiplierer;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            CompoundBorder compoundBorder;
            JComponent component = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setFont(component.getFont().deriveFont((float)((double)component.getFont().getSize() * this.sizeMulti)));
            Border border = component.getBorder();
            if (border == EFCLookAndFeelManager.TABLE_CELL_BORRDER_HIGHLIGHT && border instanceof CompoundBorder && (compoundBorder = (CompoundBorder)border).getOutsideBorder() instanceof MatteBorder) {
                MatteBorder matteBorder = (MatteBorder)compoundBorder.getOutsideBorder();
                Insets inset = EFCLookAndFeelManager.TABLE_CELL_BORRDER_OUTSIDE.getBorderInsets(component);
                Insets matInset = matteBorder.getBorderInsets(component);
                if (matInset.top != inset.top && matInset.bottom != inset.bottom) {
                    component.setBorder(new CompoundBorder(new MatteBorder((int)((double)inset.top * this.sizeMulti), (int)((double)inset.left * this.sizeMulti), (int)((double)inset.bottom * this.sizeMulti), (int)((double)inset.right * this.sizeMulti), matteBorder.getMatteColor()), EFCLookAndFeelManager.TABLE_CELL_BORRDER_INSIDE));
                }
            }
            component.setSize((int)((double)component.getSize().width * this.sizeMulti), (int)((double)component.getSize().width * this.sizeMulti));
            int height = Double.valueOf(this.getPreferredSize().getHeight()).intValue();
            if (table.getRowHeight(row) < height) {
                table.setRowHeight(row, height);
            }
            return component;
        }
    }
}

