/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.util;

import de.effectivecompany.app.app.service.SvSysDefaults;
import de.effectivecompany.app.app.service.SvSysMail;
import de.effectivecompany.app.sys.BoErrorInfo;
import de.effectivecompany.app.sys.BoSysMail;
import de.effectivecompany.app.sys.DcSysMailAddress;
import de.effectivecompany.base.datatypes.EFCBlob;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.msg.Msg;
import de.effectivecompany.base.msg.MsgType;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.data.EFCReportContainer;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.root.EFCMainFrame;
import de.effectivecompany.gui.components.swing.EFCMessageListDialog;
import de.effectivecompany.gui.frame.EFCMailDialog;
import de.effectivecompany.gui.frame.EFCMailViewer;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.Frame;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.jdesktop.swingx.error.ErrorInfo;

public class MailTools {
    private static SvSysDefaults svSysDefaults = (SvSysDefaults)SpringHelper.getService(SvSysDefaults.class);
    private static SvSysMail svSysMail = (SvSysMail)SpringHelper.getService(SvSysMail.class);

    public static void createErrorMsgMailDialog(ErrorInfo info) {
        final BoErrorInfo message = new BoErrorInfo();
        Date creationdate = new Date();
        final EFCMap contentParas = new EFCMap();
        StringWriter sw = new StringWriter();
        message.setTitle(info.getTitle());
        message.setBasicErrorMessage(info.getBasicErrorMessage());
        message.setCategory(info.getCategory());
        message.setErrorLevel(info.getErrorLevel().toString());
        message.setCreationDateInMillis(Long.valueOf(creationdate.getTime()));
        info.getErrorException().printStackTrace(new PrintWriter(sw));
        String s = sw.toString().replace("<", "&lt;");
        s = s.replace(">", "&gt;");
        s = s.replace(System.getProperty("line.separator"), "<br></br>\n");
        message.setStacktrace(s);
        new SwingWorker<EFCString, Void>(){

            @Override
            protected EFCString doInBackground() throws Exception {
                return svSysDefaults.getDefaultMailSupport();
            }

            @Override
            protected void done() {
                try {
                    EFCString mailAdress = (EFCString)this.get();
                    EFCString templateString = new EFCString(new String(svSysMail.getMailBodyErrorMsg().getData()));
                    MailTools.createMailDialog((EFCMap<EFCString, EFCString>)contentParas, null, mailAdress, templateString, new EFCString("Exception"), (BusinessObject)message);
                }
                catch (InterruptedException | ExecutionException e) {
                    EFCDesktop.reportError((Throwable)e);
                }
            }
        }.execute();
    }

    public static void createErrorMailDialog(List<Msg> messages) {
        EFCMap contentParas = new EFCMap();
        BoErrorInfo errormessagelistEntry = new BoErrorInfo();
        messages.forEach(msg -> errormessagelistEntry.getMsgList().addMsg(msg));
        long creationTimeInMillis = messages.get(0).getCreationTimeInMillis();
        contentParas.put((Object)new EFCString("creationTimeinMillis"), (Object)new EFCString(String.valueOf(creationTimeInMillis)));
        EFCThreadUtil.doLaterFAT(() -> {});
        EFCThreadUtil.builder().doOutside(th -> {
            EFCString mailAdress = svSysDefaults.getDefaultMailSupport();
            EFCString templateString = new EFCString(new String(svSysMail.getMailBodyErrorDialog().getData()));
            th.edt(() -> MailTools.createMailDialog((EFCMap<EFCString, EFCString>)contentParas, null, mailAdress, templateString, new EFCString("ErrorMessage"), (BusinessObject)errormessagelistEntry));
        });
    }

    public static void createMailViewer(EFCMap<EFCString, EFCString> contentParas, EFCBlob blob) {
        HashMap<String, Object> dlgParam = new HashMap<String, Object>();
        EFCMailViewer maildlg = new EFCMailViewer(null, BoSysMail.class, dlgParam, blob);
        maildlg.execute(null, Arrays.asList(Translator.tr((String)"_OK")));
        maildlg.dispose();
    }

    public static void createMailDialog(EFCMap<EFCString, EFCString> contentParas, EFCMap<EFCString, EFCBlob> attachments, EFCString mailToAddress, EFCString subject) {
        MailTools.createMailDialog(contentParas, attachments, mailToAddress, null, subject, new ArrayList<String>(), new ArrayList<String>(), null);
    }

    public static void createMailDialog(EFCMap<EFCString, EFCString> contentParas, EFCMap<EFCString, EFCBlob> attachments, EFCString mailToAddress) {
        MailTools.createMailDialog(contentParas, attachments, mailToAddress, null, null, new ArrayList<String>(), new ArrayList<String>(), null);
    }

    public static void createMailDialog(EFCMap<EFCString, EFCString> contentParas, EFCMap<EFCString, EFCBlob> attachments, EFCString mailToAddress, EFCString templateString, EFCString subject, BusinessObject templateBo) {
        MailTools.createMailDialog(contentParas, attachments, mailToAddress, templateString, subject, new ArrayList<String>(), new ArrayList<String>(), templateBo);
    }

    public static void createMailDialogForPrint(EFCReportContainer reportContainer, EFCString mailToAddress, EFCString templateString, EFCString subject, List<String> mailToCcList, List<String> mailToBccList) {
        MailTools.createMailDialogForPrint(reportContainer, mailToAddress, templateString, subject, mailToCcList, mailToBccList, null);
    }

    public static void createMailDialogForPrint(EFCReportContainer reportContainer, EFCString mailToAddress, EFCString templateString, EFCString subject, List<String> mailToCcList, List<String> mailToBccList, BusinessObject templateBo) {
        EFCMap conMap = new EFCMap();
        EFCMap printParams = new EFCMap();
        Object attachmentName = "Anhang";
        if (reportContainer.getParamMap() != null) {
            if (reportContainer.getParamMap().containsKey("EFC_PARAM2")) {
                attachmentName = (String)reportContainer.getParamMap().get("EFC_PARAM2");
            }
            if (reportContainer.getParamMap().containsKey("EFC_PARAM3")) {
                attachmentName = (String)attachmentName + reportContainer.getParamMap().get("EFC_PARAM3");
            }
        }
        attachmentName = (String)attachmentName + ".pdf";
        EFCMap attachments = new EFCMap();
        if (reportContainer.getEfcBlob() != null && reportContainer.getEfcBlob().getData() != null) {
            attachments.put((Object)new EFCString((String)attachmentName), (Object)reportContainer.getEfcBlob());
        }
        reportContainer.getParamMap().entrySet().forEach(entry -> {
            if (entry.getValue() != null) {
                printParams.put((Object)new EFCString((String)entry.getKey()), (Object)new EFCString(String.valueOf(entry.getValue())));
            }
        });
        MailTools.createMailDialog((EFCMap<EFCString, EFCString>)conMap, (EFCMap<EFCString, EFCBlob>)attachments, mailToAddress, templateString, subject, mailToCcList, mailToBccList, (EFCMap<EFCString, EFCString>)printParams, templateBo);
    }

    public static void createMailDialog(EFCMap<EFCString, EFCString> contentParas, EFCMap<EFCString, EFCBlob> attachments, EFCString mailToAddress, EFCString templateString, EFCString subject, List<String> mailToCcList, List<String> mailToBccList) {
        MailTools.createMailDialog(contentParas, attachments, mailToAddress, templateString, subject, mailToCcList, mailToBccList, null);
    }

    public static void createMailDialog(EFCMap<EFCString, EFCString> contentParas, EFCMap<EFCString, EFCBlob> attachments, EFCString mailToAddress, EFCString templateString, EFCString subject, List<String> mailToCcList, List<String> mailToBccList, BusinessObject templateBo) {
        MailTools.createMailDialog(contentParas, attachments, mailToAddress, templateString, subject, mailToCcList, mailToBccList, (EFCMap<EFCString, EFCString>)new EFCMap(), templateBo);
    }

    public static void createMailDialog(EFCMap<EFCString, EFCString> contentParas, EFCMap<EFCString, EFCBlob> attachments, EFCString mailToAddress, EFCString templateString, EFCString subject, List<String> mailToCcList, List<String> mailToBccList, EFCMap<EFCString, EFCString> printParamMap, BusinessObject templateBo) {
        EFCThreadUtil.edtBuilder(th -> th.doOutside(() -> {
            BoSysMail bo = templateString != null && templateString.getData() != null && !templateString.getData().isEmpty() ? svSysMail.prepareMessage(mailToAddress, contentParas, new EFCString("DE"), attachments, subject, templateString, printParamMap, templateBo) : svSysMail.prepareMessage(mailToAddress, contentParas, new EFCString("DE"), attachments, subject, null, printParamMap, templateBo);
            for (String adr : mailToCcList) {
                if (adr == null || adr.isEmpty()) continue;
                bo.getCcList().add((Object)new DcSysMailAddress(adr));
            }
            for (String adr : mailToBccList) {
                if (adr == null || adr.isEmpty()) continue;
                bo.getBccList().add((Object)new DcSysMailAddress(adr));
            }
            th.edt(() -> {
                if (bo.getCompleteMsgList().getMaxSeverity() == MsgType.ERROR) {
                    new EFCMessageListDialog((Frame)EFCMainFrame.getInstance(), true).show(bo.getCompleteMsgList().getMsgList());
                } else {
                    HashMap<String, Object> dlgParam = new HashMap<String, Object>();
                    EFCMailDialog maildlg = new EFCMailDialog(null, BoSysMail.class, dlgParam);
                    maildlg.execute((BusinessObject)bo, Arrays.asList(Translator.tr((String)"_SEND"), Translator.tr((String)"_DRAFT"), Translator.tr((String)"_CANCEL")));
                    maildlg.dispose();
                }
            });
        }));
    }

    public static void createMailDialogLogFile(EFCMap<EFCString, EFCString> contentParas, EFCBlob attachment, EFCString mailToAddress, Map<String, EFCString> paramMap, EFCString templateString, EFCString subject) {
        EFCThreadUtil.edtBuilder(th -> th.doOutside(() -> {
            Object attachmentName = "Anhang";
            if (paramMap != null) {
                if (paramMap.containsKey("EFC_PARAM2")) {
                    attachmentName = ((EFCString)paramMap.get("EFC_PARAM2")).getData();
                }
                if (paramMap.containsKey("EFC_PARAM3")) {
                    attachmentName = (String)attachmentName + paramMap.get("EFC_PARAM3");
                }
            }
            attachmentName = (String)attachmentName + ".zip";
            EFCMap attachments = new EFCMap();
            if (attachment != null && attachment.getData() != null) {
                attachments.put((Object)new EFCString((String)attachmentName), (Object)attachment);
            }
            BoSysMail bo = templateString != null && templateString.getData() != null && !templateString.getData().isEmpty() ? svSysMail.prepareMessage(mailToAddress, contentParas, new EFCString("DE"), attachments, subject, templateString) : svSysMail.prepareMessage(mailToAddress, contentParas, new EFCString("DE"), attachments, subject);
            th.edt(() -> {
                if (bo.getCompleteMsgList().getMaxSeverity() == MsgType.ERROR) {
                    new EFCMessageListDialog((Frame)EFCMainFrame.getInstance(), true).show(bo.getCompleteMsgList().getMsgList());
                } else {
                    HashMap<String, Object> dlgParam = new HashMap<String, Object>();
                    EFCMailDialog maildlg = new EFCMailDialog(null, BoSysMail.class, dlgParam);
                    maildlg.execute((BusinessObject)bo, Arrays.asList(Translator.tr((String)"_SEND"), Translator.tr((String)"_DRAFT"), Translator.tr((String)"_CANCEL")));
                    maildlg.dispose();
                }
            });
        }));
    }

    public static void createExportClientLogMailDialog(EFCBlob attachFiles) {
        EFCString to = svSysDefaults.getDefaultMailSupport();
        EFCMap contentParameter = new EFCMap();
        EFCString subject = new EFCString("EFCClientLogs");
        EFCMap paramMap = new EFCMap();
        paramMap.put((Object)"EFC_PARAM2", (Object)new EFCString("EFCClientLogs"));
        EFCString templateString = new EFCString(new String(svSysMail.getMailBodyClientLog().getData()));
        MailTools.createMailDialogLogFile((EFCMap<EFCString, EFCString>)contentParameter, attachFiles, to, (Map<String, EFCString>)paramMap, templateString, subject);
    }

    public static void createExportServerLogMailDialog() {
        EFCString to = svSysDefaults.getDefaultMailSupport();
        EFCMap contentParameter = new EFCMap();
        EFCString subject = new EFCString("EFCServerLogs");
        EFCMap paramMap = new EFCMap();
        paramMap.put((Object)"EFC_PARAM2", (Object)new EFCString("EFCServerLogs"));
        EFCString templateString = new EFCString(new String(svSysMail.getMailBodyServerLog().getData()));
        EFCBlob attachFiles = svSysMail.getServerLogForExport(templateString);
        MailTools.createMailDialogLogFile((EFCMap<EFCString, EFCString>)contentParameter, attachFiles, to, (Map<String, EFCString>)paramMap, templateString, subject);
    }
}

