/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestSecurityApiKey;
import org.apache.camel.model.rest.RestSecurityBasicAuth;
import org.apache.camel.model.rest.RestSecurityBearerToken;
import org.apache.camel.model.rest.RestSecurityDefinition;
import org.apache.camel.model.rest.RestSecurityMutualTLS;
import org.apache.camel.model.rest.RestSecurityOAuth2;
import org.apache.camel.model.rest.RestSecurityOpenIdConnect;
import org.apache.camel.spi.Metadata;

@Metadata(label="rest,security,configuration", title="Rest Security Definitions")
@XmlRootElement(name="securityDefinitions")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestSecuritiesDefinition {
    @XmlTransient
    private RestDefinition rest;
    @XmlElements(value={@XmlElement(name="apiKey", type=RestSecurityApiKey.class), @XmlElement(name="basicAuth", type=RestSecurityBasicAuth.class), @XmlElement(name="bearer", type=RestSecurityBearerToken.class), @XmlElement(name="oauth2", type=RestSecurityOAuth2.class), @XmlElement(name="openIdConnect", type=RestSecurityOpenIdConnect.class), @XmlElement(name="mutualTLS", type=RestSecurityMutualTLS.class)})
    private List<RestSecurityDefinition> securityDefinitions = new ArrayList<RestSecurityDefinition>();

    public RestSecuritiesDefinition() {
    }

    public RestSecuritiesDefinition(RestDefinition rest) {
        this.rest = rest;
    }

    public List<RestSecurityDefinition> getSecurityDefinitions() {
        return this.securityDefinitions;
    }

    public void setSecurityDefinitions(List<RestSecurityDefinition> securityDefinitions) {
        this.securityDefinitions = securityDefinitions;
    }

    public RestSecurityApiKey apiKey(String key) {
        return this.apiKey(key, null);
    }

    public RestSecurityApiKey apiKey(String key, String description) {
        RestSecurityApiKey auth = new RestSecurityApiKey(this.rest);
        auth.setKey(key);
        auth.setDescription(description);
        this.securityDefinitions.add(auth);
        return auth;
    }

    public RestSecuritiesDefinition basicAuth(String key) {
        return this.basicAuth(key, null);
    }

    public RestSecuritiesDefinition basicAuth(String key, String description) {
        RestSecurityBasicAuth auth = new RestSecurityBasicAuth(this.rest);
        this.securityDefinitions.add(auth);
        auth.setKey(key);
        auth.setDescription(description);
        return this;
    }

    public RestSecuritiesDefinition bearerToken(String key, String bearerFormat) {
        return this.bearerToken(key, null, bearerFormat);
    }

    public RestSecuritiesDefinition bearerToken(String key, String description, String bearerFormat) {
        RestSecurityBearerToken auth = new RestSecurityBearerToken(this.rest);
        this.securityDefinitions.add(auth);
        auth.setKey(key);
        auth.setDescription(description);
        auth.setFormat(bearerFormat);
        return this;
    }

    public RestSecuritiesDefinition mutualTLS(String key) {
        return this.mutualTLS(key, null);
    }

    public RestSecuritiesDefinition mutualTLS(String key, String description) {
        RestSecurityMutualTLS auth = new RestSecurityMutualTLS(this.rest);
        this.securityDefinitions.add(auth);
        auth.setKey(key);
        auth.setDescription(description);
        return this;
    }

    public RestSecuritiesDefinition openIdConnect(String key, String url) {
        return this.openIdConnect(key, null, url);
    }

    public RestSecuritiesDefinition openIdConnect(String key, String description, String url) {
        RestSecurityOpenIdConnect auth = new RestSecurityOpenIdConnect(this.rest);
        this.securityDefinitions.add(auth);
        auth.setKey(key);
        auth.setDescription(description);
        auth.setUrl(url);
        return this;
    }

    public RestSecurityOAuth2 oauth2(String key) {
        return this.oauth2(key, null);
    }

    public RestSecurityOAuth2 oauth2(String key, String description) {
        RestSecurityOAuth2 auth = new RestSecurityOAuth2(this.rest);
        auth.setKey(key);
        auth.setDescription(description);
        this.securityDefinitions.add(auth);
        return auth;
    }

    public RestDefinition end() {
        return this.rest;
    }
}

