/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.transitions;

import com.jfoenix.transitions.CacheMemento;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.util.Duration;

public class CachedTransition
extends Transition {
    protected final Node node;
    protected ObjectProperty<Timeline> timeline = new SimpleObjectProperty();
    private CacheMemento[] mementos = new CacheMemento[0];

    public CachedTransition(Node node, Timeline timeline) {
        CacheMemento[] cacheMementoArray;
        this.node = node;
        this.timeline.set((Object)timeline);
        if (node == null) {
            cacheMementoArray = this.mementos;
        } else {
            CacheMemento[] cacheMementoArray2 = new CacheMemento[1];
            cacheMementoArray = cacheMementoArray2;
            cacheMementoArray2[0] = new CacheMemento(node);
        }
        this.mementos = cacheMementoArray;
        this.statusProperty().addListener(observable -> {
            switch (this.getStatus()) {
                case RUNNING: {
                    this.starting();
                    break;
                }
                default: {
                    this.stopping();
                }
            }
        });
    }

    public CachedTransition(Node node, Timeline timeline, CacheMemento ... cacheMomentos) {
        this.node = node;
        this.timeline.set((Object)timeline);
        this.mementos = new CacheMemento[(node == null ? 0 : 1) + cacheMomentos.length];
        if (node != null) {
            this.mementos[0] = new CacheMemento(node);
        }
        System.arraycopy(cacheMomentos, 0, this.mementos, node == null ? 0 : 1, cacheMomentos.length);
        this.statusProperty().addListener(observable -> {
            switch (this.getStatus()) {
                case RUNNING: {
                    this.starting();
                    break;
                }
                default: {
                    this.stopping();
                }
            }
        });
    }

    protected void starting() {
        if (this.mementos != null) {
            for (int i = 0; i < this.mementos.length; ++i) {
                this.mementos[i].cache();
            }
        }
    }

    protected void stopping() {
        if (this.mementos != null) {
            for (int i = 0; i < this.mementos.length; ++i) {
                this.mementos[i].restore();
            }
        }
    }

    protected void interpolate(double d) {
        ((Timeline)this.timeline.get()).playFrom(Duration.seconds((double)d));
        ((Timeline)this.timeline.get()).stop();
    }
}

