/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.validation;

import com.jfoenix.validation.base.ValidatorBase;
import java.util.regex.Pattern;
import javafx.beans.DefaultProperty;
import javafx.scene.control.TextInputControl;

@DefaultProperty(value="icon")
public class RegexValidator
extends ValidatorBase {
    private String regexPattern;
    private Pattern regexPatternCompiled;

    public RegexValidator(String message) {
        super(message);
    }

    public RegexValidator() {
    }

    @Override
    protected void eval() {
        if (this.srcControl.get() instanceof TextInputControl) {
            this.evalTextInputField();
        }
    }

    private void evalTextInputField() {
        String text;
        TextInputControl textField = (TextInputControl)this.srcControl.get();
        String string = text = textField.getText() == null ? "" : textField.getText();
        if (this.regexPatternCompiled.matcher(text).matches()) {
            this.hasErrors.set(false);
        } else {
            this.hasErrors.set(true);
        }
    }

    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
        this.regexPatternCompiled = Pattern.compile(regexPattern);
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }
}

