/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.configurator;

import java.util.ArrayList;
import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.AbstractEngineConfigurator;
import org.flowable.common.engine.impl.EngineDeployer;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.eventregistry.impl.EventRegistryEngine;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.cfg.StandaloneEventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.configurator.deployer.EventDeployer;
import org.flowable.eventregistry.impl.db.EntityDependencyOrder;

public class EventRegistryEngineConfigurator
extends AbstractEngineConfigurator {
    protected EventRegistryEngine eventRegistryEngine;
    protected EventRegistryEngineConfiguration eventEngineConfiguration;

    public int getPriority() {
        return 100000;
    }

    protected List<EngineDeployer> getCustomDeployers() {
        ArrayList<EngineDeployer> deployers = new ArrayList<EngineDeployer>();
        deployers.add(new EventDeployer());
        return deployers;
    }

    protected String getMybatisCfgPath() {
        return "org/flowable/eventregistry/db/mapping/mappings.xml";
    }

    public void configure(AbstractEngineConfiguration engineConfiguration) {
        if (this.eventEngineConfiguration == null) {
            this.eventEngineConfiguration = new StandaloneEventRegistryEngineConfiguration();
        }
        this.initialiseEventRegistryEngineConfiguration(this.eventEngineConfiguration);
        this.initialiseCommonProperties(engineConfiguration, (AbstractEngineConfiguration)this.eventEngineConfiguration);
        this.eventRegistryEngine = this.initEventRegistryEngine();
        this.initServiceConfigurations(engineConfiguration, (AbstractEngineConfiguration)this.eventEngineConfiguration);
    }

    protected void initialiseEventRegistryEngineConfiguration(EventRegistryEngineConfiguration eventRegistryEngineConfiguration) {
    }

    protected List<Class<? extends Entity>> getEntityInsertionOrder() {
        return EntityDependencyOrder.INSERT_ORDER;
    }

    protected List<Class<? extends Entity>> getEntityDeletionOrder() {
        return EntityDependencyOrder.DELETE_ORDER;
    }

    protected synchronized EventRegistryEngine initEventRegistryEngine() {
        if (this.eventEngineConfiguration == null) {
            throw new FlowableException("EventRegistryEngineConfiguration is required");
        }
        return this.eventEngineConfiguration.buildEventRegistryEngine();
    }

    public EventRegistryEngineConfiguration getEventEngineConfiguration() {
        return this.eventEngineConfiguration;
    }

    public EventRegistryEngineConfigurator setEventEngineConfiguration(EventRegistryEngineConfiguration eventEngineConfiguration) {
        this.eventEngineConfiguration = eventEngineConfiguration;
        return this;
    }

    public EventRegistryEngine getEventRegistryEngine() {
        return this.eventRegistryEngine;
    }

    public void setEventRegistryEngine(EventRegistryEngine eventRegistryEngine) {
        this.eventRegistryEngine = eventRegistryEngine;
    }
}

