/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import java.time.LocalDate;
import java.util.Calendar;
import java.util.Collection;
import javafx.beans.property.Property;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper;
import jfxtras.internal.scene.control.skin.TextFieldSkin;
import jfxtras.scene.control.CalendarPicker;
import jfxtras.scene.control.CalendarTextField;
import jfxtras.scene.control.LocalDatePicker;
import jfxtras.scene.control.LocalDateTextField;

public class LocalDateTextFieldSkin
extends SkinBase<LocalDateTextField>
implements TextFieldSkin {
    private CalendarTextField calendarTextField = null;

    public LocalDateTextFieldSkin(LocalDateTextField control) {
        super((Control)control);
        this.construct();
    }

    @Override
    public void selectAll() {
        this.calendarTextField.selectAll();
    }

    private void construct() {
        this.createNodes();
        this.calendarTextField.setShowTime(false);
        this.calendarTextField.getStyleClass().addAll((Object[])new String[]{((Object)((Object)((LocalDateTextField)this.getSkinnable()))).getClass().getSimpleName()});
        this.calendarTextField.getStyleClass().addAll((Collection)((LocalDateTextField)this.getSkinnable()).getStyleClass());
        this.calendarTextField.styleProperty().bindBidirectional((Property)((LocalDateTextField)this.getSkinnable()).styleProperty());
        this.calendarTextField.tooltipProperty().bindBidirectional((Property)((LocalDateTextField)this.getSkinnable()).tooltipProperty());
        this.calendarTextField.textProperty().bindBidirectional(((LocalDateTextField)this.getSkinnable()).textProperty());
        this.calendarTextField.pickerShowingProperty().bindBidirectional((Property)((LocalDateTextField)this.getSkinnable()).pickerShowingProperty());
        ((LocalDateTextField)this.getSkinnable()).focusedProperty().addListener((observableValue, wasFocused, isFocused) -> {
            if (isFocused.booleanValue()) {
                this.calendarTextField.requestFocus();
            }
        });
        this.calendarTextField.localeProperty().bindBidirectional(((LocalDateTextField)this.getSkinnable()).localeProperty());
        this.calendarTextField.allowNullProperty().bindBidirectional((Property)((LocalDateTextField)this.getSkinnable()).allowNullProperty());
        this.calendarTextField.editableProperty().bindBidirectional((Property)((LocalDateTextField)this.getSkinnable()).editableProperty());
        this.calendarTextField.promptTextProperty().bindBidirectional(((LocalDateTextField)this.getSkinnable()).promptTextProperty());
        this.calendarTextField.parseErrorCallbackProperty().bindBidirectional(((LocalDateTextField)this.getSkinnable()).parseErrorCallbackProperty());
        DateTimeToCalendarHelper.syncLocalDate(this.calendarTextField.calendarProperty(), ((LocalDateTextField)this.getSkinnable()).localDateProperty(), this.calendarTextField.localeProperty());
        DateTimeToCalendarHelper.syncLocalDates(this.calendarTextField.highlightedCalendars(), ((LocalDateTextField)this.getSkinnable()).highlightedLocalDates(), this.calendarTextField.localeProperty());
        DateTimeToCalendarHelper.syncLocalDates(this.calendarTextField.disabledCalendars(), ((LocalDateTextField)this.getSkinnable()).disabledLocalDates(), this.calendarTextField.localeProperty());
        DateTimeToCalendarHelper.syncLocalDate(this.calendarTextField.displayedCalendar(), ((LocalDateTextField)this.getSkinnable()).displayedLocalDate(), this.calendarTextField.localeProperty());
        DateTimeToCalendarHelper.syncDateTimeFormatterForDate(this.calendarTextField.dateFormatProperty(), ((LocalDateTextField)this.getSkinnable()).dateTimeFormatterProperty());
        DateTimeToCalendarHelper.syncDateTimeFormattersForDate(this.calendarTextField.dateFormatsProperty(), ((LocalDateTextField)this.getSkinnable()).dateTimeFormattersProperty());
        this.calendarTextField.setCalendarRangeCallback(new Callback<CalendarPicker.CalendarRange, Void>(){

            public Void call(CalendarPicker.CalendarRange calendarRange) {
                Callback<LocalDatePicker.LocalDateRange, Void> lCallback = ((LocalDateTextField)LocalDateTextFieldSkin.this.getSkinnable()).getLocalDateRangeCallback();
                if (lCallback == null) {
                    return null;
                }
                return (Void)lCallback.call((Object)new LocalDatePicker.LocalDateRange(DateTimeToCalendarHelper.createLocalDateFromCalendar(calendarRange.getStartCalendar()), DateTimeToCalendarHelper.createLocalDateFromCalendar(calendarRange.getEndCalendar())));
            }
        });
        this.calendarTextField.setValueValidationCallback(new Callback<Calendar, Boolean>(){

            public Boolean call(Calendar calendar) {
                Callback<LocalDate, Boolean> lCallback = ((LocalDateTextField)LocalDateTextFieldSkin.this.getSkinnable()).getValueValidationCallback();
                if (lCallback == null) {
                    return true;
                }
                return (Boolean)lCallback.call((Object)DateTimeToCalendarHelper.createLocalDateFromCalendar(calendar));
            }
        });
    }

    private void createNodes() {
        this.calendarTextField = new CalendarTextField();
        this.getChildren().add((Object)this.calendarTextField);
        ((LocalDateTextField)this.getSkinnable()).getStyleClass().add((Object)this.getClass().getSimpleName());
    }
}

