/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import jfxtras.internal.scene.control.skin.AccordionSkin;

public class AccordionPane
extends Control {
    private final ObservableList<Tab> tabs = FXCollections.observableArrayList();
    private volatile ObjectProperty<Tab> visibleTabObjectProperty = new SimpleObjectProperty((Object)this, "visibleTab", null);

    public AccordionPane() {
        this.construct();
    }

    public AccordionPane(Tab ... tabs) {
        this.construct();
        for (Tab lTab : tabs) {
            this.tabs.add((Object)lTab);
        }
    }

    private void construct() {
        this.getStyleClass().add((Object)AccordionPane.class.getSimpleName());
    }

    public String getUserAgentStylesheet() {
        return AccordionPane.class.getResource("/jfxtras/internal/scene/control/" + AccordionPane.class.getSimpleName() + ".css").toExternalForm();
    }

    public Skin<?> createDefaultSkin() {
        return new AccordionSkin(this);
    }

    public AccordionPane withId(String value) {
        this.setId(value);
        return this;
    }

    public ObservableList<Tab> tabs() {
        return this.tabs;
    }

    public AccordionPane addTab(String name, Node node) {
        Tab lTab = new Tab().withText(name).withNode(node);
        this.tabs.add((Object)lTab);
        return this;
    }

    public AccordionPane addTab(String name, Node icon, Node node) {
        Tab lTab = new Tab().withText(name).withIcon(icon).withNode(node);
        this.tabs.add((Object)lTab);
        return this;
    }

    public AccordionPane addTab(Node icon, Node node) {
        Tab lTab = new Tab().withIcon(icon).withNode(node);
        this.tabs.add((Object)lTab);
        return this;
    }

    public ObjectProperty<Tab> visibleTabProperty() {
        return this.visibleTabObjectProperty;
    }

    public Tab getVisibleTab() {
        return (Tab)this.visibleTabObjectProperty.getValue();
    }

    public void setVisibleTab(Tab value) {
        this.visibleTabObjectProperty.setValue((Object)value);
    }

    public AccordionPane withVisibleTab(Tab value) {
        this.setVisibleTab(value);
        return this;
    }

    public static class Tab {
        private volatile ObjectProperty<String> textObjectProperty = new SimpleObjectProperty((Object)this, "text", null);
        private volatile ObjectProperty<Node> iconObjectProperty = new SimpleObjectProperty((Object)this, "icon", null);
        private volatile ObjectProperty<Node> nodeObjectProperty = new SimpleObjectProperty((Object)this, "node", null);

        public ObjectProperty<String> textProperty() {
            return this.textObjectProperty;
        }

        public String getText() {
            return (String)this.textObjectProperty.getValue();
        }

        public void setText(String value) {
            this.textObjectProperty.setValue((Object)value);
        }

        public Tab withText(String value) {
            this.setText(value);
            return this;
        }

        public ObjectProperty<Node> iconProperty() {
            return this.iconObjectProperty;
        }

        public Node getIcon() {
            return (Node)this.iconObjectProperty.getValue();
        }

        public void setIcon(Node value) {
            this.iconObjectProperty.setValue((Object)value);
        }

        public Tab withIcon(Node value) {
            this.setIcon(value);
            return this;
        }

        public ObjectProperty<Node> nodeProperty() {
            return this.nodeObjectProperty;
        }

        public Node getNode() {
            return (Node)this.nodeObjectProperty.getValue();
        }

        public void setNode(Node value) {
            this.nodeObjectProperty.setValue((Object)value);
        }

        public Tab withNode(Node value) {
            this.setNode(value);
            return this;
        }

        public String toString() {
            return super.toString() + ", text=" + this.getText();
        }
    }
}

