/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control;

import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.CalendarPickerControlSkin;

public class CalendarPicker
extends Control {
    private final ObjectProperty<Calendar> calendarObjectProperty = new SimpleObjectProperty<Calendar>((Object)this, "calendar"){

        public void set(Calendar value) {
            if (value == null && !CalendarPicker.this.getAllowNull()) {
                throw new NullPointerException("Null not allowed");
            }
            super.set((Object)value);
        }
    };
    private final ObservableList<Calendar> calendars = FXCollections.observableArrayList();
    private final AtomicInteger modifyingCalendersAtomicInteger = new AtomicInteger(0);
    private volatile ObjectProperty<Locale> localeObjectProperty = new SimpleObjectProperty((Object)this, "locale", (Object)Locale.getDefault());
    private final SimpleObjectProperty<Mode> modeObjectProperty = new SimpleObjectProperty<Mode>((Object)this, "mode", Mode.SINGLE){

        public void set(Mode value) {
            if (value == null) {
                throw new NullPointerException("Null not allowed");
            }
            super.set((Object)value);
        }
    };
    private volatile ObjectProperty<Boolean> showTimeObjectProperty = new SimpleObjectProperty((Object)this, "showTime", (Object)false);
    private volatile BooleanProperty allowNullProperty = new SimpleBooleanProperty((Object)this, "allowNull", true){

        public void set(boolean value) {
            super.set(value);
            if (!value && CalendarPicker.this.getCalendar() == null) {
                CalendarPicker.this.setCalendar(Calendar.getInstance(CalendarPicker.this.getLocale()));
            }
        }
    };
    private final ObservableList<Calendar> disabledCalendars = FXCollections.observableArrayList();
    private final ObservableList<Calendar> highlightedCalendars = FXCollections.observableArrayList();
    private final ObjectProperty<Callback<CalendarRange, Void>> calendarRangeCallbackObjectProperty = new SimpleObjectProperty((Object)this, "calendarRangeCallback", null);
    private volatile ObjectProperty<Calendar> displayedCalendarObjectProperty = new SimpleObjectProperty((Object)this, "displayedCalendar");
    private final ObjectProperty<Callback<Calendar, Boolean>> valueValidationCallbackObjectProperty = new SimpleObjectProperty((Object)this, "valueValidationCallback", null);

    public CalendarPicker() {
        this.construct();
    }

    private void construct() {
        this.getStyleClass().add((Object)CalendarPicker.class.getSimpleName());
        this.constructCalendar();
        this.constructCalendars();
        this.constructDisplayedCalendar();
    }

    public String getUserAgentStylesheet() {
        return CalendarPicker.class.getResource("/jfxtras/internal/scene/control/" + CalendarPicker.class.getSimpleName() + ".css").toExternalForm();
    }

    public Skin<?> createDefaultSkin() {
        return new CalendarPickerControlSkin(this);
    }

    public CalendarPicker withId(String value) {
        this.setId(value);
        return this;
    }

    public ObjectProperty<Calendar> calendarProperty() {
        return this.calendarObjectProperty;
    }

    public Calendar getCalendar() {
        return (Calendar)this.calendarObjectProperty.getValue();
    }

    public void setCalendar(Calendar value) {
        this.calendarObjectProperty.setValue((Object)this.cloneWithMillis0(value));
    }

    public CalendarPicker withCalendar(Calendar value) {
        this.setCalendar(value);
        return this;
    }

    private void constructCalendar() {
        this.calendarProperty().addListener((ChangeListener)new ChangeListener<Calendar>(){

            public void changed(ObservableValue<? extends Calendar> observableValue, Calendar oldValue, Calendar newValue) {
                if (CalendarPicker.this.modifyingCalendersAtomicInteger.get() == 0) {
                    if (newValue != null && !CalendarPicker.this.calendars().contains((Object)newValue)) {
                        CalendarPicker.this.calendars().add((Object)newValue);
                    }
                    if (oldValue != null) {
                        CalendarPicker.this.calendars().remove((Object)oldValue);
                    }
                }
            }
        });
    }

    public ObservableList<Calendar> calendars() {
        return this.calendars;
    }

    private void constructCalendars() {
        this.calendars.addListener((ListChangeListener)new ListChangeListener<Calendar>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onChanged(ListChangeListener.Change<? extends Calendar> change) {
                CalendarPicker.this.modifyingCalendersAtomicInteger.addAndGet(1);
                try {
                    while (change.next()) {
                        for (Calendar lCalendar : change.getAddedSubList()) {
                            CalendarPicker.this.setCalendar(lCalendar);
                        }
                        for (Calendar lCalendar : change.getRemoved()) {
                            if (!lCalendar.equals(CalendarPicker.this.getCalendar())) continue;
                            if (CalendarPicker.this.calendars().size() > 0) {
                                CalendarPicker.this.setCalendar((Calendar)CalendarPicker.this.calendars().get(0));
                                continue;
                            }
                            CalendarPicker.this.setCalendar(null);
                        }
                    }
                }
                finally {
                    CalendarPicker.this.modifyingCalendersAtomicInteger.addAndGet(-1);
                }
            }
        });
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.localeObjectProperty;
    }

    public Locale getLocale() {
        return (Locale)this.localeObjectProperty.getValue();
    }

    public void setLocale(Locale value) {
        this.localeObjectProperty.setValue((Object)value);
    }

    public CalendarPicker withLocale(Locale value) {
        this.setLocale(value);
        return this;
    }

    public ObjectProperty<Mode> modeProperty() {
        return this.modeObjectProperty;
    }

    public Mode getMode() {
        return (Mode)((Object)this.modeObjectProperty.getValue());
    }

    public void setMode(Mode value) {
        this.modeObjectProperty.setValue((Object)value);
    }

    public CalendarPicker withMode(Mode value) {
        this.setMode(value);
        return this;
    }

    public ObjectProperty<Boolean> showTimeProperty() {
        return this.showTimeObjectProperty;
    }

    public Boolean getShowTime() {
        return (Boolean)this.showTimeObjectProperty.getValue();
    }

    public void setShowTime(Boolean value) {
        this.showTimeObjectProperty.setValue((Object)value);
    }

    public CalendarPicker withShowTime(Boolean value) {
        this.setShowTime(value);
        return this;
    }

    public BooleanProperty allowNullProperty() {
        return this.allowNullProperty;
    }

    public boolean getAllowNull() {
        return this.allowNullProperty.get();
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNullProperty.set(allowNull);
    }

    public CalendarPicker withAllowNull(boolean value) {
        this.setAllowNull(value);
        return this;
    }

    public ObservableList<Calendar> disabledCalendars() {
        return this.disabledCalendars;
    }

    public ObservableList<Calendar> highlightedCalendars() {
        return this.highlightedCalendars;
    }

    public ObjectProperty<Callback<CalendarRange, Void>> calendarRangeCallbackProperty() {
        return this.calendarRangeCallbackObjectProperty;
    }

    public Callback<CalendarRange, Void> getCalendarRangeCallback() {
        return (Callback)this.calendarRangeCallbackObjectProperty.getValue();
    }

    public void setCalendarRangeCallback(Callback<CalendarRange, Void> value) {
        this.calendarRangeCallbackObjectProperty.setValue(value);
    }

    public CalendarPicker withCalendarRangeCallback(Callback<CalendarRange, Void> value) {
        this.setCalendarRangeCallback(value);
        return this;
    }

    public ObjectProperty<Calendar> displayedCalendar() {
        return this.displayedCalendarObjectProperty;
    }

    public Calendar getDisplayedCalendar() {
        return (Calendar)this.displayedCalendarObjectProperty.getValue();
    }

    public void setDisplayedCalendar(Calendar value) {
        this.displayedCalendarObjectProperty.setValue((Object)this.cloneWithMillis0(value));
    }

    public CalendarPicker withDisplayedCalendar(Calendar value) {
        this.setDisplayedCalendar(value);
        return this;
    }

    private void constructDisplayedCalendar() {
        Calendar calendar = Calendar.getInstance(this.getLocale());
        this.setDisplayedCalendar(calendar);
    }

    public ObjectProperty<Callback<Calendar, Boolean>> valueValidationCallbackProperty() {
        return this.valueValidationCallbackObjectProperty;
    }

    public Callback<Calendar, Boolean> getValueValidationCallback() {
        return (Callback)this.valueValidationCallbackObjectProperty.getValue();
    }

    public void setValueValidationCallback(Callback<Calendar, Boolean> value) {
        this.valueValidationCallbackObjectProperty.setValue(value);
    }

    public CalendarPicker withValueValidationCallback(Callback<Calendar, Boolean> value) {
        this.setValueValidationCallback(value);
        return this;
    }

    private Calendar cloneWithMillis0(Calendar calendar) {
        if (calendar != null) {
            calendar = (Calendar)calendar.clone();
            calendar.set(14, 0);
        }
        return calendar;
    }

    public static class CalendarRange {
        final Calendar start;
        final Calendar end;

        public CalendarRange(Calendar start, Calendar end) {
            this.start = start;
            this.end = end;
        }

        public Calendar getStartCalendar() {
            return this.start;
        }

        public Calendar getEndCalendar() {
            return this.end;
        }
    }

    public static enum Mode {
        SINGLE,
        MULTIPLE,
        RANGE;

    }
}

