/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control;

import java.util.Calendar;
import java.util.Locale;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.CalendarTimePickerSkin;

public class CalendarTimePicker
extends Control {
    private final ObjectProperty<Calendar> calendarObjectProperty = new SimpleObjectProperty<Calendar>((Object)this, "calendar", Calendar.getInstance()){

        public void set(Calendar value) {
            value = CalendarTimePickerSkin.blockHoursToStep(value, CalendarTimePicker.this.getHourStep());
            value = CalendarTimePickerSkin.blockMinutesToStep(value, CalendarTimePicker.this.getMinuteStep());
            value = CalendarTimePickerSkin.blockSecondsToStep(value, CalendarTimePicker.this.getSecondStep());
            super.set((Object)value);
        }
    };
    private volatile ObjectProperty<Locale> localeObjectProperty = new SimpleObjectProperty((Object)this, "locale", (Object)Locale.getDefault());
    private final SimpleObjectProperty<Integer> hourStepProperty = new SimpleObjectProperty<Integer>((Object)this, "hourStep", Integer.valueOf(1)){

        public void set(Integer value) {
            if (value == null || value < 0 || value > 23) {
                throw new IllegalArgumentException("null or outside [0-23] is not allowed");
            }
            super.set((Object)value);
            CalendarTimePicker.this.setCalendar(CalendarTimePickerSkin.blockHoursToStep(CalendarTimePicker.this.getCalendar(), CalendarTimePicker.this.getHourStep()));
        }
    };
    private final SimpleObjectProperty<Integer> minuteStepProperty = new SimpleObjectProperty<Integer>((Object)this, "minuteStep", Integer.valueOf(1)){

        public void set(Integer value) {
            if (value == null || value < 0 || value > 59) {
                throw new IllegalArgumentException("null or outside [0-59] is not allowed");
            }
            super.set((Object)value);
            CalendarTimePicker.this.setCalendar(CalendarTimePickerSkin.blockMinutesToStep(CalendarTimePicker.this.getCalendar(), CalendarTimePicker.this.getMinuteStep()));
        }
    };
    private final SimpleObjectProperty<Integer> secondStepProperty = new SimpleObjectProperty<Integer>((Object)this, "secondStep", Integer.valueOf(1)){

        public void set(Integer value) {
            if (value == null || value < 0 || value > 59) {
                throw new IllegalArgumentException("null or outside [0-59] is not allowed");
            }
            super.set((Object)value);
            CalendarTimePicker.this.setCalendar(CalendarTimePickerSkin.blockSecondsToStep(CalendarTimePicker.this.getCalendar(), CalendarTimePicker.this.getSecondStep()));
        }
    };
    private final ObjectProperty<Callback<Calendar, Boolean>> valueValidationCallbackObjectProperty = new SimpleObjectProperty((Object)this, "valueValidationCallback", null);

    public CalendarTimePicker() {
        this.construct();
    }

    private void construct() {
        this.getStyleClass().add((Object)CalendarTimePicker.class.getSimpleName());
    }

    public String getUserAgentStylesheet() {
        return CalendarTimePicker.class.getResource("/jfxtras/internal/scene/control/" + CalendarTimePicker.class.getSimpleName() + ".css").toExternalForm();
    }

    public Skin<?> createDefaultSkin() {
        return new CalendarTimePickerSkin(this);
    }

    public CalendarTimePicker withId(String value) {
        this.setId(value);
        return this;
    }

    public ObjectProperty<Calendar> calendarProperty() {
        return this.calendarObjectProperty;
    }

    public Calendar getCalendar() {
        return (Calendar)this.calendarObjectProperty.getValue();
    }

    public void setCalendar(Calendar value) {
        this.calendarObjectProperty.setValue((Object)value);
    }

    public CalendarTimePicker withCalendar(Calendar value) {
        this.setCalendar(value);
        return this;
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.localeObjectProperty;
    }

    public Locale getLocale() {
        return (Locale)this.localeObjectProperty.getValue();
    }

    public void setLocale(Locale value) {
        this.localeObjectProperty.setValue((Object)value);
    }

    public CalendarTimePicker withLocale(Locale value) {
        this.setLocale(value);
        return this;
    }

    public ObjectProperty<Integer> hourStepProperty() {
        return this.hourStepProperty;
    }

    public Integer getHourStep() {
        return (Integer)this.hourStepProperty.getValue();
    }

    public void setHourStep(Integer value) {
        this.hourStepProperty.setValue((Object)value);
    }

    public CalendarTimePicker withHourStep(Integer value) {
        this.setHourStep(value);
        return this;
    }

    public ObjectProperty<Integer> minuteStepProperty() {
        return this.minuteStepProperty;
    }

    public Integer getMinuteStep() {
        return (Integer)this.minuteStepProperty.getValue();
    }

    public void setMinuteStep(Integer value) {
        this.minuteStepProperty.setValue((Object)value);
    }

    public CalendarTimePicker withMinuteStep(Integer value) {
        this.setMinuteStep(value);
        return this;
    }

    public ObjectProperty<Integer> secondStepProperty() {
        return this.secondStepProperty;
    }

    public Integer getSecondStep() {
        return (Integer)this.secondStepProperty.getValue();
    }

    public void setSecondStep(Integer value) {
        this.secondStepProperty.setValue((Object)value);
    }

    public CalendarTimePicker withSecondStep(Integer value) {
        this.setSecondStep(value);
        return this;
    }

    public ObjectProperty<Callback<Calendar, Boolean>> valueValidationCallbackProperty() {
        return this.valueValidationCallbackObjectProperty;
    }

    public Callback<Calendar, Boolean> getValueValidationCallback() {
        return (Callback)this.valueValidationCallbackObjectProperty.getValue();
    }

    public void setValueValidationCallback(Callback<Calendar, Boolean> value) {
        this.valueValidationCallbackObjectProperty.setValue(value);
    }

    public CalendarTimePicker withValueValidationCallback(Callback<Calendar, Boolean> value) {
        this.setValueValidationCallback(value);
        return this;
    }
}

