/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control;

import java.util.Arrays;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import javafx.util.StringConverter;
import jfxtras.internal.scene.control.skin.ListSpinnerSkin;
import jfxtras.scene.control.ListSpinnerIntegerList;

public class ListSpinner<T>
extends Control {
    private ListChangeListener<T> listChangeListener = new ListChangeListener<T>(){

        public void onChanged(ListChangeListener.Change<? extends T> change) {
            int lIndex = ListSpinner.this.getIndex();
            if (lIndex >= ListSpinner.this.getItems().size()) {
                lIndex = ListSpinner.this.getItems().size() - 1;
                ListSpinner.this.setIndex(lIndex);
                return;
            }
            ListSpinner.this.valueObjectProperty.setValue(ListSpinner.this.getItems().get(lIndex));
        }
    };
    private final ObjectProperty<T> valueObjectProperty = new SimpleObjectProperty<T>((Object)this, "value", null){

        public void set(T value) {
            if (ListSpinner.this.getItems().indexOf(value) < 0) {
                throw new IllegalArgumentException("Value does not exist in the list: " + value);
            }
            super.set(value);
        }
    };
    private final ObjectProperty<Integer> indexObjectProperty = new SimpleObjectProperty<Integer>((Object)this, "index", null){

        public void set(Integer value) {
            if (value == null) {
                throw new NullPointerException("Null not allowed as the value for index");
            }
            if (value >= ListSpinner.this.getItems().size()) {
                throw new IllegalArgumentException("Index out of bounds: " + value + ", valid values are 0-" + (ListSpinner.this.getItems().size() - 1));
            }
            super.set((Object)value);
        }
    };
    private final ObjectProperty<Boolean> cyclicObjectProperty = new SimpleObjectProperty<Boolean>((Object)this, "cyclic", Boolean.valueOf(false)){

        public void set(Boolean value) {
            if (value == null) {
                throw new NullPointerException("Null not allowed as the value for cyclic");
            }
            super.set((Object)value);
        }
    };
    private final ObjectProperty<Boolean> editableObjectProperty = new SimpleObjectProperty<Boolean>((Object)this, "editable", Boolean.valueOf(false)){

        public void set(Boolean value) {
            if (value == null) {
                throw new NullPointerException("Null not allowed as the value for editable");
            }
            super.set((Object)value);
        }
    };
    private final ObjectProperty<String> postfixObjectProperty = new SimpleObjectProperty((Object)this, "postfix", (Object)"");
    private final ObjectProperty<String> prefixObjectProperty = new SimpleObjectProperty((Object)this, "prefix", (Object)"");
    private final ObjectProperty<ObservableList<T>> itemsObjectProperty = new SimpleObjectProperty<ObservableList<T>>((Object)this, "items", null){

        public void set(ObservableList<T> value) {
            if (value == null) {
                throw new NullPointerException("Null not allowed as the value for items");
            }
            super.set(value);
        }
    };
    private final ObjectProperty<Callback<ListSpinner<T>, Node>> cellFactoryObjectProperty = new SimpleObjectProperty((Object)this, "cellFactory", (Object)new DefaultCellFactory());
    private final ObjectProperty<StringConverter<T>> stringConverterObjectProperty = new SimpleObjectProperty((Object)this, "stringConverter", (Object)new DefaultStringConverter());
    private final ObjectProperty<Callback<T, Integer>> addCallbackObjectProperty = new SimpleObjectProperty((Object)this, "addCallback", null);
    private final ObjectProperty<EventHandler<CycleEvent>> iOnCycleObjectProperty = new SimpleObjectProperty(null);
    public static final String ONCYCLE_PROPERTY_ID = "onCycle";

    public ListSpinner() {
        this.construct();
    }

    public ListSpinner(ObservableList<T> items) {
        this.construct();
        this.setItems(items);
        this.first();
    }

    public ListSpinner(ObservableList<T> items, T startValue) {
        this.construct();
        this.setItems(items);
        this.setValue(startValue);
    }

    public ListSpinner(List<T> list) {
        this(FXCollections.observableList(list));
    }

    public ListSpinner(T ... list) {
        this(Arrays.asList(list));
    }

    public ListSpinner(int from, int to) {
        this(new ListSpinnerIntegerList(from, to));
    }

    public ListSpinner(int from, int to, int step) {
        this(new ListSpinnerIntegerList(from, to, step));
    }

    private void construct() {
        this.getStyleClass().add((Object)ListSpinner.class.getSimpleName());
        this.valueObjectProperty.addListener(new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> property, T oldValue, T newValue) {
                int lIdx = ListSpinner.this.getItems().indexOf(newValue);
                if (!ListSpinner.equals(ListSpinner.this.indexObjectProperty.getValue(), lIdx)) {
                    ListSpinner.this.indexObjectProperty.setValue((Object)lIdx);
                }
            }
        });
        this.indexObjectProperty.addListener((ChangeListener)new ChangeListener<Integer>(){

            public void changed(ObservableValue<? extends Integer> property, Integer oldIndex, Integer newIndex) {
                Object lValue;
                Object object = lValue = newIndex < 0 ? null : ListSpinner.this.getItems().get(newIndex.intValue());
                if (!ListSpinner.equals(ListSpinner.this.valueObjectProperty.getValue(), lValue)) {
                    ListSpinner.this.valueObjectProperty.setValue(lValue);
                }
            }
        });
        this.itemsObjectProperty.addListener(new ChangeListener<ObservableList<T>>(){

            public void changed(ObservableValue<? extends ObservableList<T>> property, ObservableList<T> oldList, ObservableList<T> newList) {
                if (oldList != null) {
                    oldList.removeListener(ListSpinner.this.listChangeListener);
                }
                if (newList != null) {
                    newList.addListener(ListSpinner.this.listChangeListener);
                }
            }
        });
    }

    public String getUserAgentStylesheet() {
        return ListSpinner.class.getResource("/jfxtras/internal/scene/control/" + ListSpinner.class.getSimpleName() + ".css").toExternalForm();
    }

    public Skin<?> createDefaultSkin() {
        return new ListSpinnerSkin(this);
    }

    public ListSpinner<T> withId(String value) {
        this.setId(value);
        return this;
    }

    public ObjectProperty<T> valueProperty() {
        return this.valueObjectProperty;
    }

    public T getValue() {
        return (T)this.valueObjectProperty.getValue();
    }

    public void setValue(T value) {
        this.valueObjectProperty.setValue(value);
    }

    public ListSpinner<T> withValue(T value) {
        this.setValue(value);
        return this;
    }

    public ObjectProperty<Integer> indexProperty() {
        return this.indexObjectProperty;
    }

    public Integer getIndex() {
        return (Integer)this.indexObjectProperty.getValue();
    }

    public void setIndex(Integer value) {
        this.indexObjectProperty.setValue((Object)value);
    }

    public ListSpinner<T> withIndex(Integer value) {
        this.setIndex(value);
        return this;
    }

    public ObjectProperty<Boolean> cyclicProperty() {
        return this.cyclicObjectProperty;
    }

    public Boolean isCyclic() {
        return (Boolean)this.cyclicObjectProperty.getValue();
    }

    public void setCyclic(Boolean value) {
        this.cyclicObjectProperty.setValue((Object)value);
    }

    public ListSpinner<T> withCyclic(Boolean value) {
        this.setCyclic(value);
        return this;
    }

    public ObjectProperty<Boolean> editableProperty() {
        return this.editableObjectProperty;
    }

    public Boolean isEditable() {
        return (Boolean)this.editableObjectProperty.getValue();
    }

    public void setEditable(Boolean value) {
        this.editableObjectProperty.setValue((Object)value);
    }

    public ListSpinner<T> withEditable(Boolean value) {
        this.setEditable(value);
        return this;
    }

    public ObjectProperty<String> postfixProperty() {
        return this.postfixObjectProperty;
    }

    public String getPostfix() {
        return (String)this.postfixObjectProperty.getValue();
    }

    public void setPostfix(String value) {
        this.postfixObjectProperty.setValue((Object)value);
    }

    public ListSpinner<T> withPostfix(String value) {
        this.setPostfix(value);
        return this;
    }

    public ObjectProperty<String> prefixProperty() {
        return this.prefixObjectProperty;
    }

    public String getPrefix() {
        return (String)this.prefixObjectProperty.getValue();
    }

    public void setPrefix(String value) {
        this.prefixObjectProperty.setValue((Object)value);
    }

    public ListSpinner<T> withPrefix(String value) {
        this.setPrefix(value);
        return this;
    }

    public ObjectProperty<ObservableList<T>> itemsProperty() {
        return this.itemsObjectProperty;
    }

    public ObservableList<T> getItems() {
        return (ObservableList)this.itemsObjectProperty.getValue();
    }

    public void setItems(ObservableList<T> value) {
        this.itemsObjectProperty.setValue(value);
    }

    public ListSpinner<T> withItems(ObservableList<T> value) {
        this.setItems(value);
        return this;
    }

    public ObjectProperty<Callback<ListSpinner<T>, Node>> cellFactoryProperty() {
        return this.cellFactoryObjectProperty;
    }

    public Callback<ListSpinner<T>, Node> getCellFactory() {
        return (Callback)this.cellFactoryObjectProperty.getValue();
    }

    public void setCellFactory(Callback<ListSpinner<T>, Node> value) {
        this.cellFactoryObjectProperty.setValue(value);
    }

    public ListSpinner<T> withCellFactory(Callback<ListSpinner<T>, Node> value) {
        this.setCellFactory(value);
        return this;
    }

    public ObjectProperty<StringConverter<T>> stringConverterProperty() {
        return this.stringConverterObjectProperty;
    }

    public StringConverter<T> getStringConverter() {
        return (StringConverter)this.stringConverterObjectProperty.getValue();
    }

    public void setStringConverter(StringConverter<T> value) {
        this.stringConverterObjectProperty.setValue(value);
    }

    public ListSpinner<T> withStringConverter(StringConverter<T> value) {
        this.setStringConverter(value);
        return this;
    }

    public ObjectProperty<Callback<T, Integer>> addCallbackProperty() {
        return this.addCallbackObjectProperty;
    }

    public Callback<T, Integer> getAddCallback() {
        return (Callback)this.addCallbackObjectProperty.getValue();
    }

    public void setAddCallback(Callback<T, Integer> value) {
        this.addCallbackObjectProperty.setValue(value);
    }

    public ListSpinner<T> withAddCallback(Callback<T, Integer> value) {
        this.setAddCallback(value);
        return this;
    }

    public ObjectProperty<EventHandler<CycleEvent>> onCycleProperty() {
        return this.iOnCycleObjectProperty;
    }

    public EventHandler<CycleEvent> getOnCycle() {
        return (EventHandler)this.iOnCycleObjectProperty.getValue();
    }

    public void setOnCycle(EventHandler<CycleEvent> value) {
        this.iOnCycleObjectProperty.setValue(value);
    }

    public ListSpinner<T> withOnCycle(EventHandler<CycleEvent> value) {
        this.setOnCycle(value);
        return this;
    }

    public void fireCycleEvent(CycleDirection cycleDirection) {
        EventHandler<CycleEvent> lCycleEventHandler = this.getOnCycle();
        if (lCycleEventHandler != null) {
            CycleEvent lCycleEvent = new CycleEvent();
            lCycleEvent.cycleDirection = cycleDirection;
            lCycleEventHandler.handle((Event)lCycleEvent);
        }
    }

    public void first() {
        if (this.getItems() == null || this.getItems().size() == 0) {
            return;
        }
        this.indexObjectProperty.setValue((Object)0);
    }

    public void decrement() {
        if (this.getItems() == null || this.getItems().size() == 0) {
            return;
        }
        int lOldIdx = (Integer)this.indexObjectProperty.getValue();
        int lIdx = lOldIdx - 1;
        if (lIdx < 0) {
            if (this.isCyclic() != null && !this.isCyclic().booleanValue()) {
                return;
            }
            lIdx = this.getItems().size() - 1;
            this.fireCycleEvent(CycleDirection.BOTTOM_TO_TOP);
        }
        this.indexObjectProperty.setValue((Object)lIdx);
    }

    public void increment() {
        if (this.getItems() == null || this.getItems().size() == 0) {
            return;
        }
        int lOldIdx = (Integer)this.indexObjectProperty.getValue();
        int lIdx = lOldIdx + 1;
        if (lIdx >= this.getItems().size()) {
            if (this.isCyclic() != null && !this.isCyclic().booleanValue()) {
                return;
            }
            lIdx = 0;
            this.fireCycleEvent(CycleDirection.TOP_TO_BOTTOM);
        }
        this.indexObjectProperty.setValue((Object)lIdx);
    }

    public void last() {
        if (this.getItems() == null || this.getItems().size() == 0) {
            return;
        }
        this.indexObjectProperty.setValue((Object)(this.getItems().size() - 1));
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static enum CycleDirection {
        TOP_TO_BOTTOM,
        BOTTOM_TO_TOP;

    }

    public static class CycleEvent
    extends Event {
        public static final EventType<CycleEvent> CYCLE = new EventType(Event.ANY, "CYCLE");
        private Object oldIdx;
        private Object newIdx;
        CycleDirection cycleDirection;

        public CycleEvent() {
            super(CYCLE);
        }

        public CycleEvent(Object source, EventTarget target) {
            super(source, target, new EventType());
        }

        public Object getOldIdx() {
            return this.oldIdx;
        }

        public Object getNewIdx() {
            return this.newIdx;
        }

        public boolean cycledDown() {
            return this.cycleDirection == CycleDirection.TOP_TO_BOTTOM;
        }

        public boolean cycledUp() {
            return this.cycleDirection == CycleDirection.BOTTOM_TO_TOP;
        }
    }

    class DefaultCellFactory
    implements Callback<ListSpinner<T>, Node> {
        private Label label = null;

        DefaultCellFactory() {
        }

        public Node call(ListSpinner<T> spinner) {
            Object lValue = spinner.getValue();
            if (this.label == null) {
                this.label = new Label();
            }
            this.label.setText((String)(lValue == null ? "" : spinner.getPrefix() + ListSpinner.this.getStringConverter().toString(lValue) + spinner.getPostfix()));
            return this.label;
        }
    }

    class DefaultStringConverter
    extends StringConverter<T> {
        DefaultStringConverter() {
        }

        public T fromString(String string) {
            throw new IllegalStateException("No StringConverter is set. An editable Spinner must have a StringConverter to be able to render and parse the value.");
        }

        public String toString(T value) {
            return value == null ? "" : value.toString();
        }
    }
}

