/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control.builders;

import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import jfxtras.fxml.BuilderService;
import jfxtras.scene.control.LocalDateTimeTextField;
import jfxtras.scene.control.builders.AbstractLocalDateTimeAPITextFieldBuilder;

public class LocalDateTimeTextFieldBuilder
extends AbstractLocalDateTimeAPITextFieldBuilder
implements BuilderService<LocalDateTimeTextField> {
    public LocalDateTimeTextField build() {
        Locale lLocale = this.iLocale == null ? Locale.getDefault() : this.iLocale;
        LocalDateTimeTextField lLocalDateTimeTextField = new LocalDateTimeTextField();
        if (this.iDateTimeFormatter != null) {
            lLocalDateTimeTextField.setDateTimeFormatter(DateTimeFormatter.ofPattern(this.iDateTimeFormatter).withLocale(lLocale));
        }
        if (this.iLocale != null) {
            lLocalDateTimeTextField.setLocale(this.iLocale);
        }
        if (this.iPromptText != null) {
            lLocalDateTimeTextField.setPromptText(this.iPromptText);
        }
        if (this.iDateTimeFormatters != null) {
            ObservableList lDateTimeFormatters = FXCollections.observableArrayList();
            for (String lPart : this.iDateTimeFormatters) {
                lDateTimeFormatters.add((Object)DateTimeFormatter.ofPattern(lPart.trim()).withLocale(lLocale));
            }
            lLocalDateTimeTextField.setDateTimeFormatters((ObservableList<DateTimeFormatter>)lDateTimeFormatters);
        }
        this.applyCommonProperties((Node)lLocalDateTimeTextField);
        return lLocalDateTimeTextField;
    }

    public boolean isBuilderFor(Class<?> clazz) {
        return LocalDateTimeTextField.class.isAssignableFrom(clazz);
    }
}

