/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.data;

import de.effectivecompany.base.data.AbstractBusinessData;
import de.effectivecompany.base.data.BusinessListEntry;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractBusinessDataList
extends AbstractBusinessData
implements Serializable {
    private static final long serialVersionUID = -1164401906446951994L;
    private EFCList<BusinessListEntry> originData;
    private List<String> groups;
    private Map<String, String> groupnames;
    private List<String> dataset;
    private Map<String, Object> datasetnames;
    private List<List<BusinessObject>> data = new LinkedList<List<BusinessObject>>();

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public EFCList<BusinessListEntry> getOriginData() {
        return this.originData;
    }

    @Override
    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    @Override
    public Map<String, String> getGroupnames() {
        return this.groupnames;
    }

    @Override
    public void setGroupnames(Map<String, String> groupnames) {
        this.groupnames = groupnames;
    }

    @Override
    public List<String> getDataset() {
        return this.dataset;
    }

    @Override
    public void setDataset(List<String> dataset) {
        this.dataset = dataset;
    }

    @Override
    public Map<String, Object> getDatasetnames() {
        return this.datasetnames;
    }

    @Override
    public void setDatasetnames(Map<String, Object> datasetnames) {
        this.datasetnames = datasetnames;
    }

    @Override
    public List<List<BusinessObject>> getData() {
        return this.data;
    }

    @Override
    public void setData(List<List<BusinessObject>> data) {
        this.data = data;
    }

    public AbstractBusinessDataList() {
        this.groups = new LinkedList<String>();
        this.dataset = new LinkedList<String>();
        this.groupnames = new LinkedHashMap<String, String>();
        this.datasetnames = new LinkedHashMap<String, Object>();
    }

    public void loadData(List<BusinessListEntry> statdata) {
        for (BusinessListEntry entry : statdata) {
            if (this.groups.contains(entry.getGroup())) continue;
            this.groups.add(entry.getGroup());
        }
        for (BusinessListEntry entry : statdata) {
            if (this.dataset.contains(entry.getDataset())) continue;
            this.dataset.add(entry.getDataset());
            this.data.add(new LinkedList());
            int id = this.dataset.indexOf(entry.getDataset());
            for (int i = 0; i < this.groups.size(); ++i) {
                this.data.get(id).add(null);
            }
        }
        for (BusinessListEntry entry : statdata) {
            int setid = this.dataset.indexOf(entry.getDataset());
            int groupid = this.groups.indexOf(entry.getGroup());
            this.data.get(setid).set(groupid, entry.getValue());
        }
    }

    public void loadData(EFCList<BusinessListEntry> statdata, EFCMap<EFCString, EFCString> allgroups, EFCMap<EFCString, EFCString> alldatasets) {
        for (Map.Entry e : allgroups.entrySet()) {
            String key = ((EFCString)e.getKey()).getData();
            if (this.groups.contains(key)) continue;
            this.groups.add(key);
            this.groupnames.put(key, ((EFCString)e.getValue()).toString());
        }
        for (Map.Entry e : alldatasets.entrySet()) {
            String comp = ((EFCString)e.getKey()).getData();
            if (this.dataset.contains(comp)) continue;
            this.dataset.add(comp);
            this.datasetnames.put(comp, e.getValue());
            this.data.add(new LinkedList());
            int id = this.dataset.indexOf(comp);
            for (int i = 0; i < this.groups.size(); ++i) {
                this.data.get(id).add(null);
            }
        }
        for (BusinessListEntry entry : statdata) {
            int setid = this.dataset.indexOf(entry.getDataset());
            int groupid = this.groups.indexOf(entry.getGroup());
            if (groupid < 0 || setid < 0) {
                System.err.println("invalid group or dataset selected: g=" + entry.getGroup() + " | d=" + entry.getDataset());
                continue;
            }
            this.data.get(setid).set(groupid, entry.getValue());
        }
    }

    public void loadData(EFCList<BusinessListEntry> statdata, EFCMap<EFCString, EFCString> allgroups, EFCMap<EFCString, EFCString> alldatasets, EFCList<BusinessListEntry> headerdata) {
        for (Map.Entry e : allgroups.entrySet()) {
            String key = ((EFCString)e.getKey()).getData();
            if (this.groups.contains(key)) continue;
            this.groups.add(key);
            this.groupnames.put(((EFCString)e.getKey()).toString(), ((EFCString)e.getValue()).toString());
        }
        for (Map.Entry e : alldatasets.entrySet()) {
            String comp = ((EFCString)e.getKey()).getData();
            if (this.dataset.contains(comp)) continue;
            this.dataset.add(comp);
            this.data.add(new LinkedList());
            int id = this.dataset.indexOf(comp);
            for (int i = 0; i < this.groups.size(); ++i) {
                this.data.get(id).add(null);
            }
        }
        for (BusinessListEntry entry : headerdata) {
            this.datasetnames.put(entry.getDataset().toString(), entry.getValue());
        }
        this.originData = statdata;
        for (BusinessListEntry entry : this.originData) {
            int setid = this.dataset.indexOf(entry.getDataset());
            int groupid = this.groups.indexOf(entry.getGroup());
            if (groupid < 0 || setid < 0) {
                System.err.println("invalid group or dataset selected: g=" + entry.getGroup() + " | d=" + entry.getDataset());
                continue;
            }
            this.data.get(setid).set(groupid, entry.getValue());
        }
    }

    public void loadData(EFCList<BusinessListEntry> statdata, EFCMap<EFCString, EFCString> allgroups, EFCMap<EFCString, EFCString> alldatasets, EFCMap<EFCString, Object> alldatasetNames) {
        for (Map.Entry e : allgroups.entrySet()) {
            String key = ((EFCString)e.getKey()).getData();
            if (this.groups.contains(key)) continue;
            this.groups.add(key);
            this.groupnames.put(((EFCString)e.getKey()).toString(), ((EFCString)e.getValue()).toString());
        }
        for (Map.Entry e : alldatasets.entrySet()) {
            String comp = ((EFCString)e.getKey()).getData();
            if (this.dataset.contains(comp)) continue;
            this.dataset.add(comp);
            if (alldatasetNames.containsKey(e.getKey())) {
                this.datasetnames.put(comp, alldatasetNames.get(e.getKey()));
            } else {
                this.datasetnames.put(comp, e.getValue());
            }
            this.data.add(new LinkedList());
            int id = this.dataset.indexOf(comp);
            for (int i = 0; i < this.groups.size(); ++i) {
                this.data.get(id).add(null);
            }
        }
        for (BusinessListEntry entry : statdata) {
            int setid = this.dataset.indexOf(entry.getDataset());
            int groupid = this.groups.indexOf(entry.getGroup());
            if (groupid < 0 || setid < 0) {
                System.err.println("invalid group or dataset selected: g=" + entry.getGroup() + " | d=" + entry.getDataset());
                continue;
            }
            this.data.get(setid).set(groupid, entry.getValue());
        }
    }

    public void loadData(List<BusinessListEntry> statdata, Map<EFCString, String> allgroups, Map<EFCString, String> alldatasets, Map<EFCString, Object> alldatasetNames) {
        for (Map.Entry<EFCString, String> e : allgroups.entrySet()) {
            String key = e.getKey().getData();
            if (this.groups.contains(key)) continue;
            this.groups.add(key);
            this.groupnames.put(e.getKey().toString(), e.getValue());
        }
        for (Map.Entry<EFCString, String> e : alldatasets.entrySet()) {
            String comp = e.getKey().getData();
            if (this.dataset.contains(comp)) continue;
            this.dataset.add(comp);
            if (alldatasetNames.containsKey(e.getKey())) {
                this.datasetnames.put(comp, alldatasetNames.get(e.getKey()));
            } else {
                this.datasetnames.put(comp, e.getValue().toString());
            }
            this.data.add(new LinkedList());
            int id = this.dataset.indexOf(comp);
            for (int i = 0; i < this.groups.size(); ++i) {
                this.data.get(id).add(null);
            }
        }
        for (BusinessListEntry entry : statdata) {
            int setid = this.dataset.indexOf(entry.getDataset());
            int groupid = this.groups.indexOf(entry.getGroup());
            if (groupid < 0 || setid < 0) {
                System.err.println("invalid group or dataset selected: g=" + entry.getGroup() + " | d=" + entry.getDataset());
                continue;
            }
            this.data.get(setid).set(groupid, entry.getValue());
        }
    }

    public void loadData(List<BusinessListEntry> statdata, Map<EFCString, String> allgroups, Map<EFCString, String> alldatasets) {
        for (Map.Entry<EFCString, String> e : allgroups.entrySet()) {
            String key = e.getKey().getData();
            if (this.groups.contains(key)) continue;
            this.groups.add(key);
            this.groupnames.put(e.getKey().toString(), e.getValue());
        }
        for (Map.Entry<EFCString, String> e : alldatasets.entrySet()) {
            String comp = e.getKey().getData();
            if (this.dataset.contains(comp)) continue;
            this.dataset.add(comp);
            this.datasetnames.put(comp, e.getValue());
            this.data.add(new LinkedList());
            int id = this.dataset.indexOf(comp);
            for (int i = 0; i < this.groups.size(); ++i) {
                this.data.get(id).add(null);
            }
        }
        for (BusinessListEntry entry : statdata) {
            int setid = this.dataset.indexOf(entry.getDataset());
            int groupid = this.groups.indexOf(entry.getGroup());
            if (groupid < 0 || setid < 0) {
                System.err.println("invalid group or dataset selected: g=" + entry.getGroup() + " | d=" + entry.getDataset());
                continue;
            }
            this.data.get(setid).set(groupid, entry.getValue());
        }
    }

    @Override
    public int getGroupCount() {
        return this.groups.size();
    }

    @Override
    public String getGroupKey(int groupid) {
        return this.groups.get(groupid);
    }

    @Override
    public int getDatasetCount() {
        return this.data.size();
    }

    @Override
    public Object getDatasetName(int datalist) {
        if (this.datasetnames.keySet().contains(this.getDatasetKey(datalist))) {
            return this.datasetnames.get(this.getDatasetKey(datalist));
        }
        return this.dataset.get(datalist).toString();
    }

    @Override
    public String getDatasetKey(int datasetid) {
        return this.dataset.get(datasetid);
    }

    @Override
    public String getGroupName(int groupid) {
        if (this.groupnames.keySet().contains(this.getGroupKey(groupid))) {
            return this.groupnames.get(this.getGroupKey(groupid));
        }
        return this.groups.get(groupid).toString();
    }

    @Override
    public String[] getDatasetKeys() {
        return this.dataset.toArray(new String[0]);
    }

    @Override
    public String[] getGroupKeys() {
        return this.groups.toArray(new String[0]);
    }

    @Override
    public BusinessObject getValue(int datalist, int group) {
        return this.data.get(datalist).get(group);
    }

    @Override
    public void setValue(int datalist, int group, BusinessObject value) {
        this.data.get(datalist).set(group, value);
    }
}

