/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.json.EFCDateJsonDeserializer;
import de.effectivecompany.base.datatypes.json.EFCDateJsonSerializer;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

@JsonIgnoreProperties(value={"date", "datetimeinmillis", "maxsize", "minsize", "metadata"})
@JsonSerialize(using=EFCDateJsonSerializer.class)
@JsonDeserialize(using=EFCDateJsonDeserializer.class)
public final class EFCDate
extends EFCDateTime {
    private static final long serialVersionUID = -3262906895658588891L;

    public EFCDate() {
    }

    public EFCDate(Long date) {
        this(new Date(date));
    }

    public EFCDate(Integer date) {
        this(new Date(date.intValue()));
    }

    public EFCDate(Date date) {
        this();
        this.putValue(date);
    }

    public EFCDate(String date) {
        this();
        this.putValue(date);
    }

    public EFCDate(EFCString date) {
        this();
        this.putValue(date);
    }

    public EFCDate(EFCDateTime date) {
        super(date);
    }

    public EFCDate(EFCDate val) {
        super(val);
    }

    @Override
    public EFCDate clone() {
        return new EFCDate(this);
    }

    @Override
    public void defaults() {
        super.defaults();
        if (this.data != null) {
            Date date;
            try {
                date = formatDate.parse(formatDate.format(new Date(this.data)));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("wrong date format: " + e.getMessage(), e);
            }
            this.putValue(date);
        }
    }

    @Override
    public void defaultsLocale() {
        super.defaultsLocale();
        if (this.data != null) {
            Date date;
            try {
                date = formatDate.parse(formatDate.format(new Date(this.data)));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("wrong date format: " + e.getMessage(), e);
            }
            this.putValue(date);
        }
    }

    @Override
    public void setData(Long newData) {
        super.setData(newData);
        if (this.data != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date(this.data));
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(10, 0);
            cal.set(11, 0);
            this.data = cal.getTimeInMillis();
        }
    }

    @Override
    public String toString() {
        if (this.data == null) {
            return "";
        }
        return formatDate.format(this.getDate());
    }
}

