/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes;

import com.esotericsoftware.kryo.Kryo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.Metadata;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.base.datatypes.json.EFCListJsonDeserializer;
import de.effectivecompany.base.datatypes.json.EFCListJsonSerializer;
import de.effectivecompany.base.util.SerializationUtilities;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

@JsonIgnoreProperties(value={"metadata", "langultext", "langustext"})
@JsonSerialize(using=EFCListJsonSerializer.class)
@JsonDeserialize(using=EFCListJsonDeserializer.class)
public class EFCList<T>
extends Vector<T>
implements Type,
Metadata,
List<T> {
    public static final long serialVersionUID = -13526243463415L;
    private boolean initialized = false;
    private boolean modified = false;

    public EFCList() {
    }

    public EFCList(int initialCapacity) {
        super(initialCapacity);
    }

    public EFCList(EFCList<T> val) {
        this();
        if (val != null) {
            this.addAll(val.clone());
            this.putMetadata(val.getMetadata());
            this.setInitialized();
        }
        this.setModified(false);
    }

    public EFCList(List<T> val) {
        this();
        if (val != null) {
            Kryo kryo = SerializationUtilities.optainKryo();
            List deepCopyData = (List)kryo.copy(val);
            SerializationUtilities.freeKryo(kryo);
            this.addAll(deepCopyData);
            this.setInitialized();
        }
        this.setModified(false);
    }

    @Override
    public Object optainValue() {
        return this;
    }

    @Override
    public void putValue(Object o) {
        if (o != null && o instanceof EFCList && this.equals(o) || o == null && this.isEmpty()) {
            this.setModified(false);
            return;
        }
        if (this == o) {
            return;
        }
        if (o == null) {
            this.nullData();
            return;
        }
        if (o instanceof EFCList) {
            this.clear();
            Iterator it = ((EFCList)o).iterator();
            while (it.hasNext()) {
                this.add((T)it.next());
            }
            this.setModified(true);
        } else if (o instanceof List) {
            this.clear();
            Iterator it = ((List)o).iterator();
            while (it.hasNext()) {
                this.add((T)it.next());
            }
            this.setModified(true);
        } else {
            this.add((T)o);
            this.setModified(true);
        }
        this.setInitialized();
    }

    public List<T> getList() {
        return this;
    }

    @Override
    public synchronized boolean add(T e) {
        boolean ret = super.add(e);
        if (ret) {
            this.setModified(true);
            this.setInitialized();
        }
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof List) {
            List l = (List)o;
            if (l.size() != this.size()) {
                return false;
            }
            ListIterator it1 = this.listIterator();
            ListIterator it2 = l.listIterator();
            while (it1.hasNext() && it2.hasNext()) {
                Object o1 = it1.next();
                Object o2 = it2.next();
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                return false;
            }
            return !it1.hasNext() && !it2.hasNext();
        }
        return super.equals(o);
    }

    public JRBeanCollectionDataSource getData() {
        return new JRBeanCollectionDataSource((Collection)this, false);
    }

    public EFCString getLanguStext(EFCString langu, EFCString defStext) {
        Method method = null;
        EFCString resultString = null;
        try {
            for (int i = 0; i < this.size(); ++i) {
                Object item = this.get(i);
                method = item.getClass().getDeclaredMethod("getLangu", new Class[0]);
                Object clLang = method.invoke(item, new Object[0]);
                EFCString lang = (EFCString)(method = clLang.getClass().getDeclaredMethod("getLangu", new Class[0])).invoke(clLang, new Object[0]);
                if (!lang.equals(langu)) continue;
                method = item.getClass().getDeclaredMethod("getStext", new Class[0]);
                resultString = (EFCString)method.invoke(item, new Object[0]);
            }
            if (resultString == null) {
                resultString = defStext;
            }
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("illegal access on " + method.getName(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("method call failed", ex.getTargetException());
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("no such method ", ex);
        }
        return resultString;
    }

    public EFCString getLanguLtext(EFCString langu, EFCString defLtext) {
        Method method = null;
        EFCString resultString = null;
        try {
            for (int i = 0; i < this.size(); ++i) {
                Object item = this.get(i);
                method = item.getClass().getDeclaredMethod("getLangu", new Class[0]);
                Object clLang = method.invoke(item, new Object[0]);
                EFCString lang = (EFCString)(method = clLang.getClass().getDeclaredMethod("getLangu", new Class[0])).invoke(clLang, new Object[0]);
                if (!lang.equals(langu)) continue;
                method = item.getClass().getDeclaredMethod("getLtext", new Class[0]);
                resultString = (EFCString)method.invoke(item, new Object[0]);
            }
            if (resultString == null) {
                resultString = defLtext;
            }
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("illegal access on " + method.getName(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("method call failed", ex.getTargetException());
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("no such method ", ex);
        }
        return resultString;
    }

    public EFCString getLanguStext(String langu, String defStext) {
        Method method = null;
        EFCString resultString = null;
        try {
            for (int i = 0; i < this.size(); ++i) {
                Object item = this.get(i);
                method = item.getClass().getDeclaredMethod("getLangu", new Class[0]);
                Object clLang = method.invoke(item, new Object[0]);
                EFCString lang = (EFCString)(method = clLang.getClass().getDeclaredMethod("getLangu", new Class[0])).invoke(clLang, new Object[0]);
                if (lang == null || !lang.getData().equals(langu)) continue;
                method = item.getClass().getDeclaredMethod("getStext", new Class[0]);
                resultString = (EFCString)method.invoke(item, new Object[0]);
            }
            if (resultString == null) {
                resultString = new EFCString(defStext);
            }
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("illegal access on " + method.getName(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("method call failed", ex.getTargetException());
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("no such method ", ex);
        }
        return resultString;
    }

    public EFCString getLanguLtext(String langu, String defLtext) {
        Method method = null;
        EFCString resultString = null;
        try {
            for (int i = 0; i < this.size(); ++i) {
                Object item = this.get(i);
                method = item.getClass().getDeclaredMethod("getLangu", new Class[0]);
                Object clLang = method.invoke(item, new Object[0]);
                EFCString lang = (EFCString)(method = clLang.getClass().getDeclaredMethod("getLangu", new Class[0])).invoke(clLang, new Object[0]);
                if (!lang.equals(langu)) continue;
                method = item.getClass().getDeclaredMethod("getLtext", new Class[0]);
                resultString = (EFCString)method.invoke(item, new Object[0]);
            }
            if (resultString == null) {
                resultString = new EFCString(defLtext);
            }
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("illegal access on " + method.getName(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("method call failed", ex.getTargetException());
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("no such method ", ex);
        }
        return resultString;
    }

    @Override
    public EFCList<T> clone() {
        Kryo kryo = SerializationUtilities.optainKryo();
        EFCList ret = (EFCList)kryo.copy((Object)this);
        SerializationUtilities.freeKryo(kryo);
        return ret;
    }

    @Override
    public boolean isInit() {
        return this.initialized;
    }

    @Override
    public void putInit(boolean isInit) {
        this.initialized = isInit;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void putModified(boolean isModified) {
        this.modified = isModified;
    }

    public void setModified(boolean isModified) {
        this.modified = isModified;
    }

    public void setInitialized(boolean isInit) {
        this.initialized = isInit;
    }

    public void setInitialized() {
        this.putInit(true);
    }

    public void setUnInitialized() {
        this.putInit(false);
    }

    public boolean isInitialized() {
        return this.isInit();
    }

    @Override
    public Metadata getMetadata() {
        return this;
    }

    @Override
    public long getMaxsize() {
        return this.size();
    }

    @Override
    public void putMaxsize(long maxsize) {
        throw new RuntimeException("putMaxsize call not allowed");
    }

    public void putMetadata(Metadata meta) {
        this.putInit(meta.isInit());
        this.putModified(meta.isModified());
    }

    @Override
    public long getMinsize() {
        return this.size();
    }

    @Override
    public void putMinsize(long minsize) {
        throw new RuntimeException("putMinsize call not allowed");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isInitialized(), this.isModified()) + 7 * super.hashCode();
    }

    protected void nullData() {
        this.setModified(!this.isEmpty());
        this.clear();
        this.setUnInitialized();
    }
}

