/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.effectivecompany.base.datatypes.EFCFloat;
import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.NumberType;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.base.datatypes.json.EFCLongJsonDeserializer;
import de.effectivecompany.base.datatypes.json.EFCLongJsonSerializer;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Objects;

@JsonIgnoreProperties(value={"maxsize", "minsize", "metadata", "init", "bytevalue", "doublevalue", "floatvalue", "intvalue", "longvalue"})
@JsonSerialize(using=EFCLongJsonSerializer.class)
@JsonDeserialize(using=EFCLongJsonDeserializer.class)
public class EFCLong
extends NumberType {
    private static final long serialVersionUID = -5337895766091260971L;
    protected Long data = null;

    @Override
    public int hashCode() {
        return Objects.hash(this.isInitialized(), this.isModified(), this.data);
    }

    public EFCLong() {
    }

    public EFCLong(String s) {
        this();
        this.putValue(s);
        this.setModified(false);
    }

    public EFCLong(EFCString s) {
        this();
        this.putValue(s);
        this.setModified(false);
    }

    public EFCLong(Long i) {
        this();
        this.setData(i);
        this.setModified(false);
    }

    public EFCLong(EFCInteger i) {
        this();
        this.putValue(i);
        this.setModified(false);
    }

    public EFCLong(Integer i) {
        this();
        this.putValue(i);
        this.setModified(false);
    }

    public EFCLong(EFCLong val) {
        this();
        if (val != null) {
            this.data = val.data;
            this.putMetadata(val.getMetadata());
            this.setInitialized();
        }
        this.setModified(false);
    }

    @Override
    protected void nullData() {
        this.setModified(this.data != null);
        this.data = null;
        this.setUnInitialized();
    }

    @Override
    public Object optainValue() {
        return this.data;
    }

    @Override
    public Long getLongValue() {
        return this.data;
    }

    @Override
    public Double getDoubleValue() {
        if (this.data == null) {
            return null;
        }
        return this.data.doubleValue();
    }

    @Override
    public boolean decimalsAllowed() {
        return false;
    }

    @Override
    public String toString() {
        if (this.data == null) {
            return "";
        }
        return Long.toString(this.data);
    }

    public long toLong() {
        return this.data;
    }

    public void setData(Long newData) {
        if (newData != null && this.data != null && this.data.equals(newData) || this.data == null && newData == null) {
            this.setModified(false);
            return;
        }
        if (this.data != null) {
            if (newData != null) {
                this.setModified(!newData.equals(this.data));
            } else {
                this.setModified(true);
            }
        } else {
            this.setModified(true);
        }
        this.data = newData;
        this.setInit(this.data != null);
    }

    public Long getData() {
        return this.data;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof EFCInteger) {
            return this.equals((EFCInteger)obj);
        }
        if (obj instanceof EFCLong) {
            return this.equals((EFCLong)obj);
        }
        if (obj instanceof EFCFloat) {
            return this.equals((EFCFloat)obj);
        }
        if (obj instanceof EFCString) {
            return this.equals((EFCString)obj);
        }
        return false;
    }

    @Override
    public final NumberType plus(byte v) {
        return new EFCLong(this.getLongValue() + (long)v);
    }

    @Override
    public final NumberType plus(int v) {
        return new EFCLong(this.getLongValue() + (long)v);
    }

    @Override
    public final NumberType plus(long v) {
        return new EFCLong(this.getLongValue() + v);
    }

    @Override
    public final NumberType plus(float v) {
        return new EFCLong((long)(this.getDoubleValue() + (double)v));
    }

    @Override
    public final NumberType plus(double v) {
        return new EFCLong((long)(this.getDoubleValue() + v));
    }

    @Override
    public final NumberType minus(byte v) {
        return new EFCLong(this.getLongValue() - (long)v);
    }

    @Override
    public final NumberType minus(int v) {
        return new EFCLong(this.getLongValue() - (long)v);
    }

    @Override
    public final NumberType minus(long v) {
        return new EFCLong(this.getLongValue() - v);
    }

    @Override
    public final NumberType minus(float v) {
        return new EFCLong((long)((float)this.getLongValue().longValue() - v));
    }

    @Override
    public final NumberType minus(double v) {
        return new EFCLong((long)((double)this.getLongValue().longValue() - v));
    }

    @Override
    public final NumberType multiply(byte v) {
        return new EFCLong(this.getLongValue() * (long)v);
    }

    @Override
    public final NumberType multiply(int v) {
        return new EFCLong(this.getLongValue() * (long)v);
    }

    @Override
    public final NumberType multiply(long v) {
        return new EFCLong(this.getLongValue() * v);
    }

    @Override
    public final NumberType multiply(float v) {
        return new EFCLong((long)((float)this.getLongValue().longValue() * v));
    }

    @Override
    public final NumberType multiply(double v) {
        return new EFCLong((long)((double)this.getLongValue().longValue() * v));
    }

    @Override
    public final NumberType div(byte v) {
        return new EFCLong(this.getLongValue() / (long)v);
    }

    @Override
    public final NumberType div(int v) {
        return new EFCLong(this.getLongValue() / (long)v);
    }

    @Override
    public final NumberType div(long v) {
        return new EFCLong(this.getLongValue() / v);
    }

    @Override
    public final NumberType div(float v) {
        return new EFCLong((long)((float)this.getLongValue().longValue() / v));
    }

    @Override
    public final NumberType div(double v) {
        return new EFCLong((long)((double)this.getLongValue().longValue() / v));
    }

    @Override
    public final NumberType power(byte v) {
        return new EFCLong((long)Math.pow(this.getLongValue().longValue(), v));
    }

    @Override
    public final NumberType power(int v) {
        return new EFCLong((long)Math.pow(this.getLongValue().longValue(), v));
    }

    @Override
    public final NumberType power(long v) {
        return new EFCLong((long)Math.pow(this.getLongValue().longValue(), v));
    }

    @Override
    public final NumberType power(float v) {
        return new EFCLong((long)Math.pow(this.getLongValue().longValue(), v));
    }

    @Override
    public final NumberType power(double v) {
        return new EFCLong((long)Math.pow(this.getLongValue().longValue(), v));
    }

    @Override
    public final NumberType mod(byte v) {
        return new EFCLong(this.getLongValue() % (long)v);
    }

    @Override
    public final NumberType mod(int v) {
        return new EFCLong(this.getLongValue() % (long)v);
    }

    @Override
    public final NumberType mod(long v) {
        return new EFCLong(this.getLongValue() % v);
    }

    @Override
    public final NumberType mod(float v) {
        return new EFCLong((long)((float)this.getLongValue().longValue() % v));
    }

    @Override
    public final NumberType mod(double v) {
        return new EFCLong((long)((double)this.getLongValue().longValue() % v));
    }

    public EFCLong clone() {
        return new EFCLong(this);
    }

    @Override
    public void putValue(Object o) throws NumberFormatException {
        if (this == o) {
            return;
        }
        if (o == null) {
            this.nullData();
            return;
        }
        if (o instanceof Type) {
            this.putValue(((Type)o).optainValue());
        } else {
            if (o instanceof String || o instanceof EFCString) {
                String st = o instanceof EFCString ? ((EFCString)o).getData() : (String)o;
                if ("".equals(st = st.trim()) || "null".equals(st)) {
                    this.nullData();
                    return;
                }
                Number result = null;
                NumberFormat formaterWithSeparator = NumberFormat.getNumberInstance();
                NumberFormat formaterWithoutSeparator = NumberFormat.getNumberInstance();
                formaterWithSeparator.setGroupingUsed(true);
                formaterWithoutSeparator.setGroupingUsed(false);
                formaterWithSeparator.setParseIntegerOnly(!this.decimalsAllowed());
                formaterWithoutSeparator.setParseIntegerOnly(!this.decimalsAllowed());
                try {
                    result = formaterWithSeparator.parse(st);
                }
                catch (ParseException nfex1) {
                    try {
                        result = formaterWithoutSeparator.parse(st);
                    }
                    catch (ParseException nfex2) {
                        result = Double.valueOf(st);
                    }
                }
                this.putValue(result);
                return;
            }
            if (o instanceof Integer) {
                this.setData((long)((Integer)o));
            } else if (o instanceof Long) {
                this.setData((Long)o);
            } else if (o instanceof EFCInteger) {
                this.setData((long)((EFCInteger)o).getLongValue());
            } else if (o instanceof EFCLong) {
                this.setData((long)((EFCLong)o).getLongValue());
            } else {
                throw new NumberFormatException("Integer, Long, Float, Double, String, or an EFCType based on those expected, not " + o.getClass().getName());
            }
        }
        this.setInitialized();
    }

    @Override
    public void defaults() {
        this.setData(0L);
    }

    @Override
    public long getMaxsize() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getMinsize() {
        return Long.MIN_VALUE;
    }

    @Override
    public void putMaxsize(long maxsize) {
        throw new RuntimeException("putMaxsize call not allowed");
    }

    @Override
    public void putMinsize(long minsize) {
        throw new RuntimeException("putMinsize call not allowed");
    }
}

