/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.datatypes.json.Utils;
import java.io.IOException;
import java.util.function.Consumer;

public class EFCListJsonDeserializer
extends JsonDeserializer<EFCList<?>> {
    public EFCList<?> deserialize(final JsonParser jp, DeserializationContext arg1) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        final EFCList ret = new EFCList();
        if (node.get("javaValueType") == null) {
            throw new IOException("field 'javaValueType' is missing.");
        }
        final String valueType = node.get("javaValueType").asText();
        if (!node.isNull() && !node.get("data").isNull() && node.get("data").isArray()) {
            node.get("data").iterator().forEachRemaining(new Consumer<JsonNode>(){

                @Override
                public void accept(JsonNode arrayNode) {
                    try {
                        ret.putValue(jp.getCodec().treeToValue((TreeNode)arrayNode, Class.forName(valueType)));
                    }
                    catch (JsonProcessingException | ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            });
            Utils.readBaseAttributes(node, ret);
        }
        return ret;
    }
}

