/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.json.Utils;
import java.io.IOException;
import java.util.function.Consumer;

public class EFCMapJsonDeserializer
extends JsonDeserializer<EFCMap<?, ?>> {
    public EFCMap<?, ?> deserialize(final JsonParser jp, DeserializationContext arg1) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        final EFCMap ret = new EFCMap();
        if (node.get("javaValueType") == null) {
            throw new IOException("field 'javaValueType' is missing.");
        }
        final String valueType = node.get("javaValueType").asText();
        if (node.get("javaKeyType") == null) {
            throw new IOException("field 'javaKeyType' is missing.");
        }
        final String keyType = node.get("javaKeyType").asText();
        if (!node.isNull() && !node.get("data").isNull() && node.get("data").isArray()) {
            node.get("data").iterator().forEachRemaining(new Consumer<JsonNode>(){

                @Override
                public void accept(JsonNode arrayNode) {
                    try {
                        if (!arrayNode.get("v").has("data") || arrayNode.get("v").has("data") && !arrayNode.get("v").get("data").isArray()) {
                            ret.put(jp.getCodec().treeToValue((TreeNode)arrayNode.get("k"), Class.forName(keyType)), jp.getCodec().treeToValue((TreeNode)arrayNode.get("v"), Class.forName(valueType)));
                        } else {
                            final EFCList list = new EFCList();
                            final String listValueType = valueType.replace("EFCList<", "").replace(">", "");
                            arrayNode.get("v").get("data").iterator().forEachRemaining(new Consumer<JsonNode>(){

                                @Override
                                public void accept(JsonNode arrayNode) {
                                    try {
                                        list.add(jp.getCodec().treeToValue((TreeNode)arrayNode, Class.forName(listValueType)));
                                    }
                                    catch (JsonProcessingException | ClassNotFoundException e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                            ret.put(jp.getCodec().treeToValue((TreeNode)arrayNode.get("k"), Class.forName(keyType)), list);
                        }
                    }
                    catch (JsonProcessingException | ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            });
            Utils.readBaseAttributes(node, ret);
        }
        return ret;
    }
}

